/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.costcalc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class CostCalcArgs
implements Serializable {
    protected static final Log logger = LogFactory.getLog(CostCalcArgs.class);
    private static final long serialVersionUID = 6728258600214533856L;
    private Date startTime;
    private Long orgId;
    private Long costAccountId;
    private Long costTypeId;
    private Long currencyId;
    private List<Long> costCenterIds = new ArrayList<Long>(10);
    private Long manuOrgId;
    private Long periodId;
    private Long prePeriodId;
    private Date startDate;
    private Date endDate;
    private Set<Long> costObjectIds = new HashSet<Long>();
    private Map<Long, Integer> ccAndCoInfos = new HashMap<Long, Integer>();
    private BigDecimal maxDiffRate = new BigDecimal("0.01");
    private BigDecimal minDiffRate = new BigDecimal("-0.01");
    private String matCalType;
    private String mfgCalType;
    private Long checkConfigId;
    private int checkWay;
    private Long checkResultId;
    private Integer checkfailCount;
    private Boolean calc;
    private Long calcReportId;
    private Long checkReportId;
    private Long taskRecordId;
    private Set<Long> manuOrgIds = new HashSet<Long>();
    private List<Long> manuOrgList = new ArrayList<Long>();
    private String appNum;
    private List<Long> checkItemList = new ArrayList<Long>(10);
    private boolean isEnableMulFactory = false;
    private boolean isSourceUpdate = false;

    public static CostCalcArgs fromJSONString(String costParamString) {
        JSONArray array;
        if (StringUtils.isBlank((CharSequence)costParamString)) {
            return null;
        }
        JSONObject checkParamJs = JSONObject.fromObject((Object)costParamString);
        CostCalcArgs args = new CostCalcArgs();
        if (CostCalcArgs.isNotNullValue(checkParamJs, "org")) {
            args.setOrgId(Long.parseLong(checkParamJs.getString("org")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "orgId")) {
            args.setOrgId(Long.parseLong(checkParamJs.getString("orgId")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "costaccount")) {
            args.setCostAccountId(Long.parseLong(checkParamJs.getString("costaccount")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "costAcctId")) {
            args.setCostAccountId(Long.parseLong(checkParamJs.getString("costAcctId")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "period")) {
            args.setPeriodId(Long.parseLong(checkParamJs.getString("period")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "periodId")) {
            args.setPeriodId(Long.parseLong(checkParamJs.getString("periodId")));
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (CostCalcArgs.isNotNullValue(checkParamJs, "startDate")) {
                args.setStartDate(simpleDateFormat.parse(checkParamJs.getString("startDate")));
            }
            if (CostCalcArgs.isNotNullValue(checkParamJs, "endDate")) {
                args.setEndDate(simpleDateFormat.parse(checkParamJs.getString("endDate")));
            }
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "currencyId")) {
            args.setCurrencyId(Long.parseLong(checkParamJs.getString("currencyId")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "costcenters")) {
            array = checkParamJs.getJSONArray("costcenters");
            for (Object item : array) {
                if (item == null) continue;
                args.getCostCenterIds().add(Long.parseLong(item.toString()));
            }
        } else if (CostCalcArgs.isNotNullValue(checkParamJs, "costCenterIds")) {
            array = checkParamJs.getJSONArray("costCenterIds");
            for (Object item : array) {
                if (item == null) continue;
                args.getCostCenterIds().add(Long.parseLong(item.toString()));
            }
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "manuOrgIds")) {
            array = checkParamJs.getJSONArray("manuOrgIds");
            for (Object item : array) {
                if (item == null) continue;
                args.getManuOrgIds().add(Long.parseLong(item.toString()));
            }
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "manuOrgList")) {
            array = checkParamJs.getJSONArray("manuOrgList");
            for (Object item : array) {
                if (item == null) continue;
                args.getManuOrgList().add(Long.parseLong(item.toString()));
            }
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "costobjects")) {
            array = checkParamJs.getJSONArray("costobjects");
            for (Object item : array) {
                if (item == null) continue;
                args.getCostObjectIds().add(Long.parseLong(item.toString()));
            }
        } else if (CostCalcArgs.isNotNullValue(checkParamJs, "costObjects")) {
            array = checkParamJs.getJSONArray("costObjects");
            for (Object item : array) {
                if (item == null) continue;
                args.getCostObjectIds().add(Long.parseLong(item.toString()));
            }
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "ccAndCoInfos")) {
            JSONObject map = checkParamJs.getJSONObject("ccAndCoInfos");
            for (Map.Entry entry : map.entrySet()) {
                args.getCcAndCoInfos().put(Long.parseLong(entry.getKey().toString()), Integer.parseInt(entry.getValue().toString()));
            }
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "costtypeid")) {
            args.setCostTypeId(Long.parseLong(checkParamJs.getString("costtypeid")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "costTypeId")) {
            args.setCostTypeId(Long.parseLong(checkParamJs.getString("costTypeId")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "matCalType")) {
            args.setMatCalType(checkParamJs.getString("matCalType"));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "mfgCalType")) {
            args.setMfgCalType(checkParamJs.getString("mfgCalType"));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "maxDiffRate")) {
            args.setMaxDiffRate(new BigDecimal(checkParamJs.getString("maxDiffRate")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "minDiffRate")) {
            args.setMinDiffRate(new BigDecimal(checkParamJs.getString("minDiffRate")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "checkway")) {
            args.setCheckWay(Integer.parseInt(checkParamJs.getString("checkway")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "checkResultId")) {
            args.setCheckResultId(Long.parseLong(checkParamJs.getString("checkResultId")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "checkfailCount")) {
            args.setCheckfailCount(Integer.parseInt(checkParamJs.getString("checkfailCount")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "calc")) {
            args.setCalc(Boolean.parseBoolean(checkParamJs.getString("calc")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "taskRecordId")) {
            args.setTaskRecordId(Long.parseLong(checkParamJs.getString("taskRecordId")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "calcReportId")) {
            args.setCalcReportId(Long.parseLong(checkParamJs.getString("calcReportId")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "checkReportId")) {
            args.setCheckReportId(Long.parseLong(checkParamJs.getString("checkReportId")));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "appNum")) {
            args.setAppNum(checkParamJs.getString("appNum"));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "checkItemList")) {
            args.getCheckItemList().addAll((Collection<Long>)checkParamJs.getJSONArray("checkItemList"));
        }
        if (CostCalcArgs.isNotNullValue(checkParamJs, "isSourceUpdate")) {
            args.setIsSourceUpdate(checkParamJs.getBoolean("isSourceUpdate"));
        }
        return args;
    }

    private static boolean isNotNullValue(JSONObject checkParamJs, String key) {
        if (!checkParamJs.containsKey((Object)key)) {
            return false;
        }
        Object value = checkParamJs.get(key);
        if (value instanceof JSONNull) {
            return false;
        }
        return value != null;
    }

    public static String toJSONString(CostCalcArgs args) {
        if (args == null) {
            return null;
        }
        JSONObject params = new JSONObject();
        if (args.getOrgId() != null) {
            params.accumulate("org", (Object)args.getOrgId());
        }
        if (args.getCostAccountId() != null) {
            params.accumulate("costaccount", (Object)args.getCostAccountId());
        }
        if (args.getPeriodId() != null) {
            params.accumulate("period", (Object)args.getPeriodId());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (args.getStartDate() != null) {
            params.accumulate("startDate", (Object)simpleDateFormat.format(args.getStartDate()));
        }
        if (args.getEndDate() != null) {
            params.accumulate("endDate", (Object)simpleDateFormat.format(args.getEndDate()));
        }
        if (args.getCurrencyId() != null) {
            params.accumulate("currencyId", (Object)args.getCurrencyId());
        }
        JSONArray array = new JSONArray();
        if (!args.getCostCenterIds().isEmpty()) {
            for (Long l : args.getCostCenterIds()) {
                array.add((Object)l);
            }
        }
        params.accumulate("costcenters", (Object)array);
        params.accumulate("entrycostcenters", (Object)new JSONArray());
        JSONArray arrayCo = new JSONArray();
        if (!args.getCostObjectIds().isEmpty()) {
            for (Long l : args.getCostObjectIds()) {
                arrayCo.add((Object)l);
            }
        }
        params.accumulate("costobjects", (Object)arrayCo);
        if (!args.getCcAndCoInfos().isEmpty()) {
            JSONObject jSONObject = new JSONObject();
            for (Map.Entry<Long, Integer> entry : args.getCcAndCoInfos().entrySet()) {
                jSONObject.put((Object)entry.getKey().toString(), (Object)entry.getValue());
            }
            params.accumulate("ccAndCoInfos", (Object)jSONObject);
        }
        if (args.getMatCalType() != null) {
            params.accumulate("matCalType", (Object)args.getMatCalType());
        }
        if (args.getMfgCalType() != null) {
            params.accumulate("mfgCalType", (Object)args.getMfgCalType());
        }
        if (args.getCostTypeId() != null) {
            params.accumulate("costtypeid", (Object)args.getCostTypeId().toString());
        }
        if (args.getMaxDiffRate() != null) {
            params.accumulate("maxDiffRate", (Object)args.getMaxDiffRate());
        }
        if (args.getMinDiffRate() != null) {
            params.accumulate("minDiffRate", (Object)args.getMinDiffRate());
        }
        params.accumulate("checkway", (Object)String.valueOf(args.getCheckWay()));
        if (args.getCheckResultId() != null) {
            params.accumulate("checkResultId", (Object)args.getCheckResultId());
        }
        if (args.getCheckfailCount() != null) {
            params.accumulate("checkfailCount", (Object)args.getCheckfailCount());
        }
        if (args.isCalc() != null) {
            params.accumulate("calc", (Object)args.isCalc());
        }
        if (args.getTaskRecordId() != null) {
            params.accumulate("taskRecordId", (Object)args.getTaskRecordId().toString());
        }
        if (args.getCalcReportId() != null) {
            params.accumulate("calcReportId", (Object)args.getCalcReportId());
        }
        if (args.getCheckReportId() != null) {
            params.accumulate("checkReportId", (Object)args.getCheckReportId());
        }
        if (args.getManuOrgId() != null) {
            params.accumulate("manuOrgId", (Object)args.getManuOrgId());
        }
        JSONArray jSONArray = new JSONArray();
        if (args.getManuOrgIds() != null) {
            for (Long l : args.getManuOrgIds()) {
                jSONArray.add((Object)l);
            }
        }
        params.accumulate("manuOrgIds", (Object)jSONArray);
        JSONArray jSONArray2 = new JSONArray();
        if (args.getManuOrgList() != null) {
            for (Long manuorgId : args.getManuOrgList()) {
                jSONArray2.add((Object)manuorgId);
            }
        }
        params.accumulate("manuOrgList", (Object)jSONArray2);
        params.accumulate("isEnableMulFactory", args.isEnableMulFactory());
        params.accumulate("isSourceUpdate", args.getIsSourceUpdate());
        return params.toString();
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getCostAccountId() {
        return this.costAccountId;
    }

    public void setCostAccountId(Long costAccountId) {
        this.costAccountId = costAccountId;
    }

    public Long getCostTypeId() {
        return this.costTypeId;
    }

    public void setCostTypeId(Long costTypeId) {
        this.costTypeId = costTypeId;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public List<Long> getCostCenterIds() {
        return this.costCenterIds;
    }

    public void setCostCenterIds(List<Long> costCenterIds) {
        this.costCenterIds = costCenterIds;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getPrePeriodId() {
        return this.prePeriodId;
    }

    public void setPrePeriodId(Long prePeriodId) {
        this.prePeriodId = prePeriodId;
    }

    public Date getStartDate() {
        return this.startDate == null ? new Date() : this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate == null ? new Date() : this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Set<Long> getCostObjectIds() {
        return this.costObjectIds;
    }

    public void setCostObjectIds(Set<Long> costObjectIds) {
        this.costObjectIds = costObjectIds;
    }

    public Map<Long, Integer> getCcAndCoInfos() {
        return this.ccAndCoInfos;
    }

    public void setCcAndCoInfos(Map<Long, Integer> ccAndCoInfos) {
        this.ccAndCoInfos = ccAndCoInfos;
    }

    public BigDecimal getMaxDiffRate() {
        return this.maxDiffRate;
    }

    public void setMaxDiffRate(BigDecimal maxDiffRate) {
        this.maxDiffRate = maxDiffRate;
    }

    public BigDecimal getMinDiffRate() {
        return this.minDiffRate;
    }

    public void setMinDiffRate(BigDecimal minDiffRate) {
        this.minDiffRate = minDiffRate;
    }

    public String getMatCalType() {
        return this.matCalType;
    }

    public void setMatCalType(String matCalType) {
        this.matCalType = matCalType;
    }

    public String getMfgCalType() {
        return this.mfgCalType;
    }

    public void setMfgCalType(String mfgCalType) {
        this.mfgCalType = mfgCalType;
    }

    public Long getCheckConfigId() {
        return this.checkConfigId;
    }

    public void setCheckConfigId(Long checkConfigId) {
        this.checkConfigId = checkConfigId;
    }

    public int getCheckWay() {
        return this.checkWay;
    }

    public void setCheckWay(int checkWay) {
        this.checkWay = checkWay;
    }

    public Long getCheckResultId() {
        return this.checkResultId;
    }

    public void setCheckResultId(Long checkResultId) {
        this.checkResultId = checkResultId;
    }

    public Integer getCheckfailCount() {
        return this.checkfailCount;
    }

    public void setCheckfailCount(Integer checkfailCount) {
        this.checkfailCount = checkfailCount;
    }

    public Boolean isCalc() {
        return this.calc;
    }

    public void setCalc(Boolean calc) {
        this.calc = calc;
    }

    public Long getTaskRecordId() {
        return this.taskRecordId;
    }

    public void setTaskRecordId(Long taskRecordId) {
        this.taskRecordId = taskRecordId;
    }

    public Long getCalcReportId() {
        return this.calcReportId;
    }

    public void setCalcReportId(Long calcReportId) {
        this.calcReportId = calcReportId;
    }

    public Long getManuOrgId() {
        return this.manuOrgId;
    }

    public void setManuOrgId(Long manuOrgId) {
        this.manuOrgId = manuOrgId;
    }

    public Set<Long> getManuOrgIds() {
        return this.manuOrgIds;
    }

    public void setManuOrgIds(Set<Long> manuOrgIds) {
        this.manuOrgIds = manuOrgIds;
    }

    public boolean isEnableMulFactory() {
        return this.isEnableMulFactory;
    }

    public void setEnableMulFactory(boolean isEnableMulFactory) {
        this.isEnableMulFactory = isEnableMulFactory;
    }

    public Long getCheckReportId() {
        return this.checkReportId;
    }

    public void setCheckReportId(Long checkReportId) {
        this.checkReportId = checkReportId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getAppNum() {
        return this.appNum;
    }

    public void setAppNum(String appNum) {
        this.appNum = appNum;
    }

    public List<Long> getManuOrgList() {
        return this.manuOrgList;
    }

    public void setManuOrgList(List<Long> manuOrgList) {
        this.manuOrgList = manuOrgList;
    }

    public List<Long> getCheckItemList() {
        return this.checkItemList;
    }

    public void setIsSourceUpdate(boolean isSourceUpdate) {
        this.isSourceUpdate = isSourceUpdate;
    }

    public boolean getIsSourceUpdate() {
        return this.isSourceUpdate;
    }
}

