/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.costcalc;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.sca.common.costcalc.CostAdjustamt;

public class Diff2CostAdjust {
    private static final Log logger = LogFactory.getLog(Diff2CostAdjust.class);
    private static final String SPILTSIGN = "#";
    private static final int DEFAULT_PRECISION = 10;
    private Map<Long, Integer> currencyAmtPrecision = new HashMap<Long, Integer>();
    private Map<Long, Date> bizdateMap = new HashMap<Long, Date>(16);
    private Map<String, String> reductStrategy = new HashMap<String, String>(16);

    private Integer loadCurrencyAmtPrecision(Long currencyId) {
        if (currencyId == null || Long.compare(0L, currencyId) == 0) {
            return 10;
        }
        if (!this.currencyAmtPrecision.containsKey(currencyId)) {
            int amtprecision = 10;
            QFilter cur = new QFilter("id", "=", (Object)currencyId);
            DynamicObject currency_amt = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{cur});
            if (currency_amt != null) {
                amtprecision = currency_amt.getInt("amtprecision");
            }
            this.currencyAmtPrecision.put(currencyId, amtprecision);
        }
        return this.currencyAmtPrecision.get(currencyId);
    }

    public DynamicObject[] calCostBillService(DynamicObject[] finishDiffBills, String createType) {
        Set<Object> params = new HashSet(16);
        HashMap<String, Object[]> invbillInfo = new HashMap<String, Object[]>(16);
        HashMap<Long, Long> costobectVersionMap = new HashMap<Long, Long>();
        Map<String, BigDecimal> wareHouseRate = this.loadWareHouseRateByFacted(Arrays.asList(finishDiffBills), invbillInfo, costobectVersionMap);
        params = this.getCostAdjustParam(finishDiffBills, wareHouseRate, invbillInfo, costobectVersionMap, createType);
        if (params.size() > 0) {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalStandardCostDiffBillService", (String)"buildDiffBill", (Object[])new Object[]{params});
            if (result == null) {
                logger.warn("\u5bf9\u63a5\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf\u5931\u8d25\uff0c\u8fd4\u56denull");
                return finishDiffBills;
            }
            logger.info("\u5bf9\u63a5\u5b58\u8d27\u7cfb\u7edf\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a" + SerializationUtils.toJsonString((Object)result));
            boolean isReturnByEntryId = result.containsKey("srcbillentryid,createtype");
            HashSet<DynamicObject> failFinishDiffs = new HashSet<DynamicObject>();
            HashSet<DynamicObject> failEntryRows = new HashSet<DynamicObject>();
            for (DynamicObject finishDiffBill : finishDiffBills) {
                String sourcebill = finishDiffBill.getString("id");
                DynamicObjectCollection entryentity = finishDiffBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    String diffType = this.getDiffType(entry.getString("difftype"));
                    Map adjustInfo = null;
                    String key_entryid = entry.getString("id") + "_" + diffType;
                    if (isReturnByEntryId || result.containsKey(key_entryid)) {
                        adjustInfo = (Map)result.get(key_entryid);
                    }
                    if (adjustInfo == null) {
                        String key_billid = sourcebill + "_" + diffType;
                        adjustInfo = (Map)result.get(key_billid);
                    }
                    if (adjustInfo == null) {
                        failFinishDiffs.add(finishDiffBill);
                        failEntryRows.add(entry);
                        continue;
                    }
                    entry.set("adjustbill", adjustInfo.get("id"));
                    entry.set("adjustnum", adjustInfo.get("billno"));
                }
            }
            if (!failEntryRows.isEmpty()) {
                logger.warn(String.format("\u5bf9\u63a5\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf\u7ed3\u675f\uff0c%s\u5f20\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\uff0c%s\u884c\u5206\u5f55\uff0c\u6ca1\u6709\u6536\u5230\u8fd4\u56de\u7684\u6210\u672c\u8c03\u6574\u5355\u5185\u7801", failFinishDiffs.size(), failEntryRows.size()));
            }
        }
        return finishDiffBills;
    }

    private Set<Map<String, Object>> getCostAdjustParam(DynamicObject[] finishDiffBills, Map<String, BigDecimal> wareHouseRate, Map<String, Object[]> invbillInfo, Map<Long, Long> costobectVersionMap, String createType) {
        QFilter qFilter;
        DynamicObjectCollection costObjectList;
        HashSet<Map<String, Object>> params = new HashSet<Map<String, Object>>(16);
        this.getReductStrategyAndPeriodDate(finishDiffBills, this.reductStrategy, this.bizdateMap);
        int i = 0;
        HashMap idCostObjectMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet costObjectIds = Sets.newHashSetWithExpectedSize((int)finishDiffBills.length);
        for (DynamicObject finishDiffBill : finishDiffBills) {
            costObjectIds.add(finishDiffBill.getLong("costobject"));
        }
        if (!CadEmptyUtils.isEmpty((Set)costObjectIds) && !CadEmptyUtils.isEmpty((DynamicObjectCollection)(costObjectList = QueryServiceHelper.query((String)"cad_costobject", (String)"id,configuredcode,tracknumber", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "in", (Object)costObjectIds)})))) {
            for (DynamicObject costObject : costObjectList) {
                idCostObjectMap.put(costObject.getLong("id"), costObject);
            }
        }
        for (DynamicObject finishDiffBill : finishDiffBills) {
            Long orgId = finishDiffBill.getLong("org");
            String costcenterId = finishDiffBill.getString("costcenter");
            String costObjectId = finishDiffBill.getString("costobject");
            String costaccount = finishDiffBill.getString("costaccount");
            String reductKey = orgId + SPILTSIGN + costaccount;
            if ("ITEMIZED_REDUCT".equals(this.reductStrategy.get(reductKey))) continue;
            HashMap factSubentryParamMap = Maps.newHashMapWithExpectedSize((int)10);
            DynamicObjectCollection entryentity = finishDiffBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                String key = orgId + SPILTSIGN + costcenterId + SPILTSIGN + costObjectId + SPILTSIGN;
                String difftypeField = this.getDiffType(entry.getString("difftype"));
                Long subelementId = entry.getLong("subelement");
                ArrayList<CostAdjustamt> subEntryRows = new ArrayList<CostAdjustamt>(10);
                for (Map.Entry<String, BigDecimal> rate : wareHouseRate.entrySet()) {
                    BigDecimal houseRate;
                    if (!rate.getKey().startsWith(key) || CadEmptyUtils.isEmpty((BigDecimal)(houseRate = wareHouseRate.get(rate.getKey())))) continue;
                    Map<String, Object> info = this.getDetailInfo(rate.getKey());
                    String factelementKey = String.format("%s@%s", subelementId, info.get("sourcebillentry"));
                    Map<String, Object> param = (Map<String, Object>)factSubentryParamMap.get(factelementKey);
                    if (param == null) {
                        param = this.createDiffRowParam(finishDiffBill, entry, costobectVersionMap, idCostObjectMap, createType);
                        if (!this.fillInvBillInfo(param, rate.getKey(), invbillInfo)) continue;
                        factSubentryParamMap.put(factelementKey, param);
                    }
                    int amtprecision = this.loadCurrencyAmtPrecision(finishDiffBill.getLong("currency"));
                    BigDecimal amount = entry.getBigDecimal("amount").multiply(houseRate);
                    BigDecimal adjustamt = amount.setScale(amtprecision, 5);
                    if (param.containsKey(difftypeField)) {
                        param.put(difftypeField, adjustamt.add((BigDecimal)param.get(difftypeField)));
                    } else {
                        param.put(difftypeField, adjustamt);
                    }
                    CostAdjustamt adjust = new CostAdjustamt(amount, adjustamt, param, houseRate, amtprecision);
                    subEntryRows.add(adjust);
                }
                if (subEntryRows.isEmpty()) {
                    String factelementKey = String.valueOf(subelementId);
                    Map<String, Object> param = (Map<String, Object>)factSubentryParamMap.get(factelementKey);
                    if (param == null) {
                        param = this.createDiffRowParam(finishDiffBill, entry, costobectVersionMap, idCostObjectMap, createType);
                        param.put("isupdatecost", false);
                        factSubentryParamMap.put(factelementKey, param);
                    }
                    int amtprecision = this.loadCurrencyAmtPrecision(finishDiffBill.getLong("currency"));
                    BigDecimal amount = entry.getBigDecimal("amount").setScale(amtprecision, 5);
                    param.put(difftypeField, amount);
                    continue;
                }
                List<Map<String, Object>> passParams = this.checkCostAdjustamt(subEntryRows, entry.getBigDecimal("amount"), difftypeField);
                for (Map<String, Object> param : passParams) {
                    param.put("" + i++, "1");
                }
            }
            for (Map param : factSubentryParamMap.values()) {
                this.setAdjustamt(param);
                params.add(param);
            }
        }
        return params;
    }

    private void setAdjustamt(Map<String, Object> param) {
        BigDecimal sumAmt = BigDecimal.ZERO;
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (!entry.getKey().startsWith("ddiff_") || !(entry.getValue() instanceof BigDecimal)) continue;
            sumAmt = sumAmt.add((BigDecimal)entry.getValue());
        }
        param.put("adjustamt", sumAmt);
    }

    private Map<String, Object> createDiffRowParam(DynamicObject finishDiffBill, DynamicObject entry, Map<Long, Long> costobectVersionMap, Map<Long, DynamicObject> idCostObjectMap, String createType) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("calorg", finishDiffBill.get("org"));
        param.put("costaccount", finishDiffBill.get("costaccount"));
        param.put("biztype", "A");
        param.put("cstype", "bd_supplier");
        param.put("billsrctype", "D");
        Date bizDate = DateUtils.getDayStartTime((Date)this.bizdateMap.get(finishDiffBill.getLong("period")));
        param.put("bizdate", bizDate);
        param.put("bookdate", bizDate);
        param.put("currency", finishDiffBill.get("currency"));
        param.put("material", finishDiffBill.get("material"));
        Long version = costobectVersionMap.get(finishDiffBill.getLong("costobject"));
        if (version != null && version > 0L) {
            param.put("mversion", version);
        }
        long costObjectId = finishDiffBill.getLong("costobject");
        DynamicObject costObject = idCostObjectMap.get(costObjectId);
        param.put("configuredcode", costObject.get("configuredcode"));
        param.put("tracknumber", costObject.get("tracknumber"));
        param.put("assist", finishDiffBill.get("auxpty"));
        param.put("billtype", 920040553033394176L);
        param.put("baseunit", finishDiffBill.get("unit"));
        param.put("invtype", 688884005529250816L);
        param.put("invstatus", 691928582720825344L);
        param.put("ownertype", "bos_org");
        param.put("createtype", createType);
        param.put("costelement", entry.getLong("element"));
        param.put("costsubelement", entry.getLong("subelement"));
        param.put("srcbillnum", finishDiffBill.getString("billno"));
        param.put("srcentryseq", entry.getLong("seq"));
        param.put("srcbillid", finishDiffBill.getLong("id"));
        param.put("srcbillentryid", entry.getLong("id"));
        param.put("srcbizentityobject", "sca_finishdiffbill");
        param.put("srcsys", "B");
        return param;
    }

    private boolean fillInvBillInfo(Map<String, Object> param, String key, Map<String, Object[]> invbillInfo) {
        Map<String, Object> info = this.getDetailInfo(key);
        if (info.size() == 0) {
            return false;
        }
        String invKey = String.format("%s@%s", param.get("costaccount"), info.get("sourcebillentry"));
        if (invbillInfo.containsKey(invKey)) {
            Object[] srcInfomap = invbillInfo.get(invKey);
            param.put("invbillnum", srcInfomap[0]);
            param.put("inventryseq", srcInfomap[1]);
            param.put("invbillid", srcInfomap[2]);
            param.put("invbillentryid", srcInfomap[3]);
            param.put("ecostcenter", srcInfomap[4]);
            param.put("storageorgunit", srcInfomap[5]);
            param.put("noupdatecalfields", srcInfomap[6]);
        }
        param.put("invbizentityobject", "im_mdc_mftmanuinbill");
        param.put("warehouse", Long.valueOf(String.valueOf(info.get("warehouse"))));
        if (info.get("location") != null && !"0".equals(String.valueOf(info.get("location")))) {
            param.put("location", Long.valueOf(String.valueOf(info.get("location"))));
        }
        param.put("owner", info.get("owner") != null ? Long.parseLong(String.valueOf(info.get("owner"))) : 0L);
        param.put("lot", info.get("lot"));
        return true;
    }

    private List<Map<String, Object>> checkCostAdjustamt(List<CostAdjustamt> entryRowParams, BigDecimal totalAmount, String diffField) {
        ArrayList<Map<String, Object>> passParams = new ArrayList<Map<String, Object>>(entryRowParams.size());
        if (entryRowParams.isEmpty()) {
            return passParams;
        }
        CostAdjustamt maxAmountRow = entryRowParams.get(entryRowParams.size() - 1);
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (CostAdjustamt row : entryRowParams) {
            if (row.getAdjustamt().compareTo(maxAmountRow.getAdjustamt()) > 0) {
                maxAmountRow = row;
            }
            sumAmount = sumAmount.add(row.getAdjustamt());
        }
        BigDecimal diffAmount = totalAmount.subtract(sumAmount);
        maxAmountRow.setAdjustamt(diffAmount.add(maxAmountRow.getAdjustamt()));
        for (CostAdjustamt row : entryRowParams) {
            if (BigDecimal.ZERO.compareTo(row.getAdjustamt()) == 0) continue;
            row.getParam().put(diffField, row.getAdjustamt());
            passParams.add(row.getParam());
        }
        return passParams;
    }

    private void getReductStrategyAndPeriodDate(DynamicObject[] finishDiffBills, Map<String, String> reductStrategy, Map<Long, Date> bizdateMap) {
        DynamicObject[] sysparams;
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> costAccounts = new HashSet<Long>(16);
        HashSet<Long> periods = new HashSet<Long>(16);
        for (DynamicObject finishDiffBill : finishDiffBills) {
            orgIds.add(finishDiffBill.getLong("org"));
            costAccounts.add(finishDiffBill.getLong("costaccount"));
            periods.add(finishDiffBill.getLong("period"));
        }
        QFilter orgQF = new QFilter("org", "in", orgIds);
        QFilter costAccountQF = new QFilter("costaccount", "in", costAccounts);
        for (DynamicObject sysparam : sysparams = BusinessDataServiceHelper.load((String)"cad_sysparam", (String)"org,costaccount,reductstrategy", (QFilter[])new QFilter[]{orgQF, costAccountQF})) {
            Long orgId = sysparam.getLong("org.id");
            String costAccount = sysparam.getString("costaccount.id");
            String reductstrategy = sysparam.getString("reductstrategy");
            String key = orgId + SPILTSIGN + costAccount;
            reductStrategy.put(key, reductstrategy);
        }
        bizdateMap.putAll(PeriodHelper.getEndDateByPeriod(periods));
    }

    private Map<Long, Long> getStorageOrg(Set<String> sourceBill) {
        HashMap<Long, Long> storageOrg = new HashMap<Long, Long>(16);
        HashSet<Long> ids = new HashSet<Long>(16);
        for (String bill : sourceBill) {
            String[] bls = bill.split(SPILTSIGN);
            if (bls.length != 11 || "0".equals(bls[6])) continue;
            ids.add(Long.valueOf(bls[6]));
        }
        if (ids.size() == 0) {
            return storageOrg;
        }
        DynamicObjectCollection mftManu = QueryServiceHelper.query((String)"im_mdc_mftmanuinbill", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        for (DynamicObject manu : mftManu) {
            storageOrg.put(manu.getLong("id"), manu.getLong("org"));
        }
        return storageOrg;
    }

    private Map<String, BigDecimal> loadWareHouseRateByFacted(List<DynamicObject> finishDiffBills, Map<String, Object[]> invbillInfo, Map<Long, Long> costobectVersionMap) {
        DataSet factedOut;
        HashMap<String, BigDecimal> wareHouseRate = new HashMap<String, BigDecimal>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> costCenterIds = new HashSet<Long>(16);
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        HashSet<Long> periods = new HashSet<Long>(16);
        for (DynamicObject unAbsorbDiff : finishDiffBills) {
            orgIds.add(unAbsorbDiff.getLong("org"));
            costCenterIds.add(unAbsorbDiff.getLong("costcenter"));
            costObjectIds.add(unAbsorbDiff.getLong("costobject"));
            periods.add(unAbsorbDiff.getLong("period"));
        }
        if (orgIds.size() == 0 || costCenterIds.size() == 0 || costObjectIds.size() == 0) {
            return wareHouseRate;
        }
        QFilter costObjectF = new QFilter("id", "in", costObjectIds);
        DynamicObjectCollection costObjectVersion = QueryServiceHelper.query((String)"cad_costobject", (String)"id,bomversion", (QFilter[])costObjectF.toArray());
        costObjectVersion.forEach(t -> costobectVersionMap.put(t.getLong("id"), t.getLong("bomversion")));
        HashMap<String, BigDecimal> costObjectTotal = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> costObjectHouse = new HashMap<String, BigDecimal>(16);
        String selectFields = "org,costcenter,entryentity.costobject AS costobject,entryentity.qty AS qty,warehouse,location,wareinorg,sourcebill,sourcebillentry,batch as lot,entryentity.costobject.srcbillnumber AS scrbillnum,entryentity.costobject.srcbillrow AS srcbillrow";
        String groupByFields = "org,costcenter,costobject,warehouse,location,wareinorg,sourcebill,sourcebillentry,lot,scrbillnum,srcbillrow";
        QFilter qfOrg = new QFilter("org", "in", orgIds);
        QFilter qfCostCenter = new QFilter("costcenter", "in", costCenterIds);
        QFilter qfCostObject = new QFilter("entryentity.costobject", "in", costObjectIds);
        if (periods.size() == 1) {
            QFilter filter = new QFilter("id", "in", periods);
            DynamicObject periodTemp = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])filter.toArray());
            qfCostCenter.and("bizdate", ">=", (Object)periodTemp.getDate("begindate"));
            qfCostCenter.and("bizdate", "<=", (Object)periodTemp.getDate("enddate"));
        }
        if ((factedOut = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.common.costcalc.Diff2CostAdjust.getWareHouseRateByFacted", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{qfOrg, qfCostCenter, qfCostObject}, null).groupBy(groupByFields.split(",")).sum("qty").finish()).isEmpty()) {
            return wareHouseRate;
        }
        DataSet factnedBillCopy = factedOut.copy();
        HashSet<Long> srcIdset = new HashSet<Long>(16);
        for (Row row : factnedBillCopy) {
            srcIdset.add(row.getLong("sourcebillentry"));
        }
        invbillInfo.putAll(Diff2CostAdjust.getCalCostRecordInfoByBizEntryId(srcIdset));
        while (factedOut.hasNext()) {
            Row row = factedOut.next();
            BigDecimal qty = row.getBigDecimal("qty");
            String key = this.unionField2Key("org,costcenter,costobject", row);
            BigDecimal curVal = costObjectTotal.computeIfAbsent(key, s -> BigDecimal.ZERO);
            curVal = curVal.add(qty);
            costObjectTotal.put(key, curVal);
            key = this.unionField2Key("org,costcenter,costobject,warehouse,location,wareinorg,sourcebill,lot,scrbillnum,srcbillrow,sourcebillentry", row);
            costObjectHouse.computeIfAbsent(key, s -> qty);
        }
        for (Map.Entry totalEntry : costObjectTotal.entrySet()) {
            BigDecimal total = (BigDecimal)totalEntry.getValue();
            if (CadEmptyUtils.isEmpty((BigDecimal)total)) continue;
            for (Map.Entry subEntry : costObjectHouse.entrySet()) {
                if (!((String)subEntry.getKey()).startsWith((String)totalEntry.getKey())) continue;
                wareHouseRate.put((String)subEntry.getKey(), ((BigDecimal)subEntry.getValue()).divide(total, 10, 4));
            }
        }
        return wareHouseRate;
    }

    public static Map<String, Object[]> getCalCostRecordInfoByBizEntryId(Set<Long> costRecordSourceEntryIds) {
        QFilter filter = new QFilter("entry.bizbillentryid", "in", costRecordSourceEntryIds);
        String selectField = "costaccount,id,billnumber billno,entry.id as entryid,entry.seq seq,entry.bizbillentryid as srcbillentryid,entry.ecostcenter ecostcenter,storageorgunit,entry.noupdatecalfields noupdatecalfields";
        DataSet ds = QueryServiceHelper.queryDataSet((String)"getCalCostRecord", (String)"cal_costrecord_subentity", (String)selectField, (QFilter[])filter.toArray(), null);
        HashMap map = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : ds) {
            Long srcbillentryid = row.getLong("srcbillentryid");
            map.putIfAbsent(String.format("%s@%s", row.getLong("costaccount"), srcbillentryid), new Object[]{row.getString("billno"), row.getLong("seq"), row.getLong("id"), row.getLong("entryid"), row.getLong("ecostcenter"), row.getLong("storageorgunit"), row.getString("noupdatecalfields")});
        }
        return map;
    }

    private void loadIvnBillNos(Map<String, Map<String, Object>> invbillInfo) {
        HashSet<Long> srcEntryIds = new HashSet<Long>();
        for (Map.Entry<String, Map<String, Object>> entry : invbillInfo.entrySet()) {
            Long entryId = (Long)entry.getValue().get("invbillentryid");
            if (entryId == null) continue;
            srcEntryIds.add(entryId);
        }
        HashMap<Long, String> billNos = new HashMap<Long, String>();
        HashMap<Long, Integer> entrySeqs = new HashMap<Long, Integer>();
        QFilter idQf = new QFilter("billentry.id", "in", srcEntryIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".loadIvnBillNos"), (String)"im_mdc_mftmanuinbill", (String)"id, billno, billentry.id entryid, billentry.seq seq", (QFilter[])new QFilter[]{idQf}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long billId = row.getLong("id");
                Long entryId = row.getLong("entryid");
                String billNo = row.getString("billno");
                Integer seq = row.getInteger("seq");
                billNos.put(billId, billNo);
                entrySeqs.put(entryId, seq);
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : invbillInfo.entrySet()) {
            Long billId = (Long)entry.getValue().get("invbillid");
            Long entryId = (Long)entry.getValue().get("invbillentryid");
            entry.getValue().put("invbillnum", billNos.get(billId));
            entry.getValue().put("inventryseq", entrySeqs.get(entryId));
        }
    }

    private String unionField2Key(String fields, Row row) {
        StringBuilder sb = new StringBuilder();
        for (String field : fields.split(",")) {
            sb.append(row.get(field)).append(SPILTSIGN);
        }
        return sb.toString();
    }

    private Map<String, Object> getDetailInfo(String rateKey) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        String[] rateKeyInfos = rateKey.split(SPILTSIGN);
        if (rateKeyInfos.length != 11) {
            return result;
        }
        result.put("warehouse", rateKeyInfos[3]);
        result.put("location", rateKeyInfos[4]);
        result.put("owner", rateKeyInfos[5]);
        result.put("sourcebill", rateKeyInfos[6]);
        result.put("lot", rateKeyInfos[7]);
        result.put("srcbillnum", rateKeyInfos[8]);
        result.put("srcbillrow", rateKeyInfos[9]);
        result.put("sourcebillentry", rateKeyInfos[10]);
        return result;
    }

    private String getDiffType(String type) {
        String diffType = "";
        switch (type) {
            case "1": {
                diffType = "ddiff_p";
                break;
            }
            case "2": {
                diffType = "ddiff_q";
                break;
            }
            case "3": {
                diffType = "ddiff_s";
            }
        }
        return diffType;
    }
}

