/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.helper;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProAllocStdHelper {
    private static final Log logger = LogFactory.getLog(ProAllocStdHelper.class);

    public static Map<String, String> getProAllocStdMap(Long orgId, Long costAccountId, String effectStatus, String appNum) {
        DataSet proAllocStdDataSet = ProAllocStdHelper.getProAllocStdDataSet(orgId, costAccountId, effectStatus, appNum);
        return ProAllocStdHelper.getProAllocStdMap(proAllocStdDataSet);
    }

    public static Map<String, String> getDiffProAllocStdMap(Long orgId, Long costAccountId) {
        DataSet proAllocStdDataSet = ProAllocStdHelper.getDiffProAllocStdDs(orgId, costAccountId);
        return ProAllocStdHelper.getProAllocStdMap(proAllocStdDataSet);
    }

    public static Map<String, String> getUnAbsorbAllocStdMap(Long orgId, Long costAccountId) {
        DataSet unAbsorbAllocDataSet = ProAllocStdHelper.getUnAbsorbAllocStdDs(orgId, costAccountId);
        return ProAllocStdHelper.getProAllocStdMap(unAbsorbAllocDataSet);
    }

    private static Map<String, String> getProAllocStdMap(DataSet proAllocStdDs) {
        HashMap proAllocStdMap = Maps.newHashMapWithExpectedSize((int)64);
        for (Row row : proAllocStdDs) {
            String costCenterId = row.getString("costCenterId");
            String costDriver = row.getString("costdriver");
            proAllocStdMap.put(costCenterId, costDriver);
            String costdriverDetail = row.getString("costdriverdetail");
            if (costdriverDetail == null || !StringUtils.isNotEmpty((String)costdriverDetail)) continue;
            String subElementId = row.getString("subElementId");
            String key = costCenterId + "@" + subElementId;
            proAllocStdMap.put(key, costdriverDetail);
        }
        return proAllocStdMap;
    }

    public static String getProAllocStd(Map<String, String> proAllocStdMap, long costAccountId, long costCenterId, long subElementId) {
        if (CadEmptyUtils.isEmpty(proAllocStdMap)) {
            return null;
        }
        String key = String.format("%s@%s", costCenterId, subElementId);
        String allocStd = proAllocStdMap.get(key);
        if (StringUtils.isEmpty((String)allocStd)) {
            key = String.valueOf(costCenterId);
            allocStd = proAllocStdMap.get(key);
        }
        if (StringUtils.isEmpty((String)allocStd) && StringUtils.isEmpty((String)(allocStd = proAllocStdMap.get(key = String.format("%s@%s", "0", subElementId))))) {
            allocStd = proAllocStdMap.get("0");
        }
        return allocStd;
    }

    private static DataSet getProAllocStdDataSet(Long orgId, Long costAccountId, String effectStatus, String appNum) {
        if (CadEmptyUtils.isEmpty((Long)orgId) || CadEmptyUtils.isEmpty((Long)costAccountId) || CadEmptyUtils.isEmpty((String)effectStatus) || CadEmptyUtils.isEmpty((String)appNum)) {
            logger.info("\u67e5\u8be2\u53c2\u6570\u4f20\u5165\u9519\u8bef\uff0c\u8fd4\u56deNull");
            return null;
        }
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costAccountId);
        filter.and("effectstatus", "=", (Object)effectStatus);
        filter.and("billstatus", "=", (Object)"C");
        String selectFields = " allocentry.costcenter as costCenterId,allocentry.costdriver as costdriver,allocentry.productsubentry.element as elementId,allocentry.productsubentry.subelement as subElementId,allocentry.productsubentry.costdriverdetail as costdriverdetail";
        if ("sca".equals(appNum)) {
            return QueryServiceHelper.queryDataSet((String)"ProAllocStdHelper.getProAllocStdDataSet", (String)"sca_proallocstd", (String)selectFields, (QFilter[])filter.toArray(), null);
        }
        if ("aca".equals(appNum)) {
            return QueryServiceHelper.queryDataSet((String)"ProAllocStdHelper.getProAllocStdDataSet", (String)"aca_proallocstd", (String)selectFields, (QFilter[])filter.toArray(), null);
        }
        return null;
    }

    private static DataSet getDiffProAllocStdDs(Long orgId, Long costAccountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costAccountId);
        filter.and("effectstatus", "=", (Object)"1");
        filter.and("billstatus", "=", (Object)"C");
        String selectFields = " allocentry.costcenter as costCenterId,allocentry.diffcalccostdriver as costdriver,allocentry.costdriver as costdriverbak,allocentry.productsubentry.element as elementId,allocentry.productsubentry.subelement as subElementId,allocentry.productsubentry.diffcalccdriverdetail as costdriverdetail";
        DataSet ds = QueryServiceHelper.queryDataSet((String)"ProAllocStdHelper.getProAllocStdDataSet", (String)"sca_proallocstd", (String)selectFields, (QFilter[])filter.toArray(), null);
        ds = ds.select("costCenterId,elementId,subElementId,costdriverdetail,case when costdriver =' ' then costdriverbak when costdriver ='' then costdriverbak when costdriver is null then costdriverbak else costdriver end costdriver");
        return ds;
    }

    private static DataSet getUnAbsorbAllocStdDs(Long orgId, Long costAccountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costAccountId);
        filter.and("effectstatus", "=", (Object)"1");
        filter.and("billstatus", "=", (Object)"C");
        String selectFields = " allocentry.costcenter as costCenterId,allocentry.unabsorbcostdriver as costdriver,allocentry.costdriver as costdriverbak,0L as elementId,0L as subElementId,'' as costdriverdetail";
        DataSet ds = QueryServiceHelper.queryDataSet((String)"ProAllocStdHelper.getProAllocStdDataSet", (String)"sca_proallocstd", (String)selectFields, (QFilter[])filter.toArray(), null);
        ds = ds.select("costCenterId,elementId,subElementId,costdriverdetail,case when costdriver =' ' then costdriverbak when costdriver ='' then costdriverbak when costdriver is null then costdriverbak else costdriver end costdriver");
        return ds;
    }
}

