/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadListUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.DynamicObjectHelper;
import kd.macc.sca.common.helper.MaterialRangeCalcHelper;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import kd.macc.sca.mservice.MaterialRangeCalcServiceImpl;

public class AutoCalcMaterialExecutor
implements Executor {
    private static final Log LOG = LogFactory.getLog(AutoCalcMaterialExecutor.class);
    private static final String OPR_KEY_ALL = "AUTO_CALCULATION_ALL";
    private static final String OPR_KEY_ALL_RETRY = "AUTO_CALCULATION_ALL_RETRY";
    private static final String OPR_KEY_UNDO = "AUTO_CALCULATION_UNDO";
    private static final String SEL_FIELD_AUTO_CALC = "id,material,materialattr";
    private static final String QUERY_MATERIAL_BATCH_SIZE_KEY = "autoCalcQueryMaterialBatchSize";
    private static final String HEART_CHECK__MINUTE_TIME_OUT = "heartCheckMinuteTimeOut";
    private static final Set<String> operateKeySet = new HashSet<String>();
    private static final String AUTO_CALC_MATERIAL_LOCK = "auto_calc_material_lock";
    private String entityName;
    private String oprKey;

    public AutoCalcMaterialExecutor(String entityName, String oprKey) {
        this.entityName = entityName;
        this.oprKey = oprKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO param) {
        LOG.info("autoCalcMaterialExecutor task start, oprKey={}", (Object)this.oprKey);
        if (!operateKeySet.contains(this.oprKey)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(param, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.oprKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        if (param == null) {
            return false;
        }
        if (CadEmptyUtils.isEmpty((List)param.getOrgCostAccountUserList())) {
            LOG.info("autoCalcMaterialExecutor task is over, because param or accountOrg is empty!");
            ScaAutoExecShemeHelper.buildSchemeLogDetail(param, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.oprKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        List orgCostAccountUserList = param.getOrgCostAccountUserList();
        for (Long[] orgCostAccountUser : orgCostAccountUserList) {
            if (orgCostAccountUser == null || orgCostAccountUser.length <= 0) continue;
            Long accountOrgId = orgCostAccountUser[0];
            if (OPR_KEY_UNDO.equals(this.oprKey)) {
                LOG.info("autoCalcMaterialExecutor task undo start run,accountOrgId={}", (Object)accountOrgId);
                ArrayList<String> statusList = new ArrayList<String>();
                statusList.add(String.valueOf(3));
                statusList.add(String.valueOf(0));
                statusList.add(String.valueOf(4));
                boolean result = this.runAllTask(accountOrgId, null, statusList);
                LOG.info("autoCalcMaterialExecutor task undo end run,accountOrgId={},result={}", (Object)accountOrgId, (Object)result);
                continue;
            }
            if (OPR_KEY_ALL_RETRY.equals(this.oprKey) || !OPR_KEY_ALL.equals(this.oprKey)) continue;
            LOG.info("autoCalcMaterialExecutor task all start run,accountOrgId={}", (Object)accountOrgId);
            int result = this.updateMaterialRangeStatus(accountOrgId);
            LOG.info("autoCalcMaterialExecutor task all end run,accountOrgId={}, result={}", (Object)accountOrgId, (Object)result);
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(param, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.oprKey, AutoExecInvEnum.SUCCESS.getName());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runAllTask(Long accountOrgId, Long lastSuccessPointAutoCalcRangeId, List<String> statusList) {
        DLock lock = DLock.create((String)AUTO_CALC_MATERIAL_LOCK, (String)ResManager.loadKDString((String)"\u7269\u6599\u8303\u56f4\u5377\u7b97\u540c\u6b65\u9501", (String)"AutoCalcMaterialExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
        if (!lock.tryLock()) {
            LOG.info("runAllTask accountOrgId={}, get lock={} fail.", (Object)accountOrgId, (Object)AUTO_CALC_MATERIAL_LOCK);
            return false;
        }
        boolean result = false;
        try {
            result = this.runTask(accountOrgId, statusList, lastSuccessPointAutoCalcRangeId);
        }
        catch (Exception e) {
            result = false;
            LOG.error("runAllTask accountOrgId={}, error=", (Object)accountOrgId, (Object)e);
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
        return result;
    }

    private Long getRetryPoint() {
        QFilter qFilter = new QFilter("status", "=", (Object)"0");
        int heartCheckTimeOut = Integer.parseInt(CadBgParamUtils.getCadBgParamForString((String)HEART_CHECK__MINUTE_TIME_OUT, (String)"120"));
        qFilter.and(new QFilter("lastrundate", "<", (Object)DateUtils.getLastMinute((Date)new Date(), (int)heartCheckTimeOut)));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_aucalrangeprorecord", (String)"autocalcrangeid", (QFilter[])qFilter.toArray(), (String)"id desc", (int)1);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return 0L;
        }
        return ((DynamicObject)dynamicObjects.get(0)).getLong("autocalcrangeid");
    }

    public boolean runTask(Long accountOrgId, List<String> statusList, Long lastSuccessPointAutoCalcRangeId) {
        long taskStartTime = System.currentTimeMillis();
        try {
            ArrayList<Long> accountOrgIdList = new ArrayList<Long>();
            accountOrgIdList.add(accountOrgId);
            List produceOrgIdList = MaterialRangeCalcHelper.getDelegatedOrgIdListByOrgId(accountOrgIdList, (String)"10", (String)"04");
            if (CadEmptyUtils.isEmpty((List)produceOrgIdList)) {
                LOG.info("autoCalcMaterialExecutor task end, accountOrgId={}, produceOrgIdList is empty", (Object)accountOrgId);
                return false;
            }
            LOG.info("autoCalcMaterialExecutor task start,accountOrgId={},produceOrgId size={}", (Object)accountOrgId, (Object)produceOrgIdList.size());
            int producesTotal = 0;
            int producesSuccessCount = 0;
            int producesFailCount = 0;
            for (Long produceOrgId : produceOrgIdList) {
                LOG.info("autoCalcMaterialExecutor task cycle produceOrg process start produceOrgId={}", (Object)produceOrgId);
                int successCount = 0;
                int failCount = 0;
                int totalCount = 0;
                for (int j = 0; j < 2; ++j) {
                    Long routeRuleSettingId;
                    boolean configAttr = j == 1;
                    LOG.info("autoCalcMaterialExecutor task cycle config attr process start produceOrgId={},configAttr={}", (Object)produceOrgId, (Object)configAttr);
                    Long mockCostType = MaterialRangeCalcHelper.getMockCostTypeByProduceOrgId((Long)produceOrgId);
                    if (CadEmptyUtils.isEmpty((Long)mockCostType)) {
                        LOG.info("autoCalcMaterialExecutor task end produceOrgId={}, mockCostType is empty", (Object)produceOrgId);
                        continue;
                    }
                    Long rulePlanId = MaterialRangeCalcHelper.getRulePlanIdByCostType((Long)mockCostType);
                    if (CadEmptyUtils.isEmpty((Long)rulePlanId)) {
                        LOG.info("autoCalcMaterialExecutor task end produceOrgId={},mockCostType={}, rulePlanId is empty", (Object)produceOrgId, (Object)mockCostType);
                        continue;
                    }
                    Long bomRuleId = MaterialRangeCalcHelper.getBoomRuleIdByCostType((Long)mockCostType);
                    if (CadEmptyUtils.isEmpty((Long)bomRuleId)) {
                        LOG.info("autoCalcMaterialExecutor task produceOrgId={},mockCostType={}, boolRuleId is empty", (Object)produceOrgId, (Object)mockCostType);
                        if (!configAttr) continue;
                    }
                    if (CadEmptyUtils.isEmpty((Long)(routeRuleSettingId = MaterialRangeCalcHelper.getRouteRuleSettingIdByCostType((Long)mockCostType)))) {
                        LOG.info("autoCalcMaterialExecutor task produceOrgId={}, mockCostType={}, routeRuleSettingId is empty", (Object)produceOrgId, (Object)mockCostType);
                        if (!configAttr) continue;
                    }
                    LOG.info("autoCalcMaterialExecutor task process  check ok, produceOrgId={},mockCostType={},rulePlanId={},boolRuleId={},routeRuleSettingId={}  ", new Object[]{produceOrgId, mockCostType, rulePlanId, bomRuleId, routeRuleSettingId});
                    DynamicObjectCollection dynamicObjectCollection = this.getDynamicObjectsByIdList(statusList, produceOrgId, lastSuccessPointAutoCalcRangeId, configAttr);
                    if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
                        LOG.info("autoCalcMaterialExecutor task end produceOrgId={}, query from db material range is empty", (Object)produceOrgId);
                        continue;
                    }
                    List<Long> idList = this.getIdList(dynamicObjectCollection);
                    LOG.info("autoCalcMaterialExecutor task produceOrgId={}, query material range idList size={}", (Object)produceOrgId, (Object)idList.size());
                    int batchSize = Integer.parseInt(CadBgParamUtils.getCadBgParamForString((String)QUERY_MATERIAL_BATCH_SIZE_KEY, (String)"100"));
                    List splitMaterialList = CadListUtils.splitLists(new ArrayList<Long>(idList), (int)batchSize);
                    for (List materialList : splitMaterialList) {
                        List idsBatch = materialList;
                        QFilter qFilterBatch = new QFilter("id", "in", (Object)idsBatch);
                        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_autocalcmatrange", (String)SEL_FIELD_AUTO_CALC, (QFilter[])qFilterBatch.toArray());
                        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
                            LOG.info("autoCalcMaterialExecutor task produceOrgId={}, query material range idList batch result is empty", (Object)produceOrgId);
                            continue;
                        }
                        LOG.info("autoCalcMaterialExecutor task produceOrgId={}, query material range idList batch result size={}", (Object)produceOrgId, (Object)dynamicObjects.size());
                        try {
                            long startTime = System.currentTimeMillis();
                            MaterialRangeCalcServiceImpl materialRangeCalcService = new MaterialRangeCalcServiceImpl();
                            int success = materialRangeCalcService.doCheckCalculate(dynamicObjects, rulePlanId, mockCostType, bomRuleId, routeRuleSettingId, idsBatch, configAttr);
                            int total = dynamicObjects.size();
                            int fail = total - success;
                            successCount += success;
                            failCount += fail;
                            totalCount += total;
                            this.updateAutoTaskProcessRecord(idsBatch, success, fail);
                            LOG.info("autoCalcMaterialExecutor task batch doCheckCalculate success,produceOrgId={},success={},costTime={}ms", new Object[]{produceOrgId, success, System.currentTimeMillis() - startTime});
                        }
                        catch (Exception e) {
                            failCount += dynamicObjects.size();
                            LOG.error("autoCalcMaterialExecutor task batch doCheckCalculate error,produceOrgId={},e=", (Object)produceOrgId, (Object)e);
                        }
                    }
                    LOG.info("autoCalcMaterialExecutor task cycle config attr process end produceOrgId={},configAttr={},successCount={}, failCount={}", new Object[]{produceOrgId, configAttr, successCount, failCount});
                }
                producesTotal += totalCount;
                producesSuccessCount += successCount;
                producesFailCount += failCount;
                LOG.info("autoCalcMaterialExecutor task cycle produceOrg process end produceOrgId={},totalCount={}, successCount={},failCount={}", new Object[]{produceOrgId, totalCount, successCount, failCount});
            }
            LOG.info("autoCalcMaterialExecutor task end accountOrgId={},producesTotal={},producesSuccessCount={}, producesFailCount={},costTime={}ms", new Object[]{accountOrgId, producesTotal, producesSuccessCount, producesFailCount, System.currentTimeMillis() - taskStartTime});
            this.updateAutoTaskFinalProcessRecord();
            return true;
        }
        catch (Exception e) {
            LOG.error("autoCalcMaterialExecutor task accountOrgId={}, error=", (Object)accountOrgId, (Object)e);
            return false;
        }
    }

    private void updateAutoTaskFinalProcessRecord() {
        Object[] params = new SqlParameter[]{new SqlParameter("status", 12, (Object)"1")};
        DB.execute((DBRoute)new DBRoute("cal"), (String)"update t_cad_aucalrangeprorecord set fstatus = ? where 1 = 1", (Object[])params);
    }

    private void updateAutoTaskProcessRecord(List<Long> idsBatch, int success, int fail) {
        Long lastId = idsBatch.get(idsBatch.size() - 1);
        QFilter qFilter = new QFilter("status", "=", (Object)"0");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_aucalrangeprorecord", (String)"id,autocalcrangeid,lastrundate,status,success,fail", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            DynamicObject dynamicObjectAdd = BusinessDataServiceHelper.newDynamicObject((String)"cad_aucalrangeprorecord");
            dynamicObjectAdd.set("autocalcrangeid", (Object)lastId);
            dynamicObjectAdd.set("lastrundate", (Object)new Date());
            dynamicObjectAdd.set("status", (Object)"0");
            dynamicObjectAdd.set("success", (Object)success);
            dynamicObjectAdd.set("fail", (Object)fail);
            dynamicObjectAdd.set("total", (Object)(success + fail));
            DynamicObject[] dynamicObjectsResult = new DynamicObject[]{dynamicObjectAdd};
            SaveServiceHelper.save((DynamicObject[])dynamicObjectsResult);
        } else {
            Object[] params = new SqlParameter[]{new SqlParameter("autocalcrangeid", -5, (Object)lastId), new SqlParameter("lastrundate", 91, (Object)new Date()), new SqlParameter("success", -5, (Object)success), new SqlParameter("fail", -5, (Object)fail), new SqlParameter("total", -5, (Object)(success + fail)), new SqlParameter("id", -5, (Object)dynamicObject.getLong("id"))};
            DB.execute((DBRoute)new DBRoute("cal"), (String)"update t_cad_aucalrangeprorecord set fautocalcrangeid = ?, flastrundate=?, fsuccess =fsuccess+ ?, ffail = ffail+?, ftotal = ftotal+? where fid = ?", (Object[])params);
        }
    }

    private List<Long> getIdList(DynamicObjectCollection dynamicObjectCollection) {
        ArrayList<Long> idList = new ArrayList<Long>();
        dynamicObjectCollection.forEach(item -> idList.add(item.getLong("id")));
        return idList;
    }

    private DynamicObjectCollection getDynamicObjectsByIdList(List<String> statusList, Long produceOrgId, Long lastSuccessPointAutoCalcRangeId, boolean configAttr) {
        QFilter qFilter = new QFilter("manuorg", "=", (Object)produceOrgId);
        qFilter.and(new QFilter("configmat", "=", (Object)configAttr));
        int autoCalcMatBatchSize = CadBgParamUtils.getCadParamForInt((String)"autoCalcMatBatchSize", (int)5000);
        int autoCalcFailMatBatchSize = CadBgParamUtils.getCadParamForInt((String)"autoCalcFailMatBatchSize", (int)1000);
        int autoReCalcMatBatchSize = CadBgParamUtils.getCadParamForInt((String)"autoReCalcMatBatchSize", (int)3000);
        QFilter statusFilter = new QFilter("status", "=", (Object)"3");
        DynamicObjectCollection failMaterialDyos = QueryServiceHelper.query((String)"cad_autocalcmatrange", (String)"id", (QFilter[])new QFilter[]{qFilter, statusFilter}, (String)"syndate desc", (int)autoCalcFailMatBatchSize);
        statusFilter = new QFilter("status", "=", (Object)"4");
        DynamicObjectCollection reCalcMaterialDyos = QueryServiceHelper.query((String)"cad_autocalcmatrange", (String)"id", (QFilter[])new QFilter[]{qFilter, statusFilter}, null, (int)autoReCalcMatBatchSize);
        int count = failMaterialDyos.size() + reCalcMaterialDyos.size();
        autoCalcMatBatchSize = autoCalcMatBatchSize > count ? (autoCalcMatBatchSize -= count) : count - autoCalcMatBatchSize;
        statusFilter = new QFilter("status", "=", (Object)"0");
        DynamicObjectCollection initCalcMaterialDyos = QueryServiceHelper.query((String)"cad_autocalcmatrange", (String)"id", (QFilter[])new QFilter[]{qFilter, statusFilter}, null, (int)autoCalcMatBatchSize);
        initCalcMaterialDyos.addAll((Collection)failMaterialDyos);
        initCalcMaterialDyos.addAll((Collection)reCalcMaterialDyos);
        return initCalcMaterialDyos;
    }

    private int updateMaterialRangeStatus(Long accountOrgId) {
        ArrayList<Long> accountOrgIdList = new ArrayList<Long>();
        accountOrgIdList.add(accountOrgId);
        List produceOrgIdList = MaterialRangeCalcHelper.getDelegatedOrgIdListByOrgId(accountOrgIdList, (String)"10", (String)"04");
        QFilter qFilter = new QFilter("manuorg", "in", (Object)produceOrgIdList);
        qFilter.and(new QFilter("status", "in", (Object)new String[]{"2"}));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cad_autocalcmatrange", (String)"id", (QFilter[])qFilter.toArray());
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return 0;
        }
        List<Object> ids = DynamicObjectHelper.getFieldList(dynamicObjectCollection, "id");
        Lists.partition(ids, (int)5000).forEach(idList -> {
            String sql = "update t_cad_autocalcmatrange set fstatus='4' where fid in (" + StringUtils.join((Object[])idList.toArray(), (String)",") + ")";
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)sql);
        });
        return ids.size();
    }

    static {
        operateKeySet.add(OPR_KEY_ALL);
        operateKeySet.add(OPR_KEY_ALL_RETRY);
        operateKeySet.add(OPR_KEY_UNDO);
    }
}

