/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.helper.MaterialRangeImportHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CadListUtils;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.MaterialRangeCalcHelper;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;

public class AutoImportMaterialExecutor
implements Executor {
    private static final Log LOG = LogFactory.getLog(AutoImportMaterialExecutor.class);
    private static final String OPR_KEY_IMPORT = "AUTO_IMPORT_MATERIAL";
    private static final String AUTO_IMPORT_MATERIAL_LOCK = "auto_import_material_lock";
    private static final String MATERIAL_GROUP_BATCH_SIZE = "materialGroupBatchSize";
    private AtomicInteger success = new AtomicInteger(0);
    private String entityName;
    private String oprKey;

    public AutoImportMaterialExecutor(String entityName, String oprKey) {
        this.entityName = entityName;
        this.oprKey = oprKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO param) {
        LOG.info("AutoImportMaterialExecutor task start, oprKey={}", (Object)this.oprKey);
        if (!OPR_KEY_IMPORT.equals(this.oprKey)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(param, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.oprKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        if (param == null) {
            return false;
        }
        if (CadEmptyUtils.isEmpty((List)param.getOrgCostAccountUserList())) {
            LOG.info("AutoImportMaterialExecutor task is over, because param or accountOrg is empty!");
            ScaAutoExecShemeHelper.buildSchemeLogDetail(param, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.oprKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        List orgCostAccountUserList = param.getOrgCostAccountUserList();
        this.success = new AtomicInteger(0);
        for (Long[] orgCostAccountUser : orgCostAccountUserList) {
            if (orgCostAccountUser == null || orgCostAccountUser.length <= 0) continue;
            Long accountOrgId = orgCostAccountUser[0];
            LOG.info("AutoImportMaterialExecutor task cycle start process, accountOrgId={}", (Object)accountOrgId);
            boolean result = this.runTask(accountOrgId);
            LOG.info("AutoImportMaterialExecutor task cycle end process, accountOrgId={},result={}", (Object)accountOrgId, (Object)result);
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(param, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.oprKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), this.success.intValue()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTask(Long accountOrgId) {
        DLock lock = DLock.create((String)AUTO_IMPORT_MATERIAL_LOCK, (String)ResManager.loadKDString((String)"\u7269\u6599\u81ea\u52a8\u5bfc\u5165\u540c\u6b65\u9501", (String)"AutoImportMaterialExecutor_2", (String)"macc-sca-form", (Object[])new Object[0]));
        if (!lock.tryLock()) {
            LOG.info("AutoImportMaterialExecutor task runTask accountOrgId={}, get lock={} fail.", (Object)accountOrgId, (Object)AUTO_IMPORT_MATERIAL_LOCK);
            return false;
        }
        boolean result = false;
        try {
            ArrayList<Long> accountOrgIdList = new ArrayList<Long>();
            accountOrgIdList.add(accountOrgId);
            List produceOrgIdList = MaterialRangeCalcHelper.getDelegatedOrgIdListByOrgId(accountOrgIdList, (String)"10", (String)"04");
            if (CadEmptyUtils.isEmpty((List)produceOrgIdList)) {
                LOG.info("AutoImportMaterialExecutor task runTask end, produceOrgIdList is empty");
                boolean bl = result;
                return bl;
            }
            List<Long> materialGroupList = this.getMaterialGroupList();
            if (materialGroupList == null) {
                LOG.info("AutoImportMaterialExecutor task runTask end, materialGroupList is empty");
                boolean bl = result;
                return bl;
            }
            for (Long produceOrgId : produceOrgIdList) {
                long startTime = System.currentTimeMillis();
                LOG.info("AutoImportMaterialExecutor task runTask cycle produceOrgId process start produceOrgId={},materialGroupList size={}", (Object)produceOrgId, (Object)materialGroupList.size());
                int total = this.updateProduceMaterialToDbByBatch(produceOrgId, materialGroupList);
                this.success.addAndGet(total);
                LOG.info("AutoImportMaterialExecutor task runTask cycle produceOrgId process end produceOrgId={}, update total={},success={}, costTime={}", new Object[]{produceOrgId, total, this.success.intValue(), System.currentTimeMillis() - startTime});
            }
            result = true;
        }
        catch (Exception e) {
            result = false;
            LOG.error("AutoImportMaterialExecutor task runTask exception accountOrgId={}, error=", (Object)accountOrgId, (Object)e);
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
        return result;
    }

    private int updateProduceMaterialToDbByBatch(Long produceOrgId, List<Long> materialGroupList) {
        int materialGroupBatchSize = Integer.parseInt(CadBgParamUtils.getCadBgParamForString((String)MATERIAL_GROUP_BATCH_SIZE, (String)"5"));
        List splitGroupList = CadListUtils.splitLists(new ArrayList<Long>(materialGroupList), (int)materialGroupBatchSize);
        List bomMaterialIdList = MaterialRangeImportHelper.getBomMaterialIdList((Long)produceOrgId);
        int total = 0;
        for (List groupList : splitGroupList) {
            if (CadEmptyUtils.isEmpty((List)groupList)) continue;
            List groupIdList = groupList;
            LOG.info("AutoImportMaterialExecutor task runTask updateProduceMaterialToDbByBatch cycle group process start produceOrgId={}, groupIdList size={}", (Object)produceOrgId, (Object)groupList.size());
            List produceMaterialList = MaterialRangeImportHelper.queryMaterialProduceListByParam((Long)730148448254487552L, (List)groupIdList, (Long)produceOrgId, (List)bomMaterialIdList);
            LOG.info("AutoImportMaterialExecutor task runTask updateProduceMaterialToDbByBatch cycle group process produceOrgId={}, groupIdList size={},produceMaterialList size={}", new Object[]{produceOrgId, groupIdList.size(), produceMaterialList.size()});
            if (CadEmptyUtils.isEmpty((List)produceMaterialList)) {
                LOG.info("AutoImportMaterialExecutor task runTask updateProduceMaterialToDbByBatch cycle group process produceOrgId={}, groupIdList={},produceMaterialList is empty.", (Object)produceOrgId, (Object)groupIdList);
                continue;
            }
            int addNum = MaterialRangeImportHelper.saveAndUpdateMaterialRange((List)produceMaterialList, (Long)produceOrgId);
            total += addNum;
            LOG.info("AutoImportMaterialExecutor task runTask updateProduceMaterialToDbByBatch batch process end produceOrgId={},addNum={}", (Object)produceOrgId, (Object)addNum);
        }
        return total;
    }

    private List<Long> getMaterialGroupList() {
        ArrayList<Long> materialGroupList = new ArrayList<Long>();
        QFilter groupFilter = new QFilter("standard", "=", (Object)730148448254487552L);
        groupFilter.and(new QFilter("enable", "=", (Object)"1"));
        groupFilter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id", (QFilter[])groupFilter.toArray());
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return materialGroupList;
        }
        dynamicObjectCollection.forEach(item -> materialGroupList.add(item.getLong("id")));
        return materialGroupList;
    }
}

