/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import org.apache.commons.collections.CollectionUtils;

public class CostBomOperExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;

    public CostBomOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (!EntityOperEnum.OPER_COSTBOM.getValue().equals(this.operKey)) {
            return false;
        }
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_costbom", this.operKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"cad_costbom", (String)"47156aff000000ac");
        if (!hasPerm) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_costbom", this.operKey, AutoExecInvEnum.NO_PERM.getName());
            return false;
        }
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
        logger.info("\u81ea\u52a8\u6267\u884c-\u540c\u6b65\u5236\u9020BOM\uff0c\u6838\u7b97\u7ec4\u7ec7\uff1a{}", (Object)SerializationUtils.toJsonString(orgList));
        int sum = 0;
        for (Long orgId : orgList) {
            if (CadEmptyUtils.isEmpty((Long)orgId)) continue;
            String lockId = "CostBomOperExecutor" + orgId;
            DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u6210\u672cBOM\u81ea\u52a8\u540c\u6b65\u9501", (String)"CostBomOperExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
            try {
                boolean isLocked = lock.tryLock();
                if (!isLocked) continue;
                Map<String, String> resultMsgMap = this.doInvokeBizService(orgId);
                int result = 0;
                if (!CadEmptyUtils.isEmpty(resultMsgMap) && resultMsgMap.get("qty") != null) {
                    result = Integer.parseInt(resultMsgMap.get("qty"));
                }
                if (result < 0) continue;
                sum += result;
                schemeLogSubDetail.add(new SchemeLogSubDetail(orgId, Long.valueOf(0L), Long.valueOf(0L), result));
            }
            catch (Exception e) {
                logger.error("\u81ea\u52a8\u6267\u884c-\u540c\u6b65\u5236\u9020BOM\u5f02\u5e38\u3002", (Throwable)e);
            }
            finally {
                if (lock == null) continue;
                lock.close();
            }
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "cad_costbom", this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        return true;
    }

    private Map<String, String> doInvokeBizService(Long orgId) {
        Map resultMsgMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"CadBomRouteSyncService", (String)"doSyncBom", (Object[])new Object[]{orgId, null, null});
        return resultMsgMap;
    }
}

