/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import kd.macc.sca.common.helper.SendMessageHelper;
import org.apache.commons.collections.CollectionUtils;

public class CostObjectOperExecutor
implements Executor {
    private Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;

    public CostObjectOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (!EntityOperEnum.OPER_SYSIMPORT.getValue().equals(this.operKey)) {
            return false;
        }
        String appId = autoExecSchemeDTO.getAppnum();
        int sum = 0;
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_costobject", this.operKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        String orgIds = autoExecSchemeDTO.getOrgCostAccountUserList().stream().map(orgCostAccountUser -> orgCostAccountUser[0]).collect(Collectors.toList()).toString();
        boolean hasPerm = CadPermissionUtil.check((Long)autoExecSchemeDTO.getExecutor(), (String)orgIds, (boolean)true, (String)autoExecSchemeDTO.getAppnum(), (String)"cad_costobject", (String)"47156aff000000ac");
        if (!hasPerm) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_costobject", this.operKey, AutoExecInvEnum.NO_PERM.getName());
            return false;
        }
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
        for (Long orgId : orgList) {
            List<Long> userIds = ScaAutoExecShemeHelper.getUserIdsByOrg(orgId, orgCostAccountUserList);
            Integer sucQty = 0;
            String lockId = "CostObjectOperExecutor" + orgId;
            DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u81ea\u52a8\u5f52\u96c6\u9501", (String)"CostObjectOperExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
            try {
                boolean isLocked = lock.tryLock();
                if (!isLocked) continue;
                if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
                    List manuOrgIds = OrgHelper.getProOrgsByOrgEntity((Long)orgId, (String)"cad_costobject", (String)autoExecSchemeDTO.getAppnum());
                    Set<Long> ccIds = CostObjectOperExecutor.getCenterIdsByManuOrgIds(orgId, manuOrgIds, appId);
                    Map<String, String> resultInfo = this.invokeBizMulService(orgId, ccIds, manuOrgIds, appId);
                    this.logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u81ea\u52a8\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + resultInfo.toString());
                    Integer successQty = Integer.parseInt(resultInfo.get("successQty") != null ? resultInfo.get("successQty") : "0");
                    if (resultInfo != null && successQty > 0) {
                        sum += successQty.intValue();
                        sucQty = sucQty + successQty;
                    }
                    schemeLogSubDetail.add(new SchemeLogSubDetail(orgId, Long.valueOf(0L), Long.valueOf(0L), successQty.intValue()));
                } else {
                    List ccIds = OrgHelper.getCostCentersByOrg((long)orgId);
                    Map<String, String> resultInfo = this.invokeBizMulService(orgId, Sets.newHashSet((Iterable)ccIds), null, appId);
                    this.logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u81ea\u52a8\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + resultInfo.toString());
                    Integer successQty = Integer.parseInt(resultInfo.get("successQty") != null ? resultInfo.get("successQty") : "0");
                    if (resultInfo != null && successQty > 0) {
                        sum += successQty.intValue();
                        sucQty = sucQty + successQty;
                    }
                    schemeLogSubDetail.add(new SchemeLogSubDetail(orgId, Long.valueOf(0L), Long.valueOf(0L), successQty.intValue()));
                }
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
            finally {
                if (lock == null) continue;
                lock.close();
                continue;
            }
            if (userIds.isEmpty()) continue;
            SendMessageHelper.sendMCMessage(userIds, (String)String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f52\u96c6\u6267\u884c\u6210\u529f\uff0c\u5bfc\u5165\u6570\u636e%s\u6761\u3002", (String)"CostObjectOperExecutor_3", (String)"macc-sca-form", (Object[])new Object[0]), sucQty));
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "cad_costobject", this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        return true;
    }

    private Map<String, String> invokeBizMulService(Long orgId, Set<Long> ccIds, List<Long> manuOrgIds, String appId) {
        Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"costObjectService", (String)"importCostObject", (Object[])new Object[]{null, null, orgId, new ArrayList<Long>(ccIds), manuOrgIds, appId, null});
        return resultInfo;
    }

    public static Set<Long> getCenterIdsByManuOrgIds(Long orgId, List<Long> manuList, String appId) {
        if (CadEmptyUtils.isEmpty((String)appId)) {
            appId = "sca";
        }
        HashSet<Long> centerIds = new HashSet<Long>(20);
        HashSet<Long> allCenterIds = new HashSet<Long>(20);
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and("manuorg", "in", manuList);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)appId);
        DataSet costCenterDs = QueryServiceHelper.queryDataSet((String)"getCenterIdsByManuOrgIds", (String)"cad_centermanuorg", (String)"entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray(), null);
        for (Row costCenter : costCenterDs) {
            allCenterIds.add(costCenter.getLong("costcenterid"));
        }
        if (!CadEmptyUtils.isEmpty(allCenterIds)) {
            QFilter ccFilter = new QFilter("id", "in", allCenterIds);
            ccFilter.and(new QFilter("orgduty", "=", (Object)4L));
            DataSet basicCostCenterDs = QueryServiceHelper.queryDataSet((String)"getCenterIds", (String)"bos_costcenter", (String)"id", (QFilter[])ccFilter.toArray(), null);
            for (Row costCenter : basicCostCenterDs) {
                centerIds.add(costCenter.getLong("id"));
            }
        }
        if (CadEmptyUtils.isEmpty(centerIds)) {
            centerIds.add(-1L);
        }
        return centerIds;
    }
}

