/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.helper.CostBomRouteRefreshHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import org.apache.commons.collections.CollectionUtils;

public class CostRouterSettingOperExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;

    public CostRouterSettingOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (EntityOperEnum.OPER_REFRESHROUTE.getValue().equals(this.operKey)) {
            int sum = 0;
            List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
            if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
                ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_routersetting", this.operKey, AutoExecInvEnum.FAIL.getName());
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"cad_routersetting", (String)"47156aff000000ac");
            if (!hasPerm) {
                ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_routersetting", this.operKey, AutoExecInvEnum.NO_PERM.getName());
                return false;
            }
            ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
            List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
            for (Long orgId : orgList) {
                String lockId;
                DLock lock;
                boolean isLocked;
                if (CadEmptyUtils.isEmpty((Long)orgId) || !(isLocked = (lock = DLock.create((String)(lockId = "CostRouterSettingOperExecutor" + orgId), (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u6210\u672c\u5de5\u827a\u8def\u7ebf\u81ea\u52a8\u540c\u6b65\u9501", (String)"CostRouterSettingOperExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]))).tryLock())) continue;
                try {
                    int result = CostBomRouteRefreshHelper.refreshRoute((Long)orgId);
                    if (result < 0) continue;
                    sum += result;
                    schemeLogSubDetail.add(new SchemeLogSubDetail(orgId, Long.valueOf(0L), Long.valueOf(0L), result));
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "cad_routersetting", this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        }
        return true;
    }
}

