/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.output.AllocResult;
import kd.macc.sca.algox.alloc.ScaMatAllocHelper;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import kd.macc.sca.common.helper.SendMessageHelper;
import org.apache.commons.collections.CollectionUtils;

public class MatAllocOperExecutor
implements Executor {
    private Log logger = LogFactory.getLog(MatAllocOperExecutor.class);
    private String entityName;
    private String operKey;
    private String classPath = "kd.macc.aca.algox.alloc.AcaMatAllocHelper";
    private String methodName = "importAllocData";

    public MatAllocOperExecutor(String entityName, String operKey) {
        this.entityName = entityName;
        this.operKey = operKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)this.entityName, (String)"80513208000000ac");
        if (!hasPerm) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, AutoExecInvEnum.NO_PERM.getName());
            return false;
        }
        int sum = 0;
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
        List<Long> costAccountIds = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 1);
        DataSet paramDataSet = null;
        if ("sca".equals(autoExecSchemeDTO.getAppnum()) || "eca".equals(autoExecSchemeDTO.getAppnum())) {
            paramDataSet = this.getParamData(orgCostAccountUserList);
        }
        Map<Long, List<Long>> orgCostAccountMap = ScaAutoExecShemeHelper.getOrgCostAccountMap(orgList, costAccountIds, autoExecSchemeDTO.getAppnum());
        for (Map.Entry<Long, List<Long>> orgCostAccount : orgCostAccountMap.entrySet()) {
            List<Long> costAccounts = orgCostAccount.getValue();
            if (CollectionUtils.isEmpty(costAccounts)) continue;
            for (Long costAccount : costAccounts) {
                Integer sucQty;
                List<Long> userIds;
                block19: {
                    userIds = ScaAutoExecShemeHelper.getUserIdsByOrgCostAccount(orgCostAccount.getKey(), costAccount, orgCostAccountUserList);
                    sucQty = 0;
                    String lockId = "MatAllocOperExecutor" + orgCostAccount.getKey() + costAccount;
                    DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u6750\u6599\u8017\u7528\u81ea\u52a8\u5206\u914d\u9501", (String)"MatAllocOperExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    try {
                        Integer successQty;
                        HashMap<String, Object> costaccountMap;
                        ArrayList<Map<String, Object>> costAccountList;
                        Row row;
                        block20: {
                            boolean isLocked = lock.tryLock();
                            if (!isLocked) continue;
                            if (!EntityOperEnum.OPER_IMPORT.getValue().equals(this.operKey)) break block19;
                            try {
                                if (!"sca_matalloc".equals(this.entityName)) break block20;
                                row = this.getCurParamRow(paramDataSet, orgCostAccount.getKey(), costAccount);
                                if (row == null) continue;
                                costAccountList = new ArrayList<Map<String, Object>>(10);
                                costaccountMap = new HashMap<String, Object>();
                                costaccountMap.put("org", row.getLong("org"));
                            }
                            catch (Exception e) {
                                String detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u5bfc\u5165\u6570\u636e\u5931\u8d25\u3002", (String)"MatAllocOperExecutor_7", (String)"macc-sca-form", (Object[])new Object[0]), ScaAutoExecShemeHelper.getNameById("bos_org", orgCostAccount.getKey()));
                                ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, null, this.entityName, this.operKey, detail);
                                this.logger.error((Throwable)e);
                                boolean bl = false;
                                return bl;
                            }
                            costaccountMap.put("manuorg", 0L);
                            costaccountMap.put("costaccountnum", row.getString("number"));
                            costaccountMap.put("costaccountId", row.getLong("costaccount"));
                            costaccountMap.put("currencyId", row.getLong("currency") == null ? Long.valueOf(0L) : row.getLong("currency"));
                            costaccountMap.put("amtprecision", row.getInteger("amtprecision") == null ? Integer.valueOf(10) : row.getInteger("amtprecision"));
                            costaccountMap.put("currentperiodId", row.getLong("currentperiod"));
                            costaccountMap.put("appnum", "sca");
                            costAccountList.add(costaccountMap);
                            AllocResult result = ScaMatAllocHelper.toAlloc(costAccountList, null);
                            successQty = result.getReasonMap().get("successQty") != null ? Integer.valueOf((String)result.getReasonMap().get("successQty")) : Integer.valueOf(0);
                            sum += successQty.intValue();
                            sucQty = successQty;
                            schemeLogSubDetail.add(new SchemeLogSubDetail(orgCostAccount.getKey(), Long.valueOf(0L), costAccount, successQty.intValue()));
                            break block19;
                        }
                        if ("aca".equals(autoExecSchemeDTO.getAppnum()) && "aca_matalloc".equals(this.entityName)) {
                            Class<?> doClass = Class.forName(this.classPath);
                            Object obj = doClass.newInstance();
                            Method method = doClass.getMethod(this.methodName, List.class);
                            method.invoke(obj, costAccounts);
                            String detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u5bfc\u5165\u6570\u636e\u6210\u529f\u3002", (String)"MatAllocOperExecutor_6", (String)"macc-sca-form", (Object[])new Object[0]), ScaAutoExecShemeHelper.getNameById("bos_org", orgCostAccount.getKey()));
                            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, null, this.entityName, this.operKey, detail);
                            break block19;
                        }
                        if (!"eca".equals(autoExecSchemeDTO.getAppnum()) || !"aca_matalloc".equals(this.entityName)) break block19;
                        row = this.getCurParamRow(paramDataSet, orgCostAccount.getKey(), costAccount);
                        if (row == null) continue;
                        costAccountList = new ArrayList(10);
                        costaccountMap = new HashMap();
                        costaccountMap.put("org", row.getLong("org"));
                        costaccountMap.put("manuorg", 0L);
                        costaccountMap.put("costaccountnum", row.getString("number"));
                        costaccountMap.put("costaccountId", row.getLong("costaccount"));
                        costaccountMap.put("currencyId", row.getLong("currency") == null ? Long.valueOf(0L) : row.getLong("currency"));
                        costaccountMap.put("amtprecision", row.getInteger("amtprecision") == null ? Integer.valueOf(10) : row.getInteger("amtprecision"));
                        costaccountMap.put("currentperiodId", row.getLong("currentperiod"));
                        costaccountMap.put("appnum", "eca");
                        costAccountList.add(costaccountMap);
                        Map<String, String> responseInfo = this.importMatUse(orgCostAccount.getKey(), costAccountList, null, autoExecSchemeDTO.getAppnum(), "aca_matalloc");
                        successQty = responseInfo.get("successQty") != null ? Integer.valueOf(responseInfo.get("successQty")) : Integer.valueOf(0);
                        sum += successQty.intValue();
                        sucQty = successQty;
                        schemeLogSubDetail.add(new SchemeLogSubDetail(orgCostAccount.getKey(), Long.valueOf(0L), costAccount, successQty.intValue()));
                    }
                    catch (Exception e) {
                        this.logger.error((Throwable)e);
                    }
                    finally {
                        if (lock == null) continue;
                        lock.close();
                        continue;
                    }
                }
                if (userIds.isEmpty()) continue;
                SendMessageHelper.sendMCMessage(userIds, (String)String.format(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u6267\u884c\u6210\u529f\uff0c\u6570\u636e%s\u6761\u3002", (String)"MatAllocOperExecutor_3", (String)"macc-sca-form", (Object[])new Object[0]), sucQty));
            }
        }
        if (EntityOperEnum.OPER_IMPORT.getValue().equals(this.operKey)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        } else {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.operKey, AutoExecInvEnum.SUCCESS.getName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row getCurParamRow(DataSet paramDataSet, Long orgId, Long costAccountId) {
        if (paramDataSet == null || paramDataSet.isEmpty()) {
            return null;
        }
        try (DataSet newDataSet = paramDataSet.copy();){
            for (Row row : newDataSet) {
                if (!orgId.equals(row.getLong("org")) || !costAccountId.equals(row.getLong("costaccount"))) continue;
                Row row2 = row;
                return row2;
            }
        }
        return null;
    }

    private DataSet getParamData(List<Long[]> orgCostAccountUserList) {
        DataSet originalDataSet = this.getOriginalData(orgCostAccountUserList);
        QFilter accountFilter = null;
        QFilter sysCtrlFilter = null;
        for (Row row : originalDataSet) {
            QFilter tempFilter1 = new QFilter("calorg", "=", (Object)row.getLong("orgid"));
            tempFilter1.and("id", "=", (Object)row.getLong("costaccountid"));
            if (accountFilter == null) {
                accountFilter = tempFilter1;
            } else {
                accountFilter.or(tempFilter1);
            }
            QFilter tempFilter2 = new QFilter("org", "=", (Object)row.getLong("orgid"));
            tempFilter2.and("entry.costaccount", "=", (Object)row.getLong("costaccountid"));
            if (sysCtrlFilter == null) {
                sysCtrlFilter = tempFilter2;
                continue;
            }
            sysCtrlFilter.or(tempFilter2);
        }
        String selectFields = "id costaccount,number,calorg org,calpolicy.currency currency,calpolicy.currency.amtprecision amtprecision";
        DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".accountDataSet"), (String)"cal_bd_costaccount", (String)selectFields, (QFilter[])new QFilter[]{accountFilter}, null);
        selectFields = "org,entry.costaccount costaccount,entry.currentperiod currentperiod";
        DataSet sysCtrlDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".sysCtrlDataSet"), (String)"cal_sysctrlentity", (String)selectFields, (QFilter[])new QFilter[]{sysCtrlFilter}, null);
        return accountDataSet.leftJoin(sysCtrlDataSet).on("org", "org").on("costaccount", "costaccount").select(accountDataSet.getRowMeta().getFieldNames(), new String[]{"currentperiod"}).finish();
    }

    private DataSet getOriginalData(List<Long[]> orgCostAccountUserList) {
        RowMeta rowMeta = this.getRowMeta();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        Field[] fields = rowMeta.getFields();
        for (Long[] orgCostAccountUser : orgCostAccountUserList) {
            Object[] rowData = new Object[fields.length];
            System.arraycopy(orgCostAccountUser, 0, rowData, 0, fields.length);
            dataList.add(rowData);
        }
        if (dataList.isEmpty()) {
            return null;
        }
        return Algo.create((String)"macc.sca.business.MatAllocOperExecutor").createDataSet(dataList.iterator(), rowMeta);
    }

    private RowMeta getRowMeta() {
        Field[] fields = new Field[]{new Field("orgid", (DataType)DataType.LongType), new Field("costaccountid", (DataType)DataType.LongType)};
        return new RowMeta(fields);
    }

    private Map<String, String> importMatUse(Long orgId, List<Map<String, Object>> costAccountList, String progressId, String appNum, String entityId) {
        Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"matUseService", (String)"importMatUse", (Object[])new Object[]{orgId, costAccountList, progressId, appNum, entityId});
        return resultInfo;
    }
}

