/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;

public class PlanCostCalcExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(PlanCostCalcExecutor.class);
    private static String OPR_KEY = "PLANCOSTCALC";
    private String entityName;
    private String oprKey;

    public PlanCostCalcExecutor(String entityName, String oprKey) {
        this.entityName = entityName;
        this.oprKey = oprKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (!OPR_KEY.equals(this.getOprKey())) {
            return false;
        }
        List orgList = autoExecSchemeDTO.getOrgCostAccountUserList();
        HashSet<Long> orgs = new HashSet<Long>(5);
        if (!orgList.isEmpty()) {
            for (Long[] ids : orgList) {
                if (CadEmptyUtils.isEmpty((Long)ids[0])) continue;
                orgs.add(ids[0]);
            }
        }
        if (orgList.isEmpty()) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u6267\u884c\u5931\u8d25 #execute-{}", (Object)this.entityName);
            return false;
        }
        logger.info("PlanCostCalcExecutor#execute-{}", (Object)this.entityName);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"PlanCostService", (String)"autoCalc", (Object[])new Object[]{orgs});
        boolean status = (Boolean)result.get("status");
        Object count = result.get("count");
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, status ? SchemeExecuteResultEnum.SUCCESS.getValue() : SchemeExecuteResultEnum.FAIL.getValue(), "sca_plancostcalclog", this.oprKey, String.format(AutoExecInvEnum.SUCCESSCALCCOUNT.getName(), count), schemeLogSubDetail);
        return status;
    }

    public String getOprKey() {
        return this.oprKey;
    }
}

