/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.PurchPriceDiffImportHelper;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import org.apache.commons.collections.CollectionUtils;

public class PurchPriceOperExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;
    private String entityName;

    public PurchPriceOperExecutor(String entityName, String operKey) {
        this.operKey = operKey;
        this.entityName = entityName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (EntityOperEnum.OPER_IMPORT.getValue().equals(this.operKey)) {
            int sum = 0;
            ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
            List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
            if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
                ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "sca_mfgfeealloc", this.operKey, AutoExecInvEnum.FAIL.getName());
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"sca_mfgfeealloc", (String)"80513208000000ac");
            if (!hasPerm) {
                ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "sca_mfgfeealloc", this.operKey, AutoExecInvEnum.NO_PERM.getName());
                return false;
            }
            List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
            List<Long> costAccountList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 1);
            Map<Long, List<Long>> orgCostAccountMap = ScaAutoExecShemeHelper.getOrgCostAccountMap(orgList, costAccountList, autoExecSchemeDTO.getAppnum());
            for (Map.Entry<Long, List<Long>> orgCostAccount : orgCostAccountMap.entrySet()) {
                List<Long> costAccounts = orgCostAccount.getValue();
                if (CollectionUtils.isEmpty(costAccounts)) continue;
                for (Long costAccount : costAccounts) {
                    String orgName = ScaAutoExecShemeHelper.getNameById("bos_org", orgCostAccount.getKey());
                    String costCountName = ScaAutoExecShemeHelper.getNameById("cal_bd_costaccount", costAccount);
                    String lockId = "PurchPriceOperExecutor" + orgCostAccount.getKey() + costAccount;
                    DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u6210\u672c\u8c03\u6574\u5355\u81ea\u52a8\u540c\u6b65\u9501", (String)"PurchPriceOperExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    try {
                        int result;
                        boolean isLocked = lock.tryLock();
                        if (!isLocked || (result = PurchPriceDiffImportHelper.syncCostAdjust(orgCostAccount.getKey(), costAccount)) < 0) continue;
                        sum += result;
                        schemeLogSubDetail.add(new SchemeLogSubDetail(orgCostAccount.getKey(), costAccount, Long.valueOf(0L), result));
                    }
                    catch (Exception e) {
                        String detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u81ea\u52a8\u5206\u914d\u5931\u8d25\u3002", (String)"PurchPriceOperExecutor_2", (String)"macc-sca-form", (Object[])new Object[0]), orgName, costCountName);
                        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, null, "sca_mfgfeealloc", this.operKey, detail);
                        logger.error((Throwable)e);
                    }
                    finally {
                        if (lock == null) continue;
                        lock.close();
                    }
                }
            }
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        }
        return true;
    }
}

