/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import kd.macc.sca.common.helper.SendMessageHelper;
import org.apache.commons.collections.CollectionUtils;

public class ResourceUseOperExecutor
implements Executor {
    private Log logger = LogFactory.getLog(ResourceUseOperExecutor.class);
    private String operKey;

    public ResourceUseOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (!EntityOperEnum.OPER_SYSIMPORT.getValue().equals(this.operKey)) {
            return false;
        }
        int sum = 0;
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "sca_resourceuse", this.operKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"sca_resourceuse", (String)"47156aff000000ac");
        if (!hasPerm) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "sca_resourceuse", this.operKey, AutoExecInvEnum.NO_PERM.getName());
            return false;
        }
        List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
        Map<String, Map<Long, List<Long>>> orgAndManuOrgsCostCentersMap = ScaAutoExecShemeHelper.getOrgAndSysImportCostCostCenterMap(orgList, autoExecSchemeDTO.getAppnum(), "sca_resourceuse");
        Map<Long, List<Long>> orgManuOrgs = orgAndManuOrgsCostCentersMap.get("manuorg");
        Map<Long, List<Long>> orgCostCenters = orgAndManuOrgsCostCentersMap.get("costcenter");
        for (Map.Entry<Long, List<Long>> entry : orgCostCenters.entrySet()) {
            if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            List<Long> userIds = ScaAutoExecShemeHelper.getUserIdsByOrg(entry.getKey(), orgCostAccountUserList);
            Integer sucQty = 0;
            String lockId = "ResourceUseOperExecutor" + entry.getKey();
            DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u8d44\u6e90\u8017\u7528\u91cf\u81ea\u52a8\u5f52\u96c6\u9501", (String)"ResourceUseOperExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
            try {
                boolean isLocked = lock.tryLock();
                if (!isLocked) continue;
                this.logger.info("\u81ea\u52a8\u6267\u884c-\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u8986\u76d6\u5bfc\u5165-\u6210\u672c\u4e2d\u5fc3\uff1a" + JSON.toJSONString(entry.getValue()));
                try {
                    Map<String, String> res = this.doInvokeBizService(entry, orgManuOrgs, autoExecSchemeDTO);
                    this.logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + res.toString());
                    boolean isSuccess = "success".equalsIgnoreCase(res.get("type"));
                    Integer successQty = Integer.parseInt(res.get("successQty") != null ? res.get("successQty") : "0");
                    sum += successQty.intValue();
                    sucQty = sucQty + successQty;
                    schemeLogSubDetail.add(new SchemeLogSubDetail(entry.getKey(), Long.valueOf(0L), Long.valueOf(0L), successQty.intValue()));
                }
                catch (Exception e) {
                    this.logger.error("\u81ea\u52a8\u6267\u884c-\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u8986\u76d6\u5bfc\u5165(\u5165\u53e3)\uff1a" + e);
                    this.logger.error((Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error("\u81ea\u52a8\u6267\u884c-\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u8986\u76d6\u5bfc\u5165(\u5165\u53e3)\uff1a" + e);
                this.logger.error((Throwable)e);
            }
            finally {
                if (lock == null) continue;
                lock.close();
                continue;
            }
            if (userIds.isEmpty()) continue;
            SendMessageHelper.sendMCMessage(userIds, (String)String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u6267\u884c\u6210\u529f\uff0c\u5bfc\u5165\u6570\u636e%s\u6761\u3002", (String)"ResourceUseOperExecutor_3", (String)"macc-sca-form", (Object[])new Object[0]), sucQty));
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "sca_resourceuse", this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        return true;
    }

    private Map<String, String> doInvokeBizService(Map.Entry<Long, List<Long>> entry, Map<Long, List<Long>> orgManuOrgs, AutoExecSchemeDTO autoExecSchemeDTO) {
        Map res = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"resourceUseService", (String)"importResourceUse", (Object[])new Object[]{null, null, entry.getKey(), entry.getValue(), orgManuOrgs.get(entry.getKey()), autoExecSchemeDTO.getAppnum(), null});
        return res;
    }
}

