/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import kd.macc.sca.common.helper.SendMessageHelper;
import org.apache.commons.collections.CollectionUtils;

public class WorkFeeOperExecutor
implements Executor {
    private Log logger = LogFactory.getLog(WorkFeeOperExecutor.class);
    private String entityName;
    private String operKey;

    public WorkFeeOperExecutor(String entityName, String operKey) {
        this.entityName = entityName;
        this.operKey = operKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)this.entityName, (String)"80513208000000ac");
        if (!hasPerm) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, AutoExecInvEnum.NO_PERM.getName());
            return false;
        }
        int sum = 0;
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
        List<Long> costAccountIds = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 1);
        Map<Long, List<Long>> orgCostAccountMap = ScaAutoExecShemeHelper.getOrgCostAccountMap(orgList, costAccountIds, autoExecSchemeDTO.getAppnum());
        for (Map.Entry<Long, List<Long>> orgCostAccount : orgCostAccountMap.entrySet()) {
            List<Long> costAccounts = orgCostAccount.getValue();
            if (CollectionUtils.isEmpty(costAccounts)) continue;
            QFilter qFilter = new QFilter("accountorg", "=", (Object)orgCostAccount.getKey());
            qFilter.and("enable", "=", (Object)true);
            qFilter.and("orgduty", "=", (Object)4L);
            List costCenterIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])qFilter.toArray(), null, (int)-1);
            ArrayList<Long> costCenterIds = new ArrayList<Long>(costCenterIdList.size());
            costCenterIdList.forEach(s -> costCenterIds.add(Long.parseLong(String.valueOf(s))));
            for (Long costAccount : costAccounts) {
                Integer sucQty;
                List<Long> userIds;
                block15: {
                    DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccount);
                    userIds = ScaAutoExecShemeHelper.getUserIdsByOrgCostAccount(orgCostAccount.getKey(), costAccount, orgCostAccountUserList);
                    sucQty = 0;
                    String lockId = "WorkFeeOperExecutor" + orgCostAccount.getKey() + costAccount;
                    DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u9501", (String)"WorkFeeOperExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    try {
                        boolean isLocked = lock.tryLock();
                        if (!isLocked) continue;
                        if (!"eca".equals(autoExecSchemeDTO.getAppnum()) || !EntityOperEnum.OPER_IMPORT.getValue().equals(this.operKey)) break block15;
                        try {
                            Map<String, String> resultInfo = this.executeInvoke(orgCostAccount.getKey(), costAccount, currentPeriod.getLong("id"), costCenterIds, autoExecSchemeDTO.getAppnum());
                            Integer successQty = resultInfo.get("successQty") != null ? Integer.valueOf(resultInfo.get("successQty")) : Integer.valueOf(0);
                            sum += successQty.intValue();
                            sucQty = successQty;
                            schemeLogSubDetail.add(new SchemeLogSubDetail(orgCostAccount.getKey(), Long.valueOf(0L), costAccount, successQty.intValue()));
                        }
                        catch (Exception e) {
                            String detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u5bfc\u5165\u6570\u636e\u5931\u8d25\u3002", (String)"WorkFeeOperExecutor_4", (String)"macc-sca-form", (Object[])new Object[0]), ScaAutoExecShemeHelper.getNameById("bos_org", orgCostAccount.getKey()));
                            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, null, this.entityName, this.operKey, detail);
                            this.logger.error((Throwable)e);
                            boolean bl = false;
                            if (lock != null) {
                                lock.close();
                            }
                            return bl;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error((Throwable)e);
                    }
                    finally {
                        if (lock == null) continue;
                        lock.close();
                        continue;
                    }
                }
                if (userIds.isEmpty()) continue;
                SendMessageHelper.sendMCMessage(userIds, (String)String.format(ResManager.loadKDString((String)"\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u6267\u884c\u6210\u529f\uff0c\u6570\u636e%s\u6761\u3002", (String)"WorkFeeOperExecutor_2", (String)"macc-sca-form", (Object[])new Object[0]), sucQty));
            }
        }
        if (EntityOperEnum.OPER_IMPORT.getValue().equals(this.operKey)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        } else {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.operKey, AutoExecInvEnum.SUCCESS.getName());
        }
        return true;
    }

    private Map<String, String> executeInvoke(Long key, Long costAccount, long id, List<Long> costCenterIds, String appNum) {
        Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"eca", (String)"WorkHoursFeeService", (String)"importWorkHoursFee", (Object[])new Object[]{key, costAccount, id, costCenterIds, appNum, null});
        return resultInfo;
    }
}

