/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.constants.MatAllocRptParam;

public class MatAllocRptHelp {
    public static MatAllocRptParam getRptParam(ReportQueryParam param) {
        FilterInfo filter = param.getFilter();
        MatAllocRptParam rptParam = new MatAllocRptParam();
        rptParam.setOrg(filter.getDynamicObject("org"));
        rptParam.setCostaccount(filter.getDynamicObject("costaccount"));
        rptParam.setCurrency(filter.getDynamicObject("currency"));
        rptParam.setBeginperiod(filter.getDynamicObject("beginperiod"));
        rptParam.setEndperiod(filter.getDynamicObject("endperiod"));
        rptParam.setCostcenter(filter.getDynamicObject("costcenter"));
        rptParam.setMulcostobejctentry(filter.getDynamicObjectCollection("mulcostobejctentry"));
        rptParam.setMulsubmat(filter.getDynamicObjectCollection("mulsubmat"));
        rptParam.setMulmaterial(filter.getDynamicObjectCollection("mulmaterial"));
        rptParam.setProbillnos(filter.getString("probillnos"));
        rptParam.setMatcollectbillnos(filter.getString("matcollectbillnos"));
        rptParam.setMulcostcenter(filter.getDynamicObjectCollection("mulcostcenter"));
        rptParam.setManuorg(filter.getDynamicObjectCollection("manuorg"));
        return rptParam;
    }

    public static List<QFilter> getFilters(MatAllocRptParam queryParam, String entityId) {
        DynamicObject endperiod;
        DynamicObject beginperiod;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (queryParam.getOrg() != null) {
            filters.add(new QFilter("org", "=", queryParam.getOrg().getPkValue()));
        }
        if (queryParam.getCostaccount() != null) {
            filters.add(new QFilter("costaccount", "=", queryParam.getCostaccount().getPkValue()));
        }
        if (queryParam.getCurrency() != null) {
            filters.add(new QFilter("currency", "=", queryParam.getCurrency().getPkValue()));
        }
        if (queryParam.getMulcostcenter() != null && !queryParam.getMulcostcenter().isEmpty()) {
            HashSet costcenterIds = new HashSet(16);
            queryParam.getMulcostcenter().forEach(p -> costcenterIds.add(p.getLong("id")));
            filters.add(new QFilter("costcenter", "in", costcenterIds));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)queryParam.getManuorg())) {
            HashSet manuorgIds = new HashSet(16);
            queryParam.getManuorg().forEach(p -> manuorgIds.add(p.getLong("id")));
            filters.add(new QFilter("manuorg", "in", manuorgIds));
        } else {
            long orgId;
            DynamicObject org = queryParam.getOrg();
            if (org != null && OrgHelper.isOrgEnableMultiFactory((Long)(orgId = org.getLong("id")))) {
                filters.add(new QFilter("manuorg", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)entityId)));
            }
        }
        if (queryParam.getMulcostobejctentry() != null && !queryParam.getMulcostobejctentry().isEmpty()) {
            HashSet costobejctIds = new HashSet(16);
            queryParam.getMulcostobejctentry().forEach(p -> costobejctIds.add(p.getLong("id")));
            filters.add(new QFilter("entryentity.costobejctentry", "in", costobejctIds));
        }
        if (queryParam.getMulsubmat() != null && !queryParam.getMulsubmat().isEmpty()) {
            HashSet submatIds = new HashSet(16);
            queryParam.getMulsubmat().forEach(p -> submatIds.add(p.getLong("id")));
            filters.add(new QFilter("entryentity.costobejctentry.material", "in", submatIds));
        }
        if (queryParam.getMulmaterial() != null && !queryParam.getMulmaterial().isEmpty()) {
            HashSet matIds = new HashSet(16);
            queryParam.getMulmaterial().forEach(p -> matIds.add(p.getLong("id")));
            filters.add(new QFilter("material", "in", matIds));
        }
        if (!CadEmptyUtils.isEmpty((String)queryParam.getProbillnos())) {
            String probillnos = queryParam.getProbillnos();
            String[] probillnosArray = probillnos.split(",");
            filters.add(new QFilter("entryentity.costobejctentry.srcbillnumber", "in", (Object)probillnosArray));
        }
        if ((beginperiod = queryParam.getBeginperiod()) != null) {
            Long begindateId = beginperiod.getLong("id");
            filters.add(new QFilter("period", ">=", (Object)begindateId));
        }
        if ((endperiod = queryParam.getEndperiod()) != null) {
            Long endperiodId = endperiod.getLong("id");
            filters.add(new QFilter("period", "<=", (Object)endperiodId));
        }
        return filters;
    }

    public static List<QFilter> getFiltersTwo(MatAllocRptParam queryParam) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (queryParam.getOrg() != null) {
            filters.add(new QFilter("org", "=", queryParam.getOrg().getPkValue()));
        }
        if (!CadEmptyUtils.isEmpty((String)queryParam.getMatcollectbillnos())) {
            String billnos = queryParam.getMatcollectbillnos();
            String[] billnosArray = billnos.split(",");
            filters.add(new QFilter("billno", "in", (Object)billnosArray));
        }
        return filters;
    }
}

