/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatUseHelper {
    private static IPageCache pageCache = null;

    public static boolean isAllNotAllocConfirm(Object[] entryIds) {
        QFilter sourceFilter = new QFilter("matcollect", "in", (Object)entryIds);
        QFilter statusFilter = new QFilter("allocstatus", "=", (Object)"2");
        boolean isexists = QueryServiceHelper.exists((String)"sca_matalloc", (QFilter[])new QFilter[]{sourceFilter});
        if (!isexists) {
            return false;
        }
        boolean exists = QueryServiceHelper.exists((String)"sca_matalloc", (QFilter[])new QFilter[]{sourceFilter, statusFilter});
        return !exists;
    }

    public static Set<String> getAllocConfirmedBill(Set<Object> entryIds) {
        QFilter sourceFilter = new QFilter("matcollect", "in", entryIds);
        QFilter statusFilter = new QFilter("allocstatus", "=", (Object)"2");
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"sca_matalloc", (String)"billno", (QFilter[])new QFilter[]{sourceFilter, statusFilter}, null, (int)10000);
        HashSet<String> billnos = new HashSet<String>(16);
        if (bills.isEmpty()) {
            return billnos;
        }
        int index = 0;
        for (DynamicObject bill : bills) {
            billnos.add(bill.getString("billno"));
            if (++index <= 100) continue;
            billnos.add(ResManager.loadKDString((String)"\u2026\u2026", (String)"MatUseHelper_0", (String)"macc-sca-form", (Object[])new Object[0]));
            return billnos;
        }
        return billnos;
    }

    public static QFilter getCostCenterQFilter(String acctOrgId, String addWayKey, String appnum) {
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.getOrCreate().getUserId()));
        List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
        List orgs = OrgUnitServiceHelper.filterOrgDuty((List)hasPermOrgs, (String)"10");
        QFilter orgFilter = new QFilter("orgduty", "=", (Object)4L);
        if (!StringUtils.isEmpty((Object)acctOrgId)) {
            orgFilter = orgFilter.and(new QFilter("accountorg", "=", (Object)Long.valueOf(acctOrgId)));
            QFilter idFilter = MatUseHelper.getNotManualEnterCostCenterFilter(Lists.newArrayList((Object[])new Long[]{Long.valueOf(acctOrgId)}), addWayKey, appnum);
            return orgFilter.and(idFilter);
        }
        if (userHasPermOrgs.hasAllOrgPerm()) {
            orgFilter = orgFilter.and(new QFilter("accountorg", ">", (Object)0L));
            QFilter idFilter = MatUseHelper.getNotManualEnterCostCenterFilter(null, addWayKey, appnum);
            return orgFilter.and(idFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)orgs)) {
            orgFilter = orgFilter.and(new QFilter("accountorg", "in", (Object)orgs));
            QFilter idFilter = MatUseHelper.getNotManualEnterCostCenterFilter(orgs, addWayKey, appnum);
            return orgFilter.and(idFilter);
        }
        orgFilter = new QFilter("accountorg", "<", (Object)0L);
        return orgFilter;
    }

    private static QFilter getNotManualEnterCostCenterFilter(List<Long> acctOrgIds, String addWayKey, String appnum) {
        ArrayList<Object> ids = new ArrayList<Object>(16);
        ArrayList<Long> manualCostCenters = new ArrayList<Long>(16);
        QFilter orgFilter = null;
        orgFilter = CollectionUtils.isEmpty(acctOrgIds) ? new QFilter("accountorg", ">", (Object)0) : new QFilter("accountorg", "in", acctOrgIds);
        orgFilter.and(new QFilter("appnum", "=", (Object)appnum));
        DynamicObjectCollection params = QueryServiceHelper.query((String)"cad_sysparam", (String)("accountorg,costcenter," + addWayKey), (QFilter[])new QFilter[]{orgFilter});
        for (DynamicObject param : params) {
            String addWay = param.getString(addWayKey);
            Long costcenter = param.getLong("costcenter");
            Long accountorg = param.getLong("accountorg");
            if (!"MANUALENTER".equals(addWay)) {
                if (costcenter != null && costcenter != 0L) {
                    ids.add(costcenter);
                    continue;
                }
                List<Object> costcenters = MatUseHelper.getAllCostCenterByAcctOrg(accountorg);
                ids.addAll(costcenters);
                continue;
            }
            if (CadEmptyUtils.isEmpty((Long)costcenter)) continue;
            manualCostCenters.add(costcenter);
        }
        if (!CollectionUtils.isEmpty(manualCostCenters)) {
            ids.removeAll(manualCostCenters);
        }
        return new QFilter("id", "not in", ids);
    }

    private static List<Object> getAllCostCenterByAcctOrg(Object acctOrgId) {
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter("accountorg", "=", acctOrgId)}, null, (int)9999999);
        return primaryKeys;
    }

    public static Object getAcctOrgIdByCostCenter(Object costcenterid) {
        DynamicObject costcenter = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"accountorg", (QFilter[])new QFilter[]{new QFilter("id", "=", costcenterid)});
        if (costcenter != null) {
            return costcenter.get("accountorg");
        }
        return 0L;
    }

    public static List<Object> getCostCenterByCollectWay(List<Long> acctOrgIds, String collectWayKey, String collectWay, String appId) {
        ArrayList<Object> ids = new ArrayList<Object>();
        QFilter orgFilter = null;
        orgFilter = CollectionUtils.isEmpty(acctOrgIds) ? new QFilter("accountorg", ">", (Object)0) : new QFilter("accountorg", "in", acctOrgIds);
        QFilter wayFitler = new QFilter(collectWayKey, "=", (Object)collectWay);
        QFilter appFilter = new QFilter("appnum", "=", (Object)appId);
        DynamicObjectCollection params = QueryServiceHelper.query((String)"cad_sysparam", (String)"accountorg,costcenter", (QFilter[])new QFilter[]{orgFilter, wayFitler, appFilter});
        for (DynamicObject param : params) {
            Object costcenter = param.get("costcenter");
            Object accountorg = param.get("accountorg");
            if (costcenter != null && (Long)costcenter != 0L) {
                ids.add(costcenter);
                continue;
            }
            List<Object> costcenters = MatUseHelper.getAllCostCenterByAcctOrg(accountorg);
            ids.addAll(costcenters);
        }
        return ids;
    }

    public static boolean isEnablelot(DynamicObject material) {
        if (material != null) {
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter materialFilter = new QFilter("masterid", "=", (Object)material.getLong("masterid"));
            DynamicObject inventoryStrgy = QueryServiceHelper.queryOne((String)"bd_materialinventoryinfo", (String)"enablelot", (QFilter[])new QFilter[]{statusFilter, enableFilter, materialFilter});
            if (inventoryStrgy != null) {
                return inventoryStrgy.getBoolean("enablelot");
            }
        }
        return false;
    }

    public static void showSourceBill(IFormView view, String sourceType, List<String> billnos) {
        String entityName = MatUseHelper.getEntityNameOfMatUseCollection(sourceType);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "in", billnos)}, (String)"", (int)billnos.size());
        for (Object id : ids) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(entityName);
            billShowParameter.setPkId(id);
            billShowParameter.setBillStatus(BillOperationStatus.VIEW);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setHasRight(true);
            view.showForm((FormShowParameter)billShowParameter);
        }
    }

    public static void showSourceBillList(IFormView view, String sourceType, List<String> billnos) {
        String entityName = MatUseHelper.getEntityNameOfMatUseCollection(sourceType);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "in", billnos)}, (String)"", (int)billnos.size());
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            linkQueryPkIdCollection.addLinkQueryPkId(iterator.next());
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        view.showForm((FormShowParameter)showParameter);
    }

    private static String getEntityNameOfMatUseCollection(String sourceType) {
        String entityName = "";
        switch (sourceType) {
            case "SYSIMPORT_PROGET": {
                entityName = "im_mdc_mftproorder";
                break;
            }
            case "SYSIMPORT_PROBACK": {
                entityName = "im_mdc_mftreturnorder";
                break;
            }
            case "SYSIMPORT_PROADD": {
                entityName = "im_mdc_mftfeedorder";
                break;
            }
            case "SYSIMPORT_OUT": {
                entityName = "im_materialreqoutbill";
                break;
            }
            case "SYSIMPORT_IMMDCOMOUT": {
                entityName = "im_mdc_omoutbill";
                break;
            }
            case "SYSIMPORT_IMMDCOMRETURN": {
                entityName = "im_mdc_omreturnbill";
                break;
            }
            case "SYSIMPORT_IMMDCOMFEED": {
                entityName = "im_mdc_omfeedbill";
                break;
            }
        }
        return entityName;
    }

    public static String getEntity(String appNum) {
        if ("sca".equals(appNum)) {
            return "sca_matusecollect";
        }
        if ("aca".equals(appNum)) {
            return "aca_matusecollect";
        }
        return "sca_matusecollect";
    }

    public static IPageCache getPageCache() {
        return pageCache;
    }

    public static void setPageCache(IPageCache pageCache) {
        MatUseHelper.pageCache = pageCache;
    }
}

