/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgHelper {
    private static final Log logger = LogFactory.getLog(OrgHelper.class);

    public static List<Long> getStorageOrgUnitByCalOrg(Long calOrgid) {
        List<Long> list = new ArrayList<Long>();
        try {
            list = OrgServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)calOrgid, (Long)0L);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return list;
    }

    public static Long getCalOrgByUserOrg(Long userId, Long orgId, String entityNum) {
        return OrgHelper.getCalOrgByUserOrg(userId, orgId, entityNum, "47150e89000000ac");
    }

    public static DynamicObject getCostAccountByCalOrg(Long calOrgId) {
        QFilter q = new QFilter("calorg", "=", (Object)calOrgId).and("enable", "=", (Object)true);
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name,calorg,calsystem,calpolicy,dividebasis,ismainaccount,enable", (QFilter[])q.toArray());
        DynamicObject mainCostAccount = null;
        if (costAccounts == null || costAccounts.isEmpty()) {
            return mainCostAccount;
        }
        mainCostAccount = (DynamicObject)costAccounts.get(0);
        for (DynamicObject costAccount : costAccounts) {
            if (!costAccount.getBoolean("ismainaccount")) continue;
            mainCostAccount = costAccount;
            break;
        }
        return mainCostAccount;
    }

    public static Long getCalOrgByUserOrg(Long userId, Long orgId, String entityNum, String permItem) {
        List permOrgIds;
        List permCalOrgIds;
        Long calOrgByPurOrg;
        List allFromSccToCalOrgIds;
        List allFromInvToCalOrgIds;
        int hasPermissin;
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10") && (hasPermissin = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"10", (String)"/KIUHEXROK3D", (String)entityNum, (String)permItem)) == 1) {
            return orgId;
        }
        HashSet<Long> allCalOrgIds = new HashSet<Long>();
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"05") && (allFromInvToCalOrgIds = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)orgId, (String)"10")) != null) {
            allCalOrgIds.addAll(allFromInvToCalOrgIds);
        }
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"12") && (allFromSccToCalOrgIds = OrgUnitServiceHelper.getFromOrgs((String)"12", (Long)orgId, (String)"10")) != null) {
            allCalOrgIds.addAll(allFromSccToCalOrgIds);
        }
        if ((calOrgByPurOrg = (Long)OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)false, (Boolean)true).get("id")) != null) {
            allCalOrgIds.add(calOrgByPurOrg);
        }
        if (allCalOrgIds.size() > 0) {
            for (Long CalOrgId : allCalOrgIds) {
                int hasPermissin2 = PermissionServiceHelper.checkPermission((Long)userId, (Long)CalOrgId, (String)"10", (String)"/KIUHEXROK3D", (String)entityNum, (String)permItem);
                if (hasPermissin2 != 1) continue;
                return CalOrgId;
            }
        }
        if ((permCalOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)(permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)userId).getHasPermOrgs()), (String)"10")).size() > 0) {
            for (Long CalOrgId : permCalOrgIds) {
                int hasPermissin3 = PermissionServiceHelper.checkPermission((Long)userId, (Long)CalOrgId, (String)"10", (String)"/KIUHEXROK3D", (String)entityNum, (String)permItem);
                if (hasPermissin3 != 1) continue;
                return CalOrgId;
            }
        }
        return null;
    }
}

