/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLog;
import kd.macc.cad.common.dto.SchemeLogDetail;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.sca.business.invocation.AutoExecInvocationChain;
import kd.macc.sca.common.enums.ExecuteTypeEnum;

public class ScaAutoExecShemeHelper {
    private static final Log logger = LogFactory.getLog(ScaAutoExecShemeHelper.class);

    public static Map<String, LocaleString> getBussinessAndOperKeyNameMap() {
        HashMap<String, LocaleString> businessAndOperKeyNameMap = new HashMap<String, LocaleString>(32, 0.75f);
        businessAndOperKeyNameMap.put("cad_costobject", new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"ScaAutoExecShemeHelper_0", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("sca_resourceuse", new LocaleString(ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6", (String)"ScaAutoExecShemeHelper_1", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_plannedoutputbill", new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6", (String)"ScaAutoExecShemeHelper_2", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_factnedoutputbill", new LocaleString(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6", (String)"ScaAutoExecShemeHelper_3", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("sca_matusecollect", new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeHelper_4", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_matusecollect", new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeHelper_4", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("sca_mfgfeebill", new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeHelper_5", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_mfgfeebill", new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeHelper_5", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("sca_matalloc", new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d", (String)"ScaAutoExecShemeHelper_6", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_matalloc", new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d", (String)"ScaAutoExecShemeHelper_6", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("sca_mfgfeealloc", new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d", (String)"ScaAutoExecShemeHelper_7", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_mfgfeealloccc", new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\uff08\u6210\u672c\u4e2d\u5fc3\u95f4\uff09", (String)"ScaAutoExecShemeHelper_8", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_mfgfeeallocco", new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\uff08\u6210\u672c\u4e2d\u5fc3\uff09", (String)"ScaAutoExecShemeHelper_9", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_costbom", new LocaleString(ResManager.loadKDString((String)"\u540c\u6b65\u5236\u9020BOM", (String)"ScaAutoExecShemeHelper_10", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_router", new LocaleString(ResManager.loadKDString((String)"\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf", (String)"ScaAutoExecShemeHelper_11", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_bomsetting", new LocaleString(ResManager.loadKDString((String)"\u6210\u672cBOM\u8bbe\u7f6e", (String)"ScaAutoExecShemeHelper_21", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_routersetting", new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u5de5\u827a\u8def\u7ebf\u8bbe\u7f6e", (String)"ScaAutoExecShemeHelper_22", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("sca_purchpricediff", new LocaleString(ResManager.loadKDString((String)"\u5dee\u5f02\u5f52\u96c6\u5355", (String)"ScaAutoExecShemeHelper_12", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("sca_finishcalwizards", new LocaleString(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97", (String)"ScaAutoExecShemeHelper_13", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_mfgfeebill", new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeHelper_5", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("eca_workhoursfee", new LocaleString(ResManager.loadKDString((String)"\u5de5\u65f6\u8d39\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeHelper_19", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_mfgfeeallocco", new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d", (String)"ScaAutoExecShemeHelper_20", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("sca_salorderstdcalclog", new LocaleString(ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7\u6210\u672c\u5377\u7b97\u65e5\u5fd7", (String)"ScaAutoExecShemeHelper_25", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("sca_plancostcalclog", new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u6210\u672c\u8ba1\u7b97\u65e5\u5fd7", (String)"ScaAutoExecShemeHelper_26", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_calcruleplan", new LocaleString(ResManager.loadKDString((String)"\u6267\u884c\u91c7\u8d2d\u53d6\u4ef7", (String)"ScaAutoExecShemeHelper_27", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_realtimecalclog", new LocaleString(ResManager.loadKDString((String)"\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97\u65e5\u5fd7", (String)"ScaAutoExecShemeHelper_33", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_terminalcalwizards", new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5411\u5bfc", (String)"ScaAutoExecShemeHelper_53", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_autocalcmatrangelog", new LocaleString(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5377\u7b97(\u81ea\u52a8\u5377\u7b97)\u65e5\u5fd7", (String)"ScaAutoExecShemeHelper_35", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_purprices", new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868", (String)"ScaAutoExecShemeHelper_40", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_outsourceprice", new LocaleString(ResManager.loadKDString((String)"\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868", (String)"ScaAutoExecShemeHelper_41", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_resourceout", new LocaleString(ResManager.loadKDString((String)"\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868", (String)"ScaAutoExecShemeHelper_42", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("colreport", new LocaleString(ResManager.loadKDString((String)"\u5f52\u96c6\u62a5\u544a", (String)"ScaAutoExecShemeHelper_54", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("calcreport", new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"ScaAutoExecShemeHelper_55", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("COSTBOM", new LocaleString(ResManager.loadKDString((String)"\u540c\u6b65\u5236\u9020BOM", (String)"ScaAutoExecShemeHelper_10", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("ROUTER", new LocaleString(ResManager.loadKDString((String)"\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf", (String)"ScaAutoExecShemeHelper_11", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("REFRESHBOM", new LocaleString(ResManager.loadKDString((String)"\u5237\u65b0BOM", (String)"ScaAutoExecShemeHelper_23", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("REFRESHROUTE", new LocaleString(ResManager.loadKDString((String)"\u5237\u65b0\u5de5\u827a\u8def\u7ebf", (String)"ScaAutoExecShemeHelper_24", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("SYSIMPORT", new LocaleString(ResManager.loadKDString((String)"\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165", (String)"ScaAutoExecShemeHelper_46", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("ALLOC", new LocaleString(ResManager.loadKDString((String)"\u5206\u914d", (String)"ScaAutoExecShemeHelper_15", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("ODERIMPORT", new LocaleString(ResManager.loadKDString((String)"\u4ece\u751f\u4ea7\u5de5\u5355\u5bfc\u5165", (String)"ScaAutoExecShemeHelper_47", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("PROREPORT", new LocaleString(ResManager.loadKDString((String)"\u4ece\u5de5\u5e8f\u6c47\u62a5\u5bfc\u5165", (String)"ScaAutoExecShemeHelper_48", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("IMPORT", new LocaleString(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"ScaAutoExecShemeHelper_49", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("STDCOSTCALC", new LocaleString(ResManager.loadKDString((String)"\u5f00\u542f\u5377\u7b97\uff08\u6309\u8ddf\u8e2a\u53f7\u8fdb\u884c\u5377\u7b97\uff09", (String)"ScaAutoExecShemeHelper_28", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("AUTOCALC", new LocaleString(ResManager.loadKDString((String)"\u5de5\u5355\u5173\u95ed\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97\u3002", (String)"ScaAutoExecShemeHelper_29", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("AUTOCALC_PB", new LocaleString(ResManager.loadKDString((String)"\u5de5\u5355\u5173\u95ed\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97\uff08\u515c\u5e95\u65b9\u6848\uff09", (String)"ScaAutoExecShemeHelper_30", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("FINISH_CALC", new LocaleString(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97", (String)"ScaAutoExecShemeHelper_13", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("PLANCOSTCALC", new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u6210\u672c\u8ba1\u7b97", (String)"ScaAutoExecShemeHelper_31", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("PURCHASEPRICING", new LocaleString(ResManager.loadKDString((String)"\u53d6\u4ef7", (String)"ScaAutoExecShemeHelper_36", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("REALTIMECALC", new LocaleString(ResManager.loadKDString((String)"\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97", (String)"ScaAutoExecShemeHelper_34", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("ACTCOSTCALC", new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97", (String)"ScaAutoExecShemeHelper_52", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("AUTO_CALCULATION_ALL", new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5377\u7b97(\u6309\u975e\u8ddf\u8e2a\u53f7\u8fdb\u884c\u5377\u7b97)", (String)"ScaAutoExecShemeHelper_37", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("AUTO_CALCULATION_ALL_RETRY", new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5377\u7b97\u8865\u507f(\u6309\u975e\u8ddf\u8e2a\u53f7\u8fdb\u884c\u5377\u7b97)", (String)"ScaAutoExecShemeHelper_38", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("AUTO_CALCULATION_UNDO", new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5377\u7b97(\u6309\u5931\u8d25\u7269\u6599\u8fdb\u884c\u5377\u7b97)", (String)"ScaAutoExecShemeHelper_39", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("AUTO_IMPORT_MATERIAL", new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5bfc\u5165", (String)"ScaAutoExecShemeHelper_50", (String)"macc-sca-form", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("CLEAR_DATA", new LocaleString(ResManager.loadKDString((String)"\u6e05\u7406\u6570\u636e", (String)"ScaAutoExecShemeHelper_51", (String)"macc-sca-form", (Object[])new Object[0])));
        return businessAndOperKeyNameMap;
    }

    public static void executeSchemeById(ExecuteTypeEnum executeType, Object schemeId, Object userId, Object appId) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"sca_autoexecsheme");
        if ("0".equals(scheme.getString("enable"))) {
            logger.error("\u7981\u7528\u7684\u81ea\u52a8\u6267\u884c\u65b9\u6848\uff0c\u4e0d\u6267\u884c\u3002");
            return;
        }
        if (userId == null && scheme.getLong("executor.id") == 0L) {
            logger.error("\u6ca1\u6709\u8bbe\u7f6e\u6267\u884c\u4eba\uff0c\u4e0d\u6267\u884c\u3002");
            return;
        }
        AutoExecSchemeDTO autoExecSchemeDTO = new AutoExecSchemeDTO();
        ScaAutoExecShemeHelper.buildAutoExecSchemeDTO(scheme, autoExecSchemeDTO, userId, appId);
        autoExecSchemeDTO.getSchemeLog().setStarttime(TimeServiceHelper.now());
        autoExecSchemeDTO.getSchemeLog().setExecuteType(executeType.getValue());
        AutoExecInvocationChain invocationChain = new AutoExecInvocationChain(autoExecSchemeDTO);
        invocationChain.exec();
        autoExecSchemeDTO.getSchemeLog().setEndtime(TimeServiceHelper.now());
        autoExecSchemeDTO.getSchemeLog().setSchemeId(Long.valueOf(scheme.getLong("id")));
        ScaAutoExecShemeHelper.writeSchemeLog(autoExecSchemeDTO);
    }

    public static List<Long> getTargetList(List<Long[]> sourceList, int index) {
        ArrayList<Long> targetList = new ArrayList<Long>(sourceList.size());
        for (Long[] source : sourceList) {
            targetList.add(source[index]);
        }
        return targetList;
    }

    public static Map<Long, List<Long>> getOrgCostCenterMap(List<Long> orgList) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        for (Long org : orgList) {
            List<Long> costCenters = ScaAutoExecShemeHelper.getCostCenterByOrg(org);
            resultMap.put(org, costCenters);
        }
        return resultMap;
    }

    public static List<Long> getUserIdsByOrg(Long orgId, List<Long[]> orgCostAccountUserList) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        for (Long[] info : orgCostAccountUserList) {
            if (orgId.longValue() != info[0].longValue() || info[2] == null || info[2] == 0L) continue;
            result.add(info[2]);
        }
        return result;
    }

    public static List<Long> getUserIdsByOrgCostAccount(Long orgId, Long costAccountId, List<Long[]> orgCostAccountUserList) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        for (Long[] info : orgCostAccountUserList) {
            if (orgId.longValue() != info[0].longValue() || costAccountId.longValue() != info[1].longValue() || info[2] == null || info[2] == 0L) continue;
            result.add(info[2]);
        }
        return result;
    }

    public static Map<String, Map<Long, List<Long>>> getOrgAndSysImportCostCostCenterMap(List<Long> acctOrgIds, String appNum, String entityId) {
        HashMap<String, Map<Long, List<Long>>> resultMap = new HashMap<String, Map<Long, List<Long>>>(16);
        for (Long orgId : acctOrgIds) {
            List<Long> manuOrgList = new ArrayList<Long>();
            List<Object> costCenterIds = new ArrayList();
            boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
            if (isEnableMultiFactory) {
                Set<Long> centerIdsByManuOrgIds;
                if (CadEmptyUtils.isEmpty(manuOrgList)) {
                    manuOrgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)entityId, (String)appNum);
                }
                if (!CadEmptyUtils.isEmpty(centerIdsByManuOrgIds = ScaAutoExecShemeHelper.getCenterIdsByManuOrgIds(orgId, manuOrgList, appNum))) {
                    costCenterIds = new ArrayList<Long>(centerIdsByManuOrgIds);
                }
            } else {
                costCenterIds = OrgHelper.getCostCentersByOrg((long)orgId);
            }
            resultMap.computeIfAbsent("manuorg", s -> new HashMap()).put(orgId, manuOrgList);
            resultMap.computeIfAbsent("costcenter", s -> new HashMap()).put(orgId, costCenterIds);
        }
        return resultMap;
    }

    public static Set<Long> getCenterIdsByManuOrgIds(Long orgId, List<Long> manuList, String appId) {
        if (CadEmptyUtils.isEmpty((String)appId)) {
            appId = "sca";
        }
        HashSet<Long> centerIds = new HashSet<Long>(20);
        HashSet<Long> allCenterIds = new HashSet<Long>(20);
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and("manuorg", "in", manuList);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)appId);
        DataSet costCenterDs = QueryServiceHelper.queryDataSet((String)"getCenterIdsByManuOrgIds", (String)"cad_centermanuorg", (String)"entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray(), null);
        for (Row costCenter : costCenterDs) {
            allCenterIds.add(costCenter.getLong("costcenterid"));
        }
        if (!CadEmptyUtils.isEmpty(allCenterIds)) {
            QFilter ccFilter = new QFilter("id", "in", allCenterIds);
            ccFilter.and(new QFilter("orgduty", "=", (Object)4L));
            DataSet basicCostCenterDs = QueryServiceHelper.queryDataSet((String)"getCenterIds", (String)"bos_costcenter", (String)"id", (QFilter[])ccFilter.toArray(), null);
            for (Row costCenter : basicCostCenterDs) {
                centerIds.add(costCenter.getLong("id"));
            }
        }
        if (CadEmptyUtils.isEmpty(centerIds)) {
            centerIds.add(-1L);
        }
        return centerIds;
    }

    private static List<Long> getCostCenterByOrg(Long orgId) {
        ArrayList<Long> result = new ArrayList<Long>();
        QFilter orgFilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{orgFilter, orgdutyFilter}, null);
        if (costCenters != null) {
            for (DynamicObject costCenter : costCenters) {
                result.add(costCenter.getLong("id"));
            }
        }
        return result;
    }

    public static Map<Long, List<Long>> getOrgCostAccountMap(List<Long> orgList, List<Long> costAccountList, String appNum) {
        HashMap<Long, List<Long>> orgCostAccountMap = new HashMap<Long, List<Long>>(16);
        for (int i = 0; i < orgList.size(); ++i) {
            Long orgId = orgList.get(i);
            Long costAccount = costAccountList.get(i);
            if (costAccount == null || costAccount == 0L) {
                DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts((Long)orgId, (Boolean)Boolean.TRUE, (String)appNum);
                List ids = costAccounts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                orgCostAccountMap.put(orgId, ids);
                continue;
            }
            ArrayList<Long> costAccountIds = (ArrayList<Long>)orgCostAccountMap.get(orgId);
            if (costAccountIds == null) {
                costAccountIds = new ArrayList<Long>(1);
            }
            costAccountIds.add(costAccount);
            orgCostAccountMap.put(orgId, costAccountIds);
        }
        return orgCostAccountMap;
    }

    private static void writeSchemeLog(AutoExecSchemeDTO autoExecSchemeDTO) {
        SchemeLog schemeLog = autoExecSchemeDTO.getSchemeLog();
        DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)"sca_schemelog");
        dObj.set("scheme", (Object)schemeLog.getSchemeId());
        dObj.set("starttime", (Object)schemeLog.getStarttime());
        dObj.set("endtime", (Object)schemeLog.getEndtime());
        dObj.set("executeresult", (Object)schemeLog.getExecuteResult());
        dObj.set("appnum", (Object)autoExecSchemeDTO.getAppnum());
        dObj.set("executor", (Object)autoExecSchemeDTO.getExecutor());
        dObj.set("executetype", (Object)schemeLog.getExecuteType());
        dObj.set("executetime", (Object)ScaAutoExecShemeHelper.getEexcuteTime(schemeLog.getStarttime(), schemeLog.getEndtime()));
        DynamicObjectCollection entryentity = dObj.getDynamicObjectCollection("entryentity");
        List schemeLogDetail = schemeLog.getSchemeLogDetail();
        for (SchemeLogDetail logDetail : schemeLogDetail) {
            DynamicObject entry = entryentity.addNew();
            entry.set("businessname", (Object)logDetail.getBusinessname());
            entry.set("opername", (Object)logDetail.getOpername());
            entry.set("detail", (Object)logDetail.getDetail());
            List schemeLogSubDetail = logDetail.getSchemeLogSubDetail();
            if (CadEmptyUtils.isEmpty((List)schemeLogSubDetail)) continue;
            DynamicObjectCollection subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
            for (SchemeLogSubDetail subDetail : schemeLogSubDetail) {
                DynamicObject subEntry = subEntryEntity.addNew();
                subEntry.set("org", (Object)subDetail.getOrgId());
                subEntry.set("costcenter", (Object)subDetail.getCostCenterId());
                subEntry.set("costaccount", (Object)subDetail.getCostAccountId());
                subEntry.set("successqty", (Object)subDetail.getSuccessqty());
            }
        }
        Date delDate = DateUtils.getLastSeveralDay((Date)schemeLog.getStarttime(), (int)-7);
        QFilter delDateQF = new QFilter("starttime", "<", (Object)delDate);
        DeleteServiceHelper.delete((String)"sca_schemelog", (QFilter[])new QFilter[]{delDateQF});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObj});
    }

    public static void buildSchemeLogDetail(AutoExecSchemeDTO autoExecSchemeDTO, String executeResult, String entityName, String operKey, String detail, List<SchemeLogSubDetail> schemeLogSubDetail) {
        if (executeResult != null) {
            autoExecSchemeDTO.getSchemeLog().setExecuteResult(executeResult);
        }
        List schemeLogDetailList = autoExecSchemeDTO.getSchemeLog().getSchemeLogDetail();
        Map<String, LocaleString> bussinessAndOperKeyNameMap = ScaAutoExecShemeHelper.getBussinessAndOperKeyNameMap();
        SchemeLogDetail schemeLogDetail = new SchemeLogDetail();
        schemeLogDetail.setBusinessname(bussinessAndOperKeyNameMap.get(entityName).toString());
        schemeLogDetail.setOpername(bussinessAndOperKeyNameMap.get(operKey).toString());
        schemeLogDetail.setDetail(detail);
        schemeLogDetail.setSchemeLogSubDetail(schemeLogSubDetail);
        schemeLogDetailList.add(schemeLogDetail);
    }

    public static void buildSchemeLogDetail(AutoExecSchemeDTO autoExecSchemeDTO, String executeResult, String entityName, String operKey, String detail) {
        if (executeResult != null) {
            autoExecSchemeDTO.getSchemeLog().setExecuteResult(executeResult);
        }
        List schemeLogDetailList = autoExecSchemeDTO.getSchemeLog().getSchemeLogDetail();
        Map<String, LocaleString> bussinessAndOperKeyNameMap = ScaAutoExecShemeHelper.getBussinessAndOperKeyNameMap();
        SchemeLogDetail schemeLogDetail = new SchemeLogDetail();
        schemeLogDetail.setBusinessname(bussinessAndOperKeyNameMap.get(entityName).toString());
        schemeLogDetail.setOpername(bussinessAndOperKeyNameMap.get(operKey).toString());
        schemeLogDetail.setDetail(detail);
        schemeLogDetailList.add(schemeLogDetail);
    }

    public static String getMsgFromExecuteResult(ExecuteResult executeResult) {
        Map info = executeResult.isSuccess() ? executeResult.getSuccessInfo() : executeResult.getFalseInfo();
        Map.Entry msgMap = info.entrySet().iterator().next();
        return (String)msgMap.getValue();
    }

    public static String getNameById(String entityName, Long id) {
        DynamicObject query = QueryServiceHelper.queryOne((String)entityName, (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return query == null ? "" : query.getString("name");
    }

    private static void buildAutoExecSchemeDTO(DynamicObject scheme, AutoExecSchemeDTO autoExecSchemeDTO, Object userId, Object appId) {
        autoExecSchemeDTO.setAppnum(appId == null ? "" : appId.toString());
        autoExecSchemeDTO.setExecutor(Long.valueOf(userId == null ? scheme.getLong("executor.id") : Long.parseLong(String.valueOf(userId))));
        DynamicObjectCollection operationentry = scheme.getDynamicObjectCollection("entryentity");
        ArrayList<String[]> entityAndOperKeyList = new ArrayList<String[]>(operationentry.size());
        for (DynamicObject operInfo : operationentry) {
            String[] entityAndOperKeyArr = new String[]{operInfo.getString("businesstype"), operInfo.getString("autoexecoper.number")};
            entityAndOperKeyList.add(entityAndOperKeyArr);
        }
        autoExecSchemeDTO.setEntityAndOperKeyList(entityAndOperKeyList);
        DynamicObjectCollection orgentry = scheme.getDynamicObjectCollection("orgentry");
        ArrayList<Long[]> orgCostAccountUserList = new ArrayList<Long[]>(orgentry.size());
        for (DynamicObject orgentryInfo : orgentry) {
            Long[] orgCostAccountUserArr = new Long[]{orgentryInfo.getLong("org.id"), orgentryInfo.getLong("costaccount.id"), orgentryInfo.getLong("user.id")};
            orgCostAccountUserList.add(orgCostAccountUserArr);
        }
        autoExecSchemeDTO.setOrgCostAccountUserList(orgCostAccountUserList);
    }

    private static String getEexcuteTime(Date startTime, Date endTime) {
        try {
            long diff = endTime.getTime() - startTime.getTime();
            long hours = diff / 3600000L;
            long minutes = (diff - hours * 3600000L) / 60000L;
            long seconds = (diff - hours * 3600000L - minutes * 60000L) / 1000L;
            if (hours == 0L && minutes == 0L && seconds == 0L) {
                seconds = 1L;
            }
            return String.format("%02d", hours) + ":" + String.format("%02d", minutes) + ":" + String.format("%02d", seconds);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return "00:00:00";
        }
    }
}

