/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class ScaInitHelper {
    public static void initCostToCalcResult(Long orgId, Map<Long, DynamicObject> costAccountIdMap) {
        if (CadEmptyUtils.isEmpty((Long)orgId) || CadEmptyUtils.isEmpty(costAccountIdMap)) {
            return;
        }
        String fields = "id,org,costaccount,costobject,currency,costcenter,material,auxpty,initqty,initamt,costobject.bomversion AS bomversion,entryentity.element AS element,entryentity.subelement AS subelement,entryentity.stdamt AS stdamt,entryentity.realamt AS realamt,entryentity.datatype AS datatype,entryentity.subelement.type AS eleType,entryentity.resource AS resource,entryentity.costlevel AS costlevel,entryentity.calcbasis AS calcbasis";
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountQF = new QFilter("costaccount", "in", costAccountIdMap.keySet());
        QFilter[] qfArr = new QFilter[]{orgQF, costAccountQF};
        ExecuteResult er = new ExecuteResult();
        er.setFalseInfo(new HashMap());
        HashMap<String, List> wipCostInitMap = new HashMap<String, List>();
        DynamicObjectCollection res = QueryServiceHelper.query((String)"sca_wipcostinit", (String)fields, (QFilter[])qfArr);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)res)) {
            return;
        }
        for (DynamicObject wipcostinit : res) {
            wipCostInitMap.computeIfAbsent(wipcostinit.getString("id"), s -> new ArrayList()).add(wipcostinit);
        }
        ArrayList<DynamicObject> calcResultList = new ArrayList<DynamicObject>(10);
        for (Map.Entry entry : wipCostInitMap.entrySet()) {
            List wipCostInitList = (List)entry.getValue();
            DynamicObject startperiod = costAccountIdMap.get(((DynamicObject)wipCostInitList.get(0)).getLong("costaccount"));
            DynamicObject calcResult = ScaInitHelper.putToCalcResult(wipCostInitList, startperiod);
            calcResultList.add(calcResult);
        }
        if (!CadEmptyUtils.isEmpty(calcResultList)) {
            SaveServiceHelper.save((DynamicObject[])calcResultList.toArray(new DynamicObject[0]));
        }
    }

    public static void delCalcResult(Long orgId, List<Long> costAccountIdList) {
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountQF = new QFilter("costaccount", "in", costAccountIdList);
        QFilter[] qfArr = new QFilter[]{orgQF, costAccountQF};
        DynamicObjectCollection wipCosts = QueryServiceHelper.query((String)"sca_wipcostinit", (String)"id", (QFilter[])qfArr);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)wipCosts)) {
            return;
        }
        HashSet<Object> wipCostIdSet = new HashSet<Object>();
        for (DynamicObject wipCost : wipCosts) {
            wipCostIdSet.add(wipCost.get("id"));
        }
        QFilter srcBillQF = new QFilter("srcbill", "in", wipCostIdSet);
        DeleteServiceHelper.delete((String)"sca_calcresult", (QFilter[])new QFilter[]{srcBillQF});
    }

    private static DynamicObject putToCalcResult(List<DynamicObject> wipCostInitList, DynamicObject startperiod) {
        DynamicObject endPeriod;
        DynamicObject calcResult = BusinessDataServiceHelper.newDynamicObject((String)"sca_calcresult");
        DynamicObject wipCost = wipCostInitList.get(0);
        ScaInitHelper.setEntity(calcResult, wipCost);
        ScaInitHelper.setEntryEntity(calcResult, wipCostInitList, wipCost);
        if (startperiod != null && (endPeriod = PeriodHelper.getPreviousPeriod((Object)startperiod.get("id"))) != null) {
            calcResult.set("period", (Object)endPeriod);
            calcResult.set("bizdate", endPeriod.get("enddate"));
        }
        return calcResult;
    }

    private static void setEntryEntity(DynamicObject calcResult, List<DynamicObject> wipCostInitList, DynamicObject wipCost) {
        DynamicObjectCollection entryentity = calcResult.getDynamicObjectCollection("entryentity");
        for (DynamicObject initData : wipCostInitList) {
            DynamicObject calcResultRow1 = entryentity.addNew();
            ScaInitHelper.setEntryEntity(calcResultRow1, initData, "endFee");
        }
        DynamicObject calcResultRow3 = entryentity.addNew();
        ScaInitHelper.setFinalResult(calcResultRow3, wipCost);
    }

    private static void setFinalResult(DynamicObject calcResultRow, DynamicObject wipCost) {
        calcResultRow.set("caltype", (Object)"5");
        calcResultRow.set("datatype", (Object)"99");
        calcResultRow.set("obj", wipCost.get("costobject"));
        calcResultRow.set("producttype", (Object)"C");
        calcResultRow.set("pdendqty", wipCost.get("initqty"));
        calcResultRow.set("pdendamount", wipCost.get("initamt"));
    }

    private static void setEntryEntity(DynamicObject calcResultRow, DynamicObject initData, String caltype) {
        calcResultRow.set("resource", initData.get("resource"));
        calcResultRow.set("costlevel", (Object)ScaInitHelper.getCostlevel(initData));
        calcResultRow.set("calcbasis", initData.get("calcbasis"));
        calcResultRow.set("element", initData.get("element"));
        calcResultRow.set("subelement", initData.get("subelement"));
        calcResultRow.set("producttype", (Object)"C");
        calcResultRow.set("obj", initData.get("costobject"));
        calcResultRow.set("pdendqty", initData.get("initqty"));
        calcResultRow.set("pdendamount", initData.get("realamt"));
        calcResultRow.set("datatype", initData.get("datatype"));
        String eleType = initData.getString("eleType");
        if ("001".equals(eleType) || "002".equals(eleType)) {
            calcResultRow.set("difftype", (Object)"1");
            if ("endFee".equals(caltype)) {
                calcResultRow.set("caltype", (Object)"1");
            } else if ("finishFee".equals(caltype)) {
                calcResultRow.set("caltype", (Object)"3");
            }
        } else {
            calcResultRow.set("difftype", (Object)"2");
            if ("endFee".equals(caltype)) {
                calcResultRow.set("caltype", (Object)"2");
            } else if ("finishFee".equals(caltype)) {
                calcResultRow.set("caltype", (Object)"4");
            }
        }
    }

    private static String getCostlevel(DynamicObject initData) {
        if (CadEmptyUtils.isEmpty((Long)initData.getLong("resource"))) {
            return "";
        }
        if ("1".equals(initData.getString("datatype"))) {
            return "";
        }
        return initData.getString("costlevel") == null ? "" : initData.getString("costlevel");
    }

    private static void setEntity(DynamicObject calcResult, DynamicObject wipCost) {
        String billno = "NO." + System.currentTimeMillis();
        calcResult.set("billno", (Object)billno);
        calcResult.set("srcbill", wipCost.get("id"));
        calcResult.set("org", wipCost.get("org"));
        calcResult.set("costaccount", wipCost.get("costaccount"));
        calcResult.set("costobject", wipCost.get("costobject"));
        calcResult.set("currency", wipCost.get("currency"));
        calcResult.set("costcenter", wipCost.get("costcenter"));
        calcResult.set("modifytime", (Object)new Date());
        calcResult.set("modifier", (Object)RequestContext.get().getUserId());
        calcResult.set("billstatus", (Object)"A");
    }

    public static Long getCostType(Long costAccountId) {
        if (CadEmptyUtils.isEmpty((Long)costAccountId)) {
            return null;
        }
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costAccountId);
        Date now = new Date();
        QFilter effectdateQf = new QFilter("effectdate", "<=", (Object)now);
        QFilter invaliddateQf = new QFilter("invaliddate", ">=", (Object)now);
        QFilter bizstatusQf = new QFilter("bizstatus", "=", (Object)"1");
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"id,costtype", (QFilter[])new QFilter[]{costaccountQf, effectdateQf, invaliddateQf, bizstatusQf});
        if (infos != null && infos.length > 0) {
            return infos[0].getLong("costtype.id");
        }
        return null;
    }
}

