/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.allocstd;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.enums.SysImpEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.CadUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.sca.formplugin.base.BaseOrgAndCostCenterFilterList;

public class ResourceUseBillListPlugin
extends BaseOrgAndCostCenterFilterList {
    private static final String PAGECACHE_COSTCENTERSET = "costcenterset";
    private static final String IMPORT_RESULT = "importResult";

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setCustomParam("accountorg", (Object)this.getPageCache().get("org"));
        e.getParameter().setCustomParam("manuorg", (Object)this.getPageCache().get("manuorg"));
        e.getParameter().setCustomParam("costcenter", (Object)this.getPageCache().get("costcenter"));
        e.getParameter().setCustomParam("bookdate", (Object)this.getPageCache().get("bookdate"));
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuOrgFilter;
        super.setFilter(e);
        QFilter costCenterFilter = this.getCostCenterFilter();
        if (costCenterFilter != null) {
            e.getQFilters().add(costCenterFilter);
        }
        if ((manuOrgFilter = this.getManuOrgQFilter()) != null) {
            e.getQFilters().add(manuOrgFilter);
        }
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        String accountOrgId = this.getPageCache().get("org");
        if (fieldName.startsWith("costcenter")) {
            if (!CadEmptyUtils.isEmpty((String)accountOrgId)) {
                args.getQfilters().add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountOrgId)));
                args.getQfilters().add(new QFilter("orgduty", "=", (Object)4L).and(new QFilter("enable", "=", (Object)"1")));
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        }
        if (fieldName.startsWith("manuorg") && !CadEmptyUtils.isEmpty((String)accountOrgId)) {
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(accountOrgId), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        List<Object> orgComboItemList = new ArrayList(16);
        String newtype = "";
        if (("tblnew".equals(key) || "importdata".equals(key) || "sysimport".equals(key) || "sysimportcover".equals(key)) && CadEmptyUtils.isEmpty(orgComboItemList = this.getORGComboItemList())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ResourceUseBillListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]), new Object[0]));
            evt.setCancel(true);
            return;
        }
        switch (key) {
            case "tblnew": {
                break;
            }
            case "importdata": {
                break;
            }
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        super.filterContainerSearchClick(e);
        if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("org"))) {
            List multiCostCenters = CadUtils.getMultiCostCentersByFilterName((FilterContainerSearchClickArgs)e, (String)"costcenter.id", (Long)Long.parseLong(this.getPageCache().get("org")));
            this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString((Object)multiCostCenters));
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        QFilter filter;
        super.filterContainerInit(args);
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        if (!StringUtils.isEmpty((String)orgId)) {
            String manuOrgId = this.getPageCache().get("manuorg");
            ArrayList<Long> manuOrgList = new ArrayList<Long>();
            if (!CadEmptyUtils.isEmpty((String)manuOrgId)) {
                manuOrgList.add(Long.parseLong(manuOrgId));
            }
            filter = CostCenterHelper.getCostCenterByMultFactoryForList((long)Long.parseLong(orgId), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
        } else {
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
            List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
            filter = new QFilter("accountorg", "in", (Object)orgIds);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter, orgdutyFilter});
        HashSet costCenterSet = new HashSet(10);
        if (!CollectionUtils.isEmpty((Collection)ccs)) {
            ccs.forEach(cc -> costCenterSet.add(cc.getLong("id")));
        }
        this.getPageCache().put(PAGECACHE_COSTCENTERSET, JSON.toJSONString(costCenterSet));
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString(new ArrayList()));
        String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if ("aca".equals(appNum)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"factuse", "factbatch"});
        }
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "sysimport": {
                this.importSysDataToBill(SysImpEnum.SYSIMPORT.getValue());
                break;
            }
            case "sysimportcover": {
                if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)this.getPageCache().get("org"), (boolean)false, (String)this.getView().getFormShowParameter().getAppId(), (String)"sca_resourceuse", (String)"47156aff000000ac")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResourceUseBillListPlugin_19", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                this.importSysDataToBill(SysImpEnum.SYSIMPORTCOVER.getValue());
                break;
            }
            case "searchup": {
                this.searchUpBill();
                break;
            }
            case "colreport": {
                this.viewColReport();
                break;
            }
            case "searchconfig": {
                this.searchConfig();
                break;
            }
        }
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)"sca_resourceuse", (IFormView)this.getView());
    }

    private void viewColReport() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cad_colreport", (boolean)true, (int)1, (boolean)false);
        String acctOrgId = this.getPageCache().get("org");
        listShowParameter.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        listShowParameter.setCustomParam("org", (Object)acctOrgId);
        listShowParameter.setCustomParam("colobj", (Object)CollectObjectEnum.RESOURCE_USE.getObj());
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u62a5\u544a", (String)"ResourceUseBillListPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void searchUpBill() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() > 0) {
            Object[] primaryKeys = rows.getPrimaryKeyValues();
            Map<String, List<Object>> probillEntryIdMap = ResourceUseBillListPlugin.getProbillEntryIds(primaryKeys);
            if (CadEmptyUtils.isEmpty(probillEntryIdMap)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u662f\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\uff0c\u4e0d\u80fd\u4e0a\u67e5\u3002", (String)"ResourceUseBillListPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            block6: for (Map.Entry<String, List<Object>> probill : probillEntryIdMap.entrySet()) {
                String source;
                switch (source = probill.getKey()) {
                    case "0": {
                        QFilter[] srcBillIdQf = new QFilter[]{new QFilter("id", "in", probill.getValue())};
                        this.showSearchBill("sfc_processreportbill", srcBillIdQf);
                        this.showSearchBill("sfc_reportresource_adjust", srcBillIdQf);
                        this.showSearchBill("pom_mftorderreport", srcBillIdQf);
                        this.showSearchBill("om_processreport", srcBillIdQf);
                        continue block6;
                    }
                }
                SrcBillShowerUtils.showSearchUpBillOrList((IFormView)this.getView(), (String)source, probill.getValue(), null);
            }
        }
    }

    private static Map<String, List<Object>> getProbillEntryIds(Object[] objIds) {
        HashMap<String, List<Object>> probillEntryIdMap = new HashMap<String, List<Object>>(10);
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        filter.and(new QFilter("srcbillid", ">", (Object)0L));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"sca_resourceuse", (String)"id,srcbillid,srcbilltype", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return probillEntryIdMap;
        }
        for (DynamicObject row : rows) {
            String srcbilltype = "0";
            if (row.get("srcbilltype") != null && !CadEmptyUtils.isEmpty((String)row.getString("srcbilltype"))) {
                srcbilltype = row.getString("srcbilltype");
            }
            probillEntryIdMap.computeIfAbsent(srcbilltype, p -> new ArrayList(10)).add(row.getLong("srcbillid"));
        }
        return probillEntryIdMap;
    }

    private void showSearchBill(String entity, QFilter[] srcBillIdQf) {
        DynamicObjectCollection srcBillIds = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])srcBillIdQf);
        if (!srcBillIds.isEmpty()) {
            SrcBillShowerUtils.showSearchUpBillOrList((IFormView)this.getView(), (String)entity, (List)DynamicObjectHelper.getFieldList((DynamicObjectCollection)srcBillIds, (String)"id"), null);
        }
    }

    private void importSysDataToBill(String impType) {
        String orgId = this.getPageCache().get("org");
        String costCenterId = this.getPageCache().get("costcenter");
        ArrayList<Long> costCenters = new ArrayList<Long>(10);
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ResourceUseBillListPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        List costCenterMultiSelect = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("multiselectcostcenters"), List.class);
        if (!CadEmptyUtils.isEmpty((List)costCenterMultiSelect) && costCenterMultiSelect.size() > 1) {
            costCenters.addAll(costCenterMultiSelect);
        } else if (!CadEmptyUtils.isEmpty((String)costCenterId)) {
            costCenters.add(Long.parseLong(costCenterId));
        } else {
            boolean isEnableMultiFactory;
            String manuOrgId = this.getPageCache().get("manuorg");
            List<ComboItem> comboItems = this.getCostCenterComboItemListByManuOrg(orgId, manuOrgId);
            if (!CadEmptyUtils.isEmpty(comboItems)) {
                comboItems.forEach(p -> costCenters.add(Long.parseLong(p.getValue())));
            }
            if ((isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(orgId))) && CadEmptyUtils.isEmpty(comboItems)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"ResourceUseBillListPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
        }
        List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(Long.parseLong(orgId)), (Set)Sets.newHashSet(costCenters), (String)"sca_resourceuse", (String)this.getView().getFormShowParameter().getAppId());
        Map objRules = CostObjectHelper.getCostObjectRulesMap((Long)Long.parseLong(orgId), (List)enableCostCenters);
        if (CadEmptyUtils.isEmpty((Map)objRules)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"ResourceUseBillListPlugin_17", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        if (ImportServiceHelper.isStartCollConfigScheme().booleanValue()) {
            Set calDimensionIds = CostObjectHelper.getCalDimensionIds((Long)Long.parseLong(orgId), (List)enableCostCenters, (Map)objRules);
            List collConfigs = ImportServiceHelper.getCollConfigs((Long)Long.parseLong(orgId), null, (Set)calDimensionIds, (String)"sca_resourceuse", (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((List)collConfigs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u65b9\u6848\u3002", (String)"ResourceUseBillListPlugin_18", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
        }
        Boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId));
        ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
        if (isOrgEnableMultiFactory.booleanValue() && CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
            List userHasPermManuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            manuOrgs.addAll(userHasPermManuOrgs);
        } else if (isOrgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
            manuOrgs.add(Long.parseLong(this.getPageCache().get("manuorg")));
        }
        String progressId = UUID.randomUUID().toString();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"ResourceUseBillListPlugin_20", (String)"macc-sca-form", (Object[])new Object[0]), () -> {
            Map responseInfo = new HashMap(2);
            try {
                responseInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"resourceUseService", (String)"importResourceUse", (Object[])new Object[]{null, null, Long.parseLong(orgId), enableCostCenters, manuOrgs, this.getView().getFormShowParameter().getAppId(), progressId});
            }
            catch (NumberFormatException e) {
                MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"ResourceUseBillListPlugin_21", (String)"macc-sca-form", (Object[])new Object[0]), e.toString()), responseInfo);
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
            this.getPageCache().put("responseInfo", responseInfoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), IMPORT_RESULT));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        this.getView().hideLoading();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                if ("confirm".equals(responseInfo.get("type"))) {
                    billList.refresh();
                    this.getView().showConfirm((String)responseInfo.get("msg"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showReport", (IFormPlugin)this));
                    break;
                }
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            switch (callBackId) {
                case "showReport": {
                    String responseInfoStr = this.getPageCache().get("responseInfo");
                    if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                        return;
                    }
                    Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                    this.showColReport((String)responseInfo.get("colReportId"));
                    break;
                }
            }
        }
    }

    private void showColReport(String colReportId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_colreport");
        billShowParameter.setCustomParam("id", (Object)colReportId);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u62a5\u544a", (String)"ResourceUseBillListPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void refreshData() {
        DynamicObject[] resourcUseOpras;
        QFilter opraFilter = new QFilter("entryentity.opra", "=", (Object)0L);
        DynamicObjectCollection resourcUses = QueryServiceHelper.query((String)"sca_resourceuse", (String)"id,srcbillid,entryentity.opra opra", (QFilter[])new QFilter[]{opraFilter});
        HashSet<Long> ids = new HashSet<Long>(10);
        HashSet<Long> srcIds = new HashSet<Long>(10);
        for (DynamicObject resourcUse : resourcUses) {
            ids.add(resourcUse.getLong("id"));
            srcIds.add(resourcUse.getLong("srcbillid"));
        }
        QFilter idFilter = new QFilter("id", "in", srcIds);
        DynamicObject[] processerProBills = BusinessDataServiceHelper.load((String)"sfc_processreportbill", (String)"id,sumentry.opra", (QFilter[])new QFilter[]{idFilter});
        HashMap<Long, Long> opraMap = new HashMap<Long, Long>(16);
        for (DynamicObject processerProBill : processerProBills) {
            opraMap.put(processerProBill.getLong("id"), ((DynamicObject)processerProBill.getDynamicObjectCollection("sumentry").get(0)).getLong("opra.id"));
        }
        QFilter filter = new QFilter("id", "in", ids);
        for (DynamicObject resourcUseOpra : resourcUseOpras = BusinessDataServiceHelper.load((String)"sca_resourceuse", (String)"srcbillid,entryentity.opra", (QFilter[])new QFilter[]{filter})) {
            ((DynamicObject)resourcUseOpra.getDynamicObjectCollection("entryentity").get(0)).set("opra", opraMap.get(resourcUseOpra.getLong("srcbillid")));
            resourcUseOpra.getDynamicObjectCollection("entryentity");
        }
        SaveServiceHelper.update((DynamicObject[])resourcUseOpras);
    }

    private String getInnerType(String key) {
        String costCenter;
        String result = "";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String accountOrg = this.getPageCache().get("org");
        if (!CadEmptyUtils.isEmpty((String)accountOrg)) {
            filters.add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountOrg)));
        }
        if (!CadEmptyUtils.isEmpty((String)(costCenter = this.getPageCache().get("costcenter")))) {
            filters.add(new QFilter("costcenter", "=", (Object)Long.valueOf(costCenter)));
        }
        QFilter appnumFilter = null;
        if (this.getView().getFormShowParameter().getAppId() != null) {
            appnumFilter = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        }
        DynamicObject queryOne = null;
        if (!CadEmptyUtils.isEmpty(filters) && filters.size() == 2) {
            if (appnumFilter != null) {
                filters.add(appnumFilter);
            }
            if ((queryOne = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"resourceusetype", (QFilter[])filters.toArray(new QFilter[0]))) == null) {
                ArrayList<QFilter> filters2 = new ArrayList<QFilter>();
                filters2.add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountOrg)));
                filters2.add(new QFilter("costcenter", "=", (Object)0));
                if (appnumFilter != null) {
                    filters2.add(appnumFilter);
                }
                queryOne = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"resourceusetype", (QFilter[])filters2.toArray(new QFilter[0]));
            }
        }
        if (!CadEmptyUtils.isEmpty(filters) && filters.size() == 1) {
            DynamicObjectCollection query;
            if (appnumFilter != null) {
                filters.add(appnumFilter);
            }
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(query = QueryServiceHelper.query((String)"cad_sysparam", (String)"resourceusetype", (QFilter[])filters.toArray(new QFilter[0]))))) {
                for (DynamicObject dynamicObject : query) {
                    if ("tblnew".equals(key) && "MANUAL".equals(dynamicObject.getString("resourceusetype"))) {
                        return "MANUAL";
                    }
                    if (!"sysimportcover".equals(key) || !"OBJECTRULE".equals(dynamicObject.getString("resourceusetype"))) continue;
                    return "OBJECTRULE";
                }
                queryOne = (DynamicObject)query.get(0);
            }
        }
        if (queryOne != null) {
            result = queryOne.getString("resourceusetype");
        }
        return result;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "importdata", "importdetails"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        HashSet<String> hiddenKeys = new HashSet<String>(3);
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "costcenter.number": {
                    column.setFixed(true);
                    break;
                }
                case "costcenter.name": {
                    column.setFixed(true);
                    break;
                }
                case "manuorg.number": {
                    column.setFixed(true);
                    break;
                }
                case "manuorg.name": {
                    column.setFixed(true);
                    break;
                }
                case "billno": {
                    column.setFixed(true);
                    break;
                }
                case "resource.name": {
                    column.setFixed(true);
                }
            }
        }
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            hiddenKeys.add("pricedate");
        }
        if (!CadEmptyUtils.isEmpty(hiddenKeys)) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, hiddenKeys);
        }
    }
}

