/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.allocstd;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.servicehelper.WorkQtyCollectServiceHelper;
import kd.macc.sca.formplugin.base.BaseManuorgListPlugin;

public class WorkQtyCollecListPlugin
extends BaseManuorgListPlugin {
    private static final Log logger = LogFactory.getLog(WorkQtyCollecListPlugin.class);
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private static final String closeBack_importResult = "importResult";
    private volatile boolean orgClick = false;

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        this.initClickEvent(args);
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        String orgId = "";
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (!CadEmptyUtils.isEmpty((List)acctOrgs)) {
            orgId = this.getCurrOrgId(acctOrgs);
        }
        List<ComboItem> costcenters = this.getCostCenterByAccoutOrg(orgId);
        List<Object> manuorgs = CadEmptyUtils.isEmpty((String)orgId) ? new ArrayList() : this.getManuOrgComboItemsList(Long.valueOf(orgId));
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "org.id": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(acctOrgs);
                    commonFilterColumn.setDefaultValue(orgId);
                    break;
                }
                case "costcenter.name": {
                    listcomitem.clear();
                    if (costcenters == null) break;
                    commonFilterColumn.setComboItems(costcenters);
                    break;
                }
                case "manuorg.name": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(manuorgs);
                }
            }
        }
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator var3 = filterColumns.iterator();
        String oldOrgId = this.getPageCache().get("orgId");
        while (var3.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)var3.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (!fieldName.startsWith("org.") || !StringUtils.isNotEmpty((String)oldOrgId)) continue;
            if (!defaultValue.equals(oldOrgId)) {
                this.orgClick = true;
                continue;
            }
            this.orgClick = false;
        }
    }

    protected QFilter getManuOrgQFilter() {
        Long orgIdL;
        String orgId;
        QFilter manuOrgQf = null;
        String manuOrgId = this.getPageCache().get("manuorgId");
        if (StringUtils.isEmpty((String)manuOrgId) && !StringUtils.isEmpty((String)(orgId = this.getPageCache().get("orgId"))) && OrgHelper.isOrgEnableMultiFactory((Long)(orgIdL = Long.valueOf(orgId)))) {
            List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgIdL, (String)this.getBillEntityId());
            if (!CadEmptyUtils.isEmpty((List)userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter("manuorg", "in", (Object)userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter("manuorg", "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        String orgId = this.getPageCache().get("orgId");
        Long accountOrgId = CadEmptyUtils.isEmpty((String)orgId) ? 0L : Long.parseLong(orgId);
        if (fieldName.startsWith("manuorg")) {
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountOrgId, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        } else if (fieldName.startsWith("costcenter")) {
            if (accountOrgId == 0L) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            } else {
                args.getQfilters().add(new QFilter("accountorg", "=", (Object)accountOrgId).and(new QFilter("enable", "=", (Object)"1")));
            }
        }
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    protected List<ComboItem> getManuOrgComboItemsList(Long orgId) {
        return ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
    }

    private String getCurrOrgId(List<ComboItem> acctOrgs) {
        String orgId = this.getPageCache().get("orgId");
        if (orgId == null || "".equals(orgId)) {
            orgId = this.getCustomParam("org");
            if (!CadEmptyUtils.isEmpty((String)orgId)) {
                return orgId;
            }
            Long currAcctOrg = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
            if (isAccounting) {
                orgId = currAcctOrg + "";
            } else {
                ComboItem comboItem = acctOrgs.get(0);
                orgId = comboItem.getValue();
            }
            this.getPageCache().put("orgId", orgId);
        }
        return orgId;
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues;
        List customfilter;
        super.filterContainerSearchClick(args);
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"manuorg.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"costcenter.id");
        }
        if ((customfilter = (List)(filterValues = args.getSearchClickEvent().getFilterValues()).get("customfilter")) == null || customfilter.isEmpty()) {
            return;
        }
        String accountorgId = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            Map filter = (Map)customfilter.get(i);
            List listFieldName = (List)filter.get("FieldName");
            List listValue = (List)filter.get("Value");
            block11: for (int j = 0; j < listFieldName.size(); ++j) {
                String fieldName;
                switch (fieldName = (String)listFieldName.get(j)) {
                    case "org.id": {
                        if (listValue == null || listValue.isEmpty()) {
                            return;
                        }
                        accountorgId = (String)listValue.get(j);
                        this.getPageCache().put("orgId", accountorgId);
                        this.getPageCache().remove("mulcostcenter");
                        this.filterContainerInit(this.filterContainerInitArgs);
                        continue block11;
                    }
                    case "costcenter.id": {
                        if (listValue == null || listValue.isEmpty()) {
                            return;
                        }
                        this.getPageCache().put("mulcostcenter", SerializationUtils.toJsonString((Object)listValue));
                        if (listValue.size() > 1) {
                            this.getPageCache().put("costcenterId", "");
                            continue block11;
                        }
                        this.getPageCache().put("costcenterId", (String)listValue.get(j));
                        continue block11;
                    }
                    case "manuorg.id": {
                        if (listValue == null || listValue.isEmpty()) {
                            this.getPageCache().put("manuorgId", "");
                            continue block11;
                        }
                        this.getPageCache().put("manuorgId", (String)listValue.get(j));
                        this.filterContainerInit(this.filterContainerInitArgs);
                    }
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("searchconfig".equals(itemKey)) {
            this.searchConfig();
        }
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)"sca_workqtycollec", (IFormView)this.getView());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String orgId = this.getPageCache().get("orgId");
        if ("tblnew".equals(key) && StringUtils.isEmpty((String)orgId)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WorkQtyCollecListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]), new Object[0]));
            evt.setCancel(true);
            return;
        }
        if ("sysimport".equals(key)) {
            if (StringUtils.isEmpty((String)orgId)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WorkQtyCollecListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
                return;
            }
            this.inSysImport();
        }
    }

    private void inSysImport() {
        try {
            Map objRules;
            String acctOrg = this.getPageCache().get("orgId");
            if (CadEmptyUtils.isEmpty((String)acctOrg)) {
                return;
            }
            long accountOrgId = Long.parseLong(acctOrg);
            String costCenter = this.getPageCache().get("mulcostcenter");
            ArrayList<Long> costCenters = new ArrayList<Long>(10);
            if (!CadEmptyUtils.isEmpty((String)costCenter)) {
                List costCenterMultiSelect = (List)SerializationUtils.fromJsonString((String)costCenter, List.class);
                if (!CadEmptyUtils.isEmpty((List)costCenterMultiSelect) && costCenterMultiSelect.size() > 1) {
                    costCenterMultiSelect.forEach(s -> costCenters.add(Long.parseLong(String.valueOf(s))));
                } else if (costCenterMultiSelect.size() == 1 && !CadEmptyUtils.isEmpty((String)String.valueOf(costCenterMultiSelect.get(0)))) {
                    costCenters.add(Long.parseLong(String.valueOf(costCenterMultiSelect.get(0))));
                }
            }
            if (CadEmptyUtils.isEmpty(costCenters)) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("accountorg", "=", (Object)accountOrgId));
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("enable", "=", (Object)true));
                filters.add(new QFilter("orgduty.number", "=", (Object)"5"));
                List costCentersByOrg = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
                costCentersByOrg.forEach(s -> costCenters.add(Long.parseLong(String.valueOf(s))));
            }
            if (CadEmptyUtils.isEmpty((Map)(objRules = CostObjectHelper.getCostObjectRulesMap((Long)accountOrgId, costCenters)))) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"WorkQtyCollecListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]), (String)"CostObjectListPlugin_6"));
                return;
            }
            Set calDimensionIds = CostObjectHelper.getCalDimensionIds((Long)accountOrgId, costCenters, (Map)objRules);
            List collConfigs = CommonCollConfigService.getCollConfigs((Long)Long.parseLong(acctOrg), null, (Set)calDimensionIds, (String)"sca_workqtycollec", (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((List)collConfigs)) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u4f5c\u4e1a\u6570\u91cf\u5f52\u96c6\u65b9\u6848\u3002", (String)"WorkQtyCollecListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]), (String)"WorkQtyCollecListPlugin_18"));
                return;
            }
            Boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)accountOrgId);
            ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
            if (isOrgEnableMultiFactory.booleanValue() && CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorgId"))) {
                List userHasPermManuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountOrgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                manuOrgs.addAll(userHasPermManuOrgs);
            } else if (isOrgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorgId"))) {
                manuOrgs.add(Long.parseLong(this.getPageCache().get("manuorgId")));
            }
            String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"WorkQtyCollecListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]), () -> {
                Map responseInfo = new HashMap(2);
                try {
                    responseInfo = WorkQtyCollectServiceHelper.importWorkQtyCollect((Long)accountOrgId, (List)costCenters, (List)manuOrgs, (String)appNum, (String)progressId);
                }
                catch (Exception e) {
                    MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
                    MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"WorkQtyCollecListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]), e.toString()), responseInfo);
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        }
        catch (Exception ex) {
            logger.error("\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u62a5\u9519\uff1a", (Throwable)ex);
            throw ex;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setCustomParam("orgId", (Object)this.getPageCache().get("orgId"));
        e.getParameter().setCustomParam("costcenterId", (Object)this.getPageCache().get("costcenterId"));
        e.getParameter().setCustomParam("manuorgId", (Object)this.getPageCache().get("manuorgId"));
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
        e.setOrderBy("bizdate desc,billno desc");
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        ArrayList<String> freezeFields = new ArrayList<String>();
        freezeFields.add("manuorg.name");
        freezeFields.add("manuorg.number");
        freezeFields.add("costcenter.number");
        freezeFields.add("costcenter.name");
        freezeFields.add("billno");
        freezeFields.add("bizdate");
        List listColumns = o.getListColumns();
        listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            if (!freezeFields.contains(column.toString())) continue;
            column.setFixed(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateQtyScale();
    }

    private void updateQtyScale() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.size() < 1) {
            return;
        }
        String fields = "id, baseunit, baseunit.precision AS precision, baseunit.precisionaccount AS precisionaccount, entryentity.id AS entryid, entryentity.entryqty AS entryqty";
        QFilter idQF = new QFilter("id", "in", (Object)rows.getPrimaryKeyValues());
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"sca_workqtycollec", (String)fields, (QFilter[])new QFilter[]{idQF});
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        for (DynamicObject col : cols) {
            Long entryid = col.getLong("entryid");
            if (null == entryid || 0L == entryid) continue;
            map.put(entryid, col);
        }
        for (int i = 0; i < rows.size(); ++i) {
            Long entryid = (Long)rows.get(i).getEntryPrimaryKeyValue();
            if (null == entryid || 0L == entryid) continue;
            DynamicObject col = (DynamicObject)map.get(entryid);
            int precision = col.getInt("precision");
            String precisionaccount = col.getString("precisionaccount");
            int roundType = 4;
            if ("2".equals(precisionaccount)) {
                roundType = 1;
            } else if ("3".equals(precisionaccount)) {
                roundType = 0;
            }
            BigDecimal value = col.getBigDecimal("entryqty").setScale(precision, roundType);
            if (value.longValue() == 0L) {
                return;
            }
            String allocvalueStr = value.toString();
            billList.setCellFieldValue("entryqty", i, (Object)allocvalueStr);
        }
    }

    public List<ComboItem> getCostCenterByAccoutOrg(String orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        long org = StringUtils.isEmpty((String)orgId) ? 0L : Long.parseLong(orgId);
        String manuOrgId = this.getPageCache().get("manuorgId");
        ArrayList<Long> manuOrgList = new ArrayList<Long>();
        if (!CadEmptyUtils.isEmpty((String)manuOrgId)) {
            manuOrgList.add(Long.parseLong(manuOrgId));
        }
        QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)org, manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
        filters.add(costCenterIdFilter);
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("orgduty.number", "=", (Object)"5"));
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        List centerItems = DynamicObjectHelper.toComboItem((DynamicObjectCollection)costCenters);
        return centerItems;
    }
}

