/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.autoexec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.StdCalculateHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.AutoCalcStatusEnum;
import kd.macc.sca.common.helper.StandCostCalcHelper;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class SalOrderStdCalcLogListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final Log logger = LogFactory.getLog(SalOrderStdCalcLogListPlugin.class);
    private static final String OP_RELAUNCH = "logrelaunch";
    private static final String OP_RECANCEL = "recancel";
    private static final String OP_MANUUPDATE = "manuupdate";
    private static final String OP_QUERYSTDCOST_SUB = "querystdcost_sub";
    private static final String OP_QUERYSTDCOST_COM = "querystdcost_com";
    private static final String OP_QUERYSTDCOST_LEVEL = "querystdcost_level";
    private static final String OP_RESYNCETRACKNUM = "resyncetracknum";
    private static final String closeBack_doCalc = "closeBack_doCalc";
    private static final String closeBack_DateRange = "dateRange";
    private static final String UPDATE_SALORDERSTDCALC_CANCEL_LOG = "UPDATE t_sca_salorderstdcalclog SET fstatus='05',foperatorid=?,foperdate=? WHERE fid in(%s)";
    private static final String INSERT_SALORDERSTDCALC_SQL = "INSERT INTO t_sca_salorderstdcalclog (fid,forgid,fmanuorgid,fcosttypeid,ftargetcosttypeid,fsyncdate,fsalorderno,fsalorderseq,fsalorderentryid,fmaterialid,fauxptyid,fconfiguredcodeid,ftracknumberid,fsalorderaudittime,foperationtype,fstatus,flastexecdate,ftrytimes,fexeclog,foperatorid,foperdate) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String itemKey = evt.getOperateKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRow = listview.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow row : selectedRow) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        switch (itemKey) {
            case "logrelaunch": {
                this.logReLaunchForManul(ids);
                break;
            }
            case "recancel": {
                this.logCancel(ids, " ");
                break;
            }
            case "manuupdate": {
                this.updateForManul(ids);
                break;
            }
            case "querystdcost_sub": {
                this.dealTblStdCost(ids, itemKey);
                break;
            }
            case "querystdcost_com": {
                this.dealTblStdCost(ids, itemKey);
                break;
            }
            case "querystdcost_level": {
                this.dealTblStdCost(ids, itemKey);
                break;
            }
            case "resyncetracknum": {
                this.showDateRangeSetting();
            }
        }
    }

    private void showDateRangeSetting() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("sca_resyncetracknum");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_DateRange));
        this.getView().showForm(fsp);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("syncdate desc");
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        int salOrderLog_refreshTransmitTime = CadBgParamUtils.getCadParamForInt((String)"log_refreshTransmitTime", (int)0);
        if (salOrderLog_refreshTransmitTime == 1) {
            String org = this.getPageCache().get(this.ORG_FIELD);
            JSONArray parse = (JSONArray)JSON.parse((String)org);
            ArrayList<Long> orgIds = new ArrayList<Long>(10);
            if (CadEmptyUtils.isEmpty((List)parse) || CadEmptyUtils.isEmpty((String)((String)parse.get(0)))) {
                List acctOrgs = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                orgIds.addAll(acctOrgs);
            } else {
                String id = (String)parse.get(0);
                orgIds.add(Long.parseLong(id));
            }
            StdCalculateHelper.updateSalOrderLogTime(null, orgIds);
        }
    }

    protected void reSynceTracknum(List<Long> orgIds, Date beginDate, Date endDate) {
        HashSet<Long> exsitSalOrderTrackNums = new HashSet<Long>(200);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"sca_salorderstdcalclog", (String)"tracknumber", (QFilter[])new QFilter[]{orgFilter});
        logs.forEach(log -> exsitSalOrderTrackNums.add(log.getLong("tracknumber")));
        if (CadEmptyUtils.isEmpty(orgIds)) {
            return;
        }
        Set<Long> salOrderBillIds = this.getSalOrderBillIds(exsitSalOrderTrackNums, beginDate, endDate);
        StandCostCalcHelper.addSalOrderStdCalcLog(new ArrayList<Long>(salOrderBillIds), null);
    }

    private Set<Long> getSalOrderBillIds(Set<Long> exsitSalOrderTrackNums, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and(new QFilter("billentry.tracknumber", "not in", exsitSalOrderTrackNums));
        QFilter dateFilter = new QFilter("auditdate", ">=", (Object)beginDate);
        dateFilter.and(new QFilter("auditdate", "<=", (Object)endDate));
        filter.and(dateFilter);
        DynamicObjectCollection salOrders = QueryServiceHelper.query((String)"sm_salorder", (String)"id", (QFilter[])new QFilter[]{filter});
        return DynamicObjectHelper.getIdSet((DynamicObjectCollection)salOrders, (String)"id");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        String org = this.getPageCache().get(this.ORG_FIELD);
        JSONArray parse = (JSONArray)JSON.parse((String)org);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        if (CadEmptyUtils.isEmpty((List)parse) || CadEmptyUtils.isEmpty((String)((String)parse.get(0)))) {
            List acctOrgs = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            orgIds.addAll(acctOrgs);
        } else {
            String id = (String)parse.get(0);
            orgIds.add(Long.parseLong(id));
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "dateRange": {
                HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
                if (returnData == null) {
                    return;
                }
                Date beginDate = (Date)returnData.get("begindate");
                Date endDate = (Date)returnData.get("enddate");
                if (beginDate == null || endDate == null) {
                    return;
                }
                try {
                    this.reSynceTracknum(orgIds, beginDate, endDate);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u540c\u6b65\u8ddf\u8e2a\u53f7\u5b8c\u6210\u3002", (String)"SalOrderStdCalcLogListPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    logger.error("\u91cd\u65b0\u540c\u6b65\u8ddf\u8e2a\u53f7\u5931\u8d25", (Throwable)e);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u540c\u6b65\u8ddf\u8e2a\u53f7\u5931\u8d25\u3002", (String)"SalOrderStdCalcLogListPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "closeBack_doCalc": {
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                if ("success".equals(responseInfoStr)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5377\u7b97\u5b8c\u6210", (String)"SalOrderStdCalcLogListPlugin_14", (String)"macc-sca-form", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5377\u7b97\u5931\u8d25", (String)"SalOrderStdCalcLogListPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void dealTblStdCost(List<Long> logIds, String itemKey) {
        if (CadEmptyUtils.isEmpty(logIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SalOrderStdCalcLogListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        QFilter idFilter = new QFilter("id", "in", logIds);
        QFilter statusFilter = new QFilter("status", "!=", (Object)AutoCalcStatusEnum.SUCCESS.getValue());
        if (QueryServiceHelper.exists((String)"sca_salorderstdcalclog", (QFilter[])new QFilter[]{idFilter, statusFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u65e5\u5fd7\u72b6\u6001\u4e3a\u975e\u6210\u529f\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalOrderStdCalcLogListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        QFilter optFilter = new QFilter("operationtype", "in", (Object)new String[]{"1", "2"});
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"sca_salorderstdcalclog", (String)"operationtype", (QFilter[])new QFilter[]{idFilter, optFilter});
        ArrayList<String> opTypes = new ArrayList<String>(10);
        for (DynamicObject log : logs) {
            String operationtype = log.getString("operationtype");
            if (!opTypes.contains(operationtype)) {
                opTypes.add(operationtype);
            }
            if (opTypes.size() <= 1) continue;
            break;
        }
        if (opTypes.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u65f6\u5b58\u5728\u6267\u884c\u64cd\u4f5c\u4e3a\u5377\u7b97\u548c\u66f4\u65b0\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalOrderStdCalcLogListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] salOrderStdCalcLogs = BusinessDataServiceHelper.load((Object[])logIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"sca_salorderstdcalclog"));
        if (salOrderStdCalcLogs == null || salOrderStdCalcLogs.length < 1) {
            return;
        }
        HashSet<Long> costTypeIds = new HashSet<Long>(10);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObjectCollection mulconfigCodes = new DynamicObjectCollection();
        DynamicObjectCollection multrackNumbers = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : salOrderStdCalcLogs) {
            DynamicObject trackNumber;
            DynamicObject configCode;
            long costTypeId = dynamicObject.getLong("costtype.id");
            if (opTypes.contains("2")) {
                costTypeId = dynamicObject.getLong("targetcosttype.id");
            }
            costTypeIds.add(costTypeId);
            DynamicObject material = dynamicObject.getDynamicObject("material");
            if (material != null) {
                collection.add((Object)material);
            }
            if ((configCode = dynamicObject.getDynamicObject("configuredcode")) != null) {
                mulconfigCodes.add((Object)configCode);
            }
            if ((trackNumber = dynamicObject.getDynamicObject("tracknumber")) == null) continue;
            multrackNumbers.add((Object)trackNumber);
        }
        if (CadEmptyUtils.isEmpty(costTypeIds) || costTypeIds.contains(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6210\u672c\u7c7b\u578b\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalOrderStdCalcLogListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        if (costTypeIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u6210\u672c\u7c7b\u578b\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalOrderStdCalcLogListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        ReportShowParameter showParameter = new ReportShowParameter();
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("costtype", salOrderStdCalcLogs[0].getDynamicObject("costtype").getPkValue());
        filterInfo.addFilterItem("querydate", (Object)TimeServiceHelper.now());
        if (OP_QUERYSTDCOST_LEVEL.equals(itemKey)) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("costtype", salOrderStdCalcLogs[0].getDynamicObject("costtype").getPkValue());
            map.put("querydate", TimeServiceHelper.now());
            map.put("mulmaterial", DynamicObjectHelper.getIdList((DynamicObjectCollection)collection, (String)"id"));
            map.put("mulconfiguredcode", DynamicObjectHelper.getIdList((DynamicObjectCollection)mulconfigCodes, (String)"id"));
            map.put("multracknumber", DynamicObjectHelper.getIdList((DynamicObjectCollection)multrackNumbers, (String)"id"));
            map.put("materialgrpstd", 730148448254487552L);
            showParameter.setCustomParam("param", (Object)SerializationUtils.toJsonString(map));
            showParameter.setFormId("cad_stdcostlevelrptnew");
        } else if (OP_QUERYSTDCOST_SUB.equals(itemKey)) {
            filterInfo.addFilterItem("mulmaterial", (Object)collection);
            filterInfo.addFilterItem("mulconfiguredcode", (Object)mulconfigCodes);
            filterInfo.addFilterItem("multracknumber", (Object)multrackNumbers);
            showParameter.setFormId("cad_finalstdrpt");
            showParameter.setQueryParam(queryParam);
        } else {
            filterInfo.addFilterItem("mulmaterial", (Object)collection);
            filterInfo.addFilterItem("mulconfiguredcode", (Object)mulconfigCodes);
            filterInfo.addFilterItem("multracknumber", (Object)multrackNumbers);
            showParameter.setFormId("cad_stdrpt");
            showParameter.setQueryParam(queryParam);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateForManul(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{AutoCalcStatusEnum.RUNNING.getValue()});
        if (QueryServiceHelper.exists((String)"sca_salorderstdcalclog", (QFilter[])new QFilter[]{filter, statusFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6267\u884c\u72b6\u6001\u4e3a\u8fd0\u884c\u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalOrderStdCalcLogListPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"sca_salorderstdcalclog", (String)"id,status", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> successBills = new ArrayList<Long>(10);
        for (DynamicObject log : logs) {
            long id = log.getLong("id");
            String status = log.getString("status");
            if (!"02".equals(status)) continue;
            successBills.add(id);
        }
        if (CadEmptyUtils.isEmpty(successBills)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6267\u884c\u72b6\u6001\u4e3a\u6210\u529f\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalOrderStdCalcLogListPlugin_17", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        filter = new QFilter("id", "in", successBills);
        DynamicObjectCollection stdCalcLogs = QueryServiceHelper.query((String)"sca_salorderstdcalclog", (String)"id,costtype,targetcosttype,tracknumber", (QFilter[])new QFilter[]{filter});
        logger.info("\u81ea\u52a8\u6267\u884c\u6807\u51c6\u6210\u672c\u66f4\u65b0\uff0c\u5f53\u524d\u6267\u884c\u65f6\u95f4==>{}\uff0c\u83b7\u53d6\u6b64\u6b21\u67e5\u8be2\u8303\u56f4 ==>{}\uff0c\u672c\u6b21\u67e5\u8be2\u6761\u6570==>{}", new Object[]{TimeServiceHelper.now(), filter, stdCalcLogs.size()});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)stdCalcLogs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalOrderStdCalcLogListPlugin_18", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        HashMap<String, List> groups = new HashMap<String, List>(stdCalcLogs.size());
        for (DynamicObject stdCalcLog : stdCalcLogs) {
            Long tarCostTypeId = stdCalcLog.getLong("targetcosttype");
            if (CadEmptyUtils.isEmpty((Long)tarCostTypeId)) {
                logger.info("\u76ee\u6807\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002tarCostTypeId={}", (Object)stdCalcLog.getString("targetcosttype"));
                continue;
            }
            String key = String.join((CharSequence)"&", stdCalcLog.getString("costtype"), stdCalcLog.getString("targetcosttype"));
            groups.computeIfAbsent(key, p -> new ArrayList()).add(stdCalcLog);
        }
        if (CadEmptyUtils.isEmpty(groups)) {
            logger.info("\u6ca1\u6709\u5f85\u66f4\u65b0\u7684\u5355\u636e\uff0c\u672c\u6b21\u81ea\u52a8\u66f4\u65b0\u7ed3\u675f\u3002");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f85\u66f4\u65b0\u7684\u6570\u636e\uff0c\u66f4\u65b0\u7ed3\u675f\u3002", (String)"SalOrderStdCalcLogListPlugin_19", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        for (Map.Entry group : groups.entrySet()) {
            List values = (List)group.getValue();
            if (CadEmptyUtils.isEmpty((List)values)) continue;
            ArrayList<Long> trackIds = new ArrayList<Long>(values.size());
            for (DynamicObject value : values) {
                Long trackId = value.getLong("tracknumber");
                if (CadEmptyUtils.isEmpty((Long)trackId)) continue;
                trackIds.add(trackId);
            }
            if (CadEmptyUtils.isEmpty(trackIds) || trackIds.size() == values.size()) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u65e2\u5305\u542b\u6709\u8ddf\u8e2a\u53f7\u7684\u7269\u6599\uff0c\u53c8\u5305\u542b\u65e0\u8ddf\u8e2a\u53f7\u7684\u7269\u6599\u8fdb\u884c\u624b\u5de5\u66f4\u65b0\u3002", (String)"SalOrderStdCalcLogListPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        Map resultMsgMap = new HashMap(16);
        try {
            resultMsgMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"StdCostService", (String)"doUpdateForManu", (Object[])new Object[]{successBills});
        }
        catch (Exception e) {
            logger.error("\u624b\u5de5\u8c03\u7528\u66f4\u65b0\u670d\u52a1\u5931\u8d25\u3002", (Throwable)e);
        }
        finally {
            if (resultMsgMap.containsKey("error")) {
                this.getView().showErrorNotification((String)resultMsgMap.get("error"));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u66f4\u65b0\u5b8c\u6210\uff0c\u8bf7\u67e5\u770b\u66f4\u65b0\u72b6\u6001\u3002", (String)"SalOrderStdCalcLogListPlugin_20", (String)"macc-sca-form", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh", OperateOption.create());
        }
    }

    private void logReLaunchForManul(List<Long> ids) {
        DynamicObjectCollection logs;
        QFilter statusFilter;
        QFilter filter;
        if (ids.size() > 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6700\u591a\u9009\u62e950\u6761\u65e5\u5fd7\u3002", (String)"SalOrderStdCalcLogListPlugin_21", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        int salOrderLog_refreshTransmitTime = CadBgParamUtils.getCadParamForInt((String)"log_refreshTransmitTime", (int)0);
        if (salOrderLog_refreshTransmitTime == 1) {
            StdCalculateHelper.updateSalOrderLogTime(ids, null);
        }
        if (QueryServiceHelper.exists((String)"sca_salorderstdcalclog", (QFilter[])new QFilter[]{filter = new QFilter("id", "in", ids), statusFilter = new QFilter("status", "in", (Object)new String[]{AutoCalcStatusEnum.RUNNING.getValue()})})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u65e5\u5fd7\u72b6\u6001\u4e3a\u8fd0\u884c\u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalOrderStdCalcLogListPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        if (salOrderLog_refreshTransmitTime == 1) {
            filter.and(new QFilter("transmittime", "is not null", null));
        }
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)(logs = QueryServiceHelper.query((String)"sca_salorderstdcalclog", (String)"id,status", (QFilter[])new QFilter[]{filter})))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6267\u884c\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalOrderStdCalcLogListPlugin_30", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> successBills = new ArrayList<Long>(10);
        ArrayList<Long> ortherBills = new ArrayList<Long>(10);
        for (DynamicObject log : logs) {
            long id = log.getLong("id");
            String status = log.getString("status");
            if ("02".equals(status)) {
                successBills.add(id);
                continue;
            }
            ortherBills.add(id);
        }
        if (CadEmptyUtils.isEmpty(successBills) || !CadEmptyUtils.isEmpty(ortherBills) && !CadEmptyUtils.isEmpty(successBills)) {
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7\u6210\u672c\u5377\u7b97", (String)"SalOrderStdCalcLogListPlugin_22", (String)"macc-sca-form", (Object[])new Object[0]), () -> {
                try {
                    DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"StdCostService", (String)"doCalcForManu", (Object[])new Object[]{ortherBills, progressId});
                    this.getPageCache().put("responseInfo", "success");
                }
                catch (Exception e) {
                    logger.error("\u624b\u5de5\u8c03\u7528\u5377\u7b97\u5fae\u670d\u52a1\u5931\u8d25\u3002", (Throwable)e);
                    SalOrderStdCalcLogListPlugin.updateSalOrderLogs(ortherBills, "03", Boolean.TRUE, ResManager.loadKDString((String)"\u8c03\u7528\u5377\u7b97\u5fae\u670d\u52a1\u5931\u8d25\u3002", (String)"SalOrderStdCalcLogListPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
                    this.getPageCache().put("responseInfo", "fail");
                }
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_doCalc));
        } else if (CadEmptyUtils.isEmpty(ortherBills) && !CadEmptyUtils.isEmpty(successBills)) {
            this.getView().getPageCache().put("clacIds", SerializationUtils.toJsonString(successBills));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u65e5\u5fd7\u5747\u4e3a\u6210\u529f\u72b6\u6001\uff0c\u91cd\u65b0\u6267\u884c\u5c06\u4f1a\u5220\u9664\u539f\u5148\u7684\u8ba1\u7b97\u7ed3\u679c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalOrderStdCalcLogListPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callback_confirm", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("callback_confirm".equals(callBackId) && MessageBoxResult.Yes == e.getResult()) {
            String clacIdStr = this.getView().getPageCache().get("clacIds");
            if (CadEmptyUtils.isEmpty((String)clacIdStr)) {
                return;
            }
            List clacIds = (List)SerializationUtils.fromJsonString((String)clacIdStr, List.class);
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5377\u7b97", (String)"SalOrderStdCalcLogListPlugin_23", (String)"macc-sca-form", (Object[])new Object[0]), () -> {
                try {
                    DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"StdCostService", (String)"doCalcForManu", (Object[])new Object[]{clacIds, progressId});
                    this.getPageCache().put("responseInfo", "success");
                }
                catch (Exception exp) {
                    logger.error("\u624b\u5de5\u8c03\u7528\u5377\u7b97\u5fae\u670d\u52a1\u5931\u8d25\u3002", (Throwable)exp);
                    SalOrderStdCalcLogListPlugin.updateSalOrderLogs(clacIds, "03", Boolean.TRUE, ResManager.loadKDString((String)"\u8c03\u7528\u5377\u7b97\u5fae\u670d\u52a1\u5931\u8d25\u3002", (String)"SalOrderStdCalcLogListPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
                    this.getPageCache().put("responseInfo", "fail");
                }
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_doCalc));
        }
    }

    private void logReLaunch(List<Long> ids) {
        ArrayList filters = Lists.newArrayList();
        filters.add(new QFilter("id", "in", ids));
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{AutoCalcStatusEnum.NOT_EXECUTE.getValue()});
        statusFilter.or(new QFilter("costtype", "=", (Object)0L));
        filters.add(statusFilter);
        if (QueryServiceHelper.exists((String)"sca_salorderstdcalclog", (QFilter[])filters.toArray(new QFilter[0]))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u65e5\u5fd7\u72b6\u6001\u4e3a\u672a\u6267\u884c\u6216\u8005\u6210\u672c\u7c7b\u578b\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalOrderStdCalcLogListPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        ArrayList logParamObjs = Lists.newArrayListWithExpectedSize((int)ids.size());
        DataSet ds = this.getSelectDs(ids);
        for (Row row : ds) {
            Object[] param = this.getParam(row.getLong("org"), row.getLong("manuorg"), row.getLong("costtype"), row.getLong("targetcosttype"), row.getString("salorderno"), row.getInteger("salorderseq"), row.getLong("salorderentryid"), AutoCalcStatusEnum.NOT_EXECUTE.getValue(), row.getLong("material"), row.getLong("auxpty"), row.getLong("configuredcode"), row.getLong("tracknumber"), row.getDate("salOrderAuditTime"), row.getString("operationtype"), ResManager.loadKDString((String)"\u91cd\u65b0\u53d1\u8d77\u7684\u884c\u3002", (String)"SalOrderStdCalcLogListPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]));
            logParamObjs.add(param);
        }
        if (!logParamObjs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_SALORDERSTDCALC_SQL, (List)logParamObjs);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"SalOrderStdCalcLogListPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private Object[] getParam(Long org, Long manuOrg, Long costType, Long targetcosttype, String salOrderNo, int salOrderSeq, Long salOrderEntryId, String status, Long material, Long auxpty, Long configuredCode, Long trackNumber, Date salOrderAuditTime, String opType, String log) {
        return new Object[]{ID.genLongId(), org, manuOrg, costType, targetcosttype, new Date(), salOrderNo, salOrderSeq, salOrderEntryId, material, auxpty, configuredCode, trackNumber, salOrderAuditTime, opType, "00", null, 0, log, RequestContext.get().getCurrUserId(), new Date()};
    }

    private DataSet getSelectDs(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        return QueryServiceHelper.queryDataSet((String)"getSelectDs", (String)"sca_salorderstdcalclog", (String)"id,org,manuorg,costtype,targetcosttype,salorderno,salorderseq,salorderentryid,operationtype,material,auxpty,configuredcode,tracknumber,salorderaudittime,status", (QFilter[])filter.toArray(), null);
    }

    private void logCancel(List<Long> ids, String log) {
        StringBuilder sb = new StringBuilder();
        int size = 0;
        Object[] paramArray = new Object[]{RequestContext.get().getCurrUserId(), new Date()};
        for (Long billId : ids) {
            sb.append(billId).append(",");
            if (++size <= 50) continue;
            String sql = String.format(UPDATE_SALORDERSTDCALC_CANCEL_LOG, sb.toString().substring(0, sb.length() - 1));
            this.doSqlExecute(DBRoute.of((String)"cal"), sql, paramArray);
            sb.delete(0, sb.length());
            size = 0;
        }
        if (sb.length() > 0) {
            String sql = String.format(UPDATE_SALORDERSTDCALC_CANCEL_LOG, sb.toString().substring(0, sb.length() - 1));
            this.doSqlExecute(DBRoute.of((String)"cal"), sql, paramArray);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"SalOrderStdCalcLogListPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void doSqlExecute(DBRoute cal, String sql, Object[] paramArray) {
        DB.execute((DBRoute)cal, (String)sql, (Object[])paramArray);
    }

    private boolean existsRow(List<Long> ids, String[] status) {
        QFilter filter = new QFilter("id", "in", ids);
        filter.and("status", "not in", (Object)status);
        return QueryServiceHelper.exists((String)"sca_salorderstdcalclog", (QFilter[])filter.toArray());
    }

    private Map<Long, List<ThreeTuple>> getCostTypeAndOrg(DynamicObjectCollection businessBills) {
        HashMap<Long, List<ThreeTuple>> manuOrgCostTypeMap = new HashMap<Long, List<ThreeTuple>>(16);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)businessBills)) {
            return manuOrgCostTypeMap;
        }
        HashMap manuAccountOrgMap = new HashMap(16);
        for (DynamicObject businessBill : businessBills) {
            long manuOrg = businessBill.getLong("proorg");
            OrgRelationParam param = new OrgRelationParam();
            param.setFromViewType("10");
            param.setToViewType("04");
            param.setOrgId(manuOrg);
            param.setIncludeSelf(true);
            List fromOrgs = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            if (CadEmptyUtils.isEmpty((List)fromOrgs)) continue;
            manuAccountOrgMap.put(manuOrg, fromOrgs.get(0));
        }
        logger.info("\u9500\u552e\u8ba2\u5355\uff0c\u751f\u4ea7\u7ec4\u7ec7\u548c\u6838\u7b97\u7ec4\u7ec7\u5173\u7cfbMap\u4e2a\u6570\uff1a" + manuAccountOrgMap.size());
        for (Map.Entry entry : manuAccountOrgMap.entrySet()) {
            OrgRelationParam param;
            Long manuOrg = (Long)entry.getKey();
            Long org = (Long)entry.getValue();
            boolean enableFactory = OrgHelper.isOrgEnableMultiFactory((Long)org);
            QFilter filter = new QFilter("costtype.type", "=", (Object)"0");
            filter.and("bizstatus", "=", (Object)"1");
            filter.and("effectdate", "<=", (Object)new Date());
            filter.and("invaliddate", ">", (Object)new Date());
            if (enableFactory) {
                param = new OrgRelationParam();
                param.setFromViewType("04");
                param.setToViewType("05");
                param.setOrgId(manuOrg.longValue());
                param.setIncludeSelf(true);
                List allToOrg = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
                filter.and("storageorgunit", "=", (Object)(CadEmptyUtils.isEmpty((List)allToOrg) ? Long.valueOf(0L) : (Long)allToOrg.get(0)));
            } else {
                param = new OrgRelationParam();
                param.setFromViewType("10");
                param.setToViewType("04");
                param.setOrgId(manuOrg.longValue());
                param.setIncludeSelf(true);
                List fromOrgs = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
                filter.and("calorg", "=", (Object)(CadEmptyUtils.isEmpty((List)fromOrgs) ? Long.valueOf(0L) : (fromOrgs.contains(org) ? org : fromOrgs.get(0))));
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costtype.id as costType", (QFilter[])new QFilter[]{filter});
            HashSet<Long> costTypes = new HashSet<Long>(5);
            for (DynamicObject obj : dynamicObjects) {
                long costType = obj.getLong("costType");
                if (CadEmptyUtils.isEmpty((Long)costType)) continue;
                costTypes.add(costType);
            }
            QFilter costTypeFilter = new QFilter("id", "in", costTypes);
            costTypeFilter.and("enable", "=", (Object)"1");
            costTypeFilter.and("costtypeentry.costtypeattr", "=", (Object)"1");
            DynamicObjectCollection costTypeObjs = QueryServiceHelper.query((String)"cad_costtype", (String)"id,costtypeentry.costtype.id as costtype", (QFilter[])new QFilter[]{costTypeFilter});
            for (DynamicObject costTypeObj : costTypeObjs) {
                Long costType = costTypeObj.getLong("costtype");
                if (CadEmptyUtils.isEmpty((Long)costType)) continue;
                ThreeTuple threeTuple = new ThreeTuple((Object)org, (Object)costTypeObj.getLong("id"), (Object)costType);
                manuOrgCostTypeMap.computeIfAbsent(manuOrg, p -> new ArrayList()).add(threeTuple);
            }
        }
        return manuOrgCostTypeMap;
    }

    public static void updateSalOrderLogs(List<Long> salOrderLogIds, String status, Boolean isCalc, String errInfo) {
        DynamicObject[] logs;
        QFilter filter = new QFilter("id", "in", salOrderLogIds);
        for (DynamicObject log : logs = BusinessDataServiceHelper.load((String)"sca_salorderstdcalclog", (String)"status,operationtype,trytimes,lastexecdate,execlog", (QFilter[])new QFilter[]{filter})) {
            log.set("status", (Object)status);
            log.set("operationtype", (Object)(isCalc != false ? "1" : "2"));
            if (!"01".equals(status)) {
                int time = log.getInt("trytimes");
                log.set("trytimes", (Object)(time + 1));
                log.set("lastexecdate", (Object)TimeServiceHelper.now());
            }
            log.set("execlog", (Object)errInfo);
        }
        SaveServiceHelper.update((DynamicObject[])logs);
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "billtypeupdate": {
                this.updateData();
            }
        }
        switch (operationKey = evt.getOperationKey()) {
            case "refresh": {
                StdCalculateHelper.updateDataStatus();
            }
        }
    }

    private void updateData() {
        QFilter filter = new QFilter("srcbill", "is null", null);
        filter.or(new QFilter("srcbill", "=", (Object)" "));
        Object[] logs = BusinessDataServiceHelper.load((String)"sca_salorderstdcalclog", (String)"salorderentryid,billtype", (QFilter[])new QFilter[]{filter}, null);
        if (CadEmptyUtils.isEmpty((Object[])logs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"SalOrderStdCalcLogListPlugin_24", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> billEntryIds = new ArrayList<Long>(10);
        for (Object log : logs) {
            long salOrderEntryId = log.getLong("salorderentryid");
            if (CadEmptyUtils.isEmpty((Long)salOrderEntryId)) continue;
            billEntryIds.add(salOrderEntryId);
        }
        filter = new QFilter("billentry.id", "in", billEntryIds);
        DynamicObjectCollection orders = QueryServiceHelper.query((String)"sm_salorder", (String)"billentry.id entryId,billtype", (QFilter[])new QFilter[]{filter});
        HashMap<Long, Long> entryIdBillTypeMap = new HashMap<Long, Long>(16);
        for (DynamicObject order : orders) {
            long entryId = order.getLong("entryId");
            if (CadEmptyUtils.isEmpty((Long)entryId)) continue;
            entryIdBillTypeMap.put(entryId, order.getLong("billtype"));
        }
        ArrayList<Object> updateDyos = new ArrayList<Object>(10);
        for (Object log : logs) {
            long salOrderEntryId = log.getLong("salorderentryid");
            if (!entryIdBillTypeMap.containsKey(salOrderEntryId)) continue;
            log.set("billtype", entryIdBillTypeMap.get(salOrderEntryId));
            updateDyos.add(log);
        }
        Lists.partition(updateDyos, (int)10000).forEach(list -> SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[0])));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"SalOrderStdCalcLogListPlugin_25", (String)"macc-sca-form", (Object[])new Object[0]));
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        if (evt.getFormatValue() == null || !evt.getFormatValue().toString().equals(ResManager.loadKDString((String)"\u8054\u67e5\u8ddf\u8e2a\u53f7\u6210\u672c\u81ea\u52a8\u5377\u7b97\u62a5\u544a", (String)"SalOrderStdCalcLogListPlugin_26", (String)"macc-sca-form", (Object[])new Object[0])) && !evt.getFormatValue().toString().equals(ResManager.loadKDString((String)"\u8054\u67e5\u66f4\u65b0\u62a5\u544a", (String)"SalOrderStdCalcLogListPlugin_27", (String)"macc-sca-form", (Object[])new Object[0]))) {
            evt.getNoLinkKey().add(((ColumnDesc)evt.getSource()).getKey());
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkVal = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        if (pkVal == null) {
            return;
        }
        QFilter filter = new QFilter("id", "=", pkVal);
        DynamicObject log = QueryServiceHelper.queryOne((String)"sca_salorderstdcalclog", (String)"execlog,updatelog,calctaskid,updatetaskid", (QFilter[])new QFilter[]{filter});
        if (log == null) {
            return;
        }
        long calcTaskId = log.getLong("calctaskid");
        long updateTaskId = log.getLong("updatetaskid");
        if (CadEmptyUtils.isEmpty((Long)calcTaskId) && CadEmptyUtils.isEmpty((Long)updateTaskId)) {
            return;
        }
        String execlog = log.getString("execlog");
        String updatelog = log.getString("updatelog");
        BillShowParameter formShowParameter = new BillShowParameter();
        if (ResManager.loadKDString((String)"\u8054\u67e5\u8ddf\u8e2a\u53f7\u6210\u672c\u81ea\u52a8\u5377\u7b97\u62a5\u544a", (String)"SalOrderStdCalcLogListPlugin_26", (String)"macc-sca-form", (Object[])new Object[0]).equals(execlog)) {
            formShowParameter.setFormId("cad_calctaskrecord");
            formShowParameter.setPkId((Object)calcTaskId);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7\u6210\u672c\u81ea\u52a8\u5377\u7b97\u62a5\u544a", (String)"SalOrderStdCalcLogListPlugin_28", (String)"macc-sca-form", (Object[])new Object[0]));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        } else if (ResManager.loadKDString((String)"\u8054\u67e5\u66f4\u65b0\u62a5\u544a", (String)"SalOrderStdCalcLogListPlugin_27", (String)"macc-sca-form", (Object[])new Object[0]).equals(updatelog)) {
            formShowParameter.setFormId("cad_calctaskrecord");
            formShowParameter.setPkId((Object)updateTaskId);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u66f4\u65b0\u62a5\u544a", (String)"SalOrderStdCalcLogListPlugin_29", (String)"macc-sca-form", (Object[])new Object[0]));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
        super.billListHyperLinkClick(args);
    }
}

