/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.calc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.formplugin.base.BaseManuorgListPlugin;

public class CalcReportListPlugin
extends BaseManuorgListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs = null;

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (acctOrgs.size() == 0) {
            return;
        }
        String orgId = this.getCurrOrgId(acctOrgs);
        List<ComboItem> manuorgs = this.getManuOrgComboItemsList(Long.valueOf(orgId));
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            if (CadEmptyUtils.isEmpty((List)acctOrgs)) break;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "accountorg.id": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(acctOrgs);
                    commonFilterColumn.setDefaultValue(orgId);
                    break;
                }
                case "manuorg.name": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(manuorgs);
                }
            }
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        String accountorgId = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            Map filter = (Map)customfilter.get(i);
            List listFieldName = (List)filter.get("FieldName");
            List listValue = (List)filter.get("Value");
            block9: for (int j = 0; j < listFieldName.size(); ++j) {
                String fieldName;
                switch (fieldName = (String)listFieldName.get(j)) {
                    case "accountorg.id": {
                        if (listValue == null || listValue.isEmpty()) {
                            return;
                        }
                        accountorgId = (String)listValue.get(j);
                        this.getPageCache().put("orgId", accountorgId);
                        this.filterContainerInit(this.filterContainerInitArgs);
                        continue block9;
                    }
                    case "manuorg.id": {
                        if (listValue == null || listValue.isEmpty()) {
                            this.getPageCache().put("manuorgId", "");
                            continue block9;
                        }
                        if (this.isInOrgManuOrg(this.getPageCache().get("orgId"), String.valueOf(listValue.get(j)))) {
                            this.getPageCache().put("manuorgId", (String)listValue.get(j));
                            continue block9;
                        }
                        this.getPageCache().put("manuorgId", "");
                        listValue.set(j, "");
                    }
                }
            }
        }
    }

    private boolean isInOrgManuOrg(String orgId, String manuorgId) {
        if (StringUtils.isNotEmpty((String)orgId) && StringUtils.isNotEmpty((String)manuorgId)) {
            List<ComboItem> manuorgs = this.getManuOrgComboItemsList(Long.valueOf(orgId));
            for (ComboItem item : manuorgs) {
                if (!item.getValue().equals(manuorgId)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<ComboItem> getManuOrgComboItemsList(Long orgId) {
        return ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
    }

    private String getCurrOrgId(List<ComboItem> acctOrgs) {
        String orgId = this.getPageCache().get("orgId");
        if (orgId == null || "".equals(orgId)) {
            Long currAcctOrg = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
            if (isAccounting) {
                orgId = currAcctOrg + "";
            } else {
                ComboItem comboItem = acctOrgs.get(0);
                orgId = comboItem.getValue();
            }
            this.getPageCache().put("orgId", orgId);
        }
        return orgId;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        if (qFilters != null && qFilters.size() > 0) {
            for (QFilter qFilter : qFilters) {
                DynamicObject costcenter;
                DynamicObject[] costcenters;
                String[] split;
                String value;
                if (!"1".equals(qFilter.getProperty()) || !"ftlike".equals(qFilter.getCP()) || (value = String.valueOf(qFilter.getValue())) == null || !value.contains("#") || (split = value.split("#")).length <= 1) continue;
                String oldCondotion = split[0].contains("billno") ? split[0].replace("billno", "") : split[0];
                String condition = split[1];
                qFilter.__setValue((Object)(oldCondotion + "#" + condition));
                QFilter nameQf = new QFilter("name", "ftlike", (Object)condition);
                if (condition != null && condition.contains(";")) {
                    String[] split1;
                    for (String string : split1 = condition.split(";")) {
                        nameQf.or(new QFilter("name", "ftlike", (Object)string));
                    }
                }
                if ((costcenters = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{nameQf})).length <= 0) continue;
                HashMap<String, ArrayList<Object>> mapNameToId = new HashMap<String, ArrayList<Object>>();
                Boolean muchSearch = false;
                if (condition != null && condition.contains(";")) {
                    String[] split1 = condition.split(";");
                    muchSearch = true;
                    for (String name2 : split1) {
                        DynamicObject[] dynamicObjectArray = costcenters;
                        int n = dynamicObjectArray.length;
                        for (int i = 0; i < n; ++i) {
                            costcenter = dynamicObjectArray[i];
                            String name1 = costcenter.getString("name");
                            if (!name1.contains(name2)) continue;
                            ArrayList<Object> idList = (ArrayList<Object>)mapNameToId.get(name2);
                            if (idList == null) {
                                idList = new ArrayList<Object>();
                                mapNameToId.put(name2, idList);
                            }
                            idList.add(costcenter.getPkValue());
                        }
                    }
                }
                Set collect = Arrays.stream(costcenters).map(o -> o.getPkValue()).collect(Collectors.toSet());
                QFilter qFilter2 = new QFilter("costcenter.fbasedataid", "in", collect);
                DynamicObject[] addData = BusinessDataServiceHelper.load((String)"sca_calcreport", (String)"id,costcenter", (QFilter[])new QFilter[]{qFilter2});
                List<Object> addId = new ArrayList();
                if (addData.length > 0 && muchSearch.booleanValue()) {
                    for (DynamicObject addDatum : addData) {
                        costcenter = addDatum.getDynamicObjectCollection("costcenter");
                        Boolean ismatch = false;
                        if (costcenter.size() <= 1) continue;
                        for (DynamicObject center : costcenter) {
                            Map.Entry stringListEntry;
                            Iterator iterator = mapNameToId.entrySet().iterator();
                            while (iterator.hasNext() && !(ismatch = Boolean.valueOf(((List)(stringListEntry = iterator.next()).getValue()).contains(((DynamicObject)center.get(1)).getPkValue()))).booleanValue()) {
                            }
                            if (ismatch.booleanValue()) continue;
                            break;
                        }
                        if (!ismatch.booleanValue()) continue;
                        addId.add(addDatum.getPkValue());
                    }
                } else {
                    addId = Arrays.stream(addData).map(o -> o.getPkValue()).collect(Collectors.toList());
                }
                qFilter.or(new QFilter("id", "in", addId));
            }
        }
    }

    @Override
    protected String getOrgFileName() {
        return "accountorg";
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String finishCalWizardsCheck = ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CalcReportListPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]);
        String wipCalWizardsCheck = ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CalcReportListPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]);
        String finishCalWizards = ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97", (String)"CalcReportListPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]);
        String wipCalWizards = ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97", (String)"CalcReportListPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]);
        BillShowParameter parameter = e.getParameter();
        Object pkId = parameter.getPkId();
        DynamicObject report = QueryServiceHelper.queryOne((String)"sca_calcreport", (String)"taskname", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        if (report == null) {
            return;
        }
        if (finishCalWizardsCheck.equals(report.getString("taskname"))) {
            parameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u62a5\u544a", (String)"CalcReportListPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), finishCalWizardsCheck));
        } else if (wipCalWizardsCheck.equals(report.getString("taskname"))) {
            parameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u62a5\u544a", (String)"CalcReportListPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), wipCalWizardsCheck));
        } else if (finishCalWizards.equals(report.getString("taskname"))) {
            parameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u62a5\u544a", (String)"CalcReportListPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), finishCalWizards));
        } else if (report.getString("taskname").startsWith(ResManager.loadKDString((String)"\u5b8c\u5de5", (String)"CalcReportListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0])) && !report.getString("taskname").endsWith(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CalcReportListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]))) {
            parameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u62a5\u544a", (String)"CalcReportListPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), finishCalWizards));
        } else if (report.getString("taskname").startsWith(ResManager.loadKDString((String)"\u671f\u672b", (String)"CalcReportListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0])) && !report.getString("taskname").endsWith(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CalcReportListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]))) {
            parameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u62a5\u544a", (String)"CalcReportListPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), wipCalWizards));
        } else {
            parameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"CalcReportListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }
}

