/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.calc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class CostConfirmListPlugin
extends BaseOrgAndCostAccountListPlugin {
    protected static final Log logger = LogFactory.getLog(CostConfirmListPlugin.class);
    private static final String OP_KEY_CONFIRM = "op_confirm";
    private static final String OP_KEY_UNCONFIRM = "op_unconfirm";
    private static final String TIP_CONFIRM_KEY = "tipconfirm";

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("period.number DESC, org.number ASC, costaccount.number ASC, costcenter.number ASC, costobject.billno ASC");
    }

    @Override
    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "op_confirm": {
                if ("true".equals(this.getPageCache().get(TIP_CONFIRM_KEY))) {
                    this.getPageCache().put(TIP_CONFIRM_KEY, "false");
                    break;
                }
                boolean needConfirm1 = this.confirmCheck(e);
                if (!needConfirm1) break;
                e.setCancel(true);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(OP_KEY_CONFIRM, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u6210\u672c\u786e\u8ba4\u540e\uff0c\u7cfb\u7edf\u5c06\u8bbe\u7f6e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e3a\u5df2\u7ed3\u7b97\u72b6\u6001\uff0c\u5e76\u751f\u6210\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u3002", (String)"CostConfirmListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                break;
            }
            case "op_unconfirm": {
                if ("true".equals(this.getPageCache().get(TIP_CONFIRM_KEY))) {
                    this.getPageCache().put(TIP_CONFIRM_KEY, "false");
                    break;
                }
                StringBuilder tipMsg = new StringBuilder();
                tipMsg.append(ResManager.loadKDString((String)"\u6210\u672c\u53cd\u786e\u8ba4\u540e\uff0c\u7cfb\u7edf\u5c06\u8bbe\u7f6e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e3a\u672a\u7ed3\u7b97\u72b6\u6001\uff0c\u5e76\u5220\u9664\u5173\u8054\u7684\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u3002", (String)"CostConfirmListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                boolean needConfirm2 = this.unconfirmCheck(e, tipMsg);
                if (!needConfirm2) break;
                e.setCancel(true);
                ConfirmCallBackListener unconfirmCallBacks = new ConfirmCallBackListener(OP_KEY_UNCONFIRM, (IFormPlugin)this);
                this.getView().showConfirm(tipMsg.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, unconfirmCallBacks);
            }
        }
    }

    private boolean confirmCheck(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection rows = e.getListSelectedData().getBillListSelectedRowCollection();
        if (rows == null || rows.isEmpty()) {
            return false;
        }
        Object[] ids = rows.getPrimaryKeyValues();
        QFilter idQF = new QFilter("id", "in", (Object)ids);
        QFilter bizStatusQF = new QFilter("bizstatus", "=", (Object)"A");
        boolean existNotConfirm = QueryServiceHelper.exists((String)"sca_costconfirm", (QFilter[])new QFilter[]{idQF, bizStatusQF});
        return existNotConfirm;
    }

    private boolean unconfirmCheck(BeforeDoOperationEventArgs e, StringBuilder tipMsg) {
        ListSelectedRowCollection rows = e.getListSelectedData().getBillListSelectedRowCollection();
        if (rows == null || rows.isEmpty()) {
            return false;
        }
        Object[] ids = rows.getPrimaryKeyValues();
        DataSet conconfirmDs = QueryServiceHelper.queryDataSet((String)"COSTCONFIRM", (String)"sca_costconfirm", (String)"costobject,period,costaccount,org", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, null);
        HashSet<Long> costObjectIds = new HashSet<Long>(10);
        HashSet<Long> periodIds = new HashSet<Long>(10);
        long periodId = 0L;
        long orgId = 0L;
        long costaccountId = 0L;
        for (Row confirm : conconfirmDs) {
            costObjectIds.add(confirm.getLong("costobject"));
            long dperiod = confirm.getLong("period");
            periodIds.add(dperiod);
            if (periodId == 0L || periodId > dperiod) {
                periodId = dperiod;
            }
            orgId = confirm.getLong("org");
            costaccountId = confirm.getLong("costaccount");
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("costobject", "in", costObjectIds), new QFilter("costaccount", "=", (Object)costaccountId), new QFilter("period", ">", (Object)periodId), new QFilter("bizstatus", "=", (Object)"B")};
        DataSet costConfirm = QueryServiceHelper.queryDataSet((String)"costconfirm", (String)"sca_costconfirm", (String)"id,costobject,costobject.name costobjectname,period.name periodname", (QFilter[])filters, null);
        if (!costConfirm.isEmpty()) {
            tipMsg.append(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5b58\u5728\u672a\u6765\u671f\u95f4\u7684\u6210\u672c\u786e\u8ba4\u5355\uff0c\u53cd\u786e\u8ba4\u5c06\u540c\u6b65\u5220\u9664\u672a\u6765\u671f\u95f4\u7684\u6210\u672c\u786e\u8ba4\u5355\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u3002", (String)"CostConfirmListPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
            return true;
        }
        QFilter[] qf = new QFilter[]{new QFilter("costobject", "in", costObjectIds)};
        DataSet finishdiffBills = QueryServiceHelper.queryDataSet((String)"FINISHDIFFBILL", (String)"sca_finishdiffbill", (String)"id,billno,vouchernum,period", (QFilter[])qf, null);
        if (finishdiffBills == null || finishdiffBills.isEmpty()) {
            return false;
        }
        for (Row bill : finishdiffBills) {
            String voucher = bill.getString("vouchernum");
            if (voucher != null && !"".equals(voucher) || !periodIds.contains(bill.getLong("period"))) continue;
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes) {
            switch (e.getCallBackId()) {
                case "op_confirm": {
                    this.getView().getPageCache().put(TIP_CONFIRM_KEY, "true");
                    this.getView().invokeOperation(OP_KEY_CONFIRM, OperateOption.create());
                    break;
                }
                case "op_unconfirm": {
                    this.getView().getPageCache().put(TIP_CONFIRM_KEY, "true");
                    this.getView().invokeOperation(OP_KEY_UNCONFIRM, OperateOption.create());
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        e.setCancel(true);
        ReportShowParameter rsp = new ReportShowParameter();
        rsp.setFormId("sca_calcdetailitemprt");
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Map<String, Object> param = this.getSelectedData();
        rsp.setCustomParams(param);
        rsp.setCustomParam("source", (Object)"HyperLink");
        this.getView().showForm((FormShowParameter)rsp);
    }

    private Map<String, Object> getSelectedData() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow listSelectedRow = billList.getCurrentSelectedRowInfo();
        Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
        String fields = "org,costaccount,currency,period,costcenter,costobject,bizstatus";
        DynamicObject costconfrim = QueryServiceHelper.queryOne((String)"sca_costconfirm", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        Map<String, Object> customFilterParam = this.getCustomFilterParam(costconfrim);
        return customFilterParam;
    }

    private Map<String, Object> getCustomFilterParam(DynamicObject costconfrim) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org", costconfrim.get("org"));
        map.put("costaccount", costconfrim.get("costaccount"));
        map.put("currency", costconfrim.get("currency"));
        map.put("period", costconfrim.get("period"));
        map.put("costcenter", costconfrim.get("costcenter"));
        map.put("costobject", costconfrim.get("costobject"));
        map.put("bizstatus", costconfrim.get("bizstatus"));
        map.put("fromCostConfirm", Boolean.TRUE);
        return map;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult result = e.getOperationResult();
        switch (e.getOperateKey()) {
            case "op_confirm": 
            case "op_unconfirm": {
                if (!result.isSuccess()) break;
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

