/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.calc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import kd.macc.sca.common.rpt.UnabSorbCalcParam;

public class FinishCalEndEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"checkresult", "btncalcrpt", "btncalcbill", "btncalcdetcomp", "btncalcdetsub", "btnunabsorbfee", "btncostconfirm"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String custparam = (String)this.getView().getFormShowParameter().getCustomParam("custparam");
        if (!CadEmptyUtils.isEmpty((String)custparam)) {
            CalcDataArgs calcDataArgs = (CalcDataArgs)SerializationUtils.fromJsonString((String)custparam, CalcDataArgs.class);
            Label labtime = (Label)this.getView().getControl("labtime");
            Label labTimeText = (Label)this.getView().getControl("labtimetext");
            long spendTimeOnSeconds = calcDataArgs.getTime();
            if (spendTimeOnSeconds >= 0L && spendTimeOnSeconds < 60L) {
                labtime.setText(String.valueOf(spendTimeOnSeconds));
                labTimeText.setText(ResManager.loadKDString((String)"\u79d2", (String)"FinishCalEndEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            } else {
                labtime.setText(String.valueOf(spendTimeOnSeconds / 60L));
                labTimeText.setText(ResManager.loadKDString((String)"\u5206\u949f", (String)"FinishCalEndEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
            }
            Label labcheckfail = (Label)this.getView().getControl("labcheckfail");
            labcheckfail.setText(String.valueOf(calcDataArgs.getCheckNoPassCount()));
            Label labcheckremaind = (Label)this.getView().getControl("labcheckremaind");
            labcheckremaind.setText(String.valueOf(calcDataArgs.getCheckRemaindCount()));
            if (!CadEmptyUtils.isEmpty((Long)calcDataArgs.getCheckNoPassCount()) && calcDataArgs.getCheckNoPassCount() > 0L || calcDataArgs.isCalcError()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap15"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelapfail"});
            }
            Label labsuccesscount = (Label)this.getView().getControl("labsuccesscount");
            labsuccesscount.setText(String.valueOf(calcDataArgs.getSuccessCcCount()));
            Label labsuccesscocount = (Label)this.getView().getControl("labsuccesscocount");
            labsuccesscocount.setText(String.valueOf(calcDataArgs.getSuccessCoCount()));
            this.countUnabsorbSuccess(calcDataArgs);
            int unAbsorbCcCount = calcDataArgs.getUnAbsorbCcCount();
            Label labsuccesscountabsorb = (Label)this.getView().getControl("labsuccesscountabsorb");
            labsuccesscountabsorb.setText(String.valueOf(unAbsorbCcCount));
            Long unAbsorbCoCount = calcDataArgs.getUnAbsorbCoCount();
            Label labsuccesscocountabsorb = (Label)this.getView().getControl("labsuccesscocountabsorb");
            labsuccesscocountabsorb.setText(String.valueOf(unAbsorbCoCount));
            if (CadEmptyUtils.isEmpty((Integer)unAbsorbCcCount) || CadEmptyUtils.isEmpty((Long)unAbsorbCoCount) || calcDataArgs.getCalcType() != 2) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap15"});
            }
            if (calcDataArgs.getCalcType() != 2) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnunabsorbfee"});
            }
            if (calcDataArgs.getCalcType() == 2) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btncostconfirm"});
            }
            this.getModel().setValue("org", calcDataArgs.getOrgId());
            this.getModel().setValue("period", calcDataArgs.getPeriodId());
            this.getModel().setValue("costaccount", calcDataArgs.getCostAcctId());
            this.setMulCostcenters(calcDataArgs.getCostCenterIds());
            this.getPageCache().put("checkResultId", String.valueOf(calcDataArgs.getCheckResultId()));
            this.getPageCache().put("calcReportId", String.valueOf(calcDataArgs.getCalcReportId()));
            this.getPageCache().put("calType", String.valueOf(calcDataArgs.getCalcType()));
        }
    }

    private void countUnabsorbSuccess(CalcDataArgs args) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        qfList.add(new QFilter("org", "=", args.getOrgId()));
        qfList.add(new QFilter("costaccount", "=", args.getCostAcctId()));
        qfList.add(new QFilter("period", "=", args.getPeriodId()));
        qfList.add(new QFilter("vouchernum", "=", (Object)" "));
        if (!CadEmptyUtils.isEmpty((Set)args.getCostObjects())) {
            qfList.add(new QFilter("costobject", "in", (Object)args.getCostObjects()));
        }
        if (!CadEmptyUtils.isEmpty((Set)args.getManuOrgIds())) {
            qfList.add(new QFilter("manuorg", "in", (Object)args.getManuOrgIds()));
        }
        if (!CadEmptyUtils.isEmpty((List)args.getCostCenterIds())) {
            qfList.add(new QFilter("costcenter", "in", (Object)args.getCostCenterIds()));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FinishCalEndEditPlugin.countUnabsorbSuccess", (String)"sca_unabsorbdiff", (String)"costcenter,costobject", (QFilter[])qfList.toArray(new QFilter[0]), null);
        GroupbyDataSet csGroupBy = dataSet.copy().select("costcenter").groupBy(new String[]{"costcenter"});
        args.setUnAbsorbCcCount(csGroupBy.finish().count("costcenter", true));
        GroupbyDataSet coGroupBy = dataSet.select("costobject").groupBy(new String[]{"costobject"});
        int coCount = coGroupBy.finish().count("costobject", true);
        args.setUnAbsorbCoCount(Long.valueOf(coCount));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("checkresult".equals(key)) {
            this.openCheckResultList();
        }
        if ("btncalcrpt".equals(key)) {
            this.openCalcReport();
            return;
        }
        if ("btncalcbill".equals(key)) {
            this.openCalcRpt("sca_calcresultrpt");
        }
        if ("btncalcdetcomp".equals(key)) {
            this.openCalcRpt("sca_calcallitemrpt");
        }
        if ("btncalcdetsub".equals(key)) {
            this.openCalcRpt("sca_calcdetailitemprt");
        }
        if ("btnunabsorbfee".equals(key)) {
            this.openCalcRpt("sca_unabsorbrptnew");
        }
        if ("btncostconfirm".equals(key)) {
            this.openCostConfirm();
            return;
        }
    }

    private void setMulCostcenters(List<Long> costcenterIds) {
        if (CadEmptyUtils.isEmpty(costcenterIds)) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_costcenter");
        Object[] costcenters = BusinessDataServiceHelper.load((Object[])costcenterIds.toArray(), (DynamicObjectType)mainEntityType);
        if (!CadEmptyUtils.isEmpty((Object[])costcenters)) {
            StringBuilder costcenterNames = new StringBuilder();
            for (Object costcenter : costcenters) {
                costcenterNames.append(costcenter.getString("name")).append("\uff1b");
            }
            Label labcostcenter = (Label)this.getView().getControl("labcostcenter");
            if (labcostcenter != null) {
                labcostcenter.setText(costcenterNames.toString());
            }
        }
    }

    private void openCheckResultList() {
        BillShowParameter lsp = new BillShowParameter();
        lsp.setFormId("sca_calcreport");
        String checkResultId = this.getPageCache().get("checkResultId");
        if (CadEmptyUtils.isEmpty((String)checkResultId)) {
            return;
        }
        lsp.setPkId((Object)checkResultId);
        lsp.setCaption(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"FinishCalEndEditPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openCalcReport() {
        String custparam = (String)this.getView().getFormShowParameter().getCustomParam("calcrecordid");
        BillShowParameter lsp = new BillShowParameter();
        lsp.setFormId("sca_calcreport");
        lsp.setCustomParam("calcrecordid", (Object)custparam);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openCostConfirm() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("sca_costconfirm");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("bos_list");
        ListFilterParameter filterParam = new ListFilterParameter();
        parameter.setListFilterParameter(filterParam);
        List filters = filterParam.getQFilters();
        String custparam = (String)this.getView().getFormShowParameter().getCustomParam("custparam");
        if (!CadEmptyUtils.isEmpty((String)custparam)) {
            CalcDataArgs calcDataArgs = (CalcDataArgs)SerializationUtils.fromJsonString((String)custparam, CalcDataArgs.class);
            parameter.getCustomParams().put("period", calcDataArgs.getPeriodId());
            parameter.getCustomParams().put("org", calcDataArgs.getOrgId());
            parameter.getCustomParams().put("costaccount", calcDataArgs.getCostAcctId());
            parameter.getCustomParams().put("bizstatus", "B");
            parameter.getCustomParams().put("manuorg", calcDataArgs.getManuOrgIds());
            if (calcDataArgs.getCostCenterIds() != null && calcDataArgs.getCostCenterIds().size() > 0) {
                filters.add(new QFilter("costcenter", "in", (Object)calcDataArgs.getCostCenterIds()));
            }
        } else {
            filters.add(new QFilter("1", "!=", (Object)1));
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openCalcRpt(String rptName) {
        Boolean isHasPermission = Boolean.FALSE;
        List orgPermission = PermissionHelper.getUserPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)rptName, (String)"47150e89000000ac");
        if (orgPermission == null) {
            isHasPermission = Boolean.FALSE;
        } else if (orgPermission.size() == 0 || !orgPermission.contains(RequestContext.get().getOrgId())) {
            isHasPermission = Boolean.TRUE;
        }
        if (isHasPermission.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u62a5\u8868\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"FinishCalEndEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId(rptName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        String custparam = (String)this.getView().getFormShowParameter().getCustomParam("custparam");
        if (!CadEmptyUtils.isEmpty((String)custparam)) {
            CalcDataArgs calcDataArgs = (CalcDataArgs)SerializationUtils.fromJsonString((String)custparam, CalcDataArgs.class);
            filterInfo.addFilterItem("org", calcDataArgs.getOrgId(), "=");
            filterInfo.addFilterItem("manuorg", (Object)calcDataArgs.getManuOrgIds(), "=");
            filterInfo.addFilterItem("costaccount", calcDataArgs.getCostAcctId(), "=");
            filterInfo.addFilterItem("period", calcDataArgs.getPeriodId(), "=");
            filterInfo.addFilterItem("fperiod", calcDataArgs.getPeriodId(), "=");
            filterInfo.addFilterItem("materialgrpstd", (Object)730148448254487552L, "=");
            if (!CadEmptyUtils.isEmpty((List)calcDataArgs.getCostCenterIds())) {
                filterInfo.addFilterItem("costcenter", (Object)calcDataArgs.getCostCenterIds(), "in");
                filterInfo.addFilterItem("fcostcenter", (Object)calcDataArgs.getCostCenterIds(), "in");
            }
            filterInfo.addFilterItem("currency", calcDataArgs.getCurrencyId(), "=");
            String bizstatusField = "bizstatus";
            if ("sca_calcresultrpt".equals(rptName)) {
                bizstatusField = "fbizstatus";
            }
            if (calcDataArgs.getCalcType() == 2) {
                filterInfo.addFilterItem(bizstatusField, (Object)"ALL", "=");
            } else {
                filterInfo.addFilterItem(bizstatusField, (Object)"B", "=");
            }
            if ("sca_unabsorbrptnew".equals(rptName)) {
                UnabSorbCalcParam unabSorbCalcParam = new UnabSorbCalcParam();
                if (calcDataArgs.getOrgId() != null) {
                    unabSorbCalcParam.setOrgId(Long.valueOf(calcDataArgs.getOrgId().toString()));
                }
                if (calcDataArgs.getCostAcctId() != null) {
                    unabSorbCalcParam.setCostAccountId(Long.valueOf(calcDataArgs.getCostAcctId().toString()));
                }
                unabSorbCalcParam.setManuOrgIds(new ArrayList(calcDataArgs.getManuOrgIds()));
                if (calcDataArgs.getPeriodId() != null) {
                    unabSorbCalcParam.setPeriodIds((List)Lists.newArrayList((Object[])new Long[]{Long.valueOf(calcDataArgs.getPeriodId().toString())}));
                }
                unabSorbCalcParam.setCostCenterIds(calcDataArgs.getCostCenterIds());
                if (calcDataArgs.getCurrencyId() != null) {
                    unabSorbCalcParam.setCurrencyId(Long.valueOf(calcDataArgs.getCurrencyId().toString()));
                }
                showParameter.setCustomParam(UnabSorbCalcParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)unabSorbCalcParam));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            } else {
                showParameter.setQueryParam(queryParam);
            }
        }
        showParameter.setCustomParam("source", (Object)"HyperLink");
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

