/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.calc;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Constructor;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.sca.algox.task.TaskRunning;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class TaskRunningEditPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(TaskRunningEditPlugin.class);
    private static final String CHECKTASK_CLASS = "kd.macc.sca.algox.task.CheckTask";
    private static final String CALC_PROGRESSBAR = "progressbarap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(CALC_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        try {
            String runningParaJS = this.getView().getFormShowParameter().getCustomParam("calcParam").toString();
            String taskConfigId = this.getView().getFormShowParameter().getCustomParam("taskConfigId").toString();
            this.start(runningParaJS, taskConfigId);
            String taskReocrdId = this.getPageCache().get("taskRecordId");
            DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(taskReocrdId), (String)"sca_taskrecord");
            this.buildRunningParam(taskRecord);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw ex;
        }
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        String taskReocrdId = this.getPageCache().get("taskRecordId");
        DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(taskReocrdId), (String)"sca_taskrecord", (String)"id,taskname,progress,status,nextpage,nextpagepara,entryentity.subname,entryentity.substarttime,entryentity.subtime,entryentity.substatus");
        paramProgressEvent.setProgress(taskRecord.getInt("progress"));
        this.buildRunningParam(taskRecord);
        int progress = taskRecord.getInt("progress");
        if ("3".equals(taskRecord.getString("status")) || "4".equals(taskRecord.getString("status")) || progress >= 100) {
            this.getView().close();
            this.nextpage(taskRecord);
        }
    }

    private void start(String runningParaJS, String taskConfigId) {
        try {
            String classpath;
            logger.error("TaskRunning_start");
            String taskRecordId = this.getView().getFormShowParameter().getCustomParam("taskRecordId").toString();
            String taskParam = this.getView().getFormShowParameter().getCustomParam("calcParam").toString();
            Object calcReportId = this.getView().getFormShowParameter().getCustomParam("calcReportId");
            Object checkReportId = this.getView().getFormShowParameter().getCustomParam("checkReportId");
            this.getPageCache().put("taskRecordId", taskRecordId);
            this.getPageCache().put("taskConfigId", taskConfigId);
            if (calcReportId != null) {
                this.getPageCache().put("calcReportId", calcReportId.toString());
            }
            if (checkReportId != null) {
                this.getPageCache().put("checkReportId", checkReportId.toString());
            }
            JSONObject taskParamJs = JSONObject.fromObject((Object)taskParam);
            taskParamJs.accumulate("taskRecordId", (Object)taskRecordId);
            taskParamJs.accumulate("calcReportId", calcReportId);
            taskParamJs.accumulate("checkReportId", checkReportId);
            taskParamJs.accumulate("appNum", (Object)this.getView().getFormShowParameter().getAppId());
            ProgressBar progressBar = (ProgressBar)this.getView().getControl(CALC_PROGRESSBAR);
            progressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c ...", (String)"TaskRunningEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            progressBar.start();
            QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(taskConfigId));
            DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((String)"sca_taskconfig", (String)"class", (QFilter[])new QFilter[]{filter});
            String string = classpath = taskConfig == null ? CHECKTASK_CLASS : taskConfig.getString("class");
            if (CadEmptyUtils.isEmpty((String)classpath)) {
                logger.error("TaskRunning_classpath is empty");
                return;
            }
            logger.error("TaskRunning_classpath_" + classpath);
            Class<?> doClass = Class.forName(classpath);
            Constructor<?> con = doClass.getDeclaredConstructor(String.class);
            TaskRunning taskRunning = (TaskRunning)con.newInstance(taskParamJs.toString());
            taskRunning.setRC(RequestContext.get());
            ThreadHelper.execute((Runnable)taskRunning, (TaskType)TaskType.SCA_CALC_PROCESS);
        }
        catch (Exception e) {
            logger.error("TaskRunning_" + e.getMessage());
            logger.error((Throwable)e);
            this.getView().close();
        }
    }

    private void buildRunningParam(DynamicObject taskRecord) {
        String taskname = taskRecord.getString("taskname");
        int doneStep = 0;
        String doingStep = ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"TaskRunningEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]);
        DynamicObjectCollection taskRecordEntrys = taskRecord.getDynamicObjectCollection("entryentity");
        JSONArray taskDetailInfos = new JSONArray();
        for (DynamicObject entry : taskRecordEntrys) {
            JSONObject taskDetailInfo = new JSONObject();
            taskDetailInfo.accumulate("status", entry.get("substatus"));
            taskDetailInfo.accumulate("name", entry.get("subname"));
            if ("3".equals(entry.getString("substatus")) || "4".equals(entry.getString("substatus"))) {
                ++doneStep;
            }
            if ("2".equals(entry.getString("substatus"))) {
                doingStep = entry.getString("subname");
                break;
            }
            taskDetailInfos.add((Object)taskDetailInfo);
        }
        CustomControl taskRunningUI = (CustomControl)this.getView().getControl("tasksteps");
        JSONObject taskRunningUIPara = new JSONObject();
        taskRunningUIPara.accumulate("doneStep", doneStep);
        taskRunningUIPara.accumulate("totalStep", taskRecordEntrys.size());
        taskRunningUIPara.accumulate("doingStep", (Object)doingStep);
        taskRunningUIPara.accumulate("taskname", (Object)taskname);
        taskRunningUIPara.accumulate("taskDetailInfos", (Object)taskDetailInfos.toString());
        taskRunningUI.setData((Object)taskRunningUIPara.toString());
        String nextpagepara = taskRecord.getString("nextpagepara");
        String batch = "";
        if (!StringUtils.isEmpty((String)nextpagepara)) {
            try {
                com.alibaba.fastjson.JSONObject json = JSON.parseObject((String)nextpagepara);
                if (json.containsKey((Object)"totalBat")) {
                    int totalBat = json.getIntValue("totalBat");
                    int currBat = json.getIntValue("currBat");
                    batch = String.format("%s/%s%s ", currBat, totalBat, ResManager.loadKDString((String)"\u6279", (String)"TaskRunningEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                }
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
        Label currstep = (Label)this.getView().getControl("currsteplab");
        currstep.setText((StringUtils.isEmpty((String)batch) ? doneStep + "/" + taskRecordEntrys.size() : "") + doingStep);
    }

    private void nextpage(DynamicObject taskRecord) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)taskRecord.getString("nextpage"));
        Object lsp = null;
        lsp = mainEntityType instanceof BillEntityType ? new BillShowParameter() : new FormShowParameter();
        String nextpagePara = taskRecord.getString("nextpagepara");
        CalcDataArgs calcDataArgs = null;
        if (StringUtils.isNotEmpty((String)nextpagePara)) {
            calcDataArgs = (CalcDataArgs)SerializationUtils.fromJsonString((String)nextpagePara, CalcDataArgs.class);
            lsp.setCaption(String.format(ResManager.loadKDString((String)"%s\u62a5\u544a", (String)"TaskRunningEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]), calcDataArgs.getFinishPageTitle()));
        } else {
            lsp.setCaption(taskRecord.getString("taskname"));
        }
        String calcRecordId = this.getPageCache().get("calcReportId");
        String checkReportId = this.getPageCache().get("checkReportId");
        lsp.setFormId(taskRecord.getString("nextpage"));
        lsp.setCustomParam("custparam", (Object)nextpagePara);
        lsp.setCustomParam("calcrecordid", (Object)calcRecordId);
        if (calcRecordId == null) {
            lsp.setPkId((Object)checkReportId);
        }
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }
}

