/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.calc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CadUserDataRecordHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.constants.WipCalcCheck;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CheckHelper;
import kd.macc.sca.algox.utils.FinishCalcHelper;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.algox.wip.CalcMutexHelper;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import kd.macc.sca.common.enums.ScaCheckerWayEnum;
import net.sf.json.JSONObject;

public class WipCalWizards
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(WipCalWizards.class);
    private static final String CALC_PERM = "4730fc9f000025ae";

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit accountOrg = (BasedataEdit)this.getControl("org");
        accountOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            filterParameter.getQFilters().add(new QFilter("id", "in", (Object)OrgHelper.getHasPermAccountOrgIdsByPermItem((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId(), (String)CALC_PERM)));
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCalWizards_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            filters.add(StartCostHelper.getEnableEndInitQfilterByOrg((Long)((Long)org.getPkValue()), (String)AppIdHelper.getCurAppNum((IFormView)this.getView())));
        });
        BasedataEdit center = (BasedataEdit)this.getControl("costcenter");
        center.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("orgduty.number", "=", (Object)"4"));
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                ArrayList<Long> manuOrgList = new ArrayList<Long>(this.getManuorgSet());
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)org.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                qList.add(costCenterIdFilter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCalWizards_1", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            List manuIdList = Lists.newArrayList();
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCalWizards_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            manuIdList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)CALC_PERM, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            qList.add(new QFilter("id", "in", (Object)manuIdList));
        });
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "check": {
                this.isHasPermission(evt, "0K6+MBJCKDS2");
                break;
            }
            case "startcalc": {
                this.isHasPermission(evt, CALC_PERM);
            }
        }
    }

    private Set<Long> getManuorgSet() {
        HashSet<Long> manuorgSet = new HashSet<Long>(16);
        DynamicObjectCollection manuorgs = this.getModel().getDataEntity().getDynamicObjectCollection("manuorg");
        if (manuorgs == null) {
            return manuorgSet;
        }
        for (DynamicObject row : manuorgs) {
            DynamicObject manuOrgDyn = row.getDynamicObject("fbasedataid");
            manuorgSet.add(manuOrgDyn.getLong("masterid"));
        }
        return manuorgSet;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "check": {
                this.doCheck();
                break;
            }
            case "startcalc": {
                this.calculate();
            }
        }
    }

    private void calculate() {
        if (!this.calcParamVilidator()) {
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        String orgName = org.getLocaleString("name").getLocaleValue();
        DynamicObject acct = this.getModel().getDataEntity().getDynamicObject("costaccount");
        String costAccName = acct.getLocaleString("name").getLocaleValue();
        String costTypeId = CalcMutexHelper.getCostTypeIdBy((Object)acct.getPkValue());
        Long acctId = acct != null ? acct.getLong("id") : 0L;
        Set<Long> manuorgSet = this.getManuorgSet();
        if (!CadEmptyUtils.isEmpty(manuorgSet)) {
            for (Long manuOrgId : manuorgSet) {
                if (!CostCloseAccountHelper.checkIsCloseAccount((Long)org.getLong("id"), (Long)manuOrgId, (Long)acctId, (Long)this.getModel().getDataEntity().getDynamicObject("period").getLong("id"))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u3002", (String)"WipCalWizards_2", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
        }
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)acctId);
        try {
            String lockErrStr = CalcMutexHelper.checkMutexAndLock((String)"pdend", (boolean)enableMulFactory, (Long)acctId, manuorgSet);
            if (StringUtils.isNotEmpty((String)lockErrStr)) {
                String costaccountTip = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f", (String)"WipCalWizards_15", (String)"macc-sca-form", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(lockErrStr, lockErrStr.contains(costaccountTip) ? costAccName : orgName));
                return;
            }
            CalcDataArgs args = this.wrapCalcArgs();
            args.setCostTypeId((Object)costTypeId);
            String calcParam = SerializationUtils.toJsonString((Object)args);
            TaskHelper.startTask((IFormView)this.getView(), (IDataModel)this.getModel(), (Long)TaskHelper.PDEND_TASKID, (String)calcParam, (String)"1");
        }
        catch (Exception e) {
            CalcMutexHelper.releaseMuteFromSet((String)"pdend", (boolean)enableMulFactory, (Long)acctId, manuorgSet);
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private CalcDataArgs wrapCalcArgs() {
        CalcDataArgs args = new CalcDataArgs();
        args.setTime(System.currentTimeMillis());
        DynamicObject item = this.getModel().getDataEntity();
        args.setOrgId(Optional.ofNullable(item.getDynamicObject("org")).map(DataEntityBase::getPkValue).orElseGet(() -> 0L));
        args.setCostAcctId(Optional.ofNullable(item.getDynamicObject("costaccount")).map(DataEntityBase::getPkValue).orElseGet(() -> 0L));
        args.setCurrencyId(Optional.ofNullable(item.getDynamicObject("currency")).map(DataEntityBase::getPkValue).orElseGet(() -> 0L));
        DynamicObject period = item.getDynamicObject("period");
        if (period != null) {
            args.setPeriodId(period.getPkValue());
            args.setStartDate(period.getDate("begindate"));
            args.setEndDate(period.getDate("enddate"));
        }
        ArrayList ccList = new ArrayList(10);
        DynamicObjectCollection ccs = item.getDynamicObjectCollection("costcenter");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)ccs)) {
            ccs.forEach(s -> ccList.add(Long.valueOf(String.valueOf(((DynamicObject)s.get(1)).getPkValue()))));
        }
        args.getCostCenterIds().addAll(ccList);
        Set<Long> manuorgSet = this.getManuorgSet();
        args.setManuOrgIds(manuorgSet.isEmpty() ? null : manuorgSet);
        HashMap ccAndcoInfos = Maps.newHashMapWithExpectedSize((int)10);
        args.setCostObjects(this.getCostObjectId(ccAndcoInfos));
        args.setCcAndCoInfos((Map)ccAndcoInfos);
        args.setCalcVersion((String)this.getModel().getValue("calcversion"));
        args.setMatCalType("1");
        args.setMfgCalType("2");
        return args;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean viewcalcrange = this.getModel().getDataEntity().getBoolean("viewcalcrange");
        this.getView().setVisible(Boolean.valueOf(viewcalcrange), new String[]{"advconap1"});
        this.initOrg();
        this.initCalpolicy();
        this.setCurrency();
        this.setPeriod();
        this.getView().updateView("costcenter");
        this.setManuorg();
        this.getView().updateView("manuorg");
        this.updateEntry();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "org": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) {
                    this.setCostaccount(org.getLong("id"));
                }
                this.setCostCenterByOrg();
                this.setPeriod();
                this.initCalpolicy();
                this.setManuorg();
                this.updateEntry();
                break;
            }
            case "costaccount": {
                this.setOrgByCostAccount();
                this.setCurrency();
                this.setPeriod();
                this.updateEntry();
                break;
            }
            case "costcenter": {
                if (this.isOverMaxNum(e)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u591a\u9009\u6846\u4e0d\u80fd\u9009\u62e9\u8d85\u8fc730\u4e2a\u3002", (String)"WipCalWizards_3", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
                this.setOrgByCostCenter();
                this.updateEntry();
                break;
            }
            case "manuorg": {
                this.updateEntry();
                break;
            }
            case "viewcalcrange": {
                boolean viewcalcrange = this.getModel().getDataEntity().getBoolean("viewcalcrange");
                this.getView().setVisible(Boolean.valueOf(viewcalcrange), new String[]{"advconap1"});
                this.updateEntry();
            }
        }
    }

    private void initCalpolicy() {
        DynamicObject dyo = (DynamicObject)this.getModel().getValue("org");
        if (dyo != null) {
            BasedataEdit manuorgEdit = (BasedataEdit)this.getControl("manuorg");
            if (OrgHelper.isOrgEnableMultiFactory((Long)dyo.getLong("id"))) {
                manuorgEdit.setMustInput(true);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
            } else {
                manuorgEdit.setMustInput(false);
                this.getModel().setValue("manuorg", null);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
            }
        }
    }

    private boolean isOverMaxNum(PropertyChangedArgs e) {
        DynamicObjectCollection dyColl;
        if (e.getChangeSet() != null && e.getChangeSet()[0] != null && (dyColl = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue()) != null && dyColl.size() > 30) {
            this.getView().getModel().setValue(e.getProperty().getName(), e.getChangeSet()[0].getOldValue());
            return true;
        }
        return false;
    }

    private void initOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        Long currAcctOrg = RequestContext.get().getOrgId();
        boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
        if (isAccounting) {
            this.getModel().setValue("org", (Object)currAcctOrg);
            this.getView().updateView("org");
            this.setCostaccount(currAcctOrg);
        }
    }

    private List<Long> getCostCenterIds(DynamicObjectCollection costcenters) {
        ArrayList<Long> costCenterIds = new ArrayList<Long>();
        for (DynamicObject row : costcenters) {
            DynamicObject costcenter = row.getDynamicObject("fbasedataid");
            costCenterIds.add(costcenter.getLong("masterid"));
        }
        return costCenterIds;
    }

    private void saveUserSetting() {
        try {
            QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())};
            DynamicObject idInfo = QueryServiceHelper.queryOne((String)"cad_userdatarecord", (String)"id", (QFilter[])filters);
            Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
            DynamicObjectCollection costcenters = (DynamicObjectCollection)this.getModel().getValue("costcenter");
            List<Long> costCenterIds = this.getCostCenterIds(costcenters);
            Set<Long> manuorgSet = this.getManuorgSet();
            Map saveMap = CadUserDataRecordHelper.toMap((Long)orgId, costCenterIds, new ArrayList<Long>(manuorgSet));
            String saveJson = CadUserDataRecordHelper.toJSONString((Map)saveMap);
            if (idInfo == null) {
                DynamicObject userDataRecord = BusinessDataServiceHelper.newDynamicObject((String)"cad_userdatarecord");
                userDataRecord.set("modifytime", (Object)new Date());
                userDataRecord.set("user", (Object)RequestContext.get().getUserId());
                userDataRecord.set("conditionforend", (Object)saveJson);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userDataRecord});
                return;
            }
            DynamicObject userDataRecord = BusinessDataServiceHelper.loadSingle((Object)idInfo.getLong("id"), (String)"cad_userdatarecord");
            userDataRecord.set("conditionforend", (Object)saveJson);
            SaveServiceHelper.update((DynamicObject)userDataRecord);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237\u6570\u636e\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\u3002", (Throwable)e);
        }
    }

    private void doCheck() {
        if (!this.checkParamVilidator()) {
            return;
        }
        String checkParam = this.buildCheckParam(ScaCheckerWayEnum.CHECKERWAY_ONlY);
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("cad_checktasksetting");
        lsp.setCustomParam("checkParam", (Object)checkParam);
        lsp.setCustomParam("checktype", (Object)1);
        lsp.setCustomParam("calcParam", (Object)checkParam);
        lsp.setCustomParam("calType", (Object)"sca_wipcalwizards");
        lsp.setCaption(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"WipCalWizards_4", (String)"macc-sca-form", (Object[])new Object[0]));
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setShowTitle(false);
        this.getView().showForm(lsp);
    }

    private boolean checkParamVilidator() {
        String operName = ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u5931\u8d25\u3002", (String)"WipCalWizards_5", (String)"macc-sca-form", (Object[])new Object[0]);
        return this.conditionVilidator(operName);
    }

    private boolean calcParamVilidator() {
        String operName = ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25", (String)"WipCalWizards_6", (String)"macc-sca-form", (Object[])new Object[0]);
        return this.conditionVilidator(operName);
    }

    private boolean conditionVilidator(String operName) {
        QFilter costaccountQF;
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"WipCalWizards_7", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"WipCalWizards_8", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        DynamicObject costaccountDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccount.getLong("id"), (String)"cal_bd_costaccount");
        if (costaccountDyn == null || !costaccountDyn.getBoolean("enable")) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u8d26\u7c3f\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WipCalWizards_14", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        boolean isInit = StartCostHelper.isInit((Long)((Long)costAccount.getPkValue()), (String)this.getView().getFormShowParameter().getAppId());
        if (!isInit) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"WipCalWizards_9", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        DynamicObject period = this.getModel().getDataEntity().getDynamicObject("period");
        if (period == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u6838\u7b97\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"WipCalWizards_10", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        QFilter orgQF = new QFilter("org", "=", (Object)org.getLong("id"));
        DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id, entry.currentperiod currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF = new QFilter("entry.costaccount", "=", (Object)costAccount.getLong("id"))});
        if (sysCtrlEntity != null && sysCtrlEntity.getLong("currentperiod") != period.getLong("id")) {
            this.getModel().setValue("period", (Object)sysCtrlEntity.getLong("currentperiod"));
            this.updateEntry();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u671f\u95f4\u201d\u975e\u201c\u6210\u672c\u8d26\u8584\u201d\u7684\u5f53\u524d\u671f\u95f4\uff0c\u5237\u65b0\u6210\u5f53\u671f\u671f\u95f4\u5e76\u786e\u8ba4\u8ba1\u7b97\u8303\u56f4\u540e\u518d\u70b9\u51fb\u8ba1\u7b97\u3002", (String)"WipCalWizards_13", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void loadUserSetting() {
        Map map;
        String userId = RequestContext.get().getUserId();
        QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)Long.valueOf(userId))};
        DynamicObject userDataRecord = QueryServiceHelper.queryOne((String)"cad_userdatarecord", (String)"conditionforend", (QFilter[])filters);
        if (userDataRecord == null) {
            return;
        }
        String josnStr = userDataRecord.getString("conditionforend");
        if (StringUtils.isNotEmpty((String)josnStr) && (map = CadUserDataRecordHelper.fromJSONString((String)josnStr)).get("orgId") != null) {
            List ids;
            Long orgId = (Long)map.get("orgId");
            DynamicObject orgDyo = (DynamicObject)this.getModel().getValue("org");
            if (orgDyo != null && orgDyo.getLong("id") == orgId.longValue() && map.get("costCenterIds") != null && (ids = (List)map.get("costCenterIds")).size() > 0) {
                this.getModel().setValue("costcenter", (Object)ids.toArray());
            }
        }
    }

    private void setCurrency() {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costaccount == null) {
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod() {
        QFilter qfCostAccount;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        QFilter qfOrg = new QFilter("org", "=", (Object)org.getLong("id"));
        DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costaccount.getLong("id"))});
        if (sysCtrlEntity != null) {
            this.getModel().setValue("period", (Object)sysCtrlEntity.getLong("currentperiod"));
            this.getView().updateView("period");
        }
    }

    private void setCostaccount(long orgId) {
        Long costAccountId = this.getCostAccountByAccoutOrg(orgId);
        if (!CadEmptyUtils.isEmpty((Long)costAccountId)) {
            this.getModel().setValue("costaccount", (Object)costAccountId);
            this.getView().updateView("costaccount");
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
            this.getModel().setValue("currency", null);
            this.getView().updateView("costaccount");
            this.getView().updateView("period");
            this.getView().updateView("currency");
        }
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter calorg = new QFilter("org", "=", (Object)accountOrgId);
        QFilter appnum = new QFilter("appnum", "=", (Object)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        QFilter isStartStdCostFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        isStartStdCostFilter.and("entryentity.isinit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection cal_bd_costaccounts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{calorg, isStartStdCostFilter, appnum});
        Long costaccountId = null;
        if (cal_bd_costaccounts.size() == 1) {
            costaccountId = ((DynamicObject)cal_bd_costaccounts.get(0)).getLong("costaccount");
        } else if (cal_bd_costaccounts.size() > 1) {
            for (DynamicObject cal_bd_costaccount : cal_bd_costaccounts) {
                if (!cal_bd_costaccount.getBoolean("ismainaccount")) continue;
                costaccountId = cal_bd_costaccount.getLong("costaccount");
                break;
            }
        }
        return costaccountId;
    }

    private void setOrgByCostAccount() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        DynamicObject account = (DynamicObject)this.getModel().getValue("costaccount");
        if (account == null) {
            return;
        }
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)account.getPkValue(), (String)"cal_bd_costaccount");
        this.getModel().setValue("org", costAccount != null ? Long.valueOf(costAccount.getLong("calorg.id")) : null);
    }

    private void setOrgByCostCenter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        DynamicObjectCollection costCenter = (DynamicObjectCollection)this.getModel().getValue("costcenter");
        if (costCenter.size() == 0) {
            return;
        }
        DynamicObject firstCenter = ((DynamicObject)costCenter.get(0)).getDynamicObject("fbasedataid");
        DynamicObject center = BusinessDataServiceHelper.loadSingle((Object)firstCenter.getLong("masterid"), (String)"bos_costcenter");
        this.getModel().setValue("org", center != null ? Long.valueOf(center.getLong("accountorg.id")) : null);
    }

    private void setCostCenterByOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        DynamicObjectCollection center = (DynamicObjectCollection)this.getModel().getValue("costcenter");
        if (center.size() == 0) {
            return;
        }
        HashSet costCenterIds = new HashSet();
        DynamicObjectCollection costCenter = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{new QFilter("accountorg", "=", org.getPkValue())});
        costCenter.forEach(p -> costCenterIds.add(p.getLong("id")));
        for (DynamicObject cen : center) {
            if (costCenterIds.contains(cen.getDynamicObject("fbasedataid").getLong("masterid"))) continue;
            this.getModel().setValue("costcenter", null);
            break;
        }
        this.getModel().setValue("manuorg", null);
    }

    private CalcDataArgs getCalcDataArgs() {
        DynamicObject period;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return null;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null || costAccount.getLong("id") <= 0L) {
            return null;
        }
        DynamicObjectCollection costCenter = (DynamicObjectCollection)this.getModel().getValue("costcenter");
        ArrayList costCenterIds = Lists.newArrayList();
        if (costCenter.size() > 0) {
            costCenter.forEach(p -> costCenterIds.add(Long.valueOf(p.getDynamicObject("fbasedataid").getPkValue().toString())));
        }
        if ((period = (DynamicObject)this.getModel().getValue("period")) == null) {
            return null;
        }
        CalcDataArgs args = new CalcDataArgs();
        args.setOrgId(org.get("id"));
        args.setCostAcctId(costAccount.getPkValue());
        args.setCostAccountId(costAccount.getPkValue());
        args.setCostCenterIds((List)costCenterIds);
        Set<Long> manuorgSet = this.getManuorgSet();
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        if (enableMulFactory && CadEmptyUtils.isEmpty(this.getManuorgSet())) {
            return null;
        }
        args.setManuOrgIds(manuorgSet.isEmpty() ? null : manuorgSet);
        args.setPeriodId(period.get("id"));
        return args;
    }

    private DataSet getData(boolean isView) {
        CalcDataArgs args = this.getCalcDataArgs();
        if (args == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        Set costobjectIds = FinishCalcHelper.getWipCostObject((CalcDataArgs)args);
        ArrayList costObjectListIds = new ArrayList(costobjectIds);
        logger.info("\u671f\u672b\u8ba1\u7b97-\u5c55\u793a\u671f\u672b\u8303\u56f4\u6570\u636e\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)args.getPeriodId(), (String)"bd_period");
        if (CadEmptyUtils.isEmpty((DynamicObject)period)) {
            return null;
        }
        QFilter coFilter = new QFilter("org", "=", args.getOrgId());
        coFilter.and("billstatus", "=", (Object)"C");
        DataSet csDataSet = InFilterHelper.queryDataSetIn((String)"cad_costobject", (String)"org,costcenter,id costobject,material,auxpty", (QFilter)coFilter, (String)"id", costObjectListIds);
        if (!isView) {
            return csDataSet;
        }
        QFilter planFilter = new QFilter("accountorg", "=", args.getOrgId());
        planFilter.and("billstatus", "=", (Object)"C");
        planFilter.and("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        planFilter.and("bizdate", "<=", (Object)period.getDate("enddate"));
        DataSet plannedDataSet = InFilterHelper.queryDataSetIn((String)"cad_plannedoutputbill", (String)"costobject,baseunit,qty", (QFilter)planFilter, (String)"costobject", costObjectListIds);
        plannedDataSet = plannedDataSet.groupBy(new String[]{"costobject"}).max("baseunit").sum("qty").finish();
        csDataSet = csDataSet.leftJoin(plannedDataSet).on("costobject", "costobject").select(new String[]{"org", "costcenter", "costobject", "material", "auxpty"}, new String[]{"baseunit", "qty"}).finish();
        QFilter factFilter = new QFilter("org", "=", args.getOrgId());
        factFilter.and("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        factFilter.and("billstatus", "=", (Object)"C");
        factFilter.and("bookdate", "<=", (Object)period.getDate("enddate"));
        DataSet factnedDataSet = InFilterHelper.queryDataSetIn((String)"cad_factnedoutputbill", (String)"entryentity.costobject costobject,entryentity.qty completeqty", (QFilter)factFilter, (String)"entryentity.costobject", costObjectListIds);
        factnedDataSet = factnedDataSet.groupBy(new String[]{"costobject"}).sum("completeqty").finish();
        csDataSet = csDataSet.leftJoin(factnedDataSet).on("costobject", "costobject").select(new String[]{"org", "costcenter", "costobject", "material", "auxpty", "baseunit", "qty"}, new String[]{"completeqty"}).finish();
        logger.info("\u671f\u672b\u8ba1\u7b97-\u83b7\u53d6\u671f\u672b\u8303\u56f4\u5bf9\u5e94\u7684\u8ba1\u5212\u548c\u5b8c\u5de5\u6570\u91cf\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return csDataSet;
    }

    private void updateEntry() {
        this.getModel().deleteEntryData("entryentity");
        boolean viewcalcrange = this.getModel().getDataEntity().getBoolean("viewcalcrange");
        if (!viewcalcrange) {
            return;
        }
        DataSet data = this.getData(true);
        if (data == null) {
            return;
        }
        long start = System.currentTimeMillis();
        TableValueSetter vs = this.getTableValueSetter();
        Iterator rows = data.iterator();
        this.getModel().beginInit();
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            Object[] container = new Object[vs.getFields().size()];
            int index = 0;
            BigDecimal planQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("qty"));
            BigDecimal completeqty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("completeqty"));
            BigDecimal wipqty = planQty.subtract(completeqty);
            container[index++] = row.get("costcenter");
            container[index++] = row.get("costobject");
            container[index++] = row.get("material");
            container[index++] = row.get("baseunit");
            container[index++] = row.get("auxpty");
            container[index++] = planQty;
            container[index++] = completeqty;
            container[index] = wipqty;
            vs.addRow(container);
            if (vs.getCount() < 1000) continue;
            model.batchCreateNewEntryRow("entryentity", vs);
            vs = this.getTableValueSetter();
        }
        if (vs.getCount() > 0) {
            model.batchCreateNewEntryRow("entryentity", vs);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        logger.info("\u671f\u672b\u8ba1\u7b97-\u5c55\u793a\u8ba1\u7b97\u8303\u56f4\u5217\u8868\uff1a{}", (Object)(System.currentTimeMillis() - start));
    }

    private TableValueSetter getTableValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("costcenternumber", new Object[0]);
        vs.addField("costobject", new Object[0]);
        vs.addField("material", new Object[0]);
        vs.addField("baseunit", new Object[0]);
        vs.addField("auxpty", new Object[0]);
        vs.addField("plannedqty", new Object[0]);
        vs.addField("factnedqty", new Object[0]);
        vs.addField("wipqty", new Object[0]);
        return vs;
    }

    private String buildCheckParam(ScaCheckerWayEnum checkWay) {
        JSONObject checkParamJs = new JSONObject();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return null;
        }
        checkParamJs.accumulate("org", org.getLong("masterid"));
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            return null;
        }
        checkParamJs.accumulate("costaccount", costAccount.getLong("masterid"));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        checkParamJs.accumulate("currencyId", currency.getLong("masterid"));
        List manuIdList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)CALC_PERM, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        checkParamJs.accumulate("manuorglist", (Object)manuIdList);
        DynamicObjectCollection costcenter = (DynamicObjectCollection)this.getModel().getValue("costcenter");
        HashSet<Long> costCenterIds = new HashSet<Long>();
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costcenter)) {
            for (DynamicObject row : costcenter) {
                DynamicObject center = row.getDynamicObject("fbasedataid");
                costCenterIds.add(center.getLong("masterid"));
            }
        }
        checkParamJs.accumulate("costcenters", costCenterIds);
        Set<Long> manuorgSet = this.getManuorgSet();
        checkParamJs.accumulate("manuOrgIds", manuorgSet);
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period != null) {
            checkParamJs.accumulate("period", period.getLong("id"));
            checkParamJs.accumulate("startDate", (Object)TimeUtils.formatDate((Date)period.getDate("begindate"), (String)"yyyy-MM-dd HH:mm:ss"));
            checkParamJs.accumulate("endDate", (Object)TimeUtils.formatDate((Date)period.getDate("enddate"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        checkParamJs.accumulate("checkway", (Object)checkWay.getValue());
        HashSet<Long> entryCostCenterIds = new HashSet<Long>(16);
        Set<Long> costObjectIds = this.getCostObjectIdForCheck(entryCostCenterIds);
        checkParamJs.accumulate("entrycostcenters", entryCostCenterIds);
        checkParamJs.accumulate("costobjects", costObjectIds);
        return checkParamJs.toString();
    }

    private Set<Long> getCostObjectIdForCheck(Set<Long> entryCostCenterIds) {
        CalcDataArgs args = this.getCalcDataArgs();
        if (args == null) {
            return null;
        }
        DataSet csDataSet = null;
        Set costobjectIds = FinishCalcHelper.getWipCostObject((CalcDataArgs)args);
        if (costobjectIds == null || costobjectIds.size() < 200000) {
            QFilter filter = new QFilter("id", "in", (Object)costobjectIds);
            csDataSet = QueryServiceHelper.queryDataSet((String)"costobject", (String)"cad_costobject", (String)"costcenter", (QFilter[])filter.toArray(), null).distinct();
        } else {
            ArrayList costobjectList = new ArrayList(costobjectIds);
            List groupList = Lists.partition(costobjectList, (int)200000);
            for (List list : groupList) {
                QFilter coFilter = new QFilter("id", "in", (Object)list);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"costobject", (String)"cad_costobject", (String)"costcenter", (QFilter[])coFilter.toArray(), null).distinct();
                if (csDataSet == null) {
                    csDataSet = dataSet;
                    continue;
                }
                csDataSet = csDataSet.union(dataSet);
            }
        }
        if (csDataSet != null) {
            for (Row row : csDataSet) {
                entryCostCenterIds.add(row.getLong("costcenter"));
            }
        }
        return costobjectIds;
    }

    private Set<Object> getCostObjectId(Map<String, Long> ccAndcoInfos) {
        HashSet<Object> costObjectIds = new HashSet<Object>(16);
        DataSet data = this.getData(false);
        if (data == null) {
            return costObjectIds;
        }
        for (Row row : data) {
            costObjectIds.add(row.getLong("costobject"));
            Long cbCount = ccAndcoInfos.get(row.getString("costcenter"));
            if (cbCount == null) {
                cbCount = 0L;
            }
            ccAndcoInfos.put(row.getString("costcenter"), cbCount + 1L);
        }
        return costObjectIds;
    }

    private Map<Object, Object> getCheckResult() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        String checkParam = this.buildCheckParam(ScaCheckerWayEnum.CHECKERWAY_BEFORECALC);
        if (StringUtils.isEmpty((String)checkParam)) {
            return result;
        }
        QFilter qfType = new QFilter("type", "=", (Object)"1");
        DynamicObject checkConfig = QueryServiceHelper.queryOne((String)"sca_checkconfig", (String)"id checkConfigId,taskconfig.id taskconfigId", (QFilter[])new QFilter[]{qfType});
        if (checkConfig == null) {
            return result;
        }
        JSONObject checkParamJs = JSONObject.fromObject((Object)checkParam);
        checkParamJs.accumulate("taskRecordId", (Object)WipCalcCheck.TASKID);
        checkParamJs.accumulate("checkConfigId", (Object)checkConfig.getString("checkConfigId"));
        Long checkResultId = CheckHelper.doCheck((String)checkParamJs.toString());
        Long[] checkItemId = new Long[]{WipCalcCheck.PLANNEDOUTPUTBILLAUDIT, WipCalcCheck.FACTNEDOUTPUTBILLAUDIT, WipCalcCheck.MATUSECOLLECTAUDIT, WipCalcCheck.RESOURCEUSEBILLAUDIT, WipCalcCheck.MFGFEEBILLAUDIT, WipCalcCheck.MATALLOCSTD, WipCalcCheck.MFGFEEALLOCSTD, WipCalcCheck.PLANNEDOUTPUTBILLMAT, WipCalcCheck.RESOURCEUSEPRICE};
        result.put("checkResultId", checkResultId);
        result.put("isCalc", CheckHelper.getCheckResult((Long)checkResultId, (Long[])checkItemId));
        return result;
    }

    private void isHasPermission(BeforeItemClickEvent evt, String permItem) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCalWizards_11", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        boolean flag = PermissionHelper.checkOrgPermission((Long)Long.valueOf(RequestContext.get().getUserId()), (Long)org.getLong("id"), (String)"sca_wipcalwizards", (String)permItem);
        if (!flag) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WipCalWizards_12", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    private void setManuorg() {
        Object accountorg = this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)((DynamicObject)accountorg).getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
            List manuIdList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)((DynamicObject)accountorg).getPkValue()), (String)this.getBillEntityId(), (String)CALC_PERM, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            if (!CadEmptyUtils.isEmpty((List)manuIdList)) {
                this.getModel().setValue("manuorg", (Object)manuIdList.toArray());
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
            this.getModel().setValue("manuorg", null);
        }
    }
}

