/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.costreduction;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.helper.CostReductHelper;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import net.sf.json.JSONArray;

public class CommonSetOrgCostAccountList
extends BaseOrgAndCostAccountListPlugin {
    private static final String RESTOREDIM_CACHE_KEY = "restoredimensioncache";

    @Override
    protected void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        String entityId = ((IListView)this.getView()).getListModel().getDataEntityType().getName();
        if ("sca_costrecovry".equals(entityId) || "sca_halfprdhide".equals(entityId)) {
            this.resetOrgNoPerm(commonFilterColumn, orgIdList);
        } else {
            super.resetOrg(commonFilterColumn, orgIdList);
        }
    }

    @Override
    protected String getOrgFileName() {
        return "null";
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        parameter.setCustomParam("org", (Object)this.getSelectOrgId());
        parameter.setCustomParam("costaccount", (Object)this.getPageCache().get("costaccount"));
        parameter.setCustomParam("period", (Object)this.getPageCache().get("period"));
        parameter.setCustomParam(RESTOREDIM_CACHE_KEY, (Object)this.getPageCache().get(RESTOREDIM_CACHE_KEY));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "tblnew": {
                this.validateTblNew(evt);
                break;
            }
        }
    }

    private void validateTblNew(BeforeItemClickEvent evt) {
        Long orgId = this.getSelectOrgId();
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CommonSetOrgCostAccountList_0", (String)"macc-sca-form", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        String costaccountId = this.getPageCache().get("costaccount");
        if (CadEmptyUtils.isEmpty((String)costaccountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CommonSetOrgCostAccountList_1", (String)"macc-sca-form", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject dynamicObject = CostReductHelper.getCostParam((Long)orgId, (Long)Long.valueOf(costaccountId), (String)this.getView().getFormShowParameter().getAppId());
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u7ef4\u62a4\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u5148\u5728\u201c\u6210\u672c\u53c2\u6570>\u6210\u672c\u6838\u7b97\u53c2\u6570\u201d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"CommonSetOrgCostAccountList_2", (String)"macc-sca-form", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        this.getPageCache().put(RESTOREDIM_CACHE_KEY, dynamicObject.getString("restoredimension"));
    }

    private Long getSelectOrgId() {
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            return null;
        }
        JSONArray orgArr = JSONArray.fromObject((Object)orgId);
        if (!orgArr.isEmpty()) {
            return Long.valueOf(orgArr.getString(0));
        }
        return null;
    }

    @Override
    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        if (CollectionUtils.isEmpty(orgId)) {
            return new ArrayList<ComboItem>(1);
        }
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name";
        QFilter filter = new QFilter("org", "=", (Object)Long.parseLong(orgId.get(0).toString()));
        filter.and("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        filter.and("entryentity.isinit", "=", (Object)Boolean.TRUE);
        filter.and("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appnum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if (!StringUtils.isEmpty((String)appnum)) {
            filter.and("appnum", "=", (Object)appnum);
        }
        DynamicObjectCollection dObjectCollec = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filter.toArray(), (String)"entryentity.costaccount.ismainaccount desc,entryentity.costaccount.number");
        ArrayList<ComboItem> costAccountItems = new ArrayList<ComboItem>();
        for (DynamicObject dy : dObjectCollec) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(dy.getString("name")));
            item.setValue(dy.getString("id"));
            if (costAccountItems.contains(item)) continue;
            costAccountItems.add(item);
        }
        return costAccountItems;
    }
}

