/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.costreduction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.AcaMutexEnum;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.AcaMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.constants.FactCostReductCalcCheck;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.wip.CalcMutexHelper;
import kd.macc.sca.common.helper.CostReductHelper;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;

public class FactCostReductCalPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(FactCostReductCalPlugin.class);

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private String getAppId() {
        return this.getView().getFormShowParameter().getAppId() == null ? "sca" : this.getView().getFormShowParameter().getAppId();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarap = (Toolbar)this.getControl("toolbarap");
        toolbarap.addItemClickListener((ItemClickListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prdorg = (BasedataEdit)this.getControl("prdorg");
        prdorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("check".equals(itemKey) || "startcalc".equals(itemKey)) {
            String restoreCalcRange;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
            if (costaccount == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"FactCostReductCalPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject costParam = CostReductHelper.getCostParam((Long)org.getLong("id"), (Long)costaccount.getLong("id"), (String)this.getAppId());
            if (costParam == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u7ef4\u62a4\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u5728\u201c\u6210\u672c\u53c2\u6570>\u6210\u672c\u6838\u7b97\u53c2\u6570\u201d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"FactCostReductCalPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String restoredimension = costParam.getString("restoredimension");
            if (!this.validatePrdOrg(restoredimension, restoreCalcRange = costParam.getString("restorecalcrange"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\u5305\u542b\u751f\u4ea7\u7ec4\u7ec7\uff0c\u8bf7\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"FactCostReductCalPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if ("check".equals(itemKey)) {
                this.isHasPermission(evt, "0K6+MBJCKDS2");
            } else if ("startcalc".equals(itemKey)) {
                this.isHasPermission(evt, "4730fc9f000025ae");
            }
            this.getPageCache().put("calcDimension", restoredimension);
            this.getPageCache().put("calcRange", restoreCalcRange);
        }
    }

    private boolean validatePrdOrg(String restoredimension, String restorecalcrange) {
        DynamicObject prdorg;
        return !SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(restoredimension) || restorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue()) || restorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) || (prdorg = (DynamicObject)this.getModel().getValue("prdorg")) != null;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("check".equals(itemKey) || "startcalc".equals(itemKey)) {
            String restoredimension = this.getPageCache().get("calcDimension");
            String restoreCalcRange = this.getPageCache().get("calcRange");
            if (StringUtils.isEmpty((String)restoredimension)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"FactCostReductCalPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            if (!this.isShowProdOrg(restoredimension, restoreCalcRange)) {
                this.getModel().setValue("prdorg", null);
            }
            if ("check".equals(itemKey)) {
                this.doCheck();
            } else if ("startcalc".equals(itemKey)) {
                this.doCalc();
            }
        }
    }

    private void saveUserSetting(Long orgId, Long costaccountId, Long prdorgId) {
        try {
            QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)RequestContext.get().getUserId())};
            DynamicObject idInfo = QueryServiceHelper.queryOne((String)"cad_userdatarecord", (String)"id", (QFilter[])filters);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"org", (Object)orgId);
            jsonObj.put((Object)"costaccount", (Object)costaccountId);
            jsonObj.put((Object)"prdorg", (Object)prdorgId);
            String conforcostreductJson = jsonObj.toString();
            if (idInfo == null) {
                DynamicObject userDataRecord = BusinessDataServiceHelper.newDynamicObject((String)"cad_userdatarecord");
                userDataRecord.set("modifytime", (Object)new Date());
                userDataRecord.set("user", (Object)RequestContext.get().getUserId());
                userDataRecord.set("conforcostreduct", (Object)conforcostreductJson);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userDataRecord});
                return;
            }
            DynamicObject userDataRecord = BusinessDataServiceHelper.loadSingle((Object)idInfo.getLong("id"), (String)"cad_userdatarecord");
            userDataRecord.set("conforcostreduct", (Object)conforcostreductJson);
            SaveServiceHelper.update((DynamicObject)userDataRecord);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237\u6570\u636e\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"relacostaccount"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"relacostaccount"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"prdorg"});
        this.initOrg();
    }

    private void initOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        Long currAcctOrg = RequestContext.get().getOrgId();
        boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
        if (isAccounting) {
            Long costaccountId = null;
            if ("sca".equals(this.getAppId())) {
                DynamicObjectCollection costaccounts = StartCostHelper.getCostAccounts((Long)currAcctOrg, (Boolean)true, (String)"org,entryentity.costaccount.id id,entryentity.costaccount.name name", (String)this.getAppId());
                if (costaccounts.size() == 1) {
                    costaccountId = ((DynamicObject)costaccounts.get(0)).getLong("id");
                }
            } else {
                costaccountId = this.getCostAccountByAccoutOrg(currAcctOrg);
            }
            if (!CadEmptyUtils.isEmpty((Long)costaccountId)) {
                this.getModel().setValue("costaccount", (Object)costaccountId);
                this.getModel().setValue("org", (Object)currAcctOrg);
            }
        }
        if (this.getModel().getValue("costaccount") == null && "sca".equals(this.getAppId())) {
            String userId = RequestContext.get().getUserId();
            QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)Long.valueOf(userId))};
            DynamicObject userDataRecord = QueryServiceHelper.queryOne((String)"cad_userdatarecord", (String)"conforcostreduct", (QFilter[])filters);
            if (userDataRecord == null || userDataRecord.getString("conforcostreduct").trim().isEmpty()) {
                return;
            }
            String conforcostreduct = userDataRecord.getString("conforcostreduct");
            JSONObject checkParamJs = JSONObject.fromObject((Object)conforcostreduct);
            if (checkParamJs.containsKey((Object)"costaccount")) {
                Long costaccountId = Long.parseLong(checkParamJs.getString("costaccount"));
                Long orgId = Long.parseLong(checkParamJs.getString("org"));
                Long prdorgId = Long.parseLong(checkParamJs.getString("prdorg"));
                this.getModel().setValue("costaccount", (Object)costaccountId);
                this.getModel().setValue("org", (Object)orgId);
                this.getModel().setValue("prdorg", (Object)prdorgId);
            }
        }
        if (this.getModel().getValue("costaccount") == null) {
            return;
        }
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        org = (DynamicObject)this.getModel().getValue("org");
        this.setRelaCostAccount(org.getLong("id"), costaccount.getLong("id"));
        this.setPeriod(org, costaccount);
        this.setCurrency(costaccount);
        this.setPrdOrgVisible(org, costaccount);
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter accountorgQF = new QFilter("org", "=", (Object)accountOrgId);
        QFilter enablestdtQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        enablestdtQF.and("appnum", "=", (Object)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        QFilter isinitaccountQF = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF, isinitaccountQF}, (String)"entryentity.costaccount.ismainaccount desc,entryentity.costaccount.id desc");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)result)) {
            return 0L;
        }
        if (((DynamicObject)result.get(0)).getBoolean("ismainaccount") || result.size() == 1) {
            return ((DynamicObject)result.get(0)).getLong("costaccount");
        }
        return 0L;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newObj = changeSet[0].getNewValue();
        switch (name) {
            case "costaccount": {
                DynamicObject newValue = (DynamicObject)newObj;
                if (newValue == null) {
                    this.setValueNull(true, true, true, true, true);
                    break;
                }
                Long calorg = newValue.getLong("calorg.id");
                this.getModel().setValue("org", (Object)calorg);
                this.setRelaCostAccount(calorg, newValue.getLong("id"));
                this.setPeriod((DynamicObject)this.getModel().getValue("org"), newValue);
                this.setCurrency(newValue);
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                this.getModel().setValue("prdorg", null);
                this.setPrdOrgVisible(org, newValue);
                break;
            }
        }
    }

    private void setRelaCostAccount(Long orgId, Long costaccountId) {
        DynamicObject costParam = CostReductHelper.getCostParam((Long)orgId, (Long)costaccountId, (String)this.getAppId());
        if (costParam != null) {
            String restoreCalcRange = costParam.getString("restorecalcrange");
            DynamicObjectCollection restoreGetDataRanges = costParam.getDynamicObjectCollection("restoregetdatarange");
            if (restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) && !restoreGetDataRanges.isEmpty()) {
                if (((DynamicObject)restoreGetDataRanges.get(0)).getLong("fbasedataid.id") == 0L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\u5305\u542b\u91c7\u8d2d\u5165\u5e93\u5355\uff0c\u9700\u8981\u914d\u7f6e\u5173\u8054\u8d26\u7c3f\u3002", (String)"FactCostReductCalPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                this.getModel().setValue("relacostaccount", (Object)restoreGetDataRanges);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"relacostaccount"});
                return;
            }
        }
        this.getModel().setValue("relacostaccount", null);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"relacostaccount"});
    }

    private void setPrdOrgVisible(DynamicObject org, DynamicObject costaccount) {
        if (org == null || costaccount == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"prdorg"});
            return;
        }
        BasedataEdit prdorg = (BasedataEdit)this.getControl("prdorg");
        if (this.isShowProdOrg(org.getLong("id"), costaccount.getLong("id"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"prdorg"});
            prdorg.setMustInput(true);
        } else {
            this.getModel().setValue("prdorg", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"prdorg"});
            prdorg.setMustInput(false);
        }
    }

    private boolean isShowProdOrg(Long orgId, Long costaccountId) {
        DynamicObject costParam = CostReductHelper.getCostParam((Long)orgId, (Long)costaccountId, (String)this.getAppId());
        if (costParam == null) {
            return false;
        }
        String restoredimension = costParam.getString("restoredimension");
        String restorecalcrange = costParam.getString("restorecalcrange");
        return this.isShowProdOrg(restoredimension, restorecalcrange);
    }

    private boolean isShowProdOrg(String restoredimension, String restorecalcrange) {
        return SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(restoredimension) && !restorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue()) && !restorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue());
    }

    private void setValueNull(boolean org, boolean costaccount, boolean period, boolean currency, boolean prdorg) {
        IDataModel model = this.getModel();
        if (org) {
            model.setValue("org", null);
        }
        if (costaccount) {
            model.setValue("costaccount", null);
        }
        if (period) {
            model.setValue("period", null);
        }
        if (currency) {
            model.setValue("currency", null);
        }
        if (prdorg) {
            model.setValue("prdorg", null);
        }
        model.setValue("relacostaccount", null);
    }

    private void setPeriod(DynamicObject org, DynamicObject costaccount) {
        if (org == null) {
            this.setValueNull(false, true, true, true, true);
            return;
        }
        if (costaccount == null) {
            this.setValueNull(false, false, true, true, false);
            return;
        }
        DynamicObject periodDyn = this.getPeriodSetDynamicObject(org.getLong("id"), costaccount.getLong("id"));
        if (periodDyn == null) {
            return;
        }
        this.getModel().setValue("period", (Object)periodDyn.getLong("currentperiod"));
    }

    private void setCurrency(DynamicObject costaccount) {
        if (costaccount == null) {
            this.setValueNull(false, false, false, true, false);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.setValueNull(false, false, false, true, false);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.setValueNull(false, false, false, true, false);
            return;
        }
        this.getModel().setValue("currency", (Object)result.getLong("currency"));
    }

    private DynamicObject getPeriodSetDynamicObject(Long orgId, Long costaccountId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountFilter = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        return QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.startperiod startperiod,entry.currentperiod currentperiod", (QFilter[])new QFilter[]{orgFilter, costaccountFilter});
    }

    private QFilter getPeriodF7Filter(DynamicObject sysCtrlEntity) {
        if (sysCtrlEntity == null) {
            return null;
        }
        QFilter periodFilter = new QFilter("id", "in", (Object)Lists.newArrayList((Object[])new Long[]{sysCtrlEntity.getLong("startperiod"), sysCtrlEntity.getLong("currentperiod")}));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"begindate,enddate,periodtype", (QFilter[])periodFilter.toArray(), (String)"begindate");
        if (dataSet == null) {
            return null;
        }
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"periodtype"});
        DataSet finishDs = groupbyDataSet.max("enddate", "enddate").min("begindate", "begindate").finish();
        Iterator ite = finishDs.iterator();
        Date minDate = null;
        Long periodtype = 0L;
        while (ite.hasNext()) {
            Row row = (Row)ite.next();
            minDate = row.getDate("begindate");
            periodtype = row.getLong("periodtype");
        }
        QFilter qFilter = new QFilter("begindate", ">=", minDate);
        qFilter.and("periodtype", "=", (Object)periodtype);
        return qFilter;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = lsp.getListFilterParameter().getQFilters();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        switch (name) {
            case "org": {
                qFilters.add(new QFilter("id", "in", (Object)OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())));
                break;
            }
            case "costaccount": {
                List orgIds = OrgHelper.getHasPermAccountOrgIdsByPermItem((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"4730fc9f000025ae");
                QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
                QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
                QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
                QFilter appnumFilter = new QFilter("appnum", "=", (Object)this.getAppId());
                QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, appnumFilter};
                DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
                if (CollectionUtils.isNotEmpty((Collection)costAccountIds)) {
                    Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
                    qFilters.add(new QFilter("id", "in", costAccountIdList));
                    break;
                }
                qFilters.add(new QFilter("id", "=", (Object)0));
                break;
            }
            case "period": {
                if (costaccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"FactCostReductCalPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                this.setPeriodF7Filter(qFilters, org, costaccount);
                break;
            }
            case "prdorg": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"FactCostReductCalPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List productOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)"4730fc9f000025ae", (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                qFilters.add(new QFilter("id", "in", (Object)productOrgs));
                break;
            }
        }
    }

    private void setPeriodF7Filter(List<QFilter> qFilters, DynamicObject org, DynamicObject costaccount) {
        DynamicObject sysCtrlEntity = this.getPeriodSetDynamicObject(org.getLong("id"), costaccount.getLong("id"));
        QFilter qFilter = this.getPeriodF7Filter(sysCtrlEntity);
        if (qFilter == null) {
            return;
        }
        DynamicObjectCollection periodCol = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])qFilter.toArray());
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)periodCol)) {
            return;
        }
        HashSet periodSet = new HashSet(8);
        periodCol.forEach(r -> periodSet.add(r.getLong("id")));
        qFilters.add(new QFilter("id", "in", periodSet));
        qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
    }

    private void isHasPermission(BeforeItemClickEvent evt, String permItem) {
        List orgPermission = PermissionHelper.getUserPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"sca_factcostreduction", (String)permItem, (String)this.getAppId());
        if (orgPermission == null) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (orgPermission.size() == 0 || !orgPermission.contains(org.getLong("id"))) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FactCostReductCalPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    private void doCheck() {
        String checkParam;
        DynamicObject period;
        DynamicObject costaccount;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!this.checkParamVilidator(org, costaccount = (DynamicObject)this.getModel().getValue("costaccount"), period = (DynamicObject)this.getModel().getValue("period"))) {
            return;
        }
        Long prdorgId = 0L;
        DynamicObject prdorg = (DynamicObject)this.getModel().getValue("prdorg");
        if (prdorg != null) {
            prdorgId = prdorg.getLong("masterid");
        }
        if ("sca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.saveUserSetting(org.getLong("id"), costaccount.getLong("id"), prdorgId);
        }
        if (CadEmptyUtils.isEmpty((String)(checkParam = this.buildCalParam(org, costaccount, period)))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u7b97\u8303\u56f4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u5408\u6cd5\u6027\u68c0\u67e5\u3002", (String)"FactCostReductCalPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("cad_checktasksetting");
        lsp.setCustomParam("calcParam", (Object)checkParam);
        lsp.setCustomParam("checktype", (Object)"5");
        lsp.setCustomParam("calType", (Object)"sca_factcostreduction");
        lsp.setCaption(ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"FactCostReductCalPlugin_18", (String)"macc-sca-form", (Object[])new Object[0]));
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(lsp);
    }

    private boolean checkParamVilidator(DynamicObject org, DynamicObject costaccount, DynamicObject period) {
        String operName = ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u5931\u8d25\u3002", (String)"FactCostReductCalPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]);
        return this.conditionVilidator(operName, org, costaccount, period);
    }

    private boolean calcParamVilidator(DynamicObject org, DynamicObject costaccount, DynamicObject period) {
        String operName = ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\u3002", (String)"FactCostReductCalPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]);
        return this.conditionVilidator(operName, org, costaccount, period);
    }

    private boolean conditionVilidator(String operName, DynamicObject org, DynamicObject costaccount, DynamicObject period) {
        if (org == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"FactCostReductCalPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        if (costaccount == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"FactCostReductCalPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        boolean isInit = StartCostHelper.isInit((Long)((Long)costaccount.getPkValue()), (String)this.getAppId());
        if (!isInit) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"FactCostReductCalPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        if (period == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6838\u7b97\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"FactCostReductCalPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        DynamicObjectCollection relacostaccounts = (DynamicObjectCollection)this.getModel().getValue("relacostaccount");
        String restoreCalcRange = this.getPageCache().get("calcRange");
        if (restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) && relacostaccounts.isEmpty()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u8303\u56f4\u5305\u542b\u91c7\u8d2d\u5165\u5e93\u5355\u65f6\uff0c\u5fc5\u987b\u5728\u201c\u6210\u672c\u53c2\u6570\u201d\u4e2d\u7ef4\u62a4\u5173\u8054\u8d26\u7c3f\u3002", (String)"FactCostReductCalPlugin_14", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        HashMap<Long, DynamicObject> orgAndAccountObjMap = new HashMap<Long, DynamicObject>();
        StringBuilder allAccountSb = new StringBuilder();
        allAccountSb.append(costaccount.getString("name")).append(",");
        if (!relacostaccounts.isEmpty()) {
            for (DynamicObject dyn : relacostaccounts) {
                Long calorgId = dyn.getLong("fbasedataid.calorg.id");
                orgAndAccountObjMap.put(calorgId, dyn);
                allAccountSb.append(dyn.getString("fbasedataid.name")).append(",");
            }
            List<Long> noPermitOrgIds = this.getNotHasPermAccountOrg(orgAndAccountObjMap.keySet());
            if (!noPermitOrgIds.isEmpty()) {
                StringBuilder noPermitAccountSb = new StringBuilder();
                for (Long orgId : noPermitOrgIds) {
                    DynamicObject dyn = (DynamicObject)orgAndAccountObjMap.get(orgId);
                    noPermitAccountSb.append(dyn.getString("fbasedataid.name")).append(",");
                }
                String tipStr = ResManager.loadKDString((String)"\u3010%1$s\u3011\u3002\u3010%2$s\u3011\u9700\u8981\u540c\u65f6\u8fdb\u884c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\uff0c\u5f53\u524d\u7528\u6237\u6ca1\u6709\u3010%3$s\u3011\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u3002", (String)"FactCostReductCalPlugin_19", (String)"macc-sca-form", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(tipStr, operName, allAccountSb.toString().substring(0, allAccountSb.length() - 1), noPermitAccountSb.toString().substring(0, noPermitAccountSb.length() - 1)));
                return false;
            }
        }
        return true;
    }

    private List<Long> getNotHasPermAccountOrg(Collection<Long> orgIds) {
        ArrayList<Long> list = new ArrayList<Long>();
        List permOrgIds = OrgHelper.getHasPermAccountOrgIdsByPermItem((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"4730fc9f000025ae");
        for (Long orgId : orgIds) {
            if (permOrgIds.contains(orgId)) continue;
            list.add(orgId);
        }
        return list;
    }

    private void doCalc() {
        DynamicObject period;
        DynamicObject costaccount;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!this.calcParamVilidator(org, costaccount = (DynamicObject)this.getModel().getValue("costaccount"), period = (DynamicObject)this.getModel().getValue("period"))) {
            return;
        }
        String costAccName = costaccount.getLocaleString("name").getLocaleValue();
        String costAccStr = costaccount.getString("id");
        DynamicObject prdorg = (DynamicObject)this.getModel().getValue("prdorg");
        String prdOrgStr = "";
        String prdName = "";
        Long prdorgId = 0L;
        if (prdorg != null) {
            prdOrgStr = prdorg.getString("id");
            prdName = prdorg.getLocaleString("name").getLocaleValue();
            costAccStr = costAccStr + prdOrgStr;
            prdorgId = prdorg.getLong("masterid");
        }
        this.saveUserSetting(org.getLong("id"), costaccount.getLong("id"), prdorgId);
        try {
            long pagePeriod;
            long currentperiod;
            logger.info("\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u524d\uff0c\u82e5\u662f\u5f53\u524d\u671f\u95f4\uff0c\u5f00\u59cb\u8fd8\u539f\u8ba1\u7b97\u4e0e\u5176\u4ed6\u8ba1\u7b97\u4e4b\u95f4\u4e92\u65a5\u6027\u6821\u9a8c");
            DynamicObject periodSetDynamicObject = this.getPeriodSetDynamicObject(org.getLong("id"), costaccount.getLong("id"));
            if (periodSetDynamicObject != null && (currentperiod = periodSetDynamicObject.getLong("currentperiod")) == (pagePeriod = period.getLong("id"))) {
                this.getPageCache().put("periodIsCurrent", "Y");
                if ("aca".equals(this.getAppId())) {
                    String lockErrAcct = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costaccount.getLong("id"));
                    if (StringUtils.isNotEmpty((String)lockErrAcct)) {
                        this.getView().showErrorNotification(lockErrAcct);
                        return;
                    }
                } else {
                    String lockErrAcct = CalcMutexHelper.checkAndRequireXMutexNoPrdOrg((String)"reductcalc", (Long)costaccount.getLong("id"));
                    if (StringUtils.isNotEmpty((String)lockErrAcct)) {
                        String lockErr = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0b\u5728\u8fdb\u884c\u5dee\u5f02\u5206\u644a/\u5b8c\u5de5\u7ed3\u7b97/\u671f\u672b\u8ba1\u7b97\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u8fdb\u884c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u3002", (String)"FactCostReductCalPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]);
                        this.getView().showErrorNotification(lockErr);
                        return;
                    }
                }
            }
            logger.info("\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u524d\uff0c\u5f00\u59cb\u591a\u4e2a\u8fd8\u539f\u8ba1\u7b97\u4e4b\u95f4\u4e92\u65a5\u6027\u6821\u9a8c");
            String lockErr = CalcMutexHelper.checkAndRequireXMutex((String)"reductcalc", (Object)costAccStr.hashCode(), (boolean)false);
            if (StringUtils.isNotEmpty((String)lockErr)) {
                if (prdorg == null) {
                    this.getView().showErrorNotification(String.format(lockErr, costAccName));
                } else {
                    lockErr = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0b\u751f\u4ea7\u7ec4\u7ec7\u201c%2$s\u201d\u6b63\u5728\u8fdb\u884c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"FactCostReductCalPlugin_17", (String)"macc-sca-form", (Object[])new Object[0]);
                    this.getView().showErrorNotification(String.format(lockErr, costAccName, prdName));
                }
                return;
            }
            logger.info("\u4e24\u4e2a\u4e92\u65a5\u9501\u90fd\u5df2\u6821\u9a8c\u901a\u8fc7");
            String args = this.buildCalParam(org, costaccount, period);
            TaskHelper.startTaskForCostReduct((IFormView)this.getView(), (IDataModel)this.getModel(), (Long)FactCostReductCalcCheck.CALCTASKID, (String)args);
            logger.info("FactCostReductCalPlugin\u7c7b\u6b63\u5e38\u7ed3\u675f");
        }
        catch (Exception e) {
            CalcMutexHelper.releaseXMutex((String)"reductcalc", (Object)costAccStr.hashCode());
            String periodIsCurrent = this.getPageCache().get("periodIsCurrent");
            if (!CadEmptyUtils.isEmpty((String)periodIsCurrent) && "Y".equals(periodIsCurrent)) {
                CalcMutexHelper.releaseXMutex((String)"reductcalc", (Object)costaccount.getLong("id"));
                AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costaccount.getLong("id"));
            }
            logger.error("FactCostReductCalPlugin\u7c7b\u5f02\u5e38\uff1a" + e);
            throw new KDBizException(e.getMessage());
        }
    }

    private String buildCalParam(DynamicObject org, DynamicObject costaccount, DynamicObject period) {
        CostRecoveryParams crp = new CostRecoveryParams();
        crp.setCalOrgId(org.getLong("id"));
        crp.setCostAccountId(costaccount.getLong("id"));
        DynamicObject prdorg = (DynamicObject)this.getModel().getValue("prdorg");
        if (prdorg != null) {
            crp.setManuOrgId(prdorg.getLong("id"));
        }
        crp.setPeriodId(period.getLong("id"));
        crp.setStartDate(period.getDate("begindate"));
        crp.setEndDate(period.getDate("enddate"));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            crp.setCurrencyId(currency.getLong("id"));
        }
        Boolean isrecalset = (Boolean)this.getModel().getValue("isrecalset");
        crp.setTaskId(0L);
        crp.setUsePreConstr(isrecalset.booleanValue());
        if ("aca".equals(this.getAppId())) {
            crp.setCheckConfigId(FactCostReductCalcCheck.ACA_CHECKCONFIG_ID);
        } else {
            crp.setCheckConfigId(FactCostReductCalcCheck.SCA_CHECKCONFIG_ID);
        }
        crp.setPeriodIsCurrent(this.getPageCache().get("periodIsCurrent"));
        HashMap<Long, Long> relaOrgCostAccountMap = new HashMap<Long, Long>();
        HashSet<Long> allOrgIds = new HashSet<Long>(16);
        HashSet<Long> allCostAccounts = new HashSet<Long>(16);
        allOrgIds.add(crp.getCalOrgId());
        allCostAccounts.add(crp.getCostAccountId());
        relaOrgCostAccountMap.put(crp.getCalOrgId(), crp.getCostAccountId());
        DynamicObjectCollection relacostaccounts = (DynamicObjectCollection)this.getModel().getValue("relacostaccount");
        if (relacostaccounts.size() > 0) {
            for (DynamicObject dyn : relacostaccounts) {
                Long orgId = dyn.getLong("fbasedataid.calorg.id");
                Long accountId = dyn.getLong("fbasedataid.id");
                allOrgIds.add(orgId);
                allCostAccounts.add(accountId);
                relaOrgCostAccountMap.put(orgId, accountId);
            }
        }
        crp.setCalRange(this.getPageCache().get("calcRange"));
        crp.setCalDimension(this.getPageCache().get("calcDimension"));
        crp.setRelationCalOrgIds(allOrgIds);
        crp.setRelationCostAccountIds(allCostAccounts);
        crp.setRelaOrgCostAccountMap(relaOrgCostAccountMap);
        crp.setAppnum(this.getAppId());
        return SerializationUtils.toJsonString((Object)crp);
    }
}

