/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.costreduction;

import java.lang.reflect.Constructor;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.sca.algox.task.TaskRunning;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class FactCostReductTaskRunningPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(FactCostReductTaskRunningPlugin.class);
    private static final String RUN_PROGRESSBARAP = "reductprogressbarap";
    private static final String CHECKTASK_CLASS = "kd.macc.sca.algox.costrec.ReductCheckTask";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl(RUN_PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
        Button cancel = (Button)this.getControl("cancel");
        cancel.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String runningParaJS = (String)showParameter.getCustomParam("calcParam");
        String taskConfigId = showParameter.getCustomParam("taskConfigId").toString();
        String taskReocrdId = showParameter.getCustomParam("taskRecordId").toString();
        this.start(runningParaJS, taskConfigId, taskReocrdId);
        DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(taskReocrdId), (String)"sca_taskrecord");
        this.buildRunningParam(taskRecord);
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        String taskReocrdId = this.getPageCache().get("taskRecordId");
        DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(taskReocrdId), (String)"sca_taskrecord");
        paramProgressEvent.setProgress(taskRecord.getInt("progress"));
        this.buildRunningParam(taskRecord);
        int progress = taskRecord.getInt("progress");
        if ("3".equals(taskRecord.getString("status")) || "4".equals(taskRecord.getString("status")) || progress >= 100) {
            this.getView().close();
            this.nextpage(taskRecord);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String itemKey = ((Control)evt.getSource()).getKey();
        if ("cancel".equals(itemKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8f6c\u540e\u53f0\u8ba1\u7b97\u540e\u9700\u8981\u5728\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u62a5\u544a\u4e2d\u67e5\u8be2\u8ba1\u7b97\u7ed3\u679c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FactCostReductTaskRunningPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("sca_costredtaskrunning-close"));
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("sca_costredtaskrunning-close".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes.getValue() == result.getValue()) {
                this.getView().close();
            }
        }
    }

    private void start(String taskParam, String taskConfigId, String taskRecordId) {
        String classpath;
        Object calcReportId = this.getView().getFormShowParameter().getCustomParam("calcReportId");
        Object checkReportId = this.getView().getFormShowParameter().getCustomParam("checkReportId");
        this.getPageCache().put("taskRecordId", taskRecordId);
        this.getPageCache().put("taskConfigId", taskConfigId);
        if (calcReportId != null) {
            this.getPageCache().put("calcReportId", calcReportId.toString());
        }
        if (checkReportId != null) {
            this.getPageCache().put("checkReportId", checkReportId.toString());
        }
        JSONObject taskParamJs = JSONObject.fromObject((Object)taskParam);
        taskParamJs.accumulate("taskRecordId", (Object)taskRecordId);
        taskParamJs.accumulate("calcReportId", calcReportId);
        taskParamJs.accumulate("checkReportId", checkReportId);
        taskParamJs.accumulate("appNum", (Object)this.getView().getFormShowParameter().getAppId());
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(taskConfigId));
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((String)"sca_taskconfig", (String)"class", (QFilter[])new QFilter[]{filter});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(RUN_PROGRESSBARAP);
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c ...", (String)"FactCostReductTaskRunningPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
        progressBar.start();
        String string = classpath = taskConfig == null ? CHECKTASK_CLASS : taskConfig.getString("class");
        if (CadEmptyUtils.isEmpty((String)classpath)) {
            return;
        }
        try {
            Class<?> doClass = Class.forName(classpath);
            Constructor<?> con = doClass.getDeclaredConstructor(String.class);
            TaskRunning taskRunning = (TaskRunning)con.newInstance(taskParamJs.toString());
            ThreadHelper.execute((Runnable)taskRunning, (TaskType)TaskType.SCA_PROCESS);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().close();
        }
    }

    private void buildRunningParam(DynamicObject taskRecord) {
        String taskname = taskRecord.getString("taskname");
        int doneStep = 0;
        String doingStep = ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"FactCostReductTaskRunningPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]);
        DynamicObjectCollection taskRecordEntrys = taskRecord.getDynamicObjectCollection("entryentity");
        JSONArray taskDetailInfos = new JSONArray();
        for (DynamicObject entry : taskRecordEntrys) {
            JSONObject taskDetailInfo = new JSONObject();
            taskDetailInfo.accumulate("status", entry.get("substatus"));
            taskDetailInfo.accumulate("name", entry.get("subname"));
            if ("3".equals(entry.getString("substatus")) || "4".equals(entry.getString("substatus"))) {
                ++doneStep;
            }
            if ("2".equals(entry.getString("substatus"))) {
                doingStep = entry.getString("subname");
                break;
            }
            taskDetailInfos.add((Object)taskDetailInfo);
        }
        CustomControl taskRunningUI = (CustomControl)this.getView().getControl("tasksteps");
        JSONObject taskRunningUIPara = new JSONObject();
        taskRunningUIPara.accumulate("doneStep", doneStep);
        taskRunningUIPara.accumulate("totalStep", taskRecordEntrys.size());
        taskRunningUIPara.accumulate("doingStep", (Object)doingStep);
        taskRunningUIPara.accumulate("taskname", (Object)taskname);
        taskRunningUIPara.accumulate("taskDetailInfos", (Object)taskDetailInfos.toString());
        taskRunningUI.setData((Object)taskRunningUIPara.toString());
        Label currstep = (Label)this.getView().getControl("currsteplab");
        currstep.setText(doneStep + 1 + "/" + taskRecordEntrys.size() + doingStep);
    }

    private void nextpage(DynamicObject taskRecord) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)taskRecord.getString("nextpage"));
        Object lsp = null;
        lsp = mainEntityType instanceof BillEntityType ? new BillShowParameter() : new FormShowParameter();
        String calcRecordId = this.getPageCache().get("calcReportId");
        String checkReportId = this.getPageCache().get("checkReportId");
        lsp.setFormId(taskRecord.getString("nextpage"));
        lsp.setCaption(String.format(ResManager.loadKDString((String)"%s\u62a5\u544a", (String)"FactCostReductTaskRunningPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]), taskRecord.getString("taskname")));
        lsp.setCustomParam("custparam", (Object)taskRecord.getString("nextpagepara"));
        lsp.setCustomParam("calcrecordid", (Object)this.getPageCache().get("calcReportId"));
        if (calcRecordId == null) {
            lsp.setCaption(ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"FactCostReductTaskRunningPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
            lsp.setPkId((Object)Long.parseLong(checkReportId));
        }
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }
}

