/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.costreduction;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.helper.CostReductHelper;

public class HalfPrdStructurePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialversion = (BasedataEdit)this.getControl("materialversion");
        materialversion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit element = (BasedataEdit)this.getControl("element");
        element.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit subelement = (BasedataEdit)this.getControl("subelement");
        subelement.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit submaterial = (BasedataEdit)this.getControl("submaterial");
        submaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit submaterialversion = (BasedataEdit)this.getControl("submaterialversion");
        submaterialversion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prdorg = (BasedataEdit)this.getControl("prdorg");
        prdorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit storageorgunit = (BasedataEdit)this.getControl("storageorgunit");
        storageorgunit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        this.setCurrency(costaccount);
        this.setPeriod(org, costaccount);
    }

    private void setCurrency(DynamicObject costaccount) {
        if (costaccount == null) {
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            return;
        }
        this.getModel().setValue("currency", (Object)result.getLong("currency"));
    }

    private void setPeriod(DynamicObject org, DynamicObject costaccount) {
        if (org == null) {
            return;
        }
        if (costaccount == null) {
            return;
        }
        if (this.getModel().getDataEntity().getDynamicObject("period") != null) {
            return;
        }
        DynamicObject periodDyn = this.getPeriodSetDynamicObject(org.getLong("id"), costaccount.getLong("id"));
        if (periodDyn == null) {
            return;
        }
        this.getModel().setValue("period", (Object)periodDyn.getLong("currentperiod"));
    }

    private DynamicObject getPeriodSetDynamicObject(Long orgId, Long costaccountId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountFilter = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        return QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.startperiod startperiod,entry.currentperiod currentperiod", (QFilter[])new QFilter[]{orgFilter, costaccountFilter});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String keyName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = lsp.getListFilterParameter().getQFilters();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        this.getPageCache().put("issubelementsource", "N");
        switch (keyName) {
            case "period": {
                if (costaccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f.", (String)"HalfPrdStructurePlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                this.setPeriodF7Filter(qFilters, org, costaccount);
                break;
            }
            case "materialversion": {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material");
                if (material == null) break;
                qFilters.add(new QFilter("material", "=", material.getPkValue()));
                break;
            }
            case "subelement": {
                DynamicObject element = (DynamicObject)this.getModel().getValue("element");
                if (element != null) {
                    qFilters.add(new QFilter("id", "in", this.getSubElement(element.getLong("id"))));
                }
                this.getPageCache().put("issubelementsource", "Y");
                break;
            }
            case "submaterialversion": {
                DynamicObject submaterial = (DynamicObject)this.getModel().getValue("submaterial");
                if (submaterial == null) break;
                qFilters.add(new QFilter("material", "=", submaterial.getPkValue()));
                break;
            }
            case "prdorg": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"HalfPrdStructurePlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                qFilters.add(new QFilter("id", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId())));
                break;
            }
            case "storageorgunit": {
                DynamicObject prdorg = (DynamicObject)this.getModel().getValue("prdorg");
                if (prdorg != null) {
                    List stOrgs = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)prdorg.getLong("id"), (boolean)true);
                    qFilters.add(new QFilter("id", "in", (Object)stOrgs));
                    break;
                }
                String restoreCalcRange = this.getPageCache().get("restoreCalcRange");
                if (!StringUtils.isEmpty((CharSequence)restoreCalcRange) && (restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) || restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue()))) {
                    HashSet prdStorgs = new HashSet();
                    List productOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId());
                    for (Long porg : productOrgs) {
                        prdStorgs.addAll(OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)porg, (boolean)true));
                    }
                    List stOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)org.getLong("id"), (boolean)true);
                    stOrgs.removeAll(prdStorgs);
                    if (stOrgs.size() > 0) {
                        qFilters.add(new QFilter("id", "in", (Object)stOrgs));
                        break;
                    }
                }
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (!this.getModel().getDataEntity().getBoolean("ismodify") && !"memo".equals(keyName)) {
            this.getModel().setValue("ismodify", (Object)Boolean.TRUE);
        }
        switch (keyName) {
            case "prdorg": {
                List stOrgs;
                DynamicObject prdorg = (DynamicObject)newVal;
                if (prdorg != null && (stOrgs = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)prdorg.getLong("id"), (boolean)true)) != null && stOrgs.size() == 1) {
                    this.getModel().setValue("storageorgunit", stOrgs.get(0));
                    break;
                }
                this.getModel().setValue("storageorgunit", null);
                break;
            }
            case "amount": {
                this.recalcTotalAmt();
                break;
            }
            case "subelement": {
                DynamicObject subelement = (DynamicObject)newVal;
                this.writeBackElement(subelement, rowIndex);
                break;
            }
            case "element": {
                String issubelementsource = this.getPageCache().get("issubelementsource");
                if (!"Y".equals(issubelementsource)) {
                    DynamicObject dyn = (DynamicObject)newVal;
                    this.setDefaultSubElement(dyn, rowIndex);
                }
                this.setSubMaterialEnable(newVal, rowIndex);
                break;
            }
            case "material": {
                this.getModel().setValue("materialversion", null);
                this.getModel().setValue("auxprop", null);
                if (newVal == null) break;
                DynamicObject material = (DynamicObject)newVal;
                this.setMatVersionAndPropEnable(material);
                break;
            }
            case "submaterial": {
                this.getModel().setValue("submaterialversion", null, rowIndex);
                this.getModel().setValue("submaterialauxprop", null, rowIndex);
                this.getModel().setValue("qty", null, rowIndex);
                if (newVal == null) {
                    this.getModel().setValue("materielunit", null, rowIndex);
                    break;
                }
                DynamicObject submaterial = (DynamicObject)newVal;
                this.setSubMatVersionAndPropEnable(submaterial, rowIndex);
                DynamicObject baseunit = submaterial.getDynamicObject("baseunit");
                if (baseunit == null) break;
                this.getModel().setValue("materielunit", (Object)baseunit.getLong("masterid"), rowIndex);
            }
        }
    }

    private void setMatVersionAndPropEnable(DynamicObject material) {
        if (material == null) {
            return;
        }
        boolean isenablematerialversion = material.getBoolean("isenablematerialversion");
        BasedataEdit materialversion = (BasedataEdit)this.getView().getControl("materialversion");
        if (isenablematerialversion) {
            materialversion.setMustInput(true);
            this.getView().setEnable(Boolean.TRUE, new String[]{"materialversion"});
        } else {
            materialversion.setMustInput(false);
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialversion"});
        }
        boolean isuseauxpty = material.getBoolean("isuseauxpty");
        if (isuseauxpty) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"auxprop"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"auxprop"});
        }
    }

    private void setSubMaterialEnable(Object newVal, int rowIndex) {
        if (newVal == null) {
            return;
        }
        DynamicObject dyn = (DynamicObject)newVal;
        String type = dyn.getString("type");
        if ("001".equals(type) || "002".equals(type)) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"submaterial"});
            DynamicObject submaterial = (DynamicObject)this.getModel().getValue("submaterial", rowIndex);
            if (submaterial != null) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"submaterialversion"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"submaterialauxprop"});
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"submaterialversion"});
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"submaterialauxprop"});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"submaterial"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"submaterialversion"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"submaterialauxprop"});
            this.getModel().setValue("submaterial", null, rowIndex);
            this.getModel().setValue("submaterialversion", null, rowIndex);
            this.getModel().setValue("submaterialauxprop", null, rowIndex);
        }
    }

    private void recalcTotalAmt() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency == null) {
            return;
        }
        BigDecimal totalAmt = new BigDecimal("0");
        totalAmt = totalAmt.setScale(currency.getInt("priceprecision"), 4);
        for (int i = 0; i < entryentity.size(); ++i) {
            BigDecimal amount;
            DynamicObject row = (DynamicObject)entryentity.get(i);
            if (row == null || (amount = row.getBigDecimal("amount")) == null) continue;
            totalAmt = totalAmt.add(amount);
        }
        this.getModel().setValue("totalamount", (Object)totalAmt);
    }

    private void writeBackElement(DynamicObject subEle, int rowIndex) {
        if (subEle == null) {
            return;
        }
        long subElementId = subEle.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            this.getView().getModel().setValue("element", (Object)dySubElement.getLong("element"), rowIndex);
        }
    }

    private void setDefaultSubElement(DynamicObject element, int rowIndex) {
        if (element == null) {
            return;
        }
        QFilter qFilter = new QFilter("element", "=", (Object)element.getLong("id"));
        DynamicObjectCollection subelement = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])qFilter.toArray());
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)subelement)) {
            return;
        }
        HashSet subEleIdSet = new HashSet(subelement.size());
        subelement.forEach(r -> subEleIdSet.add(r.getLong("subelement")));
        if (CadEmptyUtils.isEmpty(subEleIdSet)) {
            return;
        }
        QFilter subFilter = new QFilter("id", "in", subEleIdSet);
        subFilter.and(new QFilter("defaultvalue", "=", (Object)Boolean.TRUE));
        DynamicObject resDyn = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id", (QFilter[])subFilter.toArray());
        if (resDyn == null) {
            this.getModel().setValue("subelement", null, rowIndex);
            return;
        }
        this.getModel().setValue("subelement", (Object)resDyn.getLong("id"), rowIndex);
    }

    public Set<Long> getSubElement(long elementId) {
        HashSet<Long> subElementIds = new HashSet<Long>();
        QFilter qfElement = new QFilter("element", "=", (Object)elementId);
        DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id", (QFilter[])new QFilter[]{qfElement});
        if (elementDetail.size() == 0) {
            return subElementIds;
        }
        for (DynamicObject ele : elementDetail) {
            subElementIds.add(ele.getLong("subelement.id"));
        }
        return subElementIds;
    }

    private void setPeriodF7Filter(List<QFilter> qFilters, DynamicObject org, DynamicObject costaccount) {
        qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
        DynamicObject sysCtrlEntity = this.getPeriodSetDynamicObject(org.getLong("id"), costaccount.getLong("id"));
        QFilter qFilter = this.getPeriodF7Filter(sysCtrlEntity);
        if (qFilter == null) {
            return;
        }
        DynamicObjectCollection periodCol = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])qFilter.toArray());
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)periodCol)) {
            return;
        }
        HashSet periodSet = new HashSet(8);
        periodCol.forEach(r -> periodSet.add(r.getLong("id")));
        qFilters.add(new QFilter("id", "in", periodSet));
    }

    private QFilter getPeriodF7Filter(DynamicObject sysCtrlEntity) {
        if (sysCtrlEntity == null) {
            return null;
        }
        QFilter periodFilter = new QFilter("id", "in", (Object)Lists.newArrayList((Object[])new Long[]{sysCtrlEntity.getLong("startperiod"), sysCtrlEntity.getLong("currentperiod")}));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"begindate,enddate,periodtype", (QFilter[])periodFilter.toArray(), (String)"begindate");
        if (dataSet == null) {
            return null;
        }
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"periodtype"});
        DataSet finishDs = groupbyDataSet.max("enddate", "enddate").min("begindate", "begindate").finish();
        Iterator ite = finishDs.iterator();
        Date minDate = null;
        Date maxDate = null;
        Long periodtype = 0L;
        while (ite.hasNext()) {
            Row row = (Row)ite.next();
            minDate = row.getDate("begindate");
            maxDate = row.getDate("enddate");
            periodtype = row.getLong("periodtype");
        }
        QFilter qFilter = new QFilter("begindate", ">=", minDate);
        qFilter.and(new QFilter("enddate", "<=", (Object)maxDate));
        qFilter.and("periodtype", "=", (Object)periodtype);
        return qFilter;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String newBillPkId;
        String itemKey = evt.getItemKey();
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        Object pkId = bsp.getPkId();
        Integer billStatusValue = bsp.getBillStatusValue();
        if (BillOperationStatus.ADDNEW.getValue() == billStatusValue.intValue()) {
            pkId = null;
        }
        if (!CadEmptyUtils.isEmpty((String)(newBillPkId = this.getPageCache().get("newBillPkId")))) {
            pkId = newBillPkId;
        }
        if (pkId == null) {
            pkId = this.getModel().getValue("id");
        }
        switch (itemKey) {
            case "bar_save": 
            case "bar_submit": 
            case "bar_submitandnew": {
                this.setElementIfNullBeforeSave();
                this.validateBillNoExists(evt, pkId);
                this.validateProductProp(evt);
                this.validateEntrySubMatProp(evt);
                break;
            }
        }
    }

    private void validateBillNoExists(BeforeItemClickEvent evt, Object pkId) {
        String billno = String.valueOf(this.getModel().getValue("billno"));
        if (billno != null) {
            boolean exists;
            if (billno.trim().length() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5355\u636e\u7f16\u53f7\u201d.", (String)"HalfPrdStructurePlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("billno", "=", (Object)billno);
            if (pkId != null) {
                qFilter.and(new QFilter("id", "!=", (Object)Long.valueOf(pkId.toString())));
            }
            if (exists = QueryServiceHelper.exists((String)"sca_halfprdstructure", (QFilter[])qFilter.toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u5df2\u5b58\u5728\u3002", (String)"HalfPrdStructurePlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    private void setElementIfNullBeforeSave() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject row = (DynamicObject)entryEntity.get(i);
            DynamicObject element = row.getDynamicObject("element");
            DynamicObject subelement = row.getDynamicObject("subelement");
            if (subelement == null || element != null) continue;
            this.writeBackElement(subelement, i);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey)) {
            operationResult = afterDoOperationEventArgs.getOperationResult();
            if (operationResult == null) {
                return;
            }
            List successPkIds = operationResult.getSuccessPkIds();
            if (!CadEmptyUtils.isEmpty((List)successPkIds)) {
                this.getPageCache().put("newBillPkId", String.valueOf(successPkIds.get(0)));
            }
        }
        if ("deleteentry".equals(operateKey)) {
            this.recalcTotalAmt();
        }
        if ("submit".equals(operateKey) && (operationResult = afterDoOperationEventArgs.getOperationResult()).isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void validateProductProp(BeforeItemClickEvent evt) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material != null) {
            DynamicObject auxprop;
            String number = material.getString("number");
            if (BomRouterHelper.isEnableAuxprop((DynamicObject)material) && (auxprop = (DynamicObject)this.getModel().getValue("auxprop")) == null) {
                String tips = String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4ea7\u54c1\u201c%s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u3002", (String)"HalfPrdStructurePlugin_5", (String)"macc-sca-form", (Object[])new Object[0]), number);
                this.getView().showTipNotification(tips);
                evt.setCancel(true);
                return;
            }
        }
    }

    private void validateEntrySubMatProp(BeforeItemClickEvent evt) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity)) {
            return;
        }
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            return;
        }
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject submaterialauxprop;
            String type;
            DynamicObject dyn = (DynamicObject)entryentity.get(i);
            DynamicObject element = dyn.getDynamicObject("element");
            DynamicObject submaterial = dyn.getDynamicObject("submaterial");
            if (element != null && ("001".equals(type = element.getString("type")) || "002".equals(type))) {
                if (submaterial == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u6210\u672c\u8981\u7d20\u4e3a\u7269\u6599\u6216\u7269\u6599\u8d39\u7528\uff0c\u5b50\u9879\u7269\u6599\u5374\u4e3a\u7a7a\u7684\u5206\u5f55\u884c\u3002", (String)"HalfPrdStructurePlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                if (submaterial.getPkValue() == material.getPkValue()) {
                    this.getModel().setValue("isunabsorb", (Object)"B", i);
                }
            }
            if (submaterial == null) continue;
            String number = submaterial.getString("number");
            if (!BomRouterHelper.isEnableAuxprop((DynamicObject)submaterial) || (submaterialauxprop = dyn.getDynamicObject("submaterialauxprop")) != null) continue;
            String tips = String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7269\u6599\u201c%s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u3002", (String)"HalfPrdStructurePlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), number);
            this.getView().showTipNotification(tips);
            evt.setCancel(true);
            break;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        this.setMatVersionAndPropEnable(material);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        this.setPrdOrgVisible(org, costaccount);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity)) {
            return;
        }
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject row = (DynamicObject)entryentity.get(i);
            DynamicObject submaterial = row.getDynamicObject("submaterial");
            this.setSubMatVersionAndPropEnable(submaterial, i);
            DynamicObject element = row.getDynamicObject("element");
            this.setSubMatEnable(element, i);
        }
    }

    private void setPrdOrgVisible(DynamicObject org, DynamicObject costaccount) {
        if (org == null || costaccount == null) {
            return;
        }
        BasedataEdit prdorg = (BasedataEdit)this.getControl("prdorg");
        DynamicObject costParam = CostReductHelper.getCostParam((Long)org.getLong("id"), (Long)costaccount.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (costParam == null) {
            return;
        }
        String restoredimension = costParam.getString("restoredimension");
        String restoreCalcRange = costParam.getString("restorecalcrange");
        this.getPageCache().put("restoredimension", restoredimension);
        this.getPageCache().put("restoreCalcRange", restoreCalcRange);
        if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(restoredimension)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"prdorg"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"storageorgunit"});
            if (!restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) && !restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue())) {
                prdorg.setMustInput(true);
            } else {
                prdorg.setMustInput(false);
            }
        } else {
            this.getModel().setValue("prdorg", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"prdorg"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"storageorgunit"});
            prdorg.setMustInput(false);
        }
    }

    private boolean isShowProdOrg(Long orgId, Long costaccountId) {
        DynamicObject costParam = CostReductHelper.getCostParam((Long)orgId, (Long)costaccountId, (String)this.getView().getFormShowParameter().getAppId());
        if (costParam == null) {
            return false;
        }
        String restoredimension = costParam.getString("restoredimension");
        return SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(restoredimension);
    }

    private void setSubMatEnable(DynamicObject element, int rowIndex) {
        String type;
        if (element != null && !"001".equals(type = element.getString("type")) && !"002".equals(type)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"submaterial", "", "submaterialversion", "submaterialauxprop"});
        }
    }

    private void setSubMatVersionAndPropEnable(DynamicObject submaterial, int rowIndex) {
        if (submaterial == null) {
            return;
        }
        boolean isenablematerialversion = submaterial.getBoolean("isenablematerialversion");
        if (isenablematerialversion) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"submaterialversion"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"submaterialversion"});
        }
        boolean isuseauxpty = submaterial.getBoolean("isuseauxpty");
        if (isuseauxpty) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"submaterialauxprop"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"submaterialauxprop"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (("newentry".equals(operateKey) || "deleteentry".equals(operateKey) || "insertentry".equals(operateKey)) && !this.getModel().getDataEntity().getBoolean("ismodify")) {
            this.getModel().setValue("ismodify", (Object)Boolean.TRUE);
        }
    }
}

