/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.difftransfer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.sca.formplugin.difftransfer.DiffTransferCommon;

public class FinishDiffListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final String BAR_TRACKDOWN = "bar_trackdown";
    private static final String RD_TRACKDOWN = "rd_trackdown";

    @Override
    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BAR_TRACKDOWN});
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setStatus(OperationStatus.VIEW);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "rd_trackdown": {
                this.trackDown();
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
        e.setOrderBy("billno desc,entryentity.difftype asc,entryentity.subelement.number asc");
    }

    private void trackDown() {
        List orgList;
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        Long orgId = 0L;
        if (!StringUtils.isEmpty((String)acctOrg) && (orgList = (List)SerializationUtils.fromJsonString((String)acctOrg, List.class)) != null && !orgList.isEmpty()) {
            orgId = Long.parseLong(orgList.get(0).toString());
        }
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FinishDiffListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0b\u67e5\u7684\u6570\u636e\u3002", (String)"FinishDiffListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("calorg", "=", (Object)orgId));
        String costaccountId = this.getPageCache().get("costaccountId");
        if (StringUtils.isNotEmpty((String)costaccountId)) {
            qfList.add(new QFilter("costaccount", "=", (Object)Long.parseLong(costaccountId)));
        }
        HashSet billNos = new HashSet();
        selectedRows.forEach(p -> billNos.add(p.getBillNo()));
        qfList.add(new QFilter("entryentity.srcbillnum", "in", billNos));
        DynamicObjectCollection costAdjusts = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"id", (QFilter[])qfList.toArray(new QFilter[0]));
        if (costAdjusts != null && !costAdjusts.isEmpty()) {
            HashSet<Long> pkIds = new HashSet<Long>();
            costAdjusts.forEach(t -> pkIds.add(t.getLong("id")));
            DiffTransferCommon.showBillByPkId(this.getView(), "cal_stdcostdiffbill", pkIds, qfList);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u67e5\u7684\u5355\u636e\u3002", (String)"FinishDiffListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }
}

