/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.difftransfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.calc.InProduceCostHelper;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class InProduceCostListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private Log logger = LogFactory.getLog(InProduceCostListPlugin.class);
    private static final String closeBack_importResult = "importResult";

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setStatus(OperationStatus.VIEW);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        switch (evt.getOperateKey()) {
            case "importdatabyhand": {
                if (!evt.getOperationResult().isSuccess()) break;
                List<Object> orgIdList = this.getOrgCache();
                String org = null;
                if (orgIdList != null && !orgIdList.isEmpty()) {
                    org = String.valueOf(orgIdList.get(0));
                }
                String costAccount = this.getPageCache().get("costaccount");
                String periodId = this.getPageCache().get("period");
                if (CadEmptyUtils.isEmpty((String)costAccount) || CadEmptyUtils.isEmpty((String)periodId) || CadEmptyUtils.isEmpty((String)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u6216\u8005\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6210\u672c\u8d26\u7c3f\u548c\u671f\u95f4\u8fdb\u884c\u5bfc\u5165\u64cd\u4f5c\u3002", (String)"InProduceCostListPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                Long costAccountId = Long.parseLong(costAccount);
                DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                if (curPeriod == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u671f\u95f4\u5931\u8d25", (String)"InProduceCostListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isNotEmpty((CharSequence)periodId) && !periodId.equals(curPeriod.getString("id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5bf9\u975e\u5f53\u524d\u671f\u95f4\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InProduceCostListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                List<Object> manuorgs = new ArrayList(10);
                Long orgId = Long.parseLong(org);
                if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
                    manuorgs = this.getSelectManuOrg(orgId);
                }
                String progressId = UUID.randomUUID().toString();
                List<Object> finalManuorgs = manuorgs;
                ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"InProduceCostListPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]), () -> {
                    try {
                        InProduceCostHelper.importDataByHand((Long)orgId, (Long)costAccountId, (List)finalManuorgs, (Long)Long.parseLong(periodId), (String)progressId);
                        this.getPageCache().put("responseInfo", "success");
                    }
                    catch (Exception e) {
                        this.logger.error("\u5728\u5236\u6210\u672c\u7ed3\u8f6c\u5355-\u5bfc\u5165\u5931\u8d25\u3002", (Throwable)e);
                        this.getPageCache().put("responseInfo", "fail");
                    }
                }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
                break;
            }
            case "generatevoucher": {
                if (evt.getOperationResult().isSuccess()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u8be6\u60c5\u8bf7\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u3002", (String)"InProduceCostListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
    }

    private List<Long> getSelectManuOrg(Long orgId) {
        List<Long> manuorg = null;
        String manuorgStr = this.getPageCache().get("manuorg");
        if (StringUtils.isNotEmpty((CharSequence)manuorgStr)) {
            manuorg = Collections.singletonList(Long.valueOf(manuorgStr));
        }
        if (manuorg == null || manuorg.isEmpty() || manuorg.get(0) == null) {
            manuorg = new ArrayList<Long>(16);
            for (ComboItem item : ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))) {
                manuorg.add(Long.valueOf(item.getValue()));
            }
        }
        return manuorg;
    }

    @Override
    protected QFilter getManuOrgQFilter() {
        Long orgIdL;
        String orgId;
        QFilter manuOrgQf = null;
        String manuOrgId = this.getPageCache().get("manuorg");
        if (kd.bos.util.StringUtils.isEmpty((String)manuOrgId) && !kd.bos.util.StringUtils.isEmpty((String)(orgId = this.getPageCache().get("orgId"))) && OrgHelper.isOrgEnableMultiFactory((Long)(orgIdL = Long.valueOf(orgId)))) {
            List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgIdL, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            if (!CadEmptyUtils.isEmpty((List)userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter("manuorg", "in", (Object)userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter("manuorg", "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                if ("success".equals(responseInfoStr)) {
                    billList.refresh();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"InProduceCostListPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"InProduceCostListPlugin_14", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
        }
    }
}

