/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.equivalent;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class EquivalentEditPlugin
extends AbstractBillPlugIn {
    private static final String confirmCallBacks = "changeConfirmCallBacks";
    private static final String[] visFileName = new String[]{"bar_save", "advconbaritemap", "advconbaritemap1", "batchfillentry", "addrow", "deleterow", "batchfill"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1"});
        BasedataEdit costType = (BasedataEdit)this.getControl("manuorg");
        costType.addBeforeF7SelectListener(evt -> {
            List manuOrg;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg != null) {
                manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)createorg.getPkValue()), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorg");
                if (!ObjectUtils.isEmpty((Object)manuorg) && !CollectionUtils.isEmpty((Collection)manuOrg)) {
                    manuOrg.remove((Long)manuorg.getPkValue());
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EquivalentEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)manuOrg));
        });
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EquivalentEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter costAccountFilter = this.getCostAccountFilter(createorg);
            qFilters.add(costAccountFilter);
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg != null) {
                DynamicObject costAccount;
                Long orgId = createorg.getLong("id");
                boolean enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
                if (enableMultiFactory) {
                    DynamicObject manuOrg = (DynamicObject)this.getModel().getValue("manuorg");
                    if (manuOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"EquivalentEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    ArrayList<Long> manuList = new ArrayList<Long>(1);
                    manuList.add(manuOrg.getLong("id"));
                    Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)orgId, manuList, (String)this.getView().getFormShowParameter().getAppId());
                    qFilters.add(new QFilter("id", "in", (Object)centerIds));
                }
                if (CadEmptyUtils.isEmpty((DynamicObject)(costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"EquivalentEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EquivalentEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter showorgduty = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorg = new QFilter("accountorg", "=", createorg.getPkValue());
            qFilters.add(showorgduty);
            qFilters.add(calorg);
        });
        BasedataEdit beginperiod = (BasedataEdit)this.getControl("period");
        beginperiod.addBeforeF7SelectListener(evt -> {
            DynamicObject costAccount;
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EquivalentEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (CadEmptyUtils.isEmpty((DynamicObject)(costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"EquivalentEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter usePeriodFilter = this.getUsePeriodFilter(Long.valueOf(String.valueOf(accountOrg.getPkValue())), Long.valueOf(String.valueOf(costAccount.getPkValue())));
            if (usePeriodFilter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u201c\u542f\u7528\u6807\u51c6\u6838\u7b97\u201d\u4e2d\u672a\u627e\u5230\u53ef\u7528\u671f\u95f4,\u8bf7\u7ef4\u62a4\u542f\u7528\u6807\u51c6\u6838\u7b97\u6570\u636e\u3002", (String)"EquivalentEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            filterParameter.getQFilters().add(usePeriodFilter);
        });
        BasedataEdit costobject = (BasedataEdit)this.getControl("costobject");
        costobject.addBeforeF7SelectListener(evt -> {
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            if (period == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u671f\u95f4\u3002", (String)"EquivalentEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            int entryentity = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject costcenterData = this.getModel().getEntryRowEntity("entryentity", entryentity).getDynamicObject("costcenter");
            if (costcenterData == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u4e2d\u5fc3\u3002", (String)"EquivalentEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection entryentityData = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            List collect = entryentityData.stream().map(o -> o.getLong("costobject.id")).filter(o -> o != null).collect(Collectors.toList());
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            if (!CollectionUtils.isEmpty(collect)) {
                QFilter idQf = new QFilter("id", "not in", collect);
                qFilters.add(idQf);
            }
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            Set costObjectIds = CostObjectHelper.getSettlCostObject((Long)costAccount.getLong("id"));
            qFilters.add(new QFilter("id", "not in", (Object)costObjectIds));
            QFilter costcenterQf = new QFilter("costcenter", "=", costcenterData.getPkValue());
            qFilters.add(new QFilter("producttype", "=", (Object)"C"));
            qFilters.add(costcenterQf);
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public QFilter getUsePeriodFilter(Long orgId, Long costAccountId) {
        QFilter result = null;
        QFilter periodfilter = new QFilter("org", "=", (Object)orgId);
        periodfilter.and(new QFilter("entry.costaccount", "=", (Object)costAccountId));
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id acctid,entry.calpolicy.periodtype periodtype,entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        if (cal_sysctrlentity.size() > 0) {
            DynamicObject periodDO = (DynamicObject)cal_sysctrlentity.get(0);
            result = new QFilter("periodtype", "=", (Object)periodDO.getLong("periodtype"));
            if (periodDO.get("startperiod") != null) {
                result.and(new QFilter("id", ">=", (Object)periodDO.getLong("startperiod")));
            }
            if (periodDO.get("currentperiod") != null) {
                result.and(new QFilter("id", "<=", (Object)periodDO.getLong("currentperiod")));
            }
        }
        return result;
    }

    private QFilter getCostAccountFilter(DynamicObject org) {
        ArrayList<Long> costaccountIds = new ArrayList<Long>();
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter isStartStdCostFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"sca");
        QFilter isinitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        DynamicObjectCollection costaccounts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id", (QFilter[])new QFilter[]{orgFilter, isStartStdCostFilter, qfAppNum, isinitFilter});
        for (DynamicObject costaccount : costaccounts) {
            costaccountIds.add(costaccount.getLong("id"));
        }
        return new QFilter("id", "in", costaccountIds);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        this.getModel().beginInit();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String acctOrg = (String)formShowParameter.getCustomParam("orgId");
        if (acctOrg != null) {
            this.getModel().setValue("org", (Object)acctOrg);
        }
        if (parentView != null) {
            String costaccount;
            String manuorg = parentView.getPageCache().get("manuorgMine");
            if (manuorg != null && this.getModel().getValue("manuorg") == null && this.checkManuOrg(acctOrg, manuorg)) {
                this.getModel().setValue("manuorg", (Object)manuorg);
            }
            if ((costaccount = parentView.getPageCache().get("costaccountMine")) != null && this.getModel().getValue("costaccount") == null && this.checkCostAccount(acctOrg, costaccount)) {
                this.getModel().setValue("costaccount", (Object)costaccount);
            }
            if ("copy".equals(parentView.getPageCache().get("copy")) || "copy".equals(this.getView().getPageCache().get("copy"))) {
                this.setPeriod();
            }
        }
        this.getModel().endInit();
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        Boolean flag = true;
        if (period == null) {
            this.setPeriod();
        } else {
            Long periodId = period.getLong("id");
            Long currPeriodId = this.getCurrPeriod();
            if (currPeriodId.compareTo(periodId) != 0) {
                this.getView().setStatus(OperationStatus.VIEW);
                flag = false;
            }
        }
        this.getView().setVisible(flag, visFileName);
        this.getModel().setDataChanged(false);
        int i = 0;
        DynamicObjectCollection entryentity = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : entryentity) {
            if (obj.getString("totalvalen") != null && !obj.getString("totalvalen").equals(obj.getString("diffcalctotalvalen"))) {
                this.getPageCache().put("diffCalcIsMannual" + i, "1");
            }
            ++i;
        }
    }

    private boolean checkCostAccount(String acctOrg, String costaccount) {
        Long calorgid;
        if (acctOrg == null || costaccount == null || "".equals(costaccount)) {
            return false;
        }
        DynamicObject costAccountData = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg.id as calorgid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(costaccount))});
        return costAccountData != null && (calorgid = Long.valueOf(costAccountData.getLong("calorgid"))) != null && calorgid == Long.parseLong(acctOrg);
    }

    private boolean checkManuOrg(String acctOrg, String manuorg) {
        if (acctOrg == null || manuorg == null || "".equals(manuorg)) {
            return false;
        }
        List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)Long.parseLong(acctOrg), (boolean)true);
        return productOrgs.contains(Long.parseLong(manuorg));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().beginInit();
        this.changeManuorgStatus();
        this.getModel().endInit();
    }

    private Long getCurrPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return 0L;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return 0L;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        QFilter isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter});
        if (res != null) {
            return res.getLong("currentperiod");
        }
        return 0L;
    }

    private void changeManuorgStatus() {
        Object costaccount = this.getModel().getValue("org");
        BasedataEdit manuorg = (BasedataEdit)this.getView().getControl("manuorg");
        if (!ObjectUtils.isEmpty((Object)costaccount)) {
            DynamicObject costaccountData = (DynamicObject)costaccount;
            boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)((Long)costaccountData.getPkValue()));
            if (enableMulFactory) {
                manuorg.setMustInput(true);
            } else {
                manuorg.setMustInput(false);
                this.getModel().setValue("manuorg", null);
            }
            this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
            manuorg.setMustInput(false);
            this.getModel().setValue("manuorg", null);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "batchfillentry": {
                this.batchFill(this.getView(), "entryentity", new String[]{"totalvalen", "diffcalctotalvalen"});
                this.setBatchCostDriverDetail();
                break;
            }
            case "batchfill": {
                this.batchFill(this.getView(), "entryentitydetail", new String[]{"detailvalen", "diffcalcdetailvalen"});
            }
        }
    }

    private void batchFill(IFormView view, String entryName, String[] needFillFields) {
        IDataModel model = view.getModel();
        int currentRow = model.getEntryCurrentRowIndex(entryName);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryName);
        String selKey = entryGrid.getEntryState().getFocusField();
        List<String> needFillFieldList = Arrays.asList(needFillFields);
        if (!needFillFieldList.contains(selKey)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u5217\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002", (String)"EquivalentEditPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        if (currentRow == -1 || CadEmptyUtils.isEmpty((String)selKey) || "0".equals(selKey)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u5143\u683c\u3002", (String)"EquivalentEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        Object selValue = model.getValue(selKey, currentRow);
        if (selValue == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u9009\u62e9\u503c\u586b\u5145\u3002", (String)"EquivalentEditPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        int rowCount = model.getEntryRowCount(entryName);
        for (int i = currentRow + 1; i < rowCount; ++i) {
            model.setValue(selKey, selValue, i);
        }
    }

    private void setBatchCostDriverDetail() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection allocEntrys = billObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject allocEntry : allocEntrys) {
            Object totalvalen = allocEntry.get("totalvalen");
            DynamicObjectCollection productSubEntrys = allocEntry.getDynamicObjectCollection("entryentitydetail");
            for (DynamicObject productSubEntry : productSubEntrys) {
                BigDecimal detailvalen = (BigDecimal)productSubEntry.get("detailvalen");
                if (!ObjectUtils.isEmpty((Object)detailvalen) && BigDecimal.ZERO.compareTo(detailvalen) != 0) continue;
                productSubEntry.set("detailvalen", totalvalen);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fileName;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (fileName = e.getProperty().getName()) {
            case "costobject": {
                Object costcenter1 = this.getModel().getValue("costcenter", index);
                if (costcenter1 == null && index > 0) {
                    Object costcenter = this.getModel().getValue("costcenter", index - 1);
                    this.getModel().setValue("costcenter", costcenter, index);
                }
                Long materialId = null;
                Long auxptyId = null;
                if (newValue != null) {
                    materialId = ((DynamicObject)newValue).getLong("material.id");
                    auxptyId = ((DynamicObject)newValue).getLong("auxpty.id");
                }
                this.getModel().setValue("costobject", newValue, index);
                this.getModel().setValue("material", (Object)materialId, index);
                this.getModel().setValue("auxpty", (Object)auxptyId, index);
                this.getModel().setValue("totalvalen", null, index);
                changeData.getDataEntity().getDynamicObjectCollection("entryentitydetail").clear();
                this.getView().updateView("entryentitydetail");
                break;
            }
            case "totalvalen": {
                String diffCalcIsMannual = this.getPageCache().get("diffCalcIsMannual" + index);
                if ("1".equals(diffCalcIsMannual)) break;
                this.getPageCache().put("costdriverMannual", "1");
                this.getModel().setValue("diffcalctotalvalen", newValue, index);
                break;
            }
            case "diffcalctotalvalen": {
                if (!"1".equals(this.getPageCache().get("costdriverMannual"))) {
                    int allocentryRowIndex1 = this.getModel().getEntryCurrentRowIndex("allocentry");
                    this.getPageCache().put("diffCalcIsMannual" + allocentryRowIndex1, "1");
                    break;
                }
                this.getPageCache().remove("costdriverMannual");
                break;
            }
            case "costaccount": {
                this.setPeriod();
            }
            case "manuorg": {
                if (ObjectUtils.isEmpty((Object)oldValue) || oldValue.equals(newValue)) {
                    return;
                }
                this.getView().getPageCache().put("fileName", fileName);
                this.getView().getPageCache().put("oldFileValue", newValue == null ? null : String.valueOf(((DynamicObject)oldValue).getPkValue()));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u751f\u4ea7\u7ec4\u7ec7\\\u6210\u672c\u8d26\u7c3f\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"EquivalentEditPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(confirmCallBacks));
                break;
            }
            case "subelement": {
                QFilter subElementIdFilter;
                DynamicObject elementAndSubelement;
                if (newValue != null && (elementAndSubelement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{subElementIdFilter = new QFilter("subelement", "=", ((DynamicObject)newValue).getPkValue())})) != null) {
                    this.getModel().setValue("element", (Object)elementAndSubelement.getLong("element"), index);
                    this.getView().updateView("element", index);
                }
                if (newValue == null || !"001".equals(((DynamicObject)newValue).getString("type"))) {
                    this.getModel().setValue("diffcalcdetailvalen", (Object)0, index);
                    break;
                }
                if (!"001".equals(((DynamicObject)newValue).getString("type"))) break;
                this.getModel().setValue("diffcalcdetailvalen", this.getModel().getValue("detailvalen", index), index);
                break;
            }
            case "detailvalen": {
                String diffSubCalcIsMannual;
                DynamicObject subElementDy;
                if (newValue == null || (subElementDy = (DynamicObject)this.getModel().getValue("subelement", index)) == null || !"001".equals(subElementDy.getString("type")) || "1".equals(diffSubCalcIsMannual = this.getPageCache().get("diffCalcIsMannual" + index))) break;
                this.getModel().setValue("diffcalcdetailvalen", newValue, index);
                this.getView().updateView("diffcalcdetailvalen", index);
                break;
            }
            case "diffcalcdetailvalen": {
                if (newValue == null) break;
                DynamicObject subElementDy = (DynamicObject)this.getModel().getValue("subelement", index);
                if (subElementDy == null) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"EquivalentEditPlugin_14", (String)"macc-sca-form", (Object[])new Object[0]), String.valueOf(index + 1)));
                    this.getModel().beginInit();
                    this.getModel().setValue("diffcalcdetailvalen", (Object)0, index);
                    this.getModel().endInit();
                    break;
                }
                String type = subElementDy.getString("type");
                if ("001".equals(type)) break;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\uff0c\u5c5e\u6027\u4e0d\u4e3a\u7269\u6599\uff0c\u5dee\u5f02\u5206\u644a\u660e\u7ec6\u5206\u914d\u6807\u51c6\u53ea\u652f\u6301\u7269\u6599\u7c7b\u578b\u7684\u5b50\u8981\u7d20\u3002", (String)"EquivalentEditPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]), String.valueOf(index + 1)));
                this.getModel().beginInit();
                this.getModel().setValue("diffcalcdetailvalen", (Object)0, index);
                this.getModel().endInit();
                break;
            }
            case "org": {
                this.changeManuorgStatus();
                break;
            }
            case "costcenter": {
                this.getModel().setValue("costobject", null, index);
                this.getModel().setValue("totalvalen", null, index);
                changeData.getDataEntity().getDynamicObjectCollection("entryentitydetail").clear();
                this.getView().updateView("entryentitydetail");
                break;
            }
        }
    }

    private void setPeriod() {
        Long currPeriod = this.getCurrPeriod();
        if (currPeriod == 0L) {
            this.getModel().setValue("period", null);
        } else {
            this.getModel().setValue("period", (Object)currPeriod);
            this.getView().updateView("period");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("copy".equals(operateKey)) {
            this.getView().getPageCache().put("copy", "copy");
        } else {
            this.getView().getPageCache().put("copy", null);
        }
        switch (operateKey) {
            case "new": {
                boolean flag = PermissionServiceHelper.hasNewPermission((long)RequestContext.get().getCurrUserId(), (String)"sca", (String)"sca_equivalent");
                if (flag) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7ea6\u5f53\u7cfb\u6570\u5904\u7406\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"EquivalentEditPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "save": {
                Object manuorg;
                boolean enableMulFactory;
                DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
                if (costaccount != null && (enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)((Long)costaccount.getPkValue()))) && (manuorg = this.getModel().getValue("manuorg")) == null) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"EquivalentEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                this.checkSaveValue(e);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "changeConfirmCallBacks": {
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    this.getModel().deleteEntryData("entryentity");
                    this.getModel().deleteEntryData("entryentitydetail");
                    break;
                }
                String fileName = this.getPageCache().get("fileName");
                this.getModel().beginInit();
                this.getModel().setValue(fileName, (Object)this.getPageCache().get("oldFileValue"));
                this.getModel().endInit();
                this.getView().updateView(fileName);
                if (!"org".equals(fileName)) break;
                this.changeManuorgStatus();
            }
        }
    }

    private void checkSaveValue(BeforeDoOperationEventArgs e) {
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity) || entryentity.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u586b\u5199\u7efc\u5408\u7ea6\u5f53\u7cfb\u6570\u548c\u660e\u7ec6\u7ea6\u5f53\u7cfb\u6570,\u8bf7\u586b\u5199\u5b8c\u6574\u3002", (String)"EquivalentEditPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }
}

