/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.equivalent;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.enums.PermitItemEnum;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class EquivalentListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private static final Log logger = LogFactory.getLog(EquivalentListPlugin.class);

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.startsWith("manuorg.")) continue;
            String useOrg = this.getPageCache().get("org");
            if (useOrg != null) {
                List orgList = JSON.parseArray((String)useOrg, String.class);
                useOrg = (String)orgList.get(0);
            }
            String filterFlag = this.getPageCache().get("filterFlag");
            if (!StringUtils.isNotEmpty((CharSequence)useOrg) || !"yes".equals(filterFlag) && StringUtils.isNotEmpty((CharSequence)filterFlag)) continue;
            List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(useOrg), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            if (!CollectionUtils.isEmpty((Collection)manuOrg)) {
                logger.info("\u751f\u4ea7\u7ec4\u7ec7 " + manuOrg);
                DynamicObject[] loadData = BusinessDataServiceHelper.load((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)manuOrg)});
                for (int i = 0; i < loadData.length; ++i) {
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(new LocaleString(loadData[i].getString("name")));
                    comboItem.setValue(String.valueOf(loadData[i].getPkValue()));
                    comboItems.add(comboItem);
                }
                ((CommonFilterColumn)filterColumn).setComboItems(comboItems);
            } else {
                ((CommonFilterColumn)filterColumn).setComboItems(comboItems);
                ((CommonFilterColumn)filterColumn).setDefaultValue("");
            }
            this.getPageCache().put("filterFlag", "no");
        }
    }

    public void setFilter(SetFilterEvent e) {
        List<Object> orgCache = this.getOrgCache();
        if (CadEmptyUtils.isEmpty(orgCache)) {
            List qFilters = e.getQFilters();
            qFilters.add(new QFilter("org", "=", (Object)0L));
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            List customfilter = (List)filterValues.get("customfilter");
            if (customfilter == null || customfilter.isEmpty()) {
                return;
            }
            for (int i = 0; i < customfilter.size(); ++i) {
                Map filter = (Map)customfilter.get(i);
                List listValue = (List)filter.get("Value");
                List listFieldName = (List)filter.get("FieldName");
                block9: for (int j = 0; j < listFieldName.size(); ++j) {
                    String fieldName;
                    switch (fieldName = (String)listFieldName.get(j)) {
                        case "manuorg.id": {
                            this.getPageCache().put("manuorgMine", (String)listValue.get(j));
                            this.getPageCache().put("filterFlag", "yes");
                            this.filterContainerInit(this.filterContainerInitArgs);
                            continue block9;
                        }
                        case "costaccount.id": {
                            this.getPageCache().put("costaccountMine", (String)listValue.get(j));
                        }
                    }
                }
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"tblnew"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        if ("tblnew".equals(itemkey) && StringUtils.isEmpty((CharSequence)this.getPageCache().get(this.ORG_FIELD))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u4e0d\u80fd\u6267\u884c\u65b0\u589e\u64cd\u4f5c\u3002", (String)"EquivalentListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("copy".equals(operateKey)) {
            this.getView().getPageCache().put("copy", "copy");
        } else {
            this.getView().getPageCache().put("copy", null);
        }
        switch (operateKey) {
            case "new": {
                List orgList;
                Long orgId;
                boolean flag;
                String useOrg = this.getPageCache().get("org");
                if (useOrg == null || (flag = PermissionHelper.checkPermission((String)"sca", (long)(orgId = Long.valueOf(Long.parseLong(useOrg = (String)(orgList = JSON.parseArray((String)useOrg, String.class)).get(0)))), (String)"sca_equivalent", (String)PermitItemEnum.ITEM_NEW.getKey()))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7ea6\u5f53\u7cfb\u6570\u5904\u7406\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"EquivalentListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }
}

