/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.alloc.MatAllocHelper;
import kd.macc.sca.algox.utils.ElementHelper;
import kd.macc.sca.algox.utils.MatCostHelper;
import kd.macc.sca.common.enums.ScaAllocEnum;

public class MatAllocateEditPlugin
extends AbstractBillPlugIn {
    public void initialize() {
        super.initialize();
        BasedataEdit entryCostObject = (BasedataEdit)this.getControl("costobejctentry");
        entryCostObject.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                List filters = MatAllocateEditPlugin.this.getEntryCostObjectFilters();
                filters.add(new QFilter("material", "!=", (Object)MatAllocateEditPlugin.this.getPkVal("material")));
                filters.add(new QFilter("costcenter", "=", (Object)MatAllocateEditPlugin.this.getPkVal("costcenter")));
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.addAll(filters);
            }
        });
        BasedataEdit costDriver = (BasedataEdit)this.getControl("costdriver");
        costDriver.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("allocclass", "=", (Object)"COSTOBJECT"));
                filters.add(new QFilter("appnum", "=", (Object)MatAllocateEditPlugin.this.getView().getFormShowParameter().getAppId()));
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.addAll(filters);
            }
        });
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)(org == null ? 0L : org.getLong("id")), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            QFilter orgFilter = new QFilter("id", "in", (Object)manuorgList);
            formShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private List<QFilter> getEntryCostObjectFilters() {
        ArrayList costObjectIds = new ArrayList();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        entrys.forEach(s -> {
            if (s.getDynamicObject("costobejctentry") != null) {
                costObjectIds.add(s.getDynamicObject("costobejctentry").getLong("id"));
            }
        });
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("id", "not in", costObjectIds));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        filters.add(new QFilter("bizstatus", "=", (Object)"A"));
        return filters;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap"});
        this.addClickListeners(new String[]{"costdriver"});
    }

    public void beforeBindData(EventObject e) {
        long baseunitId;
        DynamicObject materialDyn;
        super.beforeBindData(e);
        DynamicObject baseunitDyn = this.getModel().getDataEntity().getDynamicObject("baseunit");
        if (baseunitDyn == null && (materialDyn = this.getModel().getDataEntity().getDynamicObject("material")) != null && (baseunitId = materialDyn.getLong("baseunit.id")) != 0L) {
            this.getModel().setValue("baseunit", (Object)baseunitId);
            this.getModel().setDataChanged(false);
            this.updateBaseunit(this.getModel().getDataEntity().getLong("id"), baseunitId);
        }
        DynamicObjectCollection dynObjCols = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject dyn : dynObjCols) {
            DynamicObject costobject = dyn.getDynamicObject("costobejctentry");
            if (costobject == null) continue;
            dyn.set("costobjectmat", (Object)costobject.getDynamicObject("material"));
            dyn.set("costobjectauxpty", (Object)costobject.getDynamicObject("auxpty"));
            this.getModel().setDataChanged(false);
        }
    }

    private void updateBaseunit(long fid, long baseunitId) {
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)"sca_matalloc");
        String updateSql = "update %s set fbaseunitid=? where fid = ?";
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(1);
        SqlParameter[] params = new SqlParameter[]{new SqlParameter("baseunitid", -5, (Object)baseunitId), new SqlParameter("id", -5, (Object)fid)};
        paramsList.add(params);
        String sql = String.format(updateSql, mt.getAlias());
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramsList);
    }

    public void afterBindData(EventObject e) {
        String costdriverId;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"subentryentity"});
        this.disableFields();
        String viewOnly = (String)this.getView().getFormShowParameter().getCustomParam("viewOnly");
        if ("view".equalsIgnoreCase(viewOnly)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_confirm", "bar_allocate"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"add_row", "del_row"});
        }
        this.changManuorgStatus();
        DynamicObject costobject = this.getModel().getDataEntity().getDynamicObject("costobject");
        if (costobject != null) {
            return;
        }
        DynamicObject costdriver = this.getModel().getDataEntity().getDynamicObject("costdriver");
        String newstd = this.getPageCache().get("newDriverId");
        String newstdName = this.getPageCache().get("newDriverName");
        if (costdriver == null && CadEmptyUtils.isEmpty((String)newstd)) {
            String tips = ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5206\u914d\u6807\u51c6\u3002", (String)"MatAllocateEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
            this.getView().showErrorNotification(tips);
            return;
        }
        String string = costdriverId = costdriver == null ? "" : costdriver.getString("id");
        if (kd.bos.util.StringUtils.isNotEmpty((String)newstd) && !costdriverId.equals(newstd) && kd.bos.util.StringUtils.isNotEmpty((String)newstdName)) {
            this.getPageCache().remove("newDriverId");
            this.getPageCache().remove("newDriverName");
            String tips = String.format(ResManager.loadKDString((String)"\u6240\u9009\u5206\u914d\u6807\u51c6%s\u6ca1\u6709\u5bf9\u5e94\u7684\u5206\u914d\u6807\u51c6\u503c\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u8fdb\u884c\u4fee\u6539\u5206\u914d\u6807\u51c6\u3002", (String)"MatAllocateEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]), newstdName);
            this.getView().showErrorNotification(tips);
            return;
        }
    }

    private void disableFields() {
        DynamicObject mainData = this.getModel().getDataEntity();
        String allocStatus = mainData.getString("allocstatus");
        boolean isConfirm = "2".equals(allocStatus);
        this.getView().setEnable(Boolean.valueOf(!isConfirm), new String[]{"contentpanelflex", "bar_confirm"});
        this.getView().setVisible(Boolean.valueOf(!isConfirm), new String[]{"bar_allocate"});
        boolean isCommonMat = this.isCommonMaterial();
        this.getView().setEnable(Boolean.valueOf(isCommonMat), new String[]{"costdriver", "entryentity"});
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String tips = null;
        switch (e.getItemKey()) {
            case "add_row": {
                if (this.isCommonMaterial()) break;
                tips = ResManager.loadKDString((String)"\u4e0d\u80fd\u589e\u884c\u3002\u4e0d\u662f\u5171\u8017\u6750\u6599\u3002", (String)"MatAllocateEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]);
                break;
            }
            case "del_row": {
                if (this.isCommonMaterial()) break;
                tips = ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u884c\u3002\u4e0d\u662f\u5171\u8017\u6750\u6599\u3002", (String)"MatAllocateEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]);
                break;
            }
            case "bar_confirm": {
                String useType = (String)this.getModel().getValue("usetype");
                boolean isDirMat = ScaAllocEnum.USETYPE_DRIECT.getValue().equals(useType);
                if (isDirMat || this.check(ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u3002", (String)"MatAllocateEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]))) break;
                e.setCancel(true);
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty(tips)) {
            this.getView().showTipNotification(tips);
            e.setCancel(true);
        }
    }

    private boolean isCommonMaterial() {
        DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject");
        return costObject == null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        if ("op_confirm".equals(formOperate.getOperateKey()) && this.getModel().getDataChanged()) {
            this.getModel().setValue("alloctype", (Object)ScaAllocEnum.ALLOCTYPE_MANUAL.getValue());
        }
        if ("op_allocate".equals(formOperate.getOperateKey())) {
            this.manualAlloc();
            e.setCancel(true);
        }
    }

    private boolean check(String opTypeErr) {
        DynamicObject costdriver = this.getModel().getDataEntity().getDynamicObject("costdriver");
        if (costdriver == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5206\u914d\u6807\u51c6\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5206\u914d\u6807\u51c6\u3002", (String)"MatAllocateEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]), opTypeErr));
            return false;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6\u503c\u3002", (String)"MatAllocateEditPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]), opTypeErr));
            return false;
        }
        for (DynamicObject row : entrys) {
            if (row.getDynamicObject("costobejctentry") == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u5206\u914d\u660e\u7ec6\u884c\u6b21\u7684\u6240\u5c5e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"MatAllocateEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), opTypeErr));
                return false;
            }
            if (!CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("allocvalue"))) continue;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u5206\u914d\u660e\u7ec6\u884c\u6b21\u7684\u5206\u914d\u6807\u51c6\u503c\u4e3a\u7a7a\u6216\u8005\u4e3a0\u3002", (String)"MatAllocateEditPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), opTypeErr));
            return false;
        }
        return true;
    }

    private void manualAlloc() {
        BigDecimal amount;
        BigDecimal qty;
        String useType = (String)this.getModel().getValue("usetype");
        boolean isDirMat = ScaAllocEnum.USETYPE_DRIECT.getValue().equals(useType);
        if (isDirMat) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u627e\u5230\u6240\u5c5e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u65e0\u9700\u518d\u6b21\u5206\u914d\u3002", (String)"MatAllocateEditPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        if (!this.check(ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002", (String)"MatAllocateEditPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]))) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject manuorg = this.getModel().getDataEntity().getDynamicObject("manuorg");
        Long orgId = org.getLong("id");
        Long manuOrgId = 0L;
        if (manuorg != null) {
            manuOrgId = manuorg.getLong("id");
        }
        int currencyPrecision = this.getModel().getDataEntity().getDynamicObject("currency").getInt("amtprecision");
        BigDecimal useAmount = this.getModel().getDataEntity().getBigDecimal("useamount");
        BigDecimal useQty = this.getModel().getDataEntity().getBigDecimal("useqty");
        int matUnitPrecision = 0;
        DynamicObject materialDyn = this.getModel().getDataEntity().getDynamicObject("material");
        if (materialDyn != null && materialDyn.getDynamicObject("baseunit") != null) {
            matUnitPrecision = materialDyn.getDynamicObject("baseunit").getInt("precision");
        }
        DynamicObject mainItem = this.getModel().getDataEntity();
        DynamicObjectCollection entrys = mainItem.getDynamicObjectCollection("entryentity");
        BigDecimal totalAllocVal = BigDecimal.ZERO;
        BigDecimal maxVal = null;
        for (DynamicObject row : entrys) {
            BigDecimal val = row.getBigDecimal("allocvalue");
            if (maxVal == null || maxVal.compareTo(val) < 0) {
                maxVal = val;
            }
            totalAllocVal = totalAllocVal.add(val);
        }
        int maxIndex = -1;
        int index = 0;
        BigDecimal maxQty = BigDecimal.ZERO;
        BigDecimal maxAmount = BigDecimal.ZERO;
        BigDecimal amountDiff = useAmount;
        BigDecimal qtyDiff = useQty;
        BigDecimal allocAmount = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            BigDecimal rate = entry.getBigDecimal("allocvalue").divide(totalAllocVal, 12, 4);
            qty = useQty.multiply(rate).setScale(matUnitPrecision, 4);
            amount = entry.getBigDecimal("price").multiply(qty).setScale(currencyPrecision, 4);
            entry.set("qty", (Object)qty);
            entry.set("amount", (Object)amount);
            allocAmount = allocAmount.add(amount);
            if (entry.getBigDecimal("allocvalue").compareTo(maxVal) == 0) {
                maxIndex = index;
                maxQty = qty;
                maxAmount = amount;
            }
            qtyDiff = qtyDiff.subtract(qty);
            amountDiff = amountDiff.subtract(amount, MathContext.UNLIMITED);
            ++index;
        }
        if (maxIndex >= 0) {
            this.getModel().setValue("qty", (Object)maxQty.add(qtyDiff), maxIndex);
            this.getModel().setValue("amount", (Object)maxAmount.add(amountDiff), maxIndex);
        }
        mainItem.set("alloctype", (Object)ScaAllocEnum.ALLOCTYPE_MANUAL.getValue());
        mainItem.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
        mainItem.set("allocatedate", (Object)new Date());
        mainItem.set("alloctor", (Object)RequestContext.get().getCurrUserId());
        mainItem.set("usetype", (Object)ScaAllocEnum.USETYPE_PUBLIC.getValue());
        index = 0;
        String subMatInfo = this.getPkVal("material") + "@" + this.getPkVal("matversion") + "@" + this.getPkVal("auxpty");
        for (DynamicObject row : entrys) {
            qty = row.getBigDecimal("qty");
            amount = row.getBigDecimal("amount");
            this.setEntryElementInfo(index, row, subMatInfo, qty, amount, orgId, manuOrgId);
            ++index;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainItem});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"MatAllocateEditPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void setEntryElementInfo(int index, DynamicObject entry, String subMatInfo, BigDecimal qty, BigDecimal amount, Long orgId, Long manuOrgId) {
        Long costObjectEntryId = entry.getDynamicObject("costobejctentry").getLong("id");
        if (CadEmptyUtils.isEmpty((Long)costObjectEntryId)) {
            return;
        }
        DynamicObject mainItem = this.getModel().getDataEntity();
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        costObjectIds.add(costObjectEntryId);
        Map elementinfos = ElementHelper.getElementInfos(costObjectIds, (String)subMatInfo, (Date)mainItem.getDate("bizdate"), (Long)this.getPkVal("costaccount"), (Long)orgId, (Long)manuOrgId);
        String[] elements = ((String)elementinfos.get(String.valueOf(costObjectEntryId))).split("@");
        if (elements != null && elements.length > 1) {
            entry.set("elemententry", (Object)elements[0]);
            entry.set("subelemententry", (Object)elements[1]);
        }
        Long matCostInfoId = mainItem.getLong("matcostinfo");
        HashSet<Long> ids = new HashSet<Long>(16);
        ids.add(matCostInfoId);
        Map costInfoMap = MatCostHelper.getMatCostInfo(ids, (String[])new String[]{"2", "3"}, (Long)this.getPkVal("costaccount"));
        Map subMatCostInfo = (Map)costInfoMap.get(String.valueOf(matCostInfoId));
        if (!CadEmptyUtils.isEmpty((Map)subMatCostInfo)) {
            DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
            subEntrys.clear();
            for (Map.Entry entrySet : subMatCostInfo.entrySet()) {
                BigDecimal unitqty = (BigDecimal)((List)entrySet.getValue()).get(0);
                BigDecimal price = (BigDecimal)((List)entrySet.getValue()).get(1);
                Object[] subelements = ((String)entrySet.getKey()).split("@");
                if (CadEmptyUtils.isEmpty((Object[])subelements)) continue;
                DynamicObject subvEntry = subEntrys.addNew();
                subvEntry.set("element", subelements[0]);
                subvEntry.set("subelement", subelements[1]);
                subvEntry.set("submaterial", subelements[2]);
                subvEntry.set("submatverison", subelements[3]);
                subvEntry.set("subauxpty", subelements[4]);
                subvEntry.set("resource", subelements[6]);
                subvEntry.set("calcbasis", subelements[7]);
                subvEntry.set("subqty", (Object)unitqty.multiply(qty));
                subvEntry.set("standardcost", (Object)price);
                subvEntry.set("standardamt", (Object)price.multiply(qty));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        switch (e.getOperateKey()) {
            case "op_confirm": 
            case "op_unconfirm": {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (e.getProperty().getName()) {
            case "costdriver": {
                if (newValue == null) {
                    this.cleanAllocValue();
                    return;
                }
                String id = ((DynamicObject)newValue).getString("id");
                if (StringUtils.equals((CharSequence)id, (CharSequence)this.getPageCache().get("oldDriverId"))) {
                    return;
                }
                String tips = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u914d\u6807\u51c6\u4f1a\u91cd\u65b0\u5206\u914d\u3002\u786e\u8ba4\u8c03\u6574\uff1f", (String)"MatAllocateEditPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]);
                this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("allocConfim"));
                this.getPageCache().put("newDriverName", ((DynamicObject)newValue).getString("name"));
                this.getPageCache().put("newDriverId", id);
                break;
            }
            case "org": {
                this.changManuorgStatus();
                break;
            }
            case "costobejctentry": {
                if (newValue == null) {
                    this.getModel().setValue("costobjectmat", null, index);
                    this.getModel().setValue("costobjectauxpty", null, index);
                    break;
                }
                DynamicObject costobject = (DynamicObject)newValue;
                this.getModel().setValue("costobjectmat", (Object)costobject.getDynamicObject("material"), index);
                this.getModel().setValue("costobjectauxpty", (Object)costobject.getDynamicObject("auxpty"), index);
            }
        }
    }

    private void cleanAllocValue() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue("allocvalue", null, i);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (!"allocConfim".equals(e.getCallBackId())) {
            return;
        }
        if ("yes".equalsIgnoreCase(e.getResultValue())) {
            DynamicObject mainData = this.getModel().getDataEntity();
            MatAllocHelper.doAlloc((DynamicObject)mainData);
            this.getView().invokeOperation("refresh");
        }
        super.confirmCallBack(e);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        Long typeId = this.getModel().getDataEntity().getLong("matcostinfo");
        BigDecimal amount = MatCostHelper.getMatStdPrice((Long)typeId);
        int index = this.getModel().getEntryRowCount("entryentity") - 1;
        if (index > -1) {
            this.getModel().setValue("price", (Object)amount, index);
        }
    }

    private long getPkVal(String field) {
        DynamicObject mainItem = this.getModel().getDataEntity();
        DynamicObject item = mainItem.getDynamicObject(field);
        return Optional.ofNullable(item).map(s -> s.getLong("id")).orElse(0L);
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

