/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MatAllocDataHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.output.AllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.MessgeBoxUtils;
import kd.macc.sca.algox.alloc.MatAllocHelper;
import kd.macc.sca.algox.alloc.ScaMatAllocHelper;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class MatAllocateListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final Log logger = LogFactory.getLog(MatAllocateListPlugin.class);
    private boolean isFirstInitFilterByMainPage = false;
    private boolean isfirstSetFilterByMainPage = false;
    private static final String closeBack_doImport = "doImport";
    private static final String closeBack_importResult = "importResult";

    public MatAllocateListPlugin() {
        this.isCostAccountDef = Boolean.FALSE;
    }

    @Override
    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        if (CadEmptyUtils.isEmpty(orgId)) {
            return null;
        }
        return StartCostHelper.getCostAccountItems((Long)Long.valueOf(orgId.get(0).toString()), null, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    public void setFilter(SetFilterEvent e) {
        FormShowParameter formShowParameter;
        Map paramMap;
        super.setFilter(e);
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
        if (AppIdHelper.isMacc((IFormView)this.getView())) {
            e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
        }
        boolean hasAccount = false;
        for (QFilter filter : e.getQFilters()) {
            if (!"costaccount.id".equals(filter.getProperty())) continue;
            hasAccount = true;
            break;
        }
        if (!hasAccount && AppIdHelper.isMacc((IFormView)this.getView())) {
            e.getQFilters().add(new QFilter("costaccount", "=", (Object)0L));
        }
        if (this.isMatchCondition(paramMap = (formShowParameter = this.getView().getFormShowParameter()).getCustomParams()) && this.isfirstSetFilterByMainPage) {
            String filterStr = (String)paramMap.get("filter");
            if (StringUtils.isNotBlank((CharSequence)filterStr)) {
                QFilter filter = QFilter.fromSerializedString((String)filterStr);
                e.getQFilters().clear();
                e.getQFilters().add(filter);
            }
            this.isfirstSetFilterByMainPage = false;
        }
    }

    private boolean isMatchCondition(Map<String, Object> paramMap) {
        boolean flag = false;
        String key = (String)paramMap.get("source");
        if ("GardHomePlugin".equals(key)) {
            flag = true;
        }
        return flag;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.isFirstInitFilterByMainPage = true;
        this.isfirstSetFilterByMainPage = true;
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Map paramMap = formShowParameter.getCustomParams();
        if (this.isMatchCondition(paramMap) && this.isFirstInitFilterByMainPage) {
            this.mainPageFilterInit(filterColumns, paramMap);
            this.isFirstInitFilterByMainPage = false;
        }
    }

    private void mainPageFilterInit(List<FilterColumn> filterColumns, Map<String, Object> paramMap) {
        for (int i = filterColumns.size() - 1; i >= 0; --i) {
            FilterColumn filterColumn = filterColumns.get(i);
            CommonFilterColumn schemeFilterColumn = (CommonFilterColumn)filterColumn;
            String schemeFilterColumnName = schemeFilterColumn.getFieldName();
            if ("costaccount.name".equals(schemeFilterColumnName) && paramMap.get("costaccount") != null) {
                ArrayList<Object> orgIdList = new ArrayList<Object>();
                orgIdList.add(paramMap.get("org"));
                List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIdList);
                schemeFilterColumn.setComboItems(comboItems);
                schemeFilterColumn.setDefaultValue(paramMap.get("costaccount").toString());
                this.getPageCache().put("costaccount", paramMap.get("costaccount").toString());
                continue;
            }
            if ("org.id".equals(schemeFilterColumnName) && paramMap.get("org") != null) {
                schemeFilterColumn.setDefaultValue(paramMap.get("org").toString());
                continue;
            }
            if ("allocstatus".equals(schemeFilterColumnName) && paramMap.get("allocstatus") != null) {
                List parseArray = JSONArray.parseArray((String)paramMap.get("allocstatus").toString(), String.class);
                schemeFilterColumn.setDefaultValues(parseArray.toArray());
                continue;
            }
            schemeFilterColumn.setDefaultValue((String)null);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        super.beforeItemClick(e);
        switch (itemKey = e.getItemKey()) {
            case "importcollc": {
                if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)this.getPageCache().get("org"), (boolean)true, (String)"sca", (String)"sca_matalloc", (String)"47156aff000000ac")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6750\u6599\u8017\u7528\u5206\u914d\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MatAllocateListPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                List<Object> orgIds = this.getOrgCache();
                Long orgId = orgIds == null ? 0L : Long.parseLong(orgIds.get(0).toString());
                if (!this.isExistCostAccount(orgId)) break;
                this.showImportPage();
                break;
            }
            case "bar_allocate": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows == null || selectedRows.size() > 0) {
                    return;
                }
                billList.selectAllRows();
                this.getView().invokeOperation("op_allocate");
                e.setCancel(true);
            }
        }
    }

    private void showImportPage() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("sca_matallocimport");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam(this.ORG_FIELD, this.getOrgCache());
        fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_doImport));
        this.getView().showForm(fsp);
    }

    private boolean isExistCostAccount(Long orgId) {
        List costAccountItems = StartCostHelper.getCostAccountItems((Long)orgId, null, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        if (costAccountItems.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u6210\u672c\u8d26\u7c3f\u3002", (String)"MatAllocateListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        this.getView().hideLoading();
        switch (actionId = e.getActionId()) {
            case "doImport": {
                this.doImport(e);
                break;
            }
            case "importResult": {
                this.dealAllocRes(e);
            }
        }
    }

    private void dealAllocRes(ClosedCallBackEvent e) {
        String resJsonString = this.getPageCache().get("allocRes");
        if (StringUtils.isEmpty((CharSequence)resJsonString)) {
            return;
        }
        AllocResult allocRes = (AllocResult)SerializationUtils.fromJsonString((String)resJsonString, AllocResult.class);
        if (allocRes == null) {
            return;
        }
        this.showImportTip(allocRes);
    }

    private void showImportTip(AllocResult allocRes) {
        IFormView view = this.getView();
        Map reasonMap = allocRes.getReasonMap();
        String useAmountIsEmptyTip = (String)reasonMap.get("useAmountIsEmptyTip");
        if (allocRes.isSuccess()) {
            if (StringUtils.isEmpty((CharSequence)useAmountIsEmptyTip)) {
                view.showSuccessNotification((String)reasonMap.get("success"));
            } else {
                view.showMessage(useAmountIsEmptyTip);
            }
        } else {
            List errorList = allocRes.getErrorList();
            if (errorList != null && errorList.size() > 0) {
                MessgeBoxUtils.showDetailsMessageBox((IFormView)view, (String)ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u6570\u636e", (String)"MatAllocateListPlugin_14", (String)"macc-sca-form", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u6570\u636e", (String)"MatAllocateListPlugin_14", (String)"macc-sca-form", (Object[])new Object[0]), (List)errorList);
            } else {
                String tip = useAmountIsEmptyTip == null ? "" : useAmountIsEmptyTip;
                view.showMessage((String)reasonMap.get("false") + "\r\n" + tip);
            }
        }
        String successQty = (String)reasonMap.get("successQty");
        if (StringUtils.isNotEmpty((CharSequence)successQty) && !"0".equals(successQty)) {
            view.updateView("billlistap");
        }
        for (Long costAccountId : allocRes.getCostAccounts()) {
            SimpleMutexHelper.releaseMuteFromSet((String)"importcollc", (boolean)allocRes.getEnableMulFactory(), (Long)costAccountId, (Set)allocRes.getManuOrgIds());
        }
        this.getPageCache().remove("allocRes");
    }

    private void doImport(ClosedCallBackEvent e) {
        String lockErr;
        List selectData = (List)e.getReturnData();
        if (selectData == null || selectData.size() == 0) {
            return;
        }
        Long manuorg = CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg")) ? 0L : Long.parseLong(this.getPageCache().get("manuorg"));
        ArrayList costAccountList = new ArrayList(10);
        Long currOrgId = ((DynamicObject)selectData.get(0)).getLong("org.id");
        boolean returnFlag = false;
        String costAccountName = "";
        HashSet<Long> costAccountSet = new HashSet<Long>();
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)currOrgId);
        for (DynamicObject data : selectData) {
            DynamicObject costaccount;
            DynamicObject currentperiod = data.getDynamicObject("currentperiod");
            if (currentperiod == null) continue;
            if (enableMulFactory && CostCloseAccountHelper.checkIsCloseAccount((DynamicObject)data, (Long)manuorg)) {
                costaccount = data.getDynamicObject("costaccount");
                costAccountName = costaccount.getString("name");
                returnFlag = true;
                break;
            }
            costaccount = data.getDynamicObject("costaccount");
            DynamicObject org = data.getDynamicObject("org");
            Long orgId = org.getLong("id");
            HashMap<String, Object> costaccountMap = new HashMap<String, Object>();
            costaccountMap.put("org", orgId);
            costaccountMap.put("manuorg", manuorg);
            costaccountMap.put("costaccountnum", costaccount.getString("number"));
            costaccountMap.put("costaccountId", costaccount.getLong("id"));
            costAccountSet.add(costaccount.getLong("id"));
            DynamicObject calpolicy = this.getCurrency(costaccount);
            costaccountMap.put("currencyId", calpolicy == null ? 0L : calpolicy.getLong("currency"));
            costaccountMap.put("amtprecision", calpolicy == null ? 10 : calpolicy.getInt("amtprecision"));
            costaccountMap.put("currentperiodId", currentperiod.getLong("id"));
            costaccountMap.put("appnum", this.getView().getFormShowParameter().getAppId());
            costAccountList.add(costaccountMap);
        }
        if (returnFlag) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f%s\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5bfc\u5165\u3002", (String)"MatAllocateListPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]), costAccountName));
            return;
        }
        HashSet<Long> manuOrgs = new HashSet<Long>();
        if (enableMulFactory) {
            if (manuorg > 0L) {
                manuOrgs.add(manuorg);
            } else {
                List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)currOrgId, (String)"sca_matalloc", (String)this.getView().getFormShowParameter().getAppId());
                manuOrgs.addAll(manuorgList);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(lockErr = this.matAllocImportMutex(costAccountSet, manuOrgs, enableMulFactory)))) {
            this.getView().showErrorNotification(lockErr);
            return;
        }
        String progressId = UUID.randomUUID().toString();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"MatAllocateListPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]), () -> {
            AllocResult alloc = null;
            try {
                alloc = ScaMatAllocHelper.toAlloc((List)costAccountList, (String)progressId);
                ProgressHelper.showSuccess((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210", (String)"MatAllocateListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]), (int)0);
            }
            catch (Exception ex) {
                logger.error("\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165-\u62a5\u9519", (Throwable)ex);
                alloc = new AllocResult();
                alloc.setSuccess(false);
                HashMap<String, String> reasonMap = new HashMap<String, String>();
                reasonMap.put("false", String.format(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"MatAllocateListPlugin_17", (String)"macc-sca-form", (Object[])new Object[0]), ex.getMessage()));
                alloc.setReasonMap(reasonMap);
                ProgressHelper.showError((String)progressId, (String)ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u5931\u8d25", (String)"MatAllocateListPlugin_18", (String)"macc-sca-form", (Object[])new Object[0]));
            }
            finally {
                alloc.setOrgId(currOrgId);
                alloc.setEnableMulFactory(Boolean.valueOf(enableMulFactory));
                alloc.setCostAccounts(costAccountSet);
                alloc.setManuOrgIds(manuOrgs);
                for (Long costAccountId : alloc.getCostAccounts()) {
                    SimpleMutexHelper.releaseMuteFromSet((String)"importcollc", (boolean)alloc.getEnableMulFactory(), (Long)costAccountId, (Set)alloc.getManuOrgIds());
                }
                String resJsonString = SerializationUtils.toJsonString((Object)alloc);
                this.getPageCache().put("allocRes", resJsonString);
            }
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
    }

    private synchronized String matAllocImportMutex(Set<Long> costAccountSet, Set<Long> manuOrgIds, boolean enableMulFactory) {
        ArrayList<Long> cancelCostAccountIds = new ArrayList<Long>();
        String lockErr = null;
        boolean cancelFlag = false;
        for (Long costaccountId : costAccountSet) {
            lockErr = SimpleMutexHelper.checkMutexAndLock((String)"importcollc", (boolean)enableMulFactory, (Long)costaccountId, manuOrgIds);
            if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                cancelFlag = true;
                break;
            }
            cancelCostAccountIds.add(costaccountId);
        }
        if (StringUtils.isNotEmpty(lockErr) && cancelFlag && cancelCostAccountIds.size() > 0) {
            for (Long id : cancelCostAccountIds) {
                SimpleMutexHelper.releaseMuteFromSet((String)"importcollc", (boolean)enableMulFactory, (Long)id, manuOrgIds);
            }
        }
        return lockErr;
    }

    private DynamicObject getCurrency(DynamicObject costaccount) {
        if (costaccount == null) {
            return null;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return null;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency, currency.amtprecision AS amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        return result;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        BillList billList = (BillList)e.getHyperLinkClickEvent().getSource();
        Long pkVal = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        if (CadEmptyUtils.isEmpty((Long)pkVal)) {
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)pkVal);
        filter.and(QFilter.of((String)"allocstatus =? or costobject > 0 or alloctype ='2'", (Object[])new Object[]{ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()}));
        if (QueryServiceHelper.exists((String)"sca_matalloc", (QFilter[])new QFilter[]{filter})) {
            return;
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        ids.add(pkVal);
        MatAllocDataHelper.setMatAllocStdNull(ids);
        MatAllocHelper.doAlloc(ids);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        if ("op_allocate".equals(operate.getOperateKey())) {
            ListSelectedRowCollection list = e.getListSelectedData();
            Object[] ids = list.getPrimaryKeyValues();
            HashSet<Long> idsSet = new HashSet<Long>(16);
            for (Object obj : ids) {
                idsSet.add(Long.valueOf(obj.toString()));
            }
            MatAllocDataHelper.setMatAllocStdNull(idsSet);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        BillList billList = (BillList)this.getControl("billlistap");
        if ("op_allocate".equals(e.getOperateKey())) {
            billList.clearSelection();
            this.getView().updateView("billlistap");
        }
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        switch (e.getOperateKey()) {
            case "op_confirm": 
            case "op_unconfirm": {
                billList.clearSelection();
                this.getView().updateView("billlistap");
            }
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            if (!column.toString().equals("billno")) continue;
            column.setFixed(true);
        }
    }
}

