/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.sca.common.helper.MatUseHelper;

public class MatUseCollectEditplugin
extends AbstractBillPlugIn {
    private static final String COSTCENTER = "costcenter";
    private static final String ACCTORG = "org";
    private static final String MANUORG = "manuorg";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bar_traceup"});
        BasedataEdit costcenter = (BasedataEdit)this.getControl(COSTCENTER);
        BasedataEdit costObject = (BasedataEdit)this.getControl("costobject");
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        BasedataEdit configCode = (BasedataEdit)this.getControl("configuredcode");
        BasedataEdit trackNumber = (BasedataEdit)this.getControl("tracknumber");
        BasedataEdit matversion = (BasedataEdit)this.getControl("matversion");
        BasedataEdit location = (BasedataEdit)this.getControl("location");
        BasedataEdit productgroup = (BasedataEdit)this.getControl("productgroup");
        BasedataEdit manuorg = (BasedataEdit)this.getControl(MANUORG);
        final String acctOrg = this.getPageCache().get(ACCTORG);
        costcenter.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                if (!CadEmptyUtils.isEmpty((String)acctOrg)) {
                    Long manuorgId = MatUseCollectEditplugin.this.getModel().getDataEntity().getLong("manuorg.id");
                    ArrayList<Long> manuOrgList = new ArrayList<Long>();
                    manuOrgList.add(manuorgId);
                    QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)Long.parseLong(acctOrg), manuOrgList, (String)MatUseCollectEditplugin.this.getView().getFormShowParameter().getAppId());
                    listShowParameter.getListFilterParameter().getQFilters().add(costCenterIdFilter);
                }
            }
        });
        if (manuorg != null) {
            manuorg.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                    Long acctOrgId = acctOrg == null ? MatUseCollectEditplugin.this.getModel().getDataEntity().getDynamicObject(MatUseCollectEditplugin.ACCTORG).getLong("id") : Long.parseLong(acctOrg);
                    ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)acctOrgId, (String)MatUseCollectEditplugin.this.getBillEntityId());
                    QFilter orgfilter = new QFilter("id", "in", (Object)manuorgList);
                    listShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
                }
            });
        }
        costObject.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                DynamicObject costcenter = MatUseCollectEditplugin.this.getModel().getDataEntity().getDynamicObject(MatUseCollectEditplugin.COSTCENTER);
                if (costcenter == null) {
                    MatUseCollectEditplugin.this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u3002", (String)"MatUseCollectEditplugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter[] filters = MatUseCollectEditplugin.this.getCostObjectQFilters(beforeF7SelectEvent);
                listShowParameter.getListFilterParameter().getQFilters().addAll(Arrays.asList(filters));
            }
        });
        material.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Set materialBySalOrder;
                DynamicObject costcenter = MatUseCollectEditplugin.this.getModel().getDataEntity().getDynamicObject(MatUseCollectEditplugin.COSTCENTER);
                if (costcenter == null) {
                    MatUseCollectEditplugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u4e2d\u5fc3\u3002", (String)"MatUseCollectEditplugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                }
                ListShowParameter fParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                fParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
                ListFilterParameter filterParameter = fParameter.getListFilterParameter();
                List qList = filterParameter.getQFilters();
                int index = MatUseCollectEditplugin.this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject configuredcode = (DynamicObject)MatUseCollectEditplugin.this.getModel().getValue("configuredcode", index);
                DynamicObject tracknumber = (DynamicObject)MatUseCollectEditplugin.this.getModel().getValue("tracknumber", index);
                if (!(configuredcode == null && tracknumber == null || CadEmptyUtils.isEmpty((Set)(materialBySalOrder = ConfigTrackHelper.getMaterialBySalOrder((Long)(configuredcode == null ? 0L : configuredcode.getLong("id")), (Long)(tracknumber == null ? 0L : tracknumber.getLong("id"))))))) {
                    qList.add(new QFilter("id", "in", (Object)materialBySalOrder));
                }
            }
        });
        configCode.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                List configCodeIds;
                int index = MatUseCollectEditplugin.this.getModel().getEntryCurrentRowIndex("entryentity");
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = parameter.getListFilterParameter();
                List qList = filterParameter.getQFilters();
                DynamicObject matObj = (DynamicObject)MatUseCollectEditplugin.this.getModel().getValue("material", index);
                if (matObj != null && !CadEmptyUtils.isEmpty((List)(configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(Collections.singleton(matObj.getLong("id")))))) {
                    qList.add(new QFilter("id", "in", (Object)configCodeIds));
                }
            }
        });
        matversion.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                QFilter filter = MatUseCollectEditplugin.this.getMatVersionFilter(beforeF7SelectEvent);
                if (filter != null) {
                    ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    listShowParameter.getListFilterParameter().getQFilters().add(filter);
                }
            }
        });
        location.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                QFilter filter = MatUseCollectEditplugin.this.getlocationFilter(beforeF7SelectEvent);
                if (filter != null) {
                    ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    listShowParameter.getListFilterParameter().getQFilters().add(filter);
                }
            }
        });
        if (productgroup != null) {
            productgroup.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                    QFilter[] filter = MatUseCollectEditplugin.this.getProGroupFilter(beforeF7SelectEvent);
                    ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    listShowParameter.getListFilterParameter().getQFilters().addAll(Arrays.asList(filter));
                }
            });
        }
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String appId = fsp.getAppId();
        this.getModel().setValue("appnum", (Object)appId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String acctOrg = (String)formShowParameter.getCustomParam(ACCTORG);
        String costCenter = (String)formShowParameter.getCustomParam(COSTCENTER);
        String manuOrg = (String)formShowParameter.getCustomParam(MANUORG);
        String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if ("aca".equalsIgnoreCase(appNum)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"srcauditdate"});
        }
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
        }
        if (!StringUtils.isEmpty((Object)acctOrg) && !"0".equals(acctOrg)) {
            this.getModel().setValue(ACCTORG, (Object)acctOrg);
            this.getPageCache().put(ACCTORG, acctOrg);
        }
        if ("0".equals(acctOrg)) {
            this.getModel().setValue(ACCTORG, null);
        }
        if (!StringUtils.isEmpty((Object)manuOrg) && !"0".equals(manuOrg)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{MANUORG});
            this.getModel().setValue(MANUORG, (Object)manuOrg);
        }
        if ("0".equals(manuOrg)) {
            this.getModel().setValue(MANUORG, null);
        }
        if (!StringUtils.isEmpty((Object)costCenter)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{COSTCENTER});
            this.getModel().setValue(COSTCENTER, (Object)costCenter);
        }
        if (formShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.getModel().setValue("source", (Object)"MANUALENTER");
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        String source;
        super.afterBindData(e);
        String viewOnly = (String)this.getView().getFormShowParameter().getCustomParam("viewOnly");
        if ("view".equalsIgnoreCase(viewOnly)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_modify", "bar_audit", "bar_traceup"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"addrow", "delrow", "advconbaritemap", "advconbaritemap1"});
        }
        if (!StringUtils.isEmpty((Object)(source = this.getModel().getDataEntity().getString("source"))) && source.startsWith("SYSIMPORT")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"fs_baseinfo"});
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        for (int row = 0; row < entries.size(); ++row) {
            this.getModel().setValue("showqty", (Object)((DynamicObject)entries.get(row)).getBigDecimal("qty"), row);
        }
        this.changManuorgStatus();
        this.setEnablePropBySource();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "costcenter": {
                DynamicObject accountorg;
                DynamicObject costcenter = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (costcenter == null || (accountorg = costcenter.getDynamicObject("accountorg")) == null) break;
                this.getModel().setValue(ACCTORG, (Object)accountorg);
                break;
            }
            case "material": {
                if (rowIndex < 0) {
                    return;
                }
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
                if (material == null) break;
                this.dealMatRelation(material, rowIndex);
                break;
            }
            case "showqty": {
                if (rowIndex < 0) {
                    return;
                }
                BigDecimal showqty = (BigDecimal)this.getModel().getValue("showqty", rowIndex);
                this.getModel().setValue("qty", (Object)showqty, rowIndex);
                break;
            }
            case "billstatus": {
                this.setEnablePropBySource();
                break;
            }
            case "warehouse": {
                this.getModel().setValue("location", null, rowIndex);
                DynamicObject warehouse = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (warehouse != null && warehouse.getBoolean("isopenlocation")) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"location"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"location"});
                break;
            }
            case "costobject": {
                break;
            }
            case "org": {
                this.changManuorgStatus();
                break;
            }
            case "configuredcode": {
                ConfigTrackHelper.setTrackValueByConfig((IFormView)this.getView(), (IDataModel)this.getModel(), (Integer)rowIndex);
                break;
            }
            case "tracknumber": {
                ConfigTrackHelper.setConfigValueByTrack((IFormView)this.getView(), (IDataModel)this.getModel(), (Integer)rowIndex);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("bar_traceup".equals(evt.getItemKey())) {
            String sourcebillid = this.getModel().getDataEntity().getString("sourcebillid");
            if (StringUtils.isEmpty((Object)sourcebillid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u662f\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\uff0c\u4e0d\u80fd\u4e0a\u67e5\u3002", (String)"MatUseCollectEditplugin_16", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            String source = ((DynamicObject)this.getModel().getValue("srcbilltype")).getString("id");
            SrcBillShowerUtils.showSearchUpBill((IFormView)this.getView(), (String)source, Collections.singletonList(sourcebillid));
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((Object)appId)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5e94\u7528\u6807\u8bc6\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165", (String)"MatUseCollectEditplugin_17", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        Map importData = e.getSourceData();
        Object bizdate = importData.get("bizdate");
        Object bookdate = importData.get("bookdate");
        if (bizdate != null && bookdate == null) {
            importData.put("bookdate", bizdate);
        }
        importData.put("appnum", appId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object[] entryids;
        boolean allNotAllocConfirm;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("unaudit".equals(operateKey) && (allNotAllocConfirm = MatUseHelper.isAllNotAllocConfirm(entryids = this.getEntryPrimarykeyValues()))) {
            args.setCancel(true);
            String msg = String.format(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff1a%s\u5df2\u7ecf\u8fdb\u884c\u5206\u914d\uff0c\u53cd\u5ba1\u6838\u4f1a\u5220\u9664\u5206\u914d\u7ed3\u679c\u3002\u786e\u8ba4\u53cd\u5ba1\u6838 ?", (String)"MatUseCollectEditplugin_4", (String)"macc-sca-form", (Object[])new Object[0]), this.getModel().getValue("billno"));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("isDelete", (IFormPlugin)this));
        }
    }

    private boolean isManualNewAdd(String acctOrgId, String costCenterId) {
        QFilter orgFilter = null;
        QFilter costCenterFilter = null;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (StringUtils.isEmpty((Object)acctOrgId) && StringUtils.isEmpty((Object)costCenterId)) {
            return true;
        }
        if (!StringUtils.isEmpty((Object)acctOrgId)) {
            QFilter qFilter = MatUseHelper.getCostCenterQFilter(acctOrgId, "matcollectway", this.getView().getFormShowParameter().getAppId());
            boolean exists = QueryServiceHelper.exists((String)"bos_costcenter", (QFilter[])new QFilter[]{qFilter});
            if (!exists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6838\u7b97\u7ec4\u7ec7\u4e0b\u4e0d\u5b58\u5728\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u624b\u5de5\u5f55\u5165\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"MatUseCollectEditplugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                return false;
            }
            orgFilter = new QFilter("accountorg", "=", (Object)Long.valueOf(acctOrgId));
            filters.add(orgFilter);
        }
        if (!StringUtils.isEmpty((Object)costCenterId)) {
            costCenterFilter = new QFilter(COSTCENTER, "=", (Object)Long.valueOf(costCenterId));
            filters.add(costCenterFilter);
        }
        filters.add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        DynamicObject sysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"matcollectway", (QFilter[])filters.toArray(new QFilter[0]));
        if (sysParam == null) {
            return true;
        }
        switch (sysParam.getString("matcollectway")) {
            case "TPLIMPORT": {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u6210\u672c\u53c2\u6570\u4e2d\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u6a21\u677f\u5bfc\u5165\u3002", (String)"MatUseCollectEditplugin_18", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
            case "APIINTERFACE": {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u6210\u672c\u53c2\u6570\u4e2d\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3aAPI\u63a5\u53e3\u3002", (String)"MatUseCollectEditplugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
            case "INNERSYSIMPORT": {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u6210\u672c\u53c2\u6570\u4e2d\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u3002", (String)"MatUseCollectEditplugin_19", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
            case "MANUALENTER": {
                return true;
            }
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("audit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("isDelete".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            int value = result.getValue();
            if (MessageBoxResult.Yes.getValue() == value) {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)MatUseHelper.getEntity(this.getView().getFormShowParameter().getAppId()), (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (OperateOption)OperateOption.create());
                if (operationResult.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"MatUseCollectEditplugin_9", (String)"macc-sca-form", (Object[])new Object[0]));
                } else {
                    this.getView().showOperationResult(operationResult);
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void setEnablePropBySource() {
        String proMatGet_enableProps = "billno,bizdate,org,costcenter,biztype,material,matversion,auxpty,lotcoderule,showqty,warehouse,location,costobject";
        String outStorage_enableProps = "billno,bizdate,org,costcenter,biztype,material,lotcoderule,showqty,warehouse,location";
        String source = this.getModel().getDataEntity().getString("source");
        String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if ("aca".equalsIgnoreCase(appNum)) {
            proMatGet_enableProps = proMatGet_enableProps + ",productgroup";
        }
        if ("SYSIMPORT_PROGET".equals(source) || "SYSIMPORT_PROBACK".equals(source) || "SYSIMPORT_PROADD".equals(source)) {
            this.getView().setEnable(Boolean.FALSE, proMatGet_enableProps.split(","));
        } else if ("SYSIMPORT_OUT".equals(source)) {
            this.getView().setEnable(Boolean.FALSE, outStorage_enableProps.split(","));
            this.ctrlVerAndAuxpty();
        }
    }

    private void ctrlVerAndAuxpty() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int rowIndex = 0;
        for (DynamicObject entry : entryEntity) {
            DynamicObject material = (DynamicObject)entry.get("material");
            if (material == null) {
                return;
            }
            this.getView().setEnable(Boolean.valueOf(BomRouterHelper.isEnableMatversion((DynamicObject)material)), rowIndex, new String[]{"matversion"});
            this.getView().setEnable(Boolean.valueOf(BomRouterHelper.isEnableAuxprop((DynamicObject)material)), rowIndex, new String[]{"auxpty"});
            ++rowIndex;
        }
    }

    private QFilter[] getProGroupFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter groupTypeFilter = new QFilter("grouptype", "=", (Object)Character.valueOf('3'));
        return new QFilter[]{groupTypeFilter};
    }

    private QFilter getlocationFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        int row = beforeF7SelectEvent.getRow();
        Object warehouseObj = this.getModel().getValue("warehouse", row);
        if (warehouseObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed3\u5e93\u3002", (String)"MatUseCollectEditplugin_10", (String)"macc-sca-form", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return null;
        }
        QFilter idFilter = null;
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", row);
        DynamicObjectCollection locations = warehouse.getDynamicObjectCollection("entryentity");
        List list = locations.stream().map(e -> e.get("location.id")).collect(Collectors.toList());
        idFilter = CollectionUtils.isEmpty(list) ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", list);
        return idFilter;
    }

    private QFilter getMatVersionFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        int row = beforeF7SelectEvent.getRow();
        Object material = this.getModel().getValue("material", row);
        if (material != null) {
            QFilter materialFilter = new QFilter("material", "=", ((DynamicObject)material).get("id"));
            return materialFilter;
        }
        return null;
    }

    private QFilter[] getCostObjectQFilters(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject costcenter = this.getModel().getDataEntity().getDynamicObject(COSTCENTER);
        QFilter costCenterFilter = new QFilter(COSTCENTER, "=", costcenter.getPkValue());
        QFilter statusFilter = new QFilter("bizstatus", "=", (Object)Character.valueOf('A'));
        QFilter typeQFilter = new QFilter("producttype", "=", (Object)"C");
        return new QFilter[]{costCenterFilter, statusFilter, typeQFilter};
    }

    private void dealMatRelation(DynamicObject material, int rowIndex) {
        Boolean isEnableVersion = material.getBoolean("isenablematerialversion");
        boolean isuseauxpty = material.getBoolean("isuseauxpty");
        boolean enablelot = MatUseHelper.isEnablelot(material);
        Object unitid = material.get("baseunit.id");
        this.getModel().setValue("unit", unitid, rowIndex);
        this.getView().setEnable(isEnableVersion, rowIndex, new String[]{"matversion"});
        this.getView().setEnable(Boolean.valueOf(isuseauxpty), rowIndex, new String[]{"auxpty"});
        this.getView().setEnable(Boolean.valueOf(enablelot), rowIndex, new String[]{"lotcoderule"});
    }

    private Object[] getEntryPrimarykeyValues() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Object[] ids = entryentity.stream().map(DataEntityBase::getPkValue).toArray();
        return ids;
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue(ACCTORG);
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MANUORG});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MANUORG});
        }
    }
}

