/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class MfgFeeAllocEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit benefcostcenter = (BasedataEdit)this.getControl("benefcostcenter");
        final DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        benefcostcenter.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter orgfilter = CadEmptyUtils.isEmpty((DynamicObject)org) ? null : new QFilter("accountorg", "=", (Object)org.getLong("masterid"));
                listShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
            }
        });
        BasedataEdit costdriver = (BasedataEdit)this.getControl("costdriver");
        costdriver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("enable", "=", (Object)1));
            qList.add(new QFilter("status", "=", (Object)"C"));
            qList.add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if ("2".equals(this.getModel().getValue("allocstatus")) || "2".equals(this.getModel().getValue("usetype"))) {
            this.setEditfieldsEnable(false);
        } else {
            this.setEditfieldsEnable(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        this.getModel().setValue("alloctype", (Object)"2");
        switch (name) {
            case "costdriver": {
                this.getView().invokeOperation("donothing");
                break;
            }
            case "allocvalue": {
                this.updateAlloc();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            switch (e.getOperateKey()) {
                case "confirm": {
                    this.setEditfieldsEnable(false);
                    break;
                }
                case "unconfirm": {
                    this.setEditfieldsEnable(true);
                    break;
                }
                case "donothing": {
                    this.getView().invokeOperation("refresh");
                }
            }
        }
    }

    private void setEditfieldsEnable(boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"entryentity", "costdriver"});
        this.getView().setVisible(Boolean.valueOf(isEnable), new String[]{"advcontoolbarap"});
    }

    private void updateAlloc() {
        int AmtPrecision = 2;
        int QtyPrecision = 2;
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        BigDecimal sumAmt = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal sumVal = BigDecimal.ZERO;
        for (DynamicObject en : entry) {
            sumVal = sumVal.add(en.getBigDecimal("allocvalue"));
        }
        int maxIndex = -1;
        BigDecimal maxAmt = BigDecimal.ZERO;
        int i = 0;
        BigDecimal realSumAmt = BigDecimal.ZERO;
        for (DynamicObject en : entry) {
            BigDecimal curVal = en.getBigDecimal("allocvalue");
            BigDecimal curAmt = curVal.divide(sumVal, QtyPrecision, 4).multiply(sumAmt).setScale(AmtPrecision, 4);
            realSumAmt = realSumAmt.add(curAmt);
            en.set("allocamt", (Object)curAmt);
            if (curAmt.compareTo(maxAmt) > 0) {
                maxAmt = curAmt;
                maxIndex = i;
            }
            ++i;
        }
        if (maxIndex == -1) {
            return;
        }
        ((DynamicObject)entry.get(maxIndex)).set("allocamt", (Object)maxAmt.add(sumAmt.subtract(realSumAmt)));
        this.getView().updateView("entryentity");
    }
}

