/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.ScaAllocEnum;
import kd.macc.sca.formplugin.base.BaseOrgAndCostCenterFilterList;

public class MfgFeeAllocStdListPlugin
extends BaseOrgAndCostCenterFilterList {
    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("org.number asc,billno asc");
        e.addCustomQFilter(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("new".equals(operateKey)) {
            boolean isValid = this.checkOrg();
            if (!isValid) {
                args.setCancel(true);
            }
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "updatedata": {
                if (!this.checkOrg()) {
                    return;
                }
                this.updatedata();
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"MfgFeeAllocStdListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            }
        }
    }

    private void updatedata() {
        DynamicObject[] updateData;
        Long orgId = Long.parseLong(this.getPageCache().get(this.ORG_FIELD));
        QFilter filter = new QFilter("allocmold", "=", (Object)ScaAllocEnum.ASSIST_PRODUCT_ALLOC.getValue());
        filter.and("org", "=", (Object)orgId);
        DynamicObjectCollection ele = QueryServiceHelper.query((String)"sca_mfgfeeallocstdnew", (String)"id", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject el : ele) {
            ids.add(el.getLong("id"));
        }
        for (DynamicObject dynObj : updateData = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sca_mfgfeeallocstdnew"))) {
            DynamicObjectCollection entry = dynObj.getDynamicObjectCollection("entryentity");
            if (entry.size() <= 1) continue;
            for (int i = entry.size() - 1; i > 0; --i) {
                entry.remove(i);
            }
        }
        SaveServiceHelper.save((DynamicObject[])updateData);
    }

    private boolean checkOrg() {
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeAllocStdListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            if (!column.toString().equals("billno")) continue;
            column.setFixed(true);
            break;
        }
    }

    @Override
    protected List<ComboItem> getCostCenterComboItemList(String orgId) {
        return this.getCostCenterComboItemListBy(orgId, null);
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String orgId;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costcenter") && StringUtils.isNotBlank((CharSequence)(orgId = this.getPageCache().get(this.ORG_FIELD)))) {
            args.getQfilters().add(new QFilter("accountorg", "=", (Object)Long.parseLong(orgId)).and(new QFilter("enable", "=", (Object)"1")));
        }
    }

    @Override
    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)"sca_mfgfeeallocstdnew", (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId());
    }
}

