/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.ScaMfgFeeImpSchEnum;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class MfgFeeImpSchListPlugin
extends BaseOrgAndCostAccountListPlugin {
    public void initialize() {
        super.initialize();
        this.isCostAccountDef = Boolean.TRUE;
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        this.initClick(args);
        super.filterContainerInit(args);
    }

    @Override
    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        DynamicObjectCollection ccs;
        QFilter filter = null;
        if (!CadEmptyUtils.isEmpty(orgId)) {
            ArrayList lOrgIds = new ArrayList();
            orgId.forEach(id -> {
                try {
                    lOrgIds.add(Long.valueOf(id.toString()));
                }
                catch (Exception ex) {
                    logger.error("\u83b7\u53d6\u6210\u672c\u8d26\u7c3f\u5931\u8d25", (Throwable)ex);
                }
            });
            filter = new QFilter("calorg", "in", lOrgIds);
        } else {
            filter = new QFilter("calorg", ">", (Object)0L);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(orgId)) {
            Long org = 0L;
            try {
                org = Long.parseLong(orgId.get(0).toString());
                filter.and(StartCostHelper.getEnabledFilter(Collections.singletonList(org), (String)this.getAppId()));
            }
            catch (Exception ex) {
                logger.error("\u83b7\u53d6\u6210\u672c\u8d26\u7c3f\u5931\u8d25", (Throwable)ex);
                filter.and("id", "=", (Object)0L);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(ccs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, (String)"ismainaccount desc,number asc")))) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    private void initClick(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator var3 = filterColumns.iterator();
        String org = this.getPageCache().get("org");
        while (var3.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)var3.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (!fieldName.startsWith("org.") || org == null || "".equals(org)) continue;
            List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
            String string = (String)list.get(0);
        }
    }

    @Override
    protected void resetCostAccount(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        if (!CollectionUtils.isEmpty(orgIdList)) {
            List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIdList);
            if (CollectionUtils.isEmpty(comboItems)) {
                return;
            }
            commonFilterColumn.setComboItems(comboItems);
            ComboItem item = comboItems.get(0);
            String defVal = item.getValue();
            commonFilterColumn.setDefaultValue(defVal);
            this.getPageCache().put("costaccount", defVal);
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List orgList;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        String orgJsonString = this.getPageCache().get("org");
        Long accountOrgId = null;
        if (!CadEmptyUtils.isEmpty((String)orgJsonString) && !CadEmptyUtils.isEmpty((List)(orgList = (List)SerializationUtils.fromJsonString((String)orgJsonString, List.class)))) {
            accountOrgId = Long.parseLong(String.valueOf(orgList.get(0)));
        }
        if (fieldName.startsWith("costaccount") && !CadEmptyUtils.isEmpty(accountOrgId)) {
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledFilter(Collections.singletonList(accountOrgId), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().add(enabledCostAccountIdsFilter);
        }
        if (fieldName.startsWith("manuorg")) {
            if (!CadEmptyUtils.isEmpty(accountOrgId)) {
                List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountOrgId, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                args.getQfilters().add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List objects;
        String accountorgId = this.getPageCache().get("org");
        String org = "";
        if (!StringUtils.isEmpty((Object)accountorgId) && (objects = SerializationUtils.fromJsonStringToList((String)accountorgId, String.class)).size() > 0) {
            org = (String)objects.get(0);
        }
        if (!CadEmptyUtils.isEmpty((String)org)) {
            List userHasPermManuorgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(org), (String)this.getBillEntityId());
            userHasPermManuorgs.add(0L);
            QFilter filter = new QFilter("manuorg", "in", (Object)userHasPermManuorgs);
            filter.or("manuorg", "is null", null);
            e.getQFilters().add(filter);
        }
        e.setOrderBy("billno ASC");
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateFormatField();
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.productGroupVisible(args);
    }

    private void productGroupVisible(BeforeCreateListColumnsArgs args) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId) || "eca".equals(appId)) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)args, (Set)Sets.newHashSet((Object[])new String[]{"productgroup.number", "productgroup.name"}));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if ("copy".equals(source.getOperateKey())) {
            this.getPageCache().put("operate", "copy");
        }
        if ("new".equals(source.getOperateKey())) {
            this.checkOrgAndCostAccount(args);
            this.getPageCache().put("operate", "new");
        }
    }

    private void checkOrgAndCostAccount(BeforeDoOperationEventArgs e) {
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeImpSchListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String costAccountId = this.getPageCache().get("costaccount");
        if (CadEmptyUtils.isEmpty((String)costAccountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"MfgFeeImpSchListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter bsp = e.getParameter();
        bsp.setCustomParam("operate", (Object)this.getPageCache().get("operate"));
    }

    @Override
    protected void getCostAccountIdsFilter(BeforeFilterF7SelectEvent args, Long orgId) {
        if (!CadEmptyUtils.isEmpty((Long)orgId)) {
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledFilter(Collections.singletonList(orgId), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().add(enabledCostAccountIdsFilter);
        }
    }

    private void updateFormatField() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.size() < 1) {
            return;
        }
        HashMap<String, String> combItemMap = new HashMap<String, String>(16);
        MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        if (srcMainET != null) {
            String string = Lang.get().toString();
            for (IDataEntityProperty prop : srcMainET.getProperties()) {
                DateTimeProp dateProp;
                if (!(prop instanceof DateTimeProp) || CadEmptyUtils.isEmpty((String)prop.getAlias()) || (dateProp = (DateTimeProp)prop).getTimeZoneTransType() == 2) continue;
                combItemMap.put(dateProp.getName(), new LocaleString(string, this.buildPropCaption((DynamicProperty)dateProp)).toString());
            }
        }
        for (ScaMfgFeeImpSchEnum value : ScaMfgFeeImpSchEnum.values()) {
            if (!value.getEnumName().contentEquals("amount") && !value.getEnumName().contentEquals("localamt")) continue;
            combItemMap.put(value.getValue(), new LocaleString(ScaMfgFeeImpSchEnum.getName(value.getValue())).toString());
        }
        String string = "id, entryentity.id entryId, entryentity.bizdate bizdate, entryentity.amount amount";
        QFilter idQF = new QFilter("id", "in", (Object)rows.getPrimaryKeyValues());
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"sca_mfgfeeimpsch", (String)string, (QFilter[])new QFilter[]{idQF});
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject col : cols) {
            Long entryid = col.getLong("entryId");
            if (entryid == null || entryid == 0L) continue;
            entryMap.put(entryid, col);
        }
        for (int i = 0; i < rows.size(); ++i) {
            Long entryid = (Long)rows.get(i).getEntryPrimaryKeyValue();
            if (entryid == null || entryid == 0L) continue;
            DynamicObject entryCol = (DynamicObject)entryMap.get(entryid);
            billList.setCellFieldValue("bizdate", i, combItemMap.get(entryCol.getString("bizdate")));
            String amountField = entryCol.getString("amount");
            Object[] amountFieldArr = amountField.split(",");
            HashSet amountFieldSet = Sets.newHashSet((Object[])amountFieldArr);
            if (amountFieldSet == null || amountFieldSet.isEmpty()) continue;
            StringBuilder amountShowValue = new StringBuilder();
            for (Map.Entry combItem : combItemMap.entrySet()) {
                if (!amountFieldSet.contains(combItem.getKey())) continue;
                amountShowValue.append((String)combItem.getValue());
                amountShowValue.append(",");
            }
            billList.setCellFieldValue("amount", i, (Object)amountShowValue.toString());
        }
    }

    private String buildPropCaption(DynamicProperty prop) {
        EntityType parentType = (EntityType)prop.getParent();
        String parentName = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"MfgFeeImpSchListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]);
        if (parentType.getDisplayName() != null) {
            parentName = parentType.getDisplayName().toString();
        }
        String propName = prop.getDisplayName() != null ? prop.getDisplayName().toString() : this.getFieldSelector(prop);
        String caption = String.format("%s.%s", parentName, propName);
        return caption;
    }

    private String getFieldSelector(DynamicProperty rateProp) {
        String selector = rateProp.getName();
        if (rateProp.getParent() != null && rateProp.getParent().getParent() != null && rateProp.getParent().getParent().getParent() != null && rateProp.getParent().getParent().getParent().getParent() == null) {
            selector = rateProp.getParent().getParent().getName() + "." + rateProp.getParent().getName() + "." + selector;
        }
        return selector;
    }
}

