/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.ScaAllocEnum;
import kd.macc.sca.common.enums.SysParamEnum;

public class MfgfeeBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String E004 = "004";

    public void initialize() {
        super.initialize();
        this.initFilter();
    }

    private void initFilter() {
        BasedataEdit costObjectInput;
        BasedataEdit costcenterInput = (BasedataEdit)this.getControl("costcenter");
        costcenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter orgQf = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            qFilters.add(orgQf);
            QFilter costCenterQF = SysParamHelper.getManualSysParamCostCenterQF((Long)org.getLong("id"), (String)"mfgfeebilltype", (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (costCenterQF != null) {
                qFilters.add(costCenterQF);
            }
            qFilters.add(this.getAllocMoldQF());
        });
        BasedataEdit costaccountInput = (BasedataEdit)this.getControl("costaccount");
        costaccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(enabledCostAccountIdsFilter);
        });
        BasedataEdit benefcostcenterInput = (BasedataEdit)this.getControl("benefcostcenter");
        benefcostcenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter qf = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            qFilters.add(qf);
        });
        BasedataEdit subelementInput = (BasedataEdit)this.getControl("subelement");
        subelementInput.addBeforeF7SelectListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("mfgfeebillentry");
            DynamicObject element = (DynamicObject)this.getModel().getValue("element", rowIndex);
            if (element == null) {
                return;
            }
            List<QFilter> qFilters = this.getInputQFilters(evt);
            qFilters.add(new QFilter("type", "=", (Object)element.getString("type")));
        });
        BasedataEdit productGroupInput = (BasedataEdit)this.getControl("productgroup");
        if (productGroupInput != null) {
            productGroupInput.addBeforeF7SelectListener(evt -> {
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                List<QFilter> qFilters = this.getInputQFilters(evt);
                if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                    qFilters.add(new QFilter("id", "=", (Object)-1L));
                } else {
                    qFilters.add(new QFilter("org", "=", org.get("id")));
                }
            });
        }
        if ((costObjectInput = (BasedataEdit)this.getControl("costobject")) != null) {
            costObjectInput.addBeforeF7SelectListener(evt -> {
                List<QFilter> qFilters = this.getInputQFilters(evt);
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
                if (CadEmptyUtils.isEmpty((DynamicObject)costCenter)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5145\u6210\u672c\u4e2d\u5fc3\u3002", (String)"MfgfeeBillEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                qFilters.add(new QFilter("costcenter", "=", costCenter.get("id")));
                DynamicObject productGroup = dataEntity.getDynamicObject("productgroup");
                if (productGroup != null) {
                    DynamicObjectCollection productGroupRes = QueryServiceHelper.query((String)"cad_productintogroup", (String)"entryentity.material AS material", (QFilter[])new QFilter[]{new QFilter("id", "=", productGroup.getPkValue())});
                    List fieldList = DynamicObjectHelper.getFieldList((DynamicObjectCollection)productGroupRes, (String)"material");
                    if (CadEmptyUtils.isEmpty((List)fieldList)) {
                        return;
                    }
                    qFilters.add(new QFilter("material", "in", (Object)fieldList));
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("mfgfeebillentry");
                HashSet costObjectSet = new HashSet();
                entryEntity.forEach(o -> costObjectSet.add(o.getLong("costobject.id")));
                if (!CadEmptyUtils.isEmpty(costObjectSet)) {
                    qFilters.add(new QFilter("id", "not in", costObjectSet));
                }
            });
        }
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            Long org = this.getModel().getDataEntity().getDynamicObject("org") == null ? 0L : this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
            if (CadEmptyUtils.isEmpty((Long)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgfeeBillEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org, (String)this.getBillEntityId());
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }

    public void afterBindData(EventObject e) {
        this.setBizDateInCopy();
        this.setMustInputCostCenter();
        this.changManuorgStatus();
        Long id = (Long)this.getModel().getValue("id");
        if (id != null && id != 0L) {
            this.setEntryMaterial();
            this.getModel().setDataChanged(false);
        } else {
            if (!"copy".equals(this.getView().getFormShowParameter().getCustomParam("operate"))) {
                this.initByListData();
            }
            this.initFormValue();
            this.getModel().setDataChanged(false);
            this.initDefaultSubEle(0);
        }
    }

    private void initDefaultSubEle(int rowIndex) {
        DynamicObject subelement = (DynamicObject)this.getModel().getValue("subelement", rowIndex);
        if (subelement == null) {
            this.getModel().setValue("subelement", this.getDefaultSubele(E004), rowIndex);
        }
    }

    private void setBizDateInCopy() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        int statusValue = fsp.getStatusValue();
        if (statusValue == OperationStatus.ADDNEW.getValue()) {
            this.setBizDate();
        }
    }

    private void initFormValue() {
        DynamicObject dataEntity;
        String srcSysNum;
        String appNum = this.getView().getFormShowParameter().getAppId();
        QFilter numberQF = new QFilter("number", "=", (Object)appNum);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number", (QFilter[])new QFilter[]{numberQF});
        for (DynamicObject dy : res) {
            Object id = dy.get("id");
            if (id == null) continue;
            this.getModel().setValue("mulsrcsys", (Object)new String[]{id.toString()});
            this.getModel().setValue("srcsys", id);
            break;
        }
        if (!"aca".equalsIgnoreCase(srcSysNum = (dataEntity = this.getModel().getDataEntity()).getString("srcsys.number"))) {
            String orgId = dataEntity.getString("org.id");
            String costCenterId = dataEntity.getString("costcenter.id");
            String addWay = SysParamHelper.getScaSysParamAddType((String)orgId, (String)costCenterId, (String)"mfgfeebilltype", (String)appNum);
            if (!SysParamEnum.COMPTYPE_MANUAL.getValue().equalsIgnoreCase(addWay)) {
                this.getModel().setValue("costcenter", null);
            }
        }
    }

    private void initByListData() {
        String manuorg;
        String costAccountId;
        String costCenterId;
        IDataModel model = this.getModel();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String orgId = (String)fsp.getCustomParam("accountorgId");
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            model.setValue("org", (Object)orgId);
        }
        if (!CadEmptyUtils.isEmpty((String)(costCenterId = (String)fsp.getCustomParam("costCenterId")))) {
            model.setValue("costcenter", (Object)costCenterId);
            this.initAllocMold(costCenterId);
        }
        if (!CadEmptyUtils.isEmpty((String)(costAccountId = (String)fsp.getCustomParam("costaccountId")))) {
            model.setValue("costaccount", (Object)costAccountId);
        }
        if (!CadEmptyUtils.isEmpty((String)(manuorg = (String)fsp.getCustomParam("manuorg")))) {
            model.setValue("manuorg", (Object)manuorg);
        } else {
            model.setValue("manuorg", null);
        }
    }

    private void initAllocMold(String costCenterId) {
        DynamicObject costCenter = this.getModel().getDataEntity().getDynamicObject("costcenter");
        if (CadEmptyUtils.isEmpty((String)costCenterId)) {
            return;
        }
        String orgduty = costCenter.getString("orgduty.number");
        String allocMold = "";
        allocMold = "4".equals(orgduty) ? "C" : ("5".equals(orgduty) ? "B" : "A");
        this.getModel().setValue("allocmold", (Object)allocMold);
        this.getModel().setValue("costcenter", (Object)costCenterId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (proName) {
            case "org": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org != null) {
                    this.setCostAccount(org.getLong("id"));
                }
                this.setPeriod();
                this.changManuorgStatus();
                break;
            }
            case "costaccount": {
                this.setCurrency();
                this.setPeriod();
                break;
            }
            case "period": {
                this.setBizDate();
                break;
            }
            case "costcenter": {
                this.cleanInputByCostCenter();
                break;
            }
            case "subelement": {
                this.setElement(e);
                break;
            }
            case "element": {
                this.setSubElement(e);
                break;
            }
            case "allocmold": {
                this.getModel().setValue("costcenter", null);
                this.setMustInputCostCenter();
                this.cleanInputByAllocMold();
                this.setMustInputRange();
                break;
            }
            case "benefcostcenter": {
                this.initDefaultSubEle(rowIndex);
                break;
            }
            case "costobject": {
                this.setMaterial(rowIndex);
                this.initDefaultSubEle(rowIndex);
                break;
            }
            case "range": {
                Object newObj = e.getChangeSet()[0].getNewValue();
                if (null != newObj && "A".equals(newObj.toString())) {
                    this.setRangeMustInput(null);
                } else if (null != newObj && "B".equals(newObj.toString())) {
                    this.setRangeMustInput(true);
                } else if (null != newObj && "C".equals(newObj.toString())) {
                    this.setRangeMustInput(false);
                }
                this.clearInputForRange();
            }
        }
    }

    private void clearInputForRange() {
        int entryRowCount = this.getModel().getEntryRowCount("mfgfeebillentry");
        for (int index = 0; index < entryRowCount; ++index) {
            this.getModel().setValue("costobject", null, index);
            this.getModel().setValue("material", null, index);
            this.getModel().setValue("auxpty", null, index);
            this.getModel().setValue("benefcostcenter", null, index);
        }
    }

    private void setMustInputRange() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (StringUtils.isEmpty((CharSequence)allocMold)) {
            return;
        }
        ComboEdit costCenterBD = (ComboEdit)this.getControl("range");
        switch (allocMold) {
            case "A": {
                costCenterBD.setMustInput(false);
                break;
            }
            case "B": {
                costCenterBD.setMustInput(false);
                break;
            }
            case "C": {
                costCenterBD.setMustInput(true);
            }
        }
    }

    private void setRangeMustInput(Boolean isMustInput) {
        BasedataEdit benfCostCenter = (BasedataEdit)this.getControl("benefcostcenter");
        BasedataEdit costObject = (BasedataEdit)this.getControl("costobject");
        if (null == isMustInput) {
            benfCostCenter.setMustInput(false);
            costObject.setMustInput(true);
        } else {
            benfCostCenter.setMustInput(isMustInput.booleanValue());
            costObject.setMustInput(isMustInput == false);
        }
    }

    private void setElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject subelement = row.getDynamicObject("subelement");
            if (subelement == null) {
                return;
            }
            QFilter subeleIdFilter = new QFilter("subelement", "=", (Object)subelement.getLong("id"));
            DynamicObject elementDetail = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id", (QFilter[])new QFilter[]{subeleIdFilter});
            if (elementDetail != null) {
                int seq = row.getInt("seq");
                int rowIndex = seq - 1;
                this.getModel().setValue("element", (Object)elementDetail.getLong("element.id"), rowIndex);
            }
        }
    }

    private void setSubElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            QFilter subeleQF;
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject element = row.getDynamicObject("element");
            DynamicObject subelement = row.getDynamicObject("subelement");
            if (element == null || subelement == null) {
                return;
            }
            QFilter eleQF = new QFilter("element", "=", (Object)element.getLong("id"));
            boolean existRelation = QueryServiceHelper.exists((String)"cad_elementdetail", (QFilter[])new QFilter[]{eleQF, subeleQF = new QFilter("subelement", "=", (Object)subelement.getLong("id"))});
            if (existRelation) {
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("mfgfeebillentry");
            this.getModel().setValue("subelement", null, rowIndex);
        }
    }

    private void setBizDate() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject period = dataEntity.getDynamicObject("period");
        if (period == null) {
            this.getModel().setValue("bizdate", null);
            return;
        }
        Date currDate = new Date();
        Date enddate = period.getDate("enddate");
        Date bizDate = currDate.compareTo(enddate) > 0 ? enddate : currDate;
        this.getModel().setValue("bizdate", (Object)bizDate);
    }

    private void setPeriod() {
        Long costaccountId;
        QFilter costaccountQF;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF = new QFilter("entry.costaccount", "=", (Object)(costaccountId = Long.valueOf(costaccount.getLong("id"))))});
        if (res != null && res.size() > 0) {
            Long currentperiod = ((DynamicObject)res.get(0)).getLong("currentperiod");
            this.getModel().setValue("period", (Object)currentperiod);
        }
    }

    private void setCostAccount(long orgId) {
        DynamicObjectCollection costaccounts = this.getCostaccount(orgId);
        if (costaccounts == null || costaccounts.size() == 0 || costaccounts.size() > 1) {
            return;
        }
        DynamicObject costaccount = (DynamicObject)costaccounts.get(0);
        this.getModel().setValue("costaccount", (Object)costaccount.getLong("id"));
    }

    private DynamicObjectCollection getCostaccount(Long orgId) {
        QFilter accountorgQF = new QFilter("calorg", "=", (Object)orgId);
        QFilter enablestdtQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        String orderby = "enablestandardcost DESC, number ASC";
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, name", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF}, (String)orderby);
        return result;
    }

    private void cleanInputByCostCenter() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String allocMold = dataEntity.getString("allocmold");
        if ("C".equals(allocMold)) {
            int entryRowCount = this.getModel().getEntryRowCount("mfgfeebillentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("costobject", null, i);
            }
        }
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.get("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        switch (operateKey) {
            case "save": {
                if (this.getModel().getEntryRowCount("mfgfeebillentry") == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u5f52\u96c6\u4e2d\u81f3\u5c11\u9700\u8981\u5b58\u5728\u4e00\u6761\u8d39\u7528\u5f52\u96c6\u5206\u5f55\u6570\u636e\u3002", (String)"MfgfeeBillEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (this.checkMustInputRange()) break;
                e.setCancel(true);
                break;
            }
            case "submit": {
                if (this.getModel().getEntryRowCount("mfgfeebillentry") == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u5f52\u96c6\u4e2d\u81f3\u5c11\u9700\u8981\u5b58\u5728\u4e00\u6761\u8d39\u7528\u5f52\u96c6\u5206\u5f55\u6570\u636e\u3002", (String)"MfgfeeBillEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (this.checkMustInputRange()) break;
                e.setCancel(true);
                break;
            }
            case "submitandnew": {
                this.setElementBySubEle();
                this.cleanBlankRow();
                break;
            }
            case "deleteentry": {
                int entryRowCount = this.getModel().getEntryRowCount("mfgfeebillentry");
                if (entryRowCount != 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u5f52\u96c6\u4e2d\u81f3\u5c11\u9700\u8981\u5b58\u5728\u4e00\u6761\u6570\u636e\u3002", (String)"MfgfeeBillEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "unaudit": {
                if (this.checkBillAllocRes()) break;
                e.setCancel(true);
                break;
            }
            case "searchup": {
                this.searchUpOriginalBill();
                break;
            }
            case "new": {
                fsp.setCustomParam("operate", (Object)"new");
                break;
            }
            case "copy": {
                fsp.setCustomParam("operate", (Object)"copy");
            }
        }
    }

    private boolean checkMustInputRange() {
        Object allocRange;
        Object allocMold = this.getView().getModel().getValue("allocmold");
        if (allocMold.toString().equals("C") && StringUtils.isEmpty((CharSequence)(allocRange = this.getView().getModel().getValue("range")).toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u7c7b\u578b\u4e3a\u57fa\u672c\u751f\u4ea7\u65f6\uff0c\u8d39\u7528\u5206\u914d\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgfeeBillEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void cleanBlankRow() {
        String allocMold = (String)this.getModel().getValue("allocmold");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("mfgfeebillentry");
        if (!"C".equalsIgnoreCase(allocMold) || entryEntity.size() <= 1) {
            return;
        }
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        for (DynamicObject row : entryEntity) {
            DynamicObject costObject = (DynamicObject)row.get("costobject");
            if (costObject != null) continue;
            rowIndexs.add(row.getInt("seq") - 1);
        }
        if (!CadEmptyUtils.isEmpty(rowIndexs)) {
            if (rowIndexs.size() == entryEntity.size()) {
                rowIndexs.remove(0);
            }
            int[] blankRowIndexs = new int[rowIndexs.size()];
            for (int i = 0; i < blankRowIndexs.length; ++i) {
                blankRowIndexs[i] = (Integer)rowIndexs.get(i);
            }
            this.getModel().deleteEntryRows("mfgfeebillentry", blankRowIndexs);
        }
    }

    private boolean checkBillAllocRes() {
        QFilter allocstatusQF;
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!"C".equals(billStatus)) {
            return true;
        }
        Long billId = (Long)this.getModel().getValue("id");
        QFilter srcbillidQF = new QFilter("srcbillid", "=", (Object)billId);
        QFilter[] qf = new QFilter[]{srcbillidQF, allocstatusQF = new QFilter("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue())};
        if (!QueryServiceHelper.exists((String)"sca_mfgfeealloccc", (QFilter[])qf) && !QueryServiceHelper.exists((String)"sca_mfgfeeallocco", (QFilter[])qf)) {
            return true;
        }
        Set<Object> allocBillNos = this.getAllocBillNo(qf);
        StringBuilder showTip = new StringBuilder();
        for (Object allocBillNo : allocBillNos) {
            String billno = (String)allocBillNo;
            String msg = String.format(ResManager.loadKDString((String)"%s: \u5df2\u7ecf\u8fdb\u884c\u4e86\u8d39\u7528\u5206\u914d", (String)"MfgfeeBillEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]), billno);
            showTip.append(msg);
            showTip.append("\r\n");
        }
        showTip.append(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u540e\u4f1a\u5220\u9664\u5206\u914d\u7ed3\u679c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"MfgfeeBillEditPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
        this.getView().showConfirm(showTip.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete", (IFormPlugin)this));
        return false;
    }

    private Set<Object> getAllocBillNo(QFilter[] qf) {
        DynamicObjectCollection ccBills = QueryServiceHelper.query((String)"sca_mfgfeealloccc", (String)"billno", (QFilter[])qf);
        Set ccBillNos = DynamicObjectHelper.getFieldSet((DynamicObjectCollection)ccBills, (String)"billno");
        DynamicObjectCollection coBills = QueryServiceHelper.query((String)"sca_mfgfeeallocco", (String)"billno", (QFilter[])qf);
        Set coBillNos = DynamicObjectHelper.getFieldSet((DynamicObjectCollection)coBills, (String)"billno");
        ccBillNos.addAll(coBillNos);
        return ccBillNos;
    }

    private void searchUpOriginalBill() {
        String[] pkidArr;
        String srcBillId = this.getModel().getDataEntity().getString("srcbillid");
        if (CadEmptyUtils.isEmpty((String)srcBillId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5236\u9020\u8d39\u7528\u5f52\u96c6\u6ca1\u6709\u6765\u6e90\u5355\u636e\u3002", (String)"MfgfeeBillEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("gl_voucher");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        for (String pkid : pkidArr = srcBillId.split("@")) {
            showParameter.addLinkQueryPkId((Object)Long.valueOf(pkid));
        }
        showParameter.getCustomParams().put("org", "");
        showParameter.getCustomParams().put("booktype", "");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setElementBySubEle() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("mfgfeebillentry");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        for (DynamicObject entry : entryEntity) {
            int rowIndex = entry.getInt("seq") - 1;
            DynamicObject element = entry.getDynamicObject("element");
            DynamicObject subelement = entry.getDynamicObject("subelement");
            if (subelement == null || element != null) continue;
            QFilter subeleIdQF = new QFilter("subelement", "=", (Object)subelement.getLong("id"));
            DynamicObject relation = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{subeleIdQF});
            this.getModel().setValue("element", (Object)relation.getLong("element"), rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "delete": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                this.unaudit();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("afterconfirm", "true");
            }
        }
    }

    private void unaudit() {
        Long billId = (Long)this.getModel().getValue("id");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"sca_mfgfeebill", (Object[])new Object[]{billId}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getModel().setValue("billstatus", (Object)"A");
            this.getView().updateView();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"MfgfeeBillEditPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "newentry": {
                this.newRowDefSubEle();
            }
        }
    }

    private void newRowDefSubEle() {
        int entryRowCount = this.getModel().getEntryRowCount("mfgfeebillentry");
        if (entryRowCount <= 0) {
            return;
        }
        this.getModel().setValue("subelement", this.getDefaultSubele(E004), entryRowCount - 1);
    }

    private Object getDefaultSubele(String type) {
        if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("E004"))) {
            return this.getPageCache().get("E004");
        }
        QFilter typeQF = new QFilter("type", "=", (Object)type);
        QFilter defaultQF = new QFilter("defaultvalue", "=", (Object)Boolean.TRUE);
        QFilter enableQF = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection defaultSubele = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{typeQF, defaultQF, enableQF});
        if (defaultSubele != null && defaultSubele.size() > 0) {
            Long id = ((DynamicObject)defaultSubele.get(0)).getLong("id");
            this.getPageCache().put("E004", id.toString());
            return id;
        }
        return null;
    }

    private void setEntryMaterial() {
        int entryRowCount = this.getModel().getEntryRowCount("mfgfeebillentry");
        if (entryRowCount <= 0) {
            return;
        }
        for (int i = 0; i < entryRowCount; ++i) {
            this.setMaterial(i);
        }
    }

    private void setMaterial(int rowIndex) {
        DynamicObject costobject = (DynamicObject)this.getModel().getValue("costobject", rowIndex);
        if (costobject == null) {
            this.getModel().setValue("material", null, rowIndex);
            this.getModel().setValue("auxpty", null, rowIndex);
        } else {
            this.getModel().setValue("material", (Object)costobject.getLong("material.id"), rowIndex);
            this.getModel().setValue("auxpty", (Object)costobject.getLong("auxpty.id"), rowIndex);
        }
    }

    private QFilter getAllocMoldQF() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (StringUtils.isEmpty((CharSequence)allocMold)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u914d\u7c7b\u578b\u3002", (String)"MfgfeeBillEditPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]));
            return new QFilter("orgduty.number", "=", (Object)"-1");
        }
        switch (allocMold) {
            case "A": {
                return new QFilter("orgduty.number", "not in", (Object)new String[]{"4", "5"});
            }
            case "B": {
                return new QFilter("orgduty.number", "=", (Object)"5");
            }
            case "C": {
                return new QFilter("orgduty.number", "=", (Object)"4");
            }
        }
        return new QFilter("orgduty.number", "=", (Object)"-1");
    }

    private void setMustInputCostCenter() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (StringUtils.isEmpty((CharSequence)allocMold)) {
            return;
        }
        BasedataEdit costCenterBD = (BasedataEdit)this.getControl("costcenter");
        switch (allocMold) {
            case "A": {
                costCenterBD.setMustInput(false);
                break;
            }
            case "B": 
            case "C": {
                costCenterBD.setMustInput(true);
            }
        }
    }

    private void cleanInputByAllocMold() {
        String allocMold = (String)this.getModel().getValue("allocmold");
        int entryRowCount = this.getModel().getEntryRowCount("mfgfeebillentry");
        for (int i = 0; i < entryRowCount; ++i) {
            if ("C".equals(allocMold)) {
                this.getModel().setValue("benefcostcenter", null, i);
                continue;
            }
            this.getModel().setValue("costobject", null, i);
            this.getModel().setValue("productgroup", null);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit benefcostcenter = (BasedataEdit)this.getControl("benefcostcenter");
        benefcostcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        ListShowParameter parameter = (ListShowParameter)arg0.getFormShowParameter();
        String name = arg0.getProperty().getName();
        if ("benefcostcenter".equals(name)) {
            Object allocmold = this.getModel().getValue("allocmold");
            Object range = this.getModel().getValue("range");
            if ("C".equals(allocmold) && "B".equals(range)) {
                QFilter qFilter = new QFilter("orgduty.number", "=", (Object)"4");
                parameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        Object range = this.getModel().getValue("range");
        if (range == null) {
            this.getModel().setValue("range", (Object)"C");
        }
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

