/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MfgfeeBillHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.utils.CadUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.ScaAllocEnum;
import kd.macc.sca.common.enums.SysParamEnum;
import kd.macc.sca.formplugin.base.BaseManuorgListPlugin;
import org.apache.commons.collections.CollectionUtils;

public class MfgfeeBillListPlugin
extends BaseManuorgListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_DELETE = "delete";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        String orgId = this.getDefOrg(acctOrgs);
        this.moveTop(acctOrgs, orgId);
        List costAccountItems = null;
        List costCenterItems = null;
        List manuorgItems = null;
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            costAccountItems = StartCostHelper.getCostAccountItems((Long)Long.valueOf(orgId), null, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            costCenterItems = OrgHelper.getCostCenterByAccoutOrg((String)orgId);
            manuorgItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "org.id": {
                    listcomitem.clear();
                    if (CadEmptyUtils.isEmpty((List)acctOrgs)) break;
                    commonFilterColumn.setComboItems(acctOrgs);
                    commonFilterColumn.setDefaultValue(orgId);
                    break;
                }
                case "costaccount.name": {
                    listcomitem.clear();
                    if (costAccountItems == null || costAccountItems.isEmpty()) break;
                    commonFilterColumn.setComboItems(costAccountItems);
                    commonFilterColumn.setDefaultValue(((ComboItem)costAccountItems.get(0)).getValue());
                    this.getPageCache().put("costaccountId", ((ComboItem)costAccountItems.get(0)).getValue());
                    break;
                }
                case "costcenter.name": {
                    listcomitem.clear();
                    if (CadEmptyUtils.isEmpty((List)costCenterItems)) break;
                    commonFilterColumn.setComboItems(costCenterItems);
                    break;
                }
                case "manuorg.name": {
                    listcomitem.clear();
                    if (CollectionUtils.isEmpty((Collection)manuorgItems)) break;
                    commonFilterColumn.setComboItems(manuorgItems);
                    String defVal = "";
                    commonFilterColumn.setDefaultValue(defVal);
                    this.getPageCache().put("manuorg", defVal);
                }
            }
        }
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString(new ArrayList()));
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costcenter")) {
            String accountorgId = this.getPageCache().get("accountorgId");
            args.getQfilters().add(new QFilter("accountorg", "=", (Object)accountorgId).and(new QFilter("enable", "=", (Object)"1")));
        }
    }

    private void moveTop(List<ComboItem> acctOrgs, String orgId) {
        String currOrg;
        String string = currOrg = StringUtils.isEmpty((CharSequence)this.getPageCache().get("currOrg")) ? orgId : this.getPageCache().get("currOrg");
        if (CadEmptyUtils.isEmpty(acctOrgs) || CadEmptyUtils.isEmpty((String)currOrg)) {
            return;
        }
        for (int i = 0; i < acctOrgs.size(); ++i) {
            if (!currOrg.equals(acctOrgs.get(i).getValue())) continue;
            ComboItem temp = acctOrgs.get(0);
            acctOrgs.set(0, acctOrgs.get(i));
            acctOrgs.set(i, temp);
        }
        this.getPageCache().put("currOrg", currOrg);
    }

    private String getDefOrg(List<ComboItem> acctOrgs) {
        String orgId = this.getPageCache().get("accountorgId");
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            Long currAcctOrg = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
            orgId = isAccounting ? currAcctOrg.toString() : (CadEmptyUtils.isEmpty(acctOrgs) ? "0" : acctOrgs.get(0).getValue());
            this.getPageCache().put("accountorgId", orgId);
        }
        return orgId;
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        String accountorgId = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            Map filter = (Map)customfilter.get(i);
            List listFieldName = (List)filter.get("FieldName");
            List listValue = (List)filter.get("Value");
            if (CadEmptyUtils.isEmpty((List)listValue)) continue;
            block13: for (int j = 0; j < listFieldName.size(); ++j) {
                String fieldName;
                switch (fieldName = (String)listFieldName.get(j)) {
                    case "org.id": {
                        accountorgId = (String)listValue.get(j);
                        this.getPageCache().put("accountorgId", accountorgId);
                        this.getPageCache().put("costaccountId", "");
                        this.getPageCache().put("costCenterId", "");
                        this.filterContainerInit(this.filterContainerInitArgs);
                        continue block13;
                    }
                    case "costaccount.id": {
                        String costaccountId = (String)listValue.get(j);
                        this.getPageCache().put("costaccountId", costaccountId);
                        continue block13;
                    }
                    case "costcenter.id": {
                        String costCenterId = (String)listValue.get(j);
                        this.getPageCache().put("costCenterId", costCenterId);
                        continue block13;
                    }
                    case "manuorg.id": {
                        String manuorg = (String)listValue.get(j);
                        this.getPageCache().put("manuorg", manuorg);
                    }
                }
            }
        }
        if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("accountorgId"))) {
            List multiCostCenters = CadUtils.getMultiCostCentersByFilterName((FilterContainerSearchClickArgs)args, (String)"costcenter.id", (Long)Long.parseLong(this.getPageCache().get("accountorgId")));
            this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString((Object)multiCostCenters));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        List userHasPermProOrgsByAccOrg;
        e.getParameter().setCustomParam("accountorgId", (Object)this.getPageCache().get("accountorgId"));
        e.getParameter().setCustomParam("costaccountId", (Object)this.getPageCache().get("costaccountId"));
        e.getParameter().setCustomParam("costCenterId", (Object)this.getPageCache().get("costCenterId"));
        e.getParameter().setCustomParam("manuorg", (Object)this.getPageCache().get("manuorg"));
        String accountorgId = this.getPageCache().get("accountorgId");
        if (!CadEmptyUtils.isEmpty((String)accountorgId) && (userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(accountorgId), (String)this.getBillEntityId())).size() == 0) {
            e.getParameter().setCustomParam("manuorg", null);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "unaudit": {
                QFilter[] qf;
                ListSelectedRowCollection rows = e.getListSelectedData().getBillListSelectedRowCollection();
                if (rows == null || rows.isEmpty() || this.checkAllocBill(qf = this.getAllocFilters(rows))) break;
                e.setCancel(true);
                Set<Object> allocBillNos = this.getAllocBillNo(qf);
                StringBuilder showTip = new StringBuilder();
                for (Object allocBillNo : allocBillNos) {
                    String billno = (String)allocBillNo;
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u7ecf\u8fdb\u884c\u5206\u914d\u3002", (String)"MfgfeeBillListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]), billno);
                    showTip.append(msg);
                    showTip.append("\r\n");
                }
                showTip.append(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u540e\u4f1a\u5220\u9664\u5206\u914d\u7ed3\u679c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"MfgfeeBillListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                this.getView().showConfirm(showTip.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this));
                break;
            }
            case "new": {
                this.checkAddWay(e, "new");
                break;
            }
            case "sysimport": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u79fb\u6b65\u81f3\u65b0\u5f52\u96c6\u5355\u8fdb\u884c\u5bfc\u5165\u3002", (String)"MfgfeeBillListPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
            case "searchup": {
                ListSelectedRowCollection selectedRows = e.getListSelectedData();
                this.searchUpOriginalBillNew(selectedRows);
                break;
            }
            case "submit": {
                if (this.checkMustInputRange(e.getListSelectedData())) break;
                e.setCancel(true);
            }
        }
    }

    private boolean checkMustInputRange(ListSelectedRowCollection selectedRows) {
        if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            return true;
        }
        StringBuilder errorBuild = new StringBuilder();
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow selectPk = selectedRows.get(i);
            DynamicObject ccbill = BusinessDataServiceHelper.loadSingle((Object)selectPk.getPrimaryKeyValue().toString(), (String)this.getEntityName());
            if (!"C".equals(ccbill.getString("allocmold")) || !StringUtils.isEmpty((CharSequence)ccbill.getString("range"))) continue;
            errorBuild.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u5206\u914d\u7c7b\u578b\u4e3a\u57fa\u672c\u751f\u4ea7\u65f6\uff0c\u8d39\u7528\u5206\u914d\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgfeeBillListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]), ccbill.getString("billno")));
        }
        if (errorBuild.length() > 0) {
            this.getView().showTipNotification(errorBuild.toString());
            return false;
        }
        return true;
    }

    private Set<Object> getAllocBillNo(QFilter[] qf) {
        String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        HashSet<Object> allocBillNos = new HashSet<Object>(16);
        if ("aca".equals(appNum)) {
            DynamicObjectCollection ccBills = QueryServiceHelper.query((String)"aca_mfgfeealloccc", (String)"billno", (QFilter[])qf);
            Set ccBillNos = DynamicObjectHelper.getFieldSet((DynamicObjectCollection)ccBills, (String)"billno");
            allocBillNos.addAll(ccBillNos);
            DynamicObjectCollection coBills = QueryServiceHelper.query((String)"aca_mfgfeeallocco", (String)"billno", (QFilter[])qf);
            Set coBillNos = DynamicObjectHelper.getFieldSet((DynamicObjectCollection)coBills, (String)"billno");
            allocBillNos.addAll(coBillNos);
        } else {
            DynamicObjectCollection ccBills = QueryServiceHelper.query((String)"sca_mfgfeealloccc", (String)"billno", (QFilter[])qf);
            Set ccBillNos = DynamicObjectHelper.getFieldSet((DynamicObjectCollection)ccBills, (String)"billno");
            allocBillNos.addAll(ccBillNos);
            DynamicObjectCollection coBills = QueryServiceHelper.query((String)"sca_mfgfeeallocco", (String)"billno", (QFilter[])qf);
            Set coBillNos = DynamicObjectHelper.getFieldSet((DynamicObjectCollection)coBills, (String)"billno");
            allocBillNos.addAll(coBillNos);
        }
        return allocBillNos;
    }

    private boolean checkAllocBill(QFilter[] qf) {
        String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if ("aca".equals(appNum)) {
            return !QueryServiceHelper.exists((String)"aca_mfgfeealloccc", (QFilter[])qf) && !QueryServiceHelper.exists((String)"aca_mfgfeeallocco", (QFilter[])qf);
        }
        return !QueryServiceHelper.exists((String)"sca_mfgfeealloccc", (QFilter[])qf) && !QueryServiceHelper.exists((String)"sca_mfgfeeallocco", (QFilter[])qf);
    }

    private void searchUpOriginalBill(ListSelectedRowCollection selectedRows) {
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter idFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        String entityName = this.getEntityName();
        DynamicObjectCollection srcBillNumbers = QueryServiceHelper.query((String)entityName, (String)"srcbillnum", (QFilter[])new QFilter[]{idFilter});
        Set srcBillNumberSet = srcBillNumbers.stream().filter(item -> !item.getString("srcbillnum").equals("")).map(item -> item.getString("srcbillnum")).collect(Collectors.toSet());
        if (srcBillNumberSet == null || srcBillNumberSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u6ca1\u6709\u6765\u6e90\u5355\u636e\u53f7\u3002", (String)"MfgfeeBillListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        QFilter srcBillNumberFilter = new QFilter("billno", "in", srcBillNumberSet);
        List voucherIds = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{srcBillNumberFilter}, null, (int)-1);
        SrcBillShowerUtils.showSearchUpBill((IFormView)this.getView(), (String)"gl_voucher", (List)voucherIds);
    }

    private void searchUpOriginalBillNew(ListSelectedRowCollection selectedRows) {
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter idFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        String entityName = this.getEntityName();
        DynamicObjectCollection srcBillIds = QueryServiceHelper.query((String)entityName, (String)"srcbillid", (QFilter[])new QFilter[]{idFilter});
        Set srcBillIdSet = srcBillIds.stream().filter(item -> !item.getString("srcbillid").equals("")).map(item -> item.getString("srcbillid")).collect(Collectors.toSet());
        if (srcBillIdSet == null || srcBillIdSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u6ca1\u6709\u6765\u6e90\u5355\u636e\u53f7\u3002", (String)"MfgfeeBillListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("gl_voucher");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        for (String srcBillId : srcBillIdSet) {
            String[] pkidArr;
            for (String pkid : pkidArr = srcBillId.split("@")) {
                showParameter.addLinkQueryPkId((Object)Long.parseLong(pkid));
            }
        }
        showParameter.getCustomParams().put("org", "");
        showParameter.getCustomParams().put("booktype", "");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "delete": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                this.unaudit();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
                this.getView().invokeOperation(KEY_REFRESH);
            }
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            if (!column.toString().equals("billno")) continue;
            column.setFixed(true);
            break;
        }
    }

    public void setFilter(SetFilterEvent e) {
        List userHasPermManuorgs;
        String accountorgId = this.getPageCache().get("accountorgId");
        if (StringUtils.isNotBlank((CharSequence)accountorgId) && CadEmptyUtils.isEmpty((List)(userHasPermManuorgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(accountorgId), (String)this.getBillEntityId())))) {
            QFilter filter = new QFilter("manuorg", "in", (Object)userHasPermManuorgs);
            e.getQFilters().add(filter);
        }
        e.setOrderBy("bookdate desc,billno desc");
    }

    private QFilter[] getAllocFilters(ListSelectedRowCollection rows) {
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            if (!"C".equalsIgnoreCase(row.getBillStatus())) continue;
            ids.add(row.getPrimaryKeyValue());
        }
        QFilter srcbillidQF = new QFilter("srcbillid", "in", ids);
        QFilter allocstatusQF = new QFilter("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
        return new QFilter[]{srcbillidQF, allocstatusQF};
    }

    private void unaudit() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        String entityName = this.getEntityName();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityName, (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"MfgfeeBillListPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private void checkAddWay(BeforeDoOperationEventArgs e, String opr) {
        boolean hasNullValue = this.checkOrgAndCostAccount();
        if (hasNullValue) {
            e.setCancel(true);
            return;
        }
        String orgId = this.getPageCache().get("accountorgId");
        String costCenterId = this.getPageCache().get("costCenterId");
        String appNum = this.getView().getFormShowParameter().getAppId();
        String addWay = SysParamHelper.getScaSysParamAddType((String)orgId, (String)costCenterId, (String)"mfgfeebilltype", (String)appNum);
        if ("new".equals(opr)) {
            if (SysParamEnum.COMPTYPE_MANUAL.getValue().equals(addWay) || StringUtils.isEmpty((CharSequence)addWay)) {
                return;
            }
            e.setCancel(true);
        }
        if ("sysimport".equals(opr)) {
            boolean isSysImport = SysParamEnum.COMPTYPE_SYS.getValue().equals(addWay);
            List<Long> costCenterIdList = new ArrayList<Long>();
            List costCenters = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("multiselectcostcenters"), List.class);
            if (!CadEmptyUtils.isEmpty((List)costCenters) && costCenters.size() > 1) {
                List costCentersList = SysParamHelper.getSysParamCostCenter((String)orgId, (String)"mfgfeebilltype", (String)SysParamEnum.COMPTYPE_SYS.getValue(), (String)appNum);
                for (Long costCenter : costCenters) {
                    if (!costCentersList.contains(costCenter)) continue;
                    costCenterIdList.add(costCenter);
                }
                if (CadEmptyUtils.isEmpty(costCenterIdList)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6210\u672c\u53c2\u6570\u201d\u4e2d\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\uff0c\u4e0d\u5b58\u5728\u201c\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u201d\u7684\u5236\u9020\u8d39\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u3002", (String)"MfgfeeBillListPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put("costCenterIdList", SerializationUtils.toJsonString(costCenterIdList));
                this.openImportWin();
                return;
            }
            if (CadEmptyUtils.isEmpty((String)costCenterId)) {
                costCenterIdList = SysParamHelper.getSysParamCostCenter((String)orgId, (String)"mfgfeebilltype", (String)SysParamEnum.COMPTYPE_SYS.getValue(), (String)appNum);
                if (CadEmptyUtils.isEmpty(costCenterIdList)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6210\u672c\u53c2\u6570\u201d\u4e2d\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\uff0c\u4e0d\u5b58\u5728\u201c\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u201d\u7684\u5236\u9020\u8d39\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u3002", (String)"MfgfeeBillListPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                if (isSysImport) {
                    costCenterIdList.add(0L);
                }
                this.getPageCache().put("costCenterIdList", SerializationUtils.toJsonString(costCenterIdList));
                this.openImportWin();
                return;
            }
            if (isSysImport) {
                costCenterIdList.add(Long.valueOf(costCenterId));
                this.getPageCache().put("costCenterIdList", SerializationUtils.toJsonString(costCenterIdList));
                this.openImportWin();
                return;
            }
        }
        if (StringUtils.isEmpty((CharSequence)addWay)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u201c\u6210\u672c\u53c2\u6570\u201d\u4e2d\u5236\u9020\u8d39\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a%s\u3002", (String)"MfgfeeBillListPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), SysParamEnum.getName(SysParamEnum.COMPTYPE_MANUAL.getValue())));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u201c\u6210\u672c\u53c2\u6570\u201d\u4e2d\u5236\u9020\u8d39\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a%s\u3002", (String)"MfgfeeBillListPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), SysParamEnum.getName(addWay)));
        }
    }

    private boolean checkOrgAndCostAccount() {
        String orgId = this.getPageCache().get("accountorgId");
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgfeeBillListPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
            return true;
        }
        String costaccountId = this.getPageCache().get("costaccountId");
        if (CadEmptyUtils.isEmpty((String)costaccountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"MfgfeeBillListPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void openImportWin() {
        String orgId = this.getPageCache().get("accountorgId");
        String manuorgId = this.getPageCache().get("manuorg");
        ArrayList<String> orgIdList = new ArrayList<String>();
        orgIdList.add(orgId);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("sca_matallocimport");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("org", orgIdList);
        fsp.setCustomParam("manuorg", (Object)manuorgId);
        fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "form"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        List selectData = (List)e.getReturnData();
        if (selectData == null || selectData.size() == 0) {
            return;
        }
        this.importMfgFeeBillBySys(selectData);
    }

    private void importMfgFeeBillBySys(List<DynamicObject> selectData) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        HashSet<Long> costAccountSet = new HashSet<Long>(16);
        for (DynamicObject selectRow : selectData) {
            DynamicObject costaccount = selectRow.getDynamicObject("costaccount");
            costAccountSet.add(costaccount.getLong("id"));
            paramMap.put(String.valueOf(costaccount.getLong("id")), selectRow.getDynamicObject("currentperiod").getLong("id"));
        }
        DynamicObject selectRow = selectData.get(0);
        Long orgId = selectRow.getDynamicObject("org").getLong("id");
        String manuorgId = this.getPageCache().get("manuorg");
        if (CadEmptyUtils.isEmpty((String)manuorgId)) {
            manuorgId = "0";
        }
        paramMap.put("manuorg", Long.parseLong(manuorgId));
        String costCenterIdListStr = this.getPageCache().get("costCenterIdList");
        List costCenterIdList = (List)SerializationUtils.fromJsonString((String)costCenterIdListStr, List.class);
        IFormView view = this.getView();
        Set dyDataRuleCostCenterIds = ImportServiceHelper.getDyDataRuleCostCenter((Long)Long.parseLong(RequestContext.get().getUserId()), (String)view.getFormShowParameter().getAppId(), (String)this.getEntityName(), (String)"4730fc9f000003ae", Collections.singletonList(orgId));
        if (!CadEmptyUtils.isEmpty((Set)dyDataRuleCostCenterIds)) {
            ArrayList notInDataRules = new ArrayList(10);
            costCenterIdList.forEach(p -> {
                if (!dyDataRuleCostCenterIds.contains(Long.parseLong(p.toString()))) {
                    notInDataRules.add(p);
                }
            });
            if (!CadEmptyUtils.isEmpty((List)costCenterIdList)) {
                costCenterIdList.removeAll(notInDataRules);
            }
        }
        paramMap.put("appnum", view.getFormShowParameter().getAppId());
        ExecuteResult executeResult = MfgfeeBillHelper.importMfgFeeBillBySys((Long)orgId, costAccountSet, (List)costCenterIdList, paramMap);
        String submitTip = executeResult.getSubmitTip();
        String aduitTip = executeResult.getAduitTip();
        if (StringUtils.isEmpty((CharSequence)submitTip) && StringUtils.isEmpty((CharSequence)aduitTip)) {
            executeResult.showNotificationSample(view);
            if (executeResult.isSuccess()) {
                view.invokeOperation(KEY_REFRESH, OperateOption.create());
            }
        } else {
            StringBuilder tip = new StringBuilder();
            String successTip = (String)executeResult.getSuccessInfo().get("Success");
            tip.append(successTip).append("\r\n").append(submitTip).append(aduitTip);
            view.showMessage(tip.toString());
            view.invokeOperation(KEY_REFRESH, OperateOption.create());
        }
    }

    private String getEntityName() {
        String entityName = "sca_mfgfeebill";
        if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            entityName = "aca_mfgfeebill";
        }
        return entityName;
    }
}

