/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.ProAllocStdHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.business.wipallocstd.WipAllocStdService;

public class ProAllocStdEdit
extends AbstractBillPlugIn {
    private static final String ELEMENT = "element";
    private static final String SUBELEMENT = "subelement";
    private static final String ASSEMBLEY = "3";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object acctOrg = formShowParameter.getCustomParam("orgId");
        Object costaccount = formShowParameter.getCustomParam("costaccount");
        if (acctOrg != null) {
            this.getModel().setValue("org", acctOrg);
        }
        Object costaccObj = this.getModel().getValue("costaccount");
        if (costaccount != null && costaccObj == null) {
            this.getCostAccountToPageCache();
            this.getModel().setValue("costaccount", costaccount);
        }
        this.getModel().setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        this.getModel().setDataChanged(false);
        int i = 0;
        DynamicObjectCollection allocentry = this.getModel().getDataEntity().getDynamicObjectCollection("allocentry");
        for (DynamicObject obj : allocentry) {
            if (obj.getString("costdriver") != null && !obj.getString("costdriver").equals(obj.getString("diffcalccostdriver"))) {
                this.getPageCache().put("diffCalcIsMannual" + i, "1");
            }
            ++i;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcenter");
        costAccount.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ProAllocStdEdit.this.getCostAccountToPageCache();
                QFilter filters = ProAllocStdEdit.this.getCostAccountFilter();
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.add(filters);
            }
        });
        costCenter.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                QFilter[] filters = ProAllocStdEdit.this.getCostCenterFilter();
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.addAll(Arrays.asList(filters));
            }
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        RefObject afterConfirm = new RefObject();
        switch (operateKey) {
            case "save": {
                this.showConfirmForm(e, operate, (RefObject<String>)afterConfirm, "ProAllocStdEdit_0", "save");
                break;
            }
            case "submit": {
                this.showConfirmForm(e, operate, (RefObject<String>)afterConfirm, "ProAllocStdEdit_1", "submit");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "costaccount": {
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    this.deleteProAllocStdData();
                    break;
                }
                if (!this.getModel().getDataChanged()) break;
                this.getModel().setValue("costaccount", (Object)this.getPageCache().get("costaccount"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        switch (proName) {
            case "subelement": {
                this.setElement(e);
                if (newValue == null || !"001".equals(((DynamicObject)newValue).getString("type"))) {
                    this.getModel().setValue("diffcalccdriverdetail", null, rowIndex);
                    break;
                }
                if (!"001".equals(((DynamicObject)newValue).getString("type"))) break;
                this.getModel().setValue("diffcalccdriverdetail", this.getModel().getValue("costdriverdetail", rowIndex), rowIndex);
                break;
            }
            case "costdriver": {
                int allocentryRowIndex = this.getModel().getEntryCurrentRowIndex("allocentry");
                String diffCalcIsMannual = this.getPageCache().get("diffCalcIsMannual" + allocentryRowIndex);
                if ("1".equals(diffCalcIsMannual)) break;
                this.getPageCache().put("costdriverMannual", "1");
                this.getModel().setValue("diffcalccostdriver", newValue, allocentryRowIndex);
                this.getView().updateView("diffcalccostdriver", allocentryRowIndex);
                break;
            }
            case "diffcalccostdriver": {
                if (!"1".equals(this.getPageCache().get("costdriverMannual"))) {
                    int allocentryRowIndex1 = this.getModel().getEntryCurrentRowIndex("allocentry");
                    this.getPageCache().put("diffCalcIsMannual" + allocentryRowIndex1, "1");
                    break;
                }
                this.getPageCache().remove("costdriverMannual");
                break;
            }
            case "costcenter": {
                break;
            }
            case "costaccount": {
                String count = this.getPageCache().get("count");
                String costaccount = this.getPageCache().get("costaccount");
                if (Integer.parseInt(count) == 1 && costaccount != null) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6210\u672c\u8d26\u7c3f\uff0c\u4f1a\u6e05\u7a7a\u5f53\u524d\u672a\u4fdd\u5b58\u7684\u5206\u914d\u6807\u51c6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProAllocStdEdit_0", (String)"macc-sca-form", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("costaccount", (IFormPlugin)this));
                }
                int temp_count = Integer.parseInt(count) + 1;
                this.getPageCache().put("count", String.valueOf(temp_count));
                break;
            }
            case "costdriverdetail": {
                String diffSubCalcIsMannual;
                if (newValue == null) break;
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex("allocentry");
                if (ASSEMBLEY.equals(newValue.toString())) {
                    DynamicObject costCenterDy = (DynamicObject)this.getModel().getValue("costcenter", currentRowIndex);
                    if (costCenterDy == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u914d\u6807\u51c6\u7b2c%s\u884c\u6210\u672c\u4e2d\u5fc3\u3002", (String)"ProAllocStdEdit_1", (String)"macc-sca-form", (Object[])new Object[0]), String.valueOf(currentRowIndex + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    String costDriverDy = (String)this.getModel().getValue("costdriver", currentRowIndex);
                    if (StringUtils.isEmpty((String)costDriverDy)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u914d\u6807\u51c6\u7b2c%s\u884c\u7efc\u5408\u5206\u914d\u6807\u51c6\u3002", (String)"ProAllocStdEdit_2", (String)"macc-sca-form", (Object[])new Object[0]), String.valueOf(currentRowIndex + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                    EntryGrid subGrid = (EntryGrid)this.getView().getControl("productsubentry");
                    int subRow = subGrid.getSelectRows()[0];
                    DynamicObject subElementDy = (DynamicObject)this.getModel().getValue(SUBELEMENT, subRow);
                    if (subElementDy == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20", (String)"ProAllocStdEdit_3", (String)"macc-sca-form", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    String type = subElementDy.getString("type");
                    String errorMsg = WipAllocStdService.isAllowAssemblyByOrgCc(org.getLong("id"), costCenterDy.getLong("id"), costCenterDy.getString("name"), type);
                    if (StringUtils.isNotEmpty((String)errorMsg)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)errorMsg, (String)"ProAllocStdEdit_24", (String)"ProAllocStdEdit_8", (Object[])new Object[0]));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{SUBELEMENT});
                    this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{"costcenter"});
                } else if ("4".equals(newValue.toString())) {
                    String costDriverDy = (String)this.getModel().getValue("costdriver", currentRowIndex);
                    if (StringUtils.isEmpty((String)costDriverDy)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u914d\u6807\u51c6\u7b2c%s\u884c\u7efc\u5408\u5206\u914d\u6807\u51c6\u3002", (String)"ProAllocStdEdit_2", (String)"macc-sca-form", (Object[])new Object[0]), String.valueOf(currentRowIndex + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    EntryGrid subGrid = (EntryGrid)this.getView().getControl("productsubentry");
                    int subRow = subGrid.getSelectRows()[0];
                    DynamicObject subElementDy = (DynamicObject)this.getModel().getValue(SUBELEMENT, subRow);
                    if (subElementDy == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20", (String)"ProAllocStdEdit_3", (String)"macc-sca-form", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    String type = subElementDy.getString("type");
                    if (!"001".equals(type)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20,\u5c5e\u6027\u4e0d\u4e3a\u7269\u6599,\u4e0d\u80fd\u9009\u62e9\u5728\u4ea7\u6210\u672c\u6309\u6750\u6599\u76d8\u70b9\u8ba1\u7b97\u3002", (String)"ProAllocStdEdit_6", (String)"macc-sca-form", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{SUBELEMENT});
                    this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{"costcenter"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{SUBELEMENT});
                    this.getView().setEnable(Boolean.TRUE, currentRowIndex, new String[]{"costcenter"});
                }
                EntryGrid subGrid = (EntryGrid)this.getView().getControl("productsubentry");
                int subRow = subGrid.getSelectRows()[0];
                DynamicObject subElementDy = (DynamicObject)this.getModel().getValue(SUBELEMENT, subRow);
                String diffcalccdriverdetail = (String)this.getModel().getValue("diffcalccdriverdetail", subRow);
                if (subElementDy == null || !"001".equals(subElementDy.getString("type")) || "1".equals(diffSubCalcIsMannual = this.getPageCache().get("diffCalcIsMannual" + currentRowIndex)) && !StringUtils.isEmpty((String)diffcalccdriverdetail)) break;
                this.getModel().setValue("diffcalccdriverdetail", newValue, rowIndex);
                this.getView().updateView("diffcalccdriverdetail", rowIndex);
                break;
            }
            case "diffcalccdriverdetail": {
                if (newValue == null) break;
                EntryGrid subGrid = (EntryGrid)this.getView().getControl("productsubentry");
                int subRow = subGrid.getSelectRows()[0];
                DynamicObject subElementDy = (DynamicObject)this.getModel().getValue(SUBELEMENT, subRow);
                if (subElementDy == null) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20", (String)"ProAllocStdEdit_3", (String)"macc-sca-form", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                    this.getModel().beginInit();
                    this.getModel().setValue("diffcalccdriverdetail", null, rowIndex);
                    this.getModel().endInit();
                    break;
                }
                String type = subElementDy.getString("type");
                if ("001".equals(type)) break;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\uff0c\u5c5e\u6027\u4e0d\u4e3a\u7269\u6599\uff0c\u5dee\u5f02\u5206\u644a\u660e\u7ec6\u5206\u914d\u6807\u51c6\u53ea\u652f\u6301\u7269\u6599\u7c7b\u578b\u7684\u5b50\u8981\u7d20\u3002", (String)"ProAllocStdEdit_9", (String)"macc-sca-form", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                this.getModel().beginInit();
                this.getModel().setValue("diffcalccdriverdetail", null, rowIndex);
                this.getModel().endInit();
                break;
            }
        }
    }

    private void getCostAccountToPageCache() {
        DynamicObject tempCostAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (tempCostAccount != null) {
            this.getPageCache().put("costaccount", tempCostAccount.getString("id"));
        }
        int count = 1;
        this.getPageCache().put("count", String.valueOf(count));
    }

    public void afterImportData(ImportDataEventArgs e) {
        String billNos;
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        DynamicObject costAccountDy = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccountDy != null && !CadEmptyUtils.isEmpty((String)(billNos = ProAllocStdHelper.checkExistProAllocStd((Object)costAccountDy.getPkValue(), (Object)pkValue, (String)"sca_proallocstd")))) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u88ab\u5355\u636e\u7f16\u53f7\u4e3a\u201c%s\u201d\u4f7f\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"ProAllocStdEdit_7", (String)"macc-sca-form", (Object[])new Object[0]), billNos));
        }
    }

    private void showConfirmForm(BeforeDoOperationEventArgs e, FormOperate operate, RefObject<String> afterConfirm, String resourceID, String callBackId) {
        QFilter effectStatusFilter;
        QFilter pkFilter;
        QFilter qFilter;
        QFilter[] filter;
        DynamicObjectCollection proallostds;
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        DynamicObject costAccountDy = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccountDy != null && !CollectionUtils.isEmpty((Collection)(proallostds = QueryServiceHelper.query((String)"sca_proallocstd", (String)"billno", (QFilter[])(filter = new QFilter[]{qFilter = new QFilter("costaccount", "=", costAccountDy.getPkValue()), pkFilter = new QFilter("id", "!=", pkValue == null ? Long.valueOf(0L) : pkValue), effectStatusFilter = new QFilter("effectstatus", "=", (Object)"1")}))))) {
            StringBuilder stringBuilder = new StringBuilder("\u201c");
            for (DynamicObject proallocstd : proallostds) {
                stringBuilder.append(proallocstd.getString("billno")).append("\uff0c");
            }
            int length = stringBuilder.length();
            stringBuilder.setLength(length - 1);
            stringBuilder.append("\u201d");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u88ab\u5355\u636e\u7f16\u53f7\u4e3a\u201c%s\u201d\u4f7f\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)resourceID, (String)"ProAllocStdEdit_7", (Object[])new Object[0]), stringBuilder.toString()));
            e.setCancel(true);
        }
    }

    private void deleteProAllocStdData() {
        this.getModel().deleteEntryData("allocentry");
        this.getModel().deleteEntryData("productsubentry");
    }

    private void setElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject subelement = row.getDynamicObject(SUBELEMENT);
            if (subelement == null) {
                return;
            }
            QFilter subeleIdFilter = new QFilter(SUBELEMENT, "=", (Object)subelement.getLong("id"));
            DynamicObject elementDetail = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id AS element", (QFilter[])new QFilter[]{subeleIdFilter});
            if (elementDetail != null) {
                int seq = row.getInt("seq");
                int rowIndex = seq - 1;
                this.getModel().setValue(ELEMENT, (Object)elementDetail.getLong(ELEMENT), rowIndex);
            }
        }
    }

    private QFilter getSubElementFilter() {
        ArrayList<Long> ids = new ArrayList<Long>();
        int rowCount = this.getModel().getEntryRowCount("productsubentry");
        for (int row = 0; row < rowCount; ++row) {
            DynamicObject subelement = (DynamicObject)this.getModel().getValue(SUBELEMENT, row);
            if (subelement == null) continue;
            ids.add((Long)subelement.getPkValue());
        }
        if (CadEmptyUtils.isEmpty(ids)) {
            return null;
        }
        return new QFilter("id", "not in", ids);
    }

    private QFilter[] getCostCenterFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        ArrayList<Long> ids = new ArrayList<Long>();
        int rowCount = this.getModel().getEntryRowCount("allocentry");
        for (int row = 0; row < rowCount; ++row) {
            DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter", row);
            if (costcenter == null) continue;
            ids.add((Long)costcenter.getPkValue());
        }
        QFilter idFilter = new QFilter("id", "not in", ids);
        QFilter orgFilter = new QFilter("accountorg", "=", org.getPkValue());
        QFilter orgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
        return new QFilter[]{idFilter, orgFilter, orgDutyFilter};
    }

    private QFilter getCostAccountFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        ArrayList<Long> ids = new ArrayList<Long>(10);
        ArrayList<Long> costaccountIds = new ArrayList<Long>();
        QFilter orgFilter = new QFilter("org", "=", org == null ? Long.valueOf(0L) : org.getPkValue());
        QFilter isStartStdCostFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isinitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        DynamicObjectCollection costaccounts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id", (QFilter[])new QFilter[]{orgFilter, isStartStdCostFilter, qfAppNum, isinitFilter});
        for (DynamicObject costaccount : costaccounts) {
            costaccountIds.add(costaccount.getLong("id"));
        }
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        QFilter[] filter = new QFilter[]{orgFilter};
        if (pkValue != null) {
            QFilter pkFilter = new QFilter("id", "!=", pkValue);
            filter = new QFilter[]{orgFilter, pkFilter};
        }
        DynamicObjectCollection proallostds = QueryServiceHelper.query((String)"sca_proallocstd", (String)"costaccount.id id", (QFilter[])filter);
        for (DynamicObject proallocstd : proallostds) {
            Long costaccount = proallocstd.getLong("id");
            ids.add(costaccount);
        }
        costaccountIds.removeAll(ids);
        return new QFilter("id", "in", costaccountIds);
    }
}

