/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.EffectiveHelper;
import kd.macc.cad.common.helper.ForceDelHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class ProAllocStdList
extends BaseOrgAndCostAccountListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String orderBy = e.getOrderBy();
        orderBy = StringUtils.isNotBlank((CharSequence)orderBy) ? orderBy.concat(",").concat("billno desc").concat("effectdate").concat("desc") : "billno desc,effectdate desc";
        e.setOrderBy(orderBy);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)args, (Set)Sets.newHashSet((Object[])new String[]{"element.name", "subelement.name", "costdriverdetail", "diffcalccdriverdetail"}));
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        EffectiveHelper.buildEffectStatusFilterColumn((FilterContainerInitArgs)args);
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"tblnew"});
    }

    @Override
    protected void resetCostAccount(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIdList);
        if (CollectionUtils.isEmpty(comboItems)) {
            return;
        }
        commonFilterColumn.setComboItems(comboItems);
    }

    @Override
    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        if (CadEmptyUtils.isEmpty(orgId)) {
            return null;
        }
        ArrayList<Long> orgList = new ArrayList<Long>(orgId.size());
        for (Object object : orgId) {
            if ("".equals(object)) continue;
            orgList.add(Long.parseLong(object + ""));
        }
        QFilter filter = new QFilter("org", "in", orgList);
        QFilter isStartStdCostFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter appNum = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id,entryentity.costaccount.name name", (QFilter[])new QFilter[]{filter, isStartStdCostFilter, isInitFilter, appNum});
        if (CollectionUtils.isEmpty((Collection)ccs)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        if ("tblnew".equals(itemkey)) {
            List orgList;
            String orgId = this.getPageCache().get(this.ORG_FIELD);
            if (!StringUtils.isEmpty((CharSequence)orgId) && !CadEmptyUtils.isEmpty((List)(orgList = (List)SerializationUtils.fromJsonString((String)orgId, List.class)))) {
                orgId = (String)orgList.get(0);
            }
            if (StringUtils.isEmpty((CharSequence)orgId) || "0".equals(orgId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u4e0d\u80fd\u6267\u884c\u65b0\u589e\u64cd\u4f5c\u3002", (String)"ProAllocStdList_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
        if ("forcedel".equals(itemkey)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) {
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f3a\u5236\u5220\u9664\u53ef\u80fd\u4f1a\u5bfc\u81f4\u6709\u6548\u671f\u95f4\u4e0d\u8fde\u7eed\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProAllocStdList_1", (String)"macc-sca-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("forcedel", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("forcedel".equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            ForceDelHelper.forceDel((EntityType)this.getBillEntityType(), (Object[])selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray(), (String)this.getView().getFormShowParameter().getAppId());
            BillList list = (BillList)this.getView().getControl("billlistap");
            if (list != null) {
                list.refresh();
            }
        }
    }

    protected EntityType getBillEntityType() {
        return ((IListView)this.getView()).getListModel().getDataEntityType();
    }
}

