/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.init;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.helper.AcaInitHelper;
import kd.macc.sca.common.helper.ScaInitHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class StartStdCostEditPlugin
extends AbstractBillPlugIn {
    private static final String CAL_SYSCTRLENTITY = "cal_sysctrlentity";
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENABLE_USE = "enableuse";
    private static final String CLOSE_INIT = "closeinit";
    private static final String ANTI_CLOSE_INIT = "anticloseinit";
    private static final String ANTI_ENABLE_USE = "antienableuse";
    public static final Long ACA_COST_TYPE_ID = 957770985921275904L;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        if ("sca".equals(showParameter.getAppId())) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u542f\u7528\u6807\u51c6\u6210\u672c\u6838\u7b97", (String)"StartStdCostEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
        } else if ("aca".equals(showParameter.getAppId())) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u542f\u7528\u5b9e\u9645\u6210\u672c\u6838\u7b97", (String)"StartStdCostEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
        } else if ("eca".equals(showParameter.getAppId())) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u542f\u7528\u670d\u52a1\u6210\u672c\u6838\u7b97", (String)"StartStdCostEditPlugin_33", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit startperiod = (BasedataEdit)this.getControl("startperiod");
        startperiod.addBeforeF7SelectListener(evt -> {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
        });
        BasedataEdit currentperiod = (BasedataEdit)this.getControl("currentperiod");
        currentperiod.addBeforeF7SelectListener(evt -> {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
        });
    }

    public void afterCreateNewData(EventObject e) {
        List orgList;
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        if (this.isFilterByNoSpecificOrgAndPageFirstInit()) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org != null) {
                this.getModel().setValue("org", null);
            }
            this.getPageCache().put("init", "true");
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("org") != null && this.getPageCache().get("init") == null && !CadEmptyUtils.isEmpty((List)(orgList = (List)SerializationUtils.fromJsonString((String)customParams.get("org").toString(), List.class))) && !CadEmptyUtils.isEmpty((String)String.valueOf(orgList.get(0)))) {
            this.getModel().setValue("org", orgList.get(0));
        }
        this.getPageCache().put("init", "true");
        DynamicObject stdCostInfo = this.loadDbInfo();
        if (stdCostInfo != null) {
            BillModel model = (BillModel)this.getModel();
            model.setPKValue(stdCostInfo.get("id"));
            model.load(stdCostInfo.get("id"));
        } else {
            this.createStdCostForNewOp();
        }
        this.separateAccountByAppNum();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setCurrentPeriod();
        AppIdHelper.setAppId((IFormView)this.getView(), (IDataModel)this.getModel());
        this.separateAccountByAppNum();
    }

    private void separateAccountByAppNum() {
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue(ENTRY_ENTITY);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys) && CadEmptyUtils.isEmpty((Long)this.getOrgId())) {
            return;
        }
        Iterator iterator = entrys.iterator();
        List<Long> costAccountByAppId = this.getCostAccountNotCurrentAppId(this.getOrgId());
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            if (!costAccountByAppId.contains(next.getLong("costaccount.id"))) continue;
            iterator.remove();
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operationKey = ((FormOperate)args.getSource()).getOperateKey();
        String billNo = (String)this.getModel().getValue("billno");
        if (ENABLE_USE.equals(operationKey)) {
            if (CadEmptyUtils.isEmpty((String)billNo)) {
                return;
            }
            this.checkEntryEntity();
            this.checkData();
            this.enableUse();
            return;
        }
        if (ANTI_ENABLE_USE.equals(operationKey)) {
            if (CadEmptyUtils.isEmpty((String)billNo)) {
                return;
            }
            this.checkEntryEntity();
            this.checkData();
            this.antiEnableUse();
            return;
        }
        if (CLOSE_INIT.equals(operationKey)) {
            if (CadEmptyUtils.isEmpty((String)billNo)) {
                return;
            }
            this.checkEntryEntity();
            this.checkData();
            if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                this.existUnAuditWipCostInit();
            }
            this.closeInit();
            return;
        }
        if (ANTI_CLOSE_INIT.equals(operationKey)) {
            if (CadEmptyUtils.isEmpty((String)billNo)) {
                return;
            }
            this.checkEntryEntity();
            this.checkData();
            this.antiCloseInit();
        }
    }

    private void checkData() {
        Object billno = this.getModel().getValue("billno");
        if (billno == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u7f16\u53f7\u3002", (String)"StartStdCostEditPlugin_29", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        Object org = this.getModel().getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"StartStdCostEditPlugin_30", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        Object appnum = this.getModel().getValue("appnum");
        if (appnum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6240\u5c5e\u5e94\u7528\u3002", (String)"StartStdCostEditPlugin_31", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        QFilter billnoQf = new QFilter("billno", "=", billno);
        QFilter idQf = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
        QFilter orgQf = new QFilter("org", "=", ((DynamicObject)org).getPkValue());
        boolean exists = QueryServiceHelper.exists((String)"sca_startstdcost", (QFilter[])new QFilter[]{billnoQf, orgQf, idQf});
        if (exists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7f16\u53f7\u201d\u3001\u201c\u6838\u7b97\u7ec4\u7ec7\u201d \u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"StartStdCostEditPlugin_32", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    private void existUnAuditWipCostInit() {
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        HashSet costAccountIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (int selectRow : selectRows) {
            DynamicObject rowData = (DynamicObject)entryEntity.get(selectRow);
            Long costAccountId = rowData.getLong("costaccount.id");
            costAccountIdSet.add(costAccountId);
        }
        QFilter costAccountF = new QFilter("costaccount", "in", (Object)costAccountIdSet);
        QFilter statusF = new QFilter("billstatus", "!=", (Object)"C");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"aca_wipcostinit", (String)"billno", (QFilter[])new QFilter[]{costAccountF, statusF});
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            String billNos = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.joining(","));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u5355\u636e\u7f16\u53f7%s\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5355\u636e\u672a\u5ba1\u6838\u3002", (String)"StartStdCostEditPlugin_36", (String)"macc-sca-form", (Object[])new Object[0]), billNos));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        if ("refreshcostaccount".equals(operationKey)) {
            if (this.checkOrgExistIfDataNotFromDB()) {
                return;
            }
            this.removeUnavailableCostAccount();
            this.refreshNewCostAccount();
            if (this.getModel().getDataChanged()) {
                this.showNotificationAfterSave(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u672c\u8d26\u7c3f\u6210\u529f\u3002", (String)"StartStdCostEditPlugin_24", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u672c\u8d26\u7c3f\u6210\u529f\u3002", (String)"StartStdCostEditPlugin_24", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    private boolean checkOrgExistIfDataNotFromDB() {
        Long orgId;
        QFilter[] filters;
        boolean exists;
        if (!this.getModel().getDataEntity().getDataEntityState().getFromDatabase() && (exists = QueryServiceHelper.exists((String)"sca_startstdcost", (QFilter[])(filters = this.getFiltersByOrgAndApplication(orgId = this.getOrgId(), "org"))))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u672c\u8d26\u7c3f\u5931\u8d25\uff0c\u6838\u7b97\u7ec4\u7ec7\u5df2\u5b58\u5728\u3002", (String)"StartStdCostEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private QFilter[] getFiltersByOrgAndApplication(Long orgId, String org) {
        QFilter orgFilter = new QFilter(org, "=", (Object)orgId);
        return new QFilter[]{orgFilter, AppIdHelper.getAppIdFilter((IFormView)this.getView())};
    }

    private boolean refreshNewCostAccount() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObjectCollection costAccountList = this.getCostAccountList();
        if (costAccountList == null || costAccountList.isEmpty()) {
            return false;
        }
        Set costAccountIdsForCalSysCtrl = costAccountList.stream().map(costAccount -> costAccount.getLong("cost_account_id")).collect(Collectors.toSet());
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject costAccountInfo = (DynamicObject)iterator.next();
            long costAccountId = costAccountInfo.getLong("costaccount.id");
            if (costAccountIdsForCalSysCtrl.contains(costAccountId) || costAccountInfo.getBoolean("isenabled") || costAccountInfo.getBoolean("isinit")) continue;
            iterator.remove();
        }
        Set costIdSet = entryEntity.stream().map(entry -> entry.getLong("costaccount.id")).collect(Collectors.toSet());
        this.getModel().beginInit();
        for (DynamicObject costAccount2 : costAccountList) {
            if (costIdSet.contains(costAccount2.getLong("cost_account_id"))) continue;
            int rowIndex = this.getModel().createNewEntryRow(ENTRY_ENTITY);
            this.getModel().setValue("costaccount", costAccount2.get("cost_account_id"), rowIndex);
            this.getModel().setValue("calpolicy", costAccount2.get("calpolicy_id"), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
        return true;
    }

    private boolean removeUnavailableCostAccount() {
        Set<Long> unavailableCostAccountIds = this.getUnavailableCostAccountIds();
        List<Long> costAccountByAppId = this.getCostAccountNotCurrentAppId(this.getOrgId());
        costAccountByAppId.addAll(unavailableCostAccountIds);
        if (CollectionUtils.isEmpty(costAccountByAppId)) {
            return false;
        }
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_ENTITY);
        Iterator entrys = entryEntity.iterator();
        while (entrys.hasNext()) {
            DynamicObject next = (DynamicObject)entrys.next();
            if (!costAccountByAppId.contains(next.getLong("costaccount.id"))) continue;
            entrys.remove();
        }
        this.getView().updateView(ENTRY_ENTITY);
        return true;
    }

    private Set<Long> getUnavailableCostAccountIds() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_ENTITY);
        Set costAccountIds = entryEntity.stream().filter(costAccount -> !costAccount.getBoolean("isenabled") && !costAccount.getBoolean("isinit")).map(costAccount -> costAccount.getLong("costaccount.id")).collect(Collectors.toSet());
        QFilter enableFilter = new QFilter("enable", "=", (Object)false);
        QFilter idsFilter = new QFilter("id", "in", costAccountIds);
        QFilter[] filters = new QFilter[]{enableFilter, idsFilter};
        DynamicObjectCollection unavailableCostAccountList = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Collection)unavailableCostAccountList)) {
            return Collections.emptySet();
        }
        return unavailableCostAccountList.stream().map(costAccount -> costAccount.getLong("id")).collect(Collectors.toSet());
    }

    private void antiCloseInit() {
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<Integer> needSaveRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> alreadyDoCalculateRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> notEndInitRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> currPeriodNotEqualsStartPeriodRowIndexes = new ArrayList<Integer>();
        ArrayList<Long> costAccountIds = new ArrayList<Long>();
        HashMap<Long, DynamicObject> costAccountIdAndStartPeriodMap = new HashMap<Long, DynamicObject>();
        for (int selectRowIndex : selectRows) {
            DynamicObject row = (DynamicObject)entryEntity.get(selectRowIndex);
            if (row.getBoolean("isinit") == Boolean.FALSE.booleanValue()) {
                notEndInitRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            Object startPeriod = row.getDynamicObject("startperiod").getPkValue();
            Object currentPeriod = null;
            if (row.getDynamicObject("currentperiod") != null) {
                currentPeriod = row.getDynamicObject("currentperiod").getPkValue();
            }
            if (startPeriod != currentPeriod) {
                currPeriodNotEqualsStartPeriodRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            if (this.existProductCalculateResult(row)) {
                alreadyDoCalculateRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            this.getModel().setValue("isinit", (Object)Boolean.FALSE, selectRowIndex);
            needSaveRowIndexes.add(selectRowIndex);
            costAccountIds.add(row.getLong("costaccount.id"));
            costAccountIdAndStartPeriodMap.put(row.getLong("costaccount.id"), row.getDynamicObject("startperiod"));
        }
        if (CollectionUtils.isNotEmpty(needSaveRowIndexes)) {
            this.showNotificationAfterSave(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"StartStdCostEditPlugin_25", (String)"macc-sca-form", (Object[])new Object[0]));
            if ("sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                ScaInitHelper.delCalcResult(this.getOrgId(), costAccountIds);
            }
            if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                AcaInitHelper.insertOrUpdateCalcResultPeriodEndInfo(this.getOrgId(), costAccountIdAndStartPeriodMap, true);
            }
        }
        StringBuilder errorMessages = new StringBuilder();
        if (CollectionUtils.isNotEmpty(alreadyDoCalculateRowIndexes)) {
            errorMessages.append(String.format(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u8fdb\u884c\u4e86\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u6216\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\u8ba1\u7b97\u3002%2$s", (String)"StartStdCostEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), StringUtils.join(alreadyDoCalculateRowIndexes, (String)","), NEW_LINE));
        }
        if (CollectionUtils.isNotEmpty(notEndInitRowIndexes)) {
            errorMessages.append(String.format(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002%2$s", (String)"StartStdCostEditPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), StringUtils.join(notEndInitRowIndexes, (String)","), NEW_LINE));
        }
        if (CollectionUtils.isNotEmpty(currPeriodNotEqualsStartPeriodRowIndexes)) {
            errorMessages.append(String.format(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u2260\u542f\u7528\u671f\u95f4\u3002%2$s", (String)"StartStdCostEditPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), StringUtils.join(currPeriodNotEqualsStartPeriodRowIndexes, (String)","), NEW_LINE));
        }
        if (!"".equals(errorMessages.toString())) {
            this.getView().showMessage(errorMessages.toString());
        }
    }

    private void closeInit() {
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<Integer> needSaveRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> isUnEnabledRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> alreadyEndInitRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> currPeriodNotEqualsStartPeriodRowIndexes = new ArrayList<Integer>();
        HashMap<Long, DynamicObject> costAccountIdAndStartPeriodMap = new HashMap<Long, DynamicObject>();
        for (int selectRowIndex : selectRows) {
            DynamicObject row = (DynamicObject)entryEntity.get(selectRowIndex);
            if (row.getBoolean("isenabled") == Boolean.FALSE.booleanValue()) {
                isUnEnabledRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            if (row.getBoolean("isinit")) {
                alreadyEndInitRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            Object startPeriod = row.getDynamicObject("startperiod").getPkValue();
            Object currentPeriod = null;
            if (row.getDynamicObject("currentperiod") != null) {
                currentPeriod = row.getDynamicObject("currentperiod").getPkValue();
            }
            if (startPeriod != currentPeriod) {
                currPeriodNotEqualsStartPeriodRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            needSaveRowIndexes.add(selectRowIndex);
            this.getModel().setValue("isinit", (Object)Boolean.TRUE, selectRowIndex);
            costAccountIdAndStartPeriodMap.put(row.getLong("costaccount.id"), row.getDynamicObject("startperiod"));
        }
        if (CollectionUtils.isNotEmpty(needSaveRowIndexes)) {
            this.showNotificationAfterSave(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"StartStdCostEditPlugin_26", (String)"macc-sca-form", (Object[])new Object[0]));
            if ("sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                ScaInitHelper.initCostToCalcResult(this.getOrgId(), costAccountIdAndStartPeriodMap);
            }
            if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                AcaInitHelper.insertOrUpdateCalcResultPeriodEndInfo(this.getOrgId(), costAccountIdAndStartPeriodMap, false);
            }
        }
        StringBuilder errorMessages = new StringBuilder();
        if (CollectionUtils.isNotEmpty(isUnEnabledRowIndexes)) {
            errorMessages.append(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\uff0c\u672a\u542f\u7528\u4e0d\u9700\u8981\u7ed3\u675f\u521d\u59cb\u5316\u3002%2$s", (String)"StartStdCostEditPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]), StringUtils.join(isUnEnabledRowIndexes, (String)","), NEW_LINE));
        }
        if (CollectionUtils.isNotEmpty(alreadyEndInitRowIndexes)) {
            errorMessages.append(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\uff0c\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u3002%2$s", (String)"StartStdCostEditPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]), StringUtils.join(alreadyEndInitRowIndexes, (String)","), NEW_LINE));
        }
        if (CollectionUtils.isNotEmpty(currPeriodNotEqualsStartPeriodRowIndexes)) {
            errorMessages.append(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\uff0c\u5f53\u524d\u671f\u95f4\u4e3a\u542f\u7528\u671f\u95f4\u624d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002%2$s", (String)"StartStdCostEditPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]), StringUtils.join(currPeriodNotEqualsStartPeriodRowIndexes, (String)","), NEW_LINE));
        }
        if (!"".equals(errorMessages.toString())) {
            this.getView().showMessage(errorMessages.toString());
        }
    }

    private void antiEnableUse() {
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<Integer> needSaveRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> isNotEnabledRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> alreadyEndInitRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> currPeriodNotEqualsStartPeriodRowIndexes = new ArrayList<Integer>();
        for (int selectRowIndex : selectRows) {
            DynamicObject row = (DynamicObject)entryEntity.get(selectRowIndex);
            if (row.getBoolean("isenabled") == Boolean.FALSE.booleanValue()) {
                isNotEnabledRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            if (row.getBoolean("isinit")) {
                alreadyEndInitRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            Object startPeriod = row.getDynamicObject("startperiod").getPkValue();
            Object currentPeriod = null;
            if (row.getDynamicObject("currentperiod") != null) {
                currentPeriod = row.getDynamicObject("currentperiod").getPkValue();
            }
            if (startPeriod != currentPeriod) {
                currPeriodNotEqualsStartPeriodRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            this.getModel().setValue("isenabled", (Object)Boolean.FALSE, selectRowIndex);
            needSaveRowIndexes.add(selectRowIndex);
        }
        if (CollectionUtils.isNotEmpty(needSaveRowIndexes)) {
            this.showNotificationAfterSave(ResManager.loadKDString((String)"\u53cd\u542f\u7528\u6210\u529f\u3002", (String)"StartStdCostEditPlugin_27", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        StringBuilder errorMessages = new StringBuilder();
        if (CollectionUtils.isNotEmpty(isNotEnabledRowIndexes)) {
            errorMessages.append(String.format(this.getNotEnabledErrorMsgByApp(), StringUtils.join(isNotEnabledRowIndexes, (String)","), NEW_LINE));
        }
        if (CollectionUtils.isNotEmpty(alreadyEndInitRowIndexes)) {
            errorMessages.append(String.format(ResManager.loadKDString((String)"\u53cd\u542f\u7528\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u3002%2$s", (String)"StartStdCostEditPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]), StringUtils.join(alreadyEndInitRowIndexes, (String)","), NEW_LINE));
        }
        if (CollectionUtils.isNotEmpty(currPeriodNotEqualsStartPeriodRowIndexes)) {
            errorMessages.append(String.format(ResManager.loadKDString((String)"\u53cd\u542f\u7528\u5931\u8d25\u3002\u7b2c%s\u884c\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u2260\u542f\u7528\u671f\u95f4\u3002", (String)"StartStdCostEditPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]), StringUtils.join(currPeriodNotEqualsStartPeriodRowIndexes, (String)",")));
        }
        if (!"".equals(errorMessages.toString())) {
            this.getView().showMessage(errorMessages.toString());
        }
    }

    private void enableUse() {
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        ArrayList<Integer> noStartPeriodRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> alreadyEnableUseRowIndexes = new ArrayList<Integer>();
        ArrayList<Integer> needSaveRowIndexes = new ArrayList<Integer>();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        Map<Long, Long> costAccountIdAndCurrentPeriodIdMap = this.getCostAccountIdAndCurrentPeriodIdMap();
        for (int selectRowIndex : selectRows) {
            DynamicObject row = (DynamicObject)entryEntity.get(selectRowIndex);
            Long currentPeriod = costAccountIdAndCurrentPeriodIdMap.get(row.getLong("costaccount.id"));
            if (currentPeriod == null) {
                noStartPeriodRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            this.getModel().setValue("startperiod", (Object)currentPeriod, selectRowIndex);
            this.getModel().setValue("currentperiod", (Object)currentPeriod, selectRowIndex);
            if (row.getBoolean("isenabled")) {
                alreadyEnableUseRowIndexes.add(selectRowIndex + 1);
                continue;
            }
            this.getModel().setValue("isenabled", (Object)Boolean.TRUE, selectRowIndex);
            if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
                this.getModel().setValue("costtype", (Object)ACA_COST_TYPE_ID, selectRowIndex);
            }
            needSaveRowIndexes.add(selectRowIndex);
        }
        if (CollectionUtils.isNotEmpty(needSaveRowIndexes)) {
            this.showNotificationAfterSave(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"StartStdCostEditPlugin_28", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        StringBuilder errorMessages = new StringBuilder();
        if (CollectionUtils.isNotEmpty(noStartPeriodRowIndexes)) {
            errorMessages.append(String.format(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u672a\u586b\u5145\u542f\u7528\u671f\u95f4\u3002%2$s", (String)"StartStdCostEditPlugin_18", (String)"macc-sca-form", (Object[])new Object[0]), StringUtils.join(noStartPeriodRowIndexes, (String)","), NEW_LINE));
        }
        if (CollectionUtils.isNotEmpty(alreadyEnableUseRowIndexes)) {
            errorMessages.append(String.format(this.getEnabledErrorMsgByApp(), StringUtils.join(alreadyEnableUseRowIndexes, (String)","), NEW_LINE));
        }
        if (!"".equals(errorMessages.toString())) {
            this.getView().showMessage(errorMessages.toString());
        }
    }

    private String getNotEnabledErrorMsgByApp() {
        String errorMsg = ResManager.loadKDString((String)"\u53cd\u542f\u7528\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6807\u51c6\u6210\u672c\u6838\u7b97\u3002%2$s", (String)"StartStdCostEditPlugin_19", (String)"macc-sca-form", (Object[])new Object[0]);
        if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            errorMsg = ResManager.loadKDString((String)"\u53cd\u542f\u7528\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u5b9e\u9645\u6210\u672c\u6838\u7b97\u3002%2$s", (String)"StartStdCostEditPlugin_20", (String)"macc-sca-form", (Object[])new Object[0]);
        } else if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            errorMsg = ResManager.loadKDString((String)"\u53cd\u542f\u7528\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u670d\u52a1\u6210\u672c\u6838\u7b97\u3002%2$s", (String)"StartStdCostEditPlugin_34", (String)"macc-sca-form", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    private String getEnabledErrorMsgByApp() {
        String errorMsg = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u5df2\u542f\u7528\u6807\u51c6\u6210\u672c\u6838\u7b97\u3002%2$s", (String)"StartStdCostEditPlugin_21", (String)"macc-sca-form", (Object[])new Object[0]);
        if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            errorMsg = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u5df2\u542f\u7528\u5b9e\u9645\u6210\u672c\u6838\u7b97\u3002%2$s", (String)"StartStdCostEditPlugin_22", (String)"macc-sca-form", (Object[])new Object[0]);
        } else if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            errorMsg = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u5df2\u542f\u7528\u670d\u52a1\u6210\u672c\u6838\u7b97\u3002%2$s", (String)"StartStdCostEditPlugin_35", (String)"macc-sca-form", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    private void checkEntryEntity() {
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c", (String)"StartStdCostEditPlugin_23", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    private void createStdCostForNewOp() {
        OperationResult operationResult;
        DynamicObjectCollection costAccountList = this.getCostAccountList();
        if (costAccountList == null || costAccountList.isEmpty()) {
            return;
        }
        Map<Object, Object> costAccountMap = costAccountList.stream().collect(Collectors.toMap(item -> item.get("cost_account_id"), item -> Arrays.asList(item.get("calpolicy_id"), item.get("currentperiod")), (v1, v2) -> v1));
        costAccountMap.forEach((costAccountId, calPolicyIdAndCurrentPeriod) -> {
            int rowIndex = this.getModel().createNewEntryRow(ENTRY_ENTITY);
            this.getModel().setValue("costaccount", costAccountId, rowIndex);
            this.getModel().setValue("calpolicy", ((List)calPolicyIdAndCurrentPeriod).get(0), rowIndex);
        });
        String billNo = (String)this.getModel().getValue("billno");
        if (!CadEmptyUtils.isEmpty((String)billNo) && (operationResult = this.getView().invokeOperation("save")).isSuccess()) {
            this.getView().getActionResult().clear();
        }
    }

    private DynamicObjectCollection getCostAccountList() {
        Long orgId = this.getOrgId();
        if (orgId == null) {
            return null;
        }
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter costAccountEnableFilter = new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter enableFilter = new QFilter("entry.startperiod", "!=", (Object)0L);
        enableFilter.and("entry.startperiod", "is not null", null);
        List<Long> costAccountNotCurrentAppId = this.getCostAccountNotCurrentAppId(orgId);
        QFilter notCurrentAppIdCostAccountFilter = null;
        if (!CadEmptyUtils.isEmpty(costAccountNotCurrentAppId)) {
            notCurrentAppIdCostAccountFilter = new QFilter("entry.costaccount", "not in", costAccountNotCurrentAppId);
        }
        if (notCurrentAppIdCostAccountFilter != null) {
            orgFilter = orgFilter.and(notCurrentAppIdCostAccountFilter);
        }
        QFilter[] filters = new QFilter[]{orgFilter, costAccountEnableFilter, enableFilter};
        String selectedFields = "id,entry.costaccount.id as cost_account_id, entry.costaccount.calpolicy.id as calpolicy_id,entry.startperiod as startperiod, entry.currentperiod as currentperiod";
        return QueryServiceHelper.query((String)CAL_SYSCTRLENTITY, (String)selectedFields, (QFilter[])filters);
    }

    private DynamicObjectCollection getAllCostAccountFromCalSysByOrgId() {
        Long orgId = this.getOrgId();
        if (orgId == null) {
            return null;
        }
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter costAccountEnableFilter = new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter startPeriodFilter = new QFilter("entry.startperiod", "!=", (Object)0L);
        startPeriodFilter.and("entry.startperiod", "is not null", (Object)"null");
        QFilter[] filters = new QFilter[]{orgFilter, costAccountEnableFilter, startPeriodFilter};
        String selectedFields = "id,entry.costaccount.id as cost_account_id, entry.costaccount.calpolicy.id as calpolicy_id,entry.startperiod as startperiod, entry.currentperiod as currentperiod";
        return QueryServiceHelper.query((String)CAL_SYSCTRLENTITY, (String)selectedFields, (QFilter[])filters);
    }

    private List<Long> getCostAccountNotCurrentAppId(Long orgId) {
        ArrayList<Long> costAccountId = new ArrayList<Long>(10);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter useFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        useFilter.or(new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"appnum,entryentity.costaccount costaccount", (QFilter[])new QFilter[]{orgFilter, useFilter});
        String appId = this.getView().getFormShowParameter().getAppId();
        for (DynamicObject startStdCost : startStdCosts) {
            if (appId == null || appId.equals(startStdCost.getString("appnum"))) continue;
            costAccountId.add(startStdCost.getLong("costaccount"));
        }
        return costAccountId;
    }

    private Long getOrgId() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            return (Long)org.getPkValue();
        }
        return null;
    }

    private DynamicObject loadDbInfo() {
        Long orgId = this.getOrgId();
        QFilter[] filters = this.getFiltersByOrgAndApplication(orgId, "org.id");
        return QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"id", (QFilter[])filters);
    }

    private void setCurrentPeriod() {
        DynamicObjectCollection entryEntityList = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntityList)) {
            return;
        }
        Map<Long, Long> costAccountIdAndCurrentPeriodIdMap = this.getCostAccountIdAndCurrentPeriodIdMap();
        if (costAccountIdAndCurrentPeriodIdMap == null) {
            return;
        }
        for (int i = 0; i < entryEntityList.size(); ++i) {
            if (this.getModel().getValue("startperiod", i) == null) continue;
            this.getModel().setValue("currentperiod", (Object)costAccountIdAndCurrentPeriodIdMap.get(((DynamicObject)entryEntityList.get(i)).getDynamicObject("costaccount").getPkValue()), i);
        }
        this.getModel().setDataChanged(false);
    }

    private Map<Long, Long> getCostAccountIdAndCurrentPeriodIdMap() {
        DynamicObjectCollection costAccountList = this.getAllCostAccountFromCalSysByOrgId();
        if (costAccountList == null || costAccountList.isEmpty()) {
            return new HashMap<Long, Long>();
        }
        Map<Long, Long> costAccountIdAndCurrentPeriodIdMap = costAccountList.stream().collect(Collectors.toMap(item -> item.getLong("cost_account_id"), item -> {
            long currentPeriod = item.getLong("currentperiod");
            if (CadEmptyUtils.isEmpty((Long)currentPeriod)) {
                return item.getLong("startperiod");
            }
            return currentPeriod;
        }, (v1, v2) -> v1));
        return costAccountIdAndCurrentPeriodIdMap;
    }

    private void showNotificationAfterSave(String successNotification) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sca_startstdcost", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(successNotification);
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private boolean existProductCalculateResult(DynamicObject costAccount) {
        QFilter orgFilter = new QFilter("org", "=", (Object)this.getOrgId());
        QFilter costAccountFilter = new QFilter("costaccount", "=", costAccount.getPkValue());
        QFilter[] filters = new QFilter[]{orgFilter, costAccountFilter};
        return QueryServiceHelper.exists((String)"sca_calcresult", (QFilter[])filters);
    }

    private boolean isFilterByNoSpecificOrgAndPageFirstInit() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return customParams != null && "[\"\"]".equals(customParams.get("org")) && this.getPageCache().get("init") == null;
    }
}

