/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.init;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class UnabsorbInitEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initFilter();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        this.initOrgAndCostcenter(os);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "costaccount": {
                this.setCurrency();
                break;
            }
            case "subelement": {
                this.setElement(e);
                break;
            }
            case "element": {
                this.setSubElement(e);
                break;
            }
            case "amount": {
                this.setDiffTotal();
            }
        }
    }

    private void setDiffTotal() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        BigDecimal sum = new BigDecimal(0);
        for (DynamicObject dynamicObject : entryEntity) {
            BigDecimal entryQty = dynamicObject.getBigDecimal("amount");
            sum = sum.add(entryQty);
        }
        this.getModel().setValue("difftotal", (Object)sum);
    }

    private void setElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject subelement = row.getDynamicObject("subelement");
            if (subelement == null) {
                return;
            }
            QFilter subeleIdFilter = new QFilter("subelement", "=", (Object)subelement.getLong("id"));
            DynamicObject elementDetail = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id AS element", (QFilter[])new QFilter[]{subeleIdFilter});
            if (elementDetail != null) {
                int seq = row.getInt("seq");
                int rowIndex = seq - 1;
                this.getModel().setValue("element", (Object)elementDetail.getLong("element"), rowIndex);
            }
        }
    }

    private void setSubElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            QFilter defQF;
            QFilter enableQF;
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject element = row.getDynamicObject("element");
            int seq = row.getInt("seq");
            int rowIndex = seq - 1;
            this.getModel().setValue("subelement", null, rowIndex);
            if (element == null) {
                return;
            }
            QFilter eleQF = new QFilter("type", "=", (Object)element.getString("type"));
            DynamicObject query = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{eleQF, enableQF = new QFilter("enable", "=", (Object)true), defQF = new QFilter("defaultvalue", "=", (Object)true)});
            if (query == null) {
                return;
            }
            this.getModel().setValue("subelement", query.get(0), rowIndex);
            return;
        }
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }

    private void initOrgAndCostcenter(OperationStatus os) {
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Object accountorg = fsp.getCustomParam("org");
            List orgList = new ArrayList(10);
            if (accountorg != null) {
                orgList = JSON.parseArray((String)accountorg.toString(), String.class);
            }
            Object costAccount = fsp.getCustomParam("costaccount");
            if (CadEmptyUtils.isEmpty(orgList) || orgList.size() > 1) {
                this.getModel().setValue("org", null);
            } else {
                this.getModel().setValue("org", orgList.get(0));
            }
            if (costAccount != null && !"".equals(costAccount.toString())) {
                this.getModel().setValue("costaccount", costAccount);
                this.updateAccountorg();
            }
        }
    }

    private void updateAccountorg() {
        FormShowParameter fsp;
        Object accountorg;
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null && ((accountorg = (fsp = this.getView().getFormShowParameter()).getCustomParam("costaccount")) == null || "".equals(accountorg.toString()))) {
            long costAccountId = costAccount.getLong("id");
            QFilter costAccountFilter = new QFilter("id", "=", (Object)costAccountId);
            DynamicObject query = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{costAccountFilter});
            this.getModel().setValue("org", query.get(0));
        }
    }

    private void initFilter() {
        BasedataEdit costcenterInput = (BasedataEdit)this.getControl("costcenter");
        costcenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            if (org == null) {
                qFilters.clear();
                return;
            }
            qFilters.add(new QFilter("orgduty", "=", (Object)"4"));
            qFilters.add(new QFilter("accountorg", "=", (Object)org.getLong("id")));
        });
        BasedataEdit costaccountInput = (BasedataEdit)this.getControl("costaccount");
        costaccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            if (org == null) {
                return;
            }
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit subelementInput = (BasedataEdit)this.getControl("subelement");
        subelementInput.addBeforeF7SelectListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject element = (DynamicObject)this.getModel().getValue("element", rowIndex);
            if (element == null) {
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter qf = new QFilter("type", "=", (Object)element.getString("type"));
            filterParameter.getQFilters().add(qf);
        });
    }
}

