/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.ElementConstant;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.MatHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.helper.ScaInitHelper;

public class WipCostInitEditPlugin
extends AbstractBillPlugIn {
    private static final String baseproduction = "4";

    public void initialize() {
        super.initialize();
        this.initFilter();
    }

    public void afterBindData(EventObject e) {
        Long id = (Long)this.getModel().getValue("id");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Object costAccount = this.getModel().getValue("costaccount");
        Long costAccountId = costAccount == null ? 0L : ((DynamicObject)costAccount).getLong("id");
        if (this.getModel().getValue("costtype") == null) {
            Long costType = ScaInitHelper.getCostType(costAccountId);
            this.getModel().setValue("costtype", (Object)costType);
            this.getView().updateView("costtype");
        }
        if (!CadEmptyUtils.isEmpty((Long)id) && OperationStatus.ADDNEW != status) {
            this.fillShowEntryEntity();
            return;
        }
        this.getPageCache().put("isUpdateByUser", "");
        this.initByListData();
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        Long id;
        super.afterLoadData(e);
        if (this.isInitCost()) {
            this.getPageCache().put("isUpdateByUser", "true");
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
        }
        if (!CadEmptyUtils.isEmpty((Long)(id = (Long)this.getModel().getValue("id")))) {
            this.getPageCache().put("isUpdateByUser", "true");
        }
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.setElementBySubEle();
                this.setRealEntryEntity();
                String dynamicObjectJson = DynamicObjectHelper.toDynamicObjectJson((DynamicObject)this.getModel().getDataEntity(true));
                this.getPageCache().put("dataEntity", dynamicObjectJson);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                if (e.getOperationResult().isSuccess()) {
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.fillCacheEntryEntity();
            }
        }
    }

    private void fillCacheEntryEntity() {
        String dataEntityStr = this.getPageCache().get("dataEntity");
        DynamicObject dataEntity = DynamicObjectHelper.fromDynamicString((String)dataEntityStr, (MainEntityType)EntityMetadataCache.getDataEntityType((String)"sca_wipcostinit"));
        DynamicObjectCollection showEntryEntity = dataEntity.getDynamicObjectCollection("showentryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)showEntryEntity)) {
            return;
        }
        IDataModel m = this.getModel();
        m.deleteEntryData("showentryentity");
        int[] indexs = m.batchCreateNewEntryRow("showentryentity", showEntryEntity.size());
        for (int i = 0; i < showEntryEntity.size(); ++i) {
            m.setValue("showresource", ((DynamicObject)showEntryEntity.get(i)).get("showresource"), indexs[i]);
            m.setValue("showcostlevel", ((DynamicObject)showEntryEntity.get(i)).get("showcostlevel"), indexs[i]);
            m.setValue("showcalcbasis", ((DynamicObject)showEntryEntity.get(i)).get("showcalcbasis"), indexs[i]);
            m.setValue("showelement", ((DynamicObject)showEntryEntity.get(i)).get("showelement"), indexs[i]);
            m.setValue("showsubelement", ((DynamicObject)showEntryEntity.get(i)).get("showsubelement"), indexs[i]);
            m.setValue("showstdcost", ((DynamicObject)showEntryEntity.get(i)).get("showstdcost"), indexs[i]);
            m.setValue("showstdamt", ((DynamicObject)showEntryEntity.get(i)).get("showstdamt"), indexs[i]);
            m.setValue("showrealamt", ((DynamicObject)showEntryEntity.get(i)).get("showrealamt"), indexs[i]);
            m.setValue("showdiffamt", ((DynamicObject)showEntryEntity.get(i)).get("showdiffamt"), indexs[i]);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        switch (proName = e.getProperty().getName()) {
            case "costaccount": {
                this.setCurrency();
                Object newValue = changeSet[0].getNewValue();
                long costAccountId = 0L;
                if (newValue != null) {
                    costAccountId = ((DynamicObject)newValue).getLong("id");
                }
                Long costType = ScaInitHelper.getCostType(costAccountId);
                this.getModel().setValue("costtype", (Object)costType);
                this.getView().updateView("costtype");
                break;
            }
            case "costobject": {
                this.setMaterial();
                this.setEntryData();
                break;
            }
            case "initamt": {
                this.getPageCache().put("isChangedByInitAmt", "true");
                if (!"true".equals(this.getPageCache().get("isUpdateByUser")) && !"true".equals(this.getPageCache().get("isChangedByTotalDiffAmt"))) {
                    this.updateAmtByInitAmt();
                }
                this.getPageCache().put("isChangedByInitAmt", "false");
                this.updateAmtByInitAmtReal();
                break;
            }
            case "totaldiffamt": {
                this.getPageCache().put("isChangedByTotalDiffAmt", "true");
                if (!"true".equals(this.getPageCache().get("isUpdateByUser")) && !"true".equals(this.getPageCache().get("isChangedByInitAmt"))) {
                    this.updateAmtByTotalDiffAmt();
                }
                this.getPageCache().put("isChangedByTotalDiffAmt", "false");
                this.updateAmtByTotalDiffAmtReal();
                break;
            }
            case "initqty": {
                this.getPageCache().put("isChangedByInitAmt", "true");
                this.setStandardamt("showentryentity");
                this.getPageCache().put("isChangedByInitAmt", "false");
                this.setStandardamt("entryentity");
                break;
            }
            case "showsubelement": {
                this.setElement(e);
                break;
            }
            case "showelement": {
                this.setSubElement(e);
                ArrayList<Long> elementList = new ArrayList<Long>(10);
                elementList.add(ElementConstant.RESOURCE_ID);
                elementList.add(ElementConstant.OUTWORK_ID);
                DynamicObject element = (DynamicObject)this.getModel().getValue("showelement", rowIndex);
                if (elementList.contains(element.getLong("id"))) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"showresource"});
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"showcostlevel"});
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"showcalcbasis"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"showresource"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"showcostlevel"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"showcalcbasis"});
                break;
            }
            case "showstdcost": {
                this.setStandardamt(rowIndex);
                break;
            }
            case "showstdamt": {
                this.updateDiffAmt(rowIndex);
                break;
            }
            case "showrealamt": {
                this.updateDiffAmt(rowIndex);
                this.checkUpdateAmtByUser();
                break;
            }
            case "showdiffamt": {
                this.updateRealAmt(rowIndex);
                this.checkUpdateAmtByUser();
            }
        }
    }

    private void fillShowEntryEntity() {
        IDataModel m = this.getModel();
        DynamicObjectCollection entryEntity = m.getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        int rowCount = 0;
        ArrayList<Object> itemList = new ArrayList<Object>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            String datatype = ((DynamicObject)entryEntity.get(i)).getString("datatype");
            if (!"2".equals(datatype)) continue;
            itemList.add(entryEntity.get(i));
            ++rowCount;
        }
        if (rowCount == 0) {
            return;
        }
        m.deleteEntryData("showentryentity");
        int[] indexs = m.batchCreateNewEntryRow("showentryentity", rowCount);
        for (int i = 0; i < itemList.size(); ++i) {
            DynamicObject entry = (DynamicObject)itemList.get(i);
            m.setValue("showresource", entry.get("resource"), indexs[i]);
            m.setValue("showcostlevel", entry.get("costlevel"), indexs[i]);
            m.setValue("showcalcbasis", entry.get("calcbasis"), indexs[i]);
            m.setValue("showelement", entry.get("element"), indexs[i]);
            m.setValue("showsubelement", entry.get("subelement"), indexs[i]);
            m.setValue("showstdcost", entry.get("stdcost"), indexs[i]);
            m.setValue("showstdamt", entry.get("stdamt"), indexs[i]);
            m.setValue("showrealamt", entry.get("realamt"), indexs[i]);
            m.setValue("showdiffamt", entry.get("diffamt"), indexs[i]);
        }
        m.setDataChanged(false);
    }

    private boolean isInitCost() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        DynamicObjectCollection res = this.getStartstdCost(org.getLong("id"), costaccount.getLong("id"));
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)res)) {
            return false;
        }
        DynamicObject startstdcost = (DynamicObject)res.get(0);
        return startstdcost.getBoolean("isinit");
    }

    private void checkUpdateAmtByUser() {
        String isChangedByInitAmt = this.getPageCache().get("isChangedByInitAmt");
        String isChangedByTotalDiffAmt = this.getPageCache().get("isChangedByTotalDiffAmt");
        String isUpdateByUser = this.getPageCache().get("isUpdateByUser");
        if ("true".equals(isChangedByTotalDiffAmt) || "true".equals(isChangedByInitAmt) || "true".equals(isUpdateByUser)) {
            return;
        }
        BigDecimal initamt = (BigDecimal)this.getModel().getValue("initamt");
        BigDecimal toTalRealAmt = this.getToTalValue("showentryentity", "showrealamt");
        if (initamt.compareTo(BigDecimal.ZERO) != 0 && initamt.compareTo(toTalRealAmt) != 0) {
            this.getPageCache().put("isUpdateByUser", "true");
        }
        BigDecimal diffamt = (BigDecimal)this.getModel().getValue("totaldiffamt");
        BigDecimal toTalDiffAmt = this.getToTalValue("showentryentity", "showdiffamt");
        if (diffamt.compareTo(BigDecimal.ZERO) != 0 && diffamt.compareTo(toTalDiffAmt) != 0) {
            this.getPageCache().put("isUpdateByUser", "true");
        }
    }

    private void updateRealAmt(int rowIndex) {
        BigDecimal diffAmt = (BigDecimal)this.getModel().getValue("showdiffamt", rowIndex);
        BigDecimal stdAmt = (BigDecimal)this.getModel().getValue("showstdamt", rowIndex);
        BigDecimal realAmt = diffAmt.add(stdAmt);
        this.getModel().setValue("showrealamt", (Object)realAmt, rowIndex);
    }

    private void updateDiffAmt(int rowIndex) {
        BigDecimal realAmt = (BigDecimal)this.getModel().getValue("showrealamt", rowIndex);
        BigDecimal stdAmt = (BigDecimal)this.getModel().getValue("showstdamt", rowIndex);
        BigDecimal diffAmt = realAmt.subtract(stdAmt);
        this.getModel().setValue("showdiffamt", (Object)diffAmt, rowIndex);
    }

    private void setElementBySubEle() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("showentryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        for (DynamicObject entry : entryEntity) {
            int rowIndex = entry.getInt("seq") - 1;
            DynamicObject element = entry.getDynamicObject("showelement");
            DynamicObject subelement = entry.getDynamicObject("showsubelement");
            if (subelement == null || element != null) continue;
            QFilter subeleIdQF = new QFilter("subelement", "=", (Object)subelement.getLong("id"));
            DynamicObject relation = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{subeleIdQF});
            this.getModel().setValue("showelement", (Object)relation.getLong("element"), rowIndex);
        }
    }

    private void setEntryData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costobject = dataEntity.getDynamicObject("costobject");
        if (costobject == null) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("showentryentity");
            return;
        }
        DynamicObject material = dataEntity.getDynamicObject("material");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("costobject", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"WipCostInitEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        DynamicObject costtype = dataEntity.getDynamicObject("costtype");
        if (costobject == null || costtype == null || material == null) {
            return;
        }
        DynamicObjectCollection matCostInfo = WipCostInitEditPlugin.getMatCostInfo(costtype.getLong("id"), material.getLong("id"), costobject.getLong("bomversion.id"), costobject.getLong("auxpty.id"));
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)matCostInfo)) {
            this.getModel().setValue("costobject", null);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4ea7\u54c1\u201c%s\u201d\u5377\u7b97\u4fe1\u606f\uff0c\u8bf7\u5148\u8fdb\u884c\u6807\u51c6\u6210\u672c\u5377\u7b97\u3002", (String)"WipCostInitEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]), material.getString("name")));
            return;
        }
        this.setEntryEntityValue(matCostInfo);
    }

    public static DynamicObjectCollection getMatCostInfo(Long costtypeid, Long materialid, Long matverid, Long auxptyid) {
        if (CadEmptyUtils.isEmpty((Long)materialid) || CadEmptyUtils.isEmpty((Long)costtypeid)) {
            return null;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costtypeid);
        filter.and(new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3", baseproduction)));
        filter.and(new QFilter("material", "=", (Object)materialid));
        filter.and(new QFilter("ismaindata", "=", (Object)1));
        String fields = "id,effectdate,expdate,entryentity.resource resource,entryentity.calcbasis calcbasis,entryentity.element element,entryentity.subelement subelement,entryentity.submaterial submaterial,entryentity.submatvers submatvers,entryentity.subauxproperty subauxproperty,entryentity.datatype datatype,entryentity.qty qty,entryentity.stdprice stdcost,entryentity.price stdprice";
        DynamicObjectCollection matCostInfoIds = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"effectdate DESC");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)matCostInfoIds)) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)((DynamicObject)matCostInfoIds.get(0)).getLong("id"));
        QFilter dataTypeFilter = new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3", baseproduction));
        DynamicObjectCollection matCostInfos = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)fields, (QFilter[])new QFilter[]{idFilter, dataTypeFilter});
        return matCostInfos;
    }

    private DynamicObjectCollection getStartstdCost(Long orgId, Long costaccountId) {
        String fields = "id, entryentity.startperiod.begindate AS begindate, entryentity.isenabled AS isenabled, entryentity.isinit AS isinit";
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQF = new QFilter("entryentity.costaccount", "=", (Object)costaccountId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])new QFilter[]{orgQF, costaccountQF});
        return res;
    }

    private void setRealEntryEntity() {
        IDataModel m = this.getModel();
        DynamicObjectCollection showEntryEntity = m.getEntryEntity("showentryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)showEntryEntity)) {
            m.deleteEntryData("entryentity");
            return;
        }
        DynamicObjectCollection entryEntity = m.getEntryEntity("entryentity");
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (DynamicObject entity : entryEntity) {
            String datatype = entity.getString("datatype");
            if (!"2".equals(datatype)) continue;
            indexList.add(entity.getInt("seq") - 1);
        }
        int[] delIndexs = new int[indexList.size()];
        for (int i = 0; i < delIndexs.length; ++i) {
            delIndexs[i] = (Integer)indexList.get(i);
        }
        m.deleteEntryRows("entryentity", delIndexs);
        int realEntryEntityCount = showEntryEntity.size();
        int[] indexs = m.batchCreateNewEntryRow("entryentity", realEntryEntityCount);
        for (int i = 0; i < showEntryEntity.size(); ++i) {
            DynamicObject showEntry = (DynamicObject)showEntryEntity.get(i);
            m.setValue("resource", showEntry.get("showresource"), indexs[i]);
            m.setValue("costlevel", showEntry.get("showcostlevel"), indexs[i]);
            m.setValue("calcbasis", showEntry.get("showcalcbasis"), indexs[i]);
            m.setValue("element", showEntry.get("showelement"), indexs[i]);
            m.setValue("subelement", showEntry.get("showsubelement"), indexs[i]);
            m.setValue("stdcost", showEntry.get("showstdcost"), indexs[i]);
            m.setValue("stdamt", showEntry.get("showstdamt"), indexs[i]);
            m.setValue("realamt", showEntry.get("showrealamt"), indexs[i]);
            m.setValue("diffamt", showEntry.get("showdiffamt"), indexs[i]);
            m.setValue("datatype", (Object)"2", indexs[i]);
        }
    }

    private void setEntryEntityValue(DynamicObjectCollection matCostInfo) {
        DynamicObject entry;
        DynamicObject entry2;
        IDataModel m = this.getModel();
        HashMap<String, DynamicObject> subelementMapItem = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> subelementMapMulti = new HashMap<String, DynamicObject>();
        for (DynamicObject info : matCostInfo) {
            Iterator costlevel = CadEmptyUtils.isEmpty((String)info.getString("resource")) ? "" : info.getString("datatype");
            String subelement = info.getString("subelement") + "@" + info.getString("resource") + "@" + info.getString("calcbasis") + "@" + costlevel;
            String datatype = info.getString("datatype");
            if ("2".equals(datatype) || "3".equals(datatype)) {
                if (subelementMapItem.get(subelement) != null) {
                    entry2 = (DynamicObject)subelementMapItem.get(subelement);
                    entry2.set("stdcost", (Object)entry2.getBigDecimal("stdcost").add(info.getBigDecimal("stdcost")));
                } else {
                    subelementMapItem.put(subelement, info);
                }
            }
            if (!"2".equals(datatype) && !baseproduction.equals(datatype)) continue;
            if (subelementMapMulti.get(subelement) != null) {
                entry2 = (DynamicObject)subelementMapMulti.get(subelement);
                entry2.set("stdcost", (Object)entry2.getBigDecimal("stdcost").add(info.getBigDecimal("stdcost")));
                continue;
            }
            subelementMapMulti.put(subelement, info);
        }
        m.deleteEntryData("entryentity");
        m.deleteEntryData("showentryentity");
        int rowCount = subelementMapItem.size() + subelementMapMulti.size();
        m.batchCreateNewEntryRow("entryentity", rowCount);
        int index = 0;
        for (Map.Entry entrySet : subelementMapMulti.entrySet()) {
            entry = (DynamicObject)entrySet.getValue();
            this.setEntryEntityRowReal(entry, index);
            m.setValue("datatype", (Object)"1", index);
            m.setValue("costlevel", (Object)"", index);
            ++index;
        }
        for (Map.Entry entrySet : subelementMapItem.entrySet()) {
            entry = (DynamicObject)entrySet.getValue();
            this.setEntryEntityRowReal(entry, index);
            m.setValue("datatype", (Object)"2", index);
            ++index;
        }
        m.batchCreateNewEntryRow("showentryentity", subelementMapItem.size());
        int showIndex = 0;
        for (Map.Entry entrySet : subelementMapItem.entrySet()) {
            entry2 = (DynamicObject)entrySet.getValue();
            this.setEntryEntityRow(entry2, showIndex);
            ++showIndex;
        }
    }

    private void setEntryEntityRowReal(DynamicObject entry, int index) {
        IDataModel m = this.getModel();
        m.setValue("resource", entry.get("resource"), index);
        ArrayList<String> costLevelList = new ArrayList<String>(16);
        costLevelList.add("2");
        costLevelList.add("3");
        if (!CadEmptyUtils.isEmpty((Long)entry.getLong("resource")) && costLevelList.contains(entry.getString("datatype"))) {
            m.setValue("costlevel", (Object)entry.getString("datatype"), index);
        }
        m.setValue("resource", entry.get("resource"), index);
        m.setValue("calcbasis", entry.get("calcbasis"), index);
        m.setValue("element", entry.get("element"), index);
        m.setValue("subelement", entry.get("subelement"), index);
        m.setValue("stdcost", entry.get("stdcost"), index);
    }

    private void setEntryEntityRow(DynamicObject entry, int index) {
        IDataModel m = this.getModel();
        ArrayList<String> costLevelList = new ArrayList<String>(16);
        costLevelList.add("2");
        costLevelList.add("3");
        if (!CadEmptyUtils.isEmpty((Long)entry.getLong("resource")) && costLevelList.contains(entry.getString("datatype"))) {
            m.setValue("showcostlevel", (Object)entry.getString("datatype"), index);
        }
        m.setValue("showresource", entry.get("resource"), index);
        m.setValue("showcalcbasis", entry.get("calcbasis"), index);
        m.setValue("showelement", entry.get("element"), index);
        m.setValue("showsubelement", entry.get("subelement"), index);
        m.setValue("showstdcost", entry.get("stdcost"), index);
    }

    private void updateAmtByTotalDiffAmtReal() {
        BigDecimal totaldiffamt = (BigDecimal)this.getModel().getValue("totaldiffamt");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        BigDecimal totalStdCost = this.getToTalValue("entryentity", "stdcost");
        if (BigDecimal.ZERO.compareTo(totalStdCost) == 0) {
            return;
        }
        double rate = totaldiffamt.doubleValue() / totalStdCost.doubleValue();
        Map<String, BigDecimal> diffValueMap = this.correctAmt(entryEntity, rate, false);
        String maxValueRowIndex = "";
        BigDecimal diffValue = BigDecimal.ZERO;
        Map.Entry<String, BigDecimal> entry = diffValueMap.entrySet().iterator().next();
        if (entry != null) {
            maxValueRowIndex = entry.getKey();
            diffValue = entry.getValue();
        }
        for (DynamicObject row : entryEntity) {
            String dataType = row.getString("datatype");
            if (!"1".equals(dataType)) continue;
            Integer rowIndex = row.getInt("seq") - 1;
            BigDecimal stdCost = row.getBigDecimal("stdcost");
            double diffAmtDouble = 0.0;
            if (BigDecimal.ZERO.compareTo(totalStdCost) != 0) {
                diffAmtDouble = rate * stdCost.doubleValue();
            }
            BigDecimal diffAmt = BigDecimal.valueOf(diffAmtDouble);
            if (row.getString("seq").equals(maxValueRowIndex)) {
                diffAmt = diffAmt.add(diffValue);
            }
            diffAmt = diffAmt.setScale(this.getAmtPrecision(), 4);
            this.getModel().setValue("diffamt", (Object)diffAmt, rowIndex.intValue());
            BigDecimal realAmt = diffAmt.add(row.getBigDecimal("stdamt"));
            this.getModel().setValue("realamt", (Object)realAmt, rowIndex.intValue());
        }
    }

    private void updateAmtByInitAmtReal() {
        BigDecimal initAmt = (BigDecimal)this.getModel().getValue("initamt");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        BigDecimal totalStdCost = this.getToTalValue("entryentity", "stdcost");
        if (BigDecimal.ZERO.compareTo(totalStdCost) == 0) {
            return;
        }
        double rate = initAmt.doubleValue() / totalStdCost.doubleValue();
        Map<String, BigDecimal> diffValueMap = this.correctAmt(entryEntity, rate, false);
        String maxValueRowIndex = "";
        BigDecimal diffValue = BigDecimal.ZERO;
        Map.Entry<String, BigDecimal> entry = diffValueMap.entrySet().iterator().next();
        if (entry != null) {
            maxValueRowIndex = entry.getKey();
            diffValue = entry.getValue();
        }
        for (DynamicObject row : entryEntity) {
            String dataType = row.getString("datatype");
            if (!"1".equals(dataType)) continue;
            Integer rowIndex = row.getInt("seq") - 1;
            BigDecimal stdCost = row.getBigDecimal("stdcost");
            double realAmtDouble = 0.0;
            if (BigDecimal.ZERO.compareTo(totalStdCost) != 0) {
                realAmtDouble = rate * stdCost.doubleValue();
            }
            BigDecimal realAmt = BigDecimal.valueOf(realAmtDouble);
            if (row.getString("seq").equals(maxValueRowIndex)) {
                realAmt = realAmt.add(diffValue);
            }
            realAmt = realAmt.setScale(this.getAmtPrecision(), 4);
            this.getModel().setValue("realamt", (Object)realAmt, rowIndex.intValue());
            BigDecimal diffamt = realAmt.subtract(row.getBigDecimal("stdamt"));
            this.getModel().setValue("diffamt", (Object)diffamt, rowIndex.intValue());
        }
    }

    private void updateAmtByTotalDiffAmt() {
        BigDecimal initAmt = (BigDecimal)this.getModel().getValue("initamt");
        BigDecimal totaldiffamt = (BigDecimal)this.getModel().getValue("totaldiffamt");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("showentryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        BigDecimal totalStdCost = this.getToTalValue("showentryentity", "showstdcost");
        if (BigDecimal.ZERO.compareTo(totalStdCost) == 0) {
            return;
        }
        double rate = totaldiffamt.doubleValue() / totalStdCost.doubleValue();
        Map<String, BigDecimal> diffValueMap = this.correctAmt(entryEntity, rate, true);
        String maxValueRowIndex = "";
        BigDecimal diffValue = BigDecimal.ZERO;
        Map.Entry<String, BigDecimal> entry = diffValueMap.entrySet().iterator().next();
        if (entry != null) {
            maxValueRowIndex = entry.getKey();
            diffValue = entry.getValue();
        }
        initAmt = BigDecimal.ZERO;
        for (DynamicObject row : entryEntity) {
            Integer rowIndex = row.getInt("seq") - 1;
            BigDecimal stdCost = row.getBigDecimal("showstdcost");
            double diffAmtDouble = 0.0;
            if (BigDecimal.ZERO.compareTo(totalStdCost) != 0) {
                diffAmtDouble = rate * stdCost.doubleValue();
            }
            BigDecimal diffAmt = BigDecimal.valueOf(diffAmtDouble);
            if (row.getString("seq").equals(maxValueRowIndex)) {
                diffAmt = diffAmt.add(diffValue);
            }
            diffAmt = diffAmt.setScale(this.getAmtPrecision(), 4);
            this.getModel().setValue("showdiffamt", (Object)diffAmt, rowIndex.intValue());
            BigDecimal realAmt = diffAmt.add(row.getBigDecimal("showstdamt"));
            initAmt = initAmt.add(realAmt);
        }
        this.getModel().setValue("initamt", (Object)initAmt);
    }

    private void updateAmtByInitAmt() {
        BigDecimal initAmt = (BigDecimal)this.getModel().getValue("initamt");
        BigDecimal totaldiffamt = (BigDecimal)this.getModel().getValue("totaldiffamt");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("showentryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        BigDecimal totalStdCost = this.getToTalValue("showentryentity", "showstdcost");
        double rate = initAmt.doubleValue() / totalStdCost.doubleValue();
        if (BigDecimal.ZERO.compareTo(totalStdCost) == 0) {
            return;
        }
        Map<String, BigDecimal> diffValueMap = this.correctAmt(entryEntity, rate, true);
        String maxValueRowIndex = "";
        BigDecimal diffValue = BigDecimal.ZERO;
        Map.Entry<String, BigDecimal> entry = diffValueMap.entrySet().iterator().next();
        if (entry != null) {
            maxValueRowIndex = entry.getKey();
            diffValue = entry.getValue();
        }
        totaldiffamt = BigDecimal.ZERO;
        for (DynamicObject row : entryEntity) {
            Integer rowIndex = row.getInt("seq") - 1;
            BigDecimal stdCost = row.getBigDecimal("showstdcost");
            double realAmtDouble = 0.0;
            if (BigDecimal.ZERO.compareTo(totalStdCost) != 0) {
                realAmtDouble = rate * stdCost.doubleValue();
            }
            BigDecimal realAmt = BigDecimal.valueOf(realAmtDouble);
            if (row.getString("seq").equals(maxValueRowIndex)) {
                realAmt = realAmt.add(diffValue);
            }
            realAmt = realAmt.setScale(this.getAmtPrecision(), 4);
            this.getModel().setValue("showrealamt", (Object)realAmt, rowIndex.intValue());
            BigDecimal diffamt = realAmt.subtract(row.getBigDecimal("showstdamt"));
            totaldiffamt = totaldiffamt.add(diffamt);
        }
        this.getModel().setValue("totaldiffamt", (Object)totaldiffamt);
    }

    private Map<String, BigDecimal> correctAmt(DynamicObjectCollection entryEntity, double rate, boolean isShowData) {
        HashMap<String, BigDecimal> diffValueMap = new HashMap<String, BigDecimal>();
        double diffValue = 0.0;
        double maxValue = 0.0;
        String maxRowIndex = "1";
        for (DynamicObject row : entryEntity) {
            String seq = row.getString("seq");
            BigDecimal stdCost = row.getBigDecimal(isShowData ? "showstdcost" : "stdcost");
            double realValue = rate * stdCost.doubleValue();
            if (maxValue < realValue) {
                maxValue = realValue;
                maxRowIndex = seq;
            }
            BigDecimal roundValue = BigDecimal.valueOf(realValue).setScale(this.getAmtPrecision(), 4);
            diffValue += realValue - roundValue.doubleValue();
        }
        diffValueMap.put(maxRowIndex, BigDecimal.valueOf(diffValue));
        return diffValueMap;
    }

    private int getAmtPrecision() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        int precision = 10;
        if (currency != null) {
            precision = currency.getInt("amtprecision");
        }
        return precision;
    }

    private BigDecimal getToTalValue(String entryentity, String value) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryentity);
        BigDecimal totalValue = BigDecimal.ZERO;
        for (DynamicObject row : entryEntity) {
            if ("entryentity".equals(entryentity) && !"1".equals(row.getString("datatype"))) continue;
            totalValue = totalValue.add(row.getBigDecimal(value));
        }
        return totalValue;
    }

    private void setMaterial() {
        DynamicObject costobject = (DynamicObject)this.getModel().getValue("costobject");
        if (costobject == null) {
            this.getModel().setValue("material", null);
            this.getModel().setValue("auxpty", null);
            this.getModel().setValue("baseunit", null);
        } else {
            this.getModel().setValue("material", costobject.get("material"));
            this.getModel().setValue("auxpty", costobject.get("auxpty"));
            DynamicObject material = costobject.getDynamicObject("material");
            if (material == null) {
                this.getModel().setValue("baseunit", null);
            } else {
                HashSet<Long> baseUnit = new HashSet<Long>(16);
                baseUnit.add(material.getLong("id"));
                this.getModel().setValue("baseunit", MatHelper.getMatBaseUnit(baseUnit).get(material.getLong("id")));
            }
        }
    }

    private void setStandardamt(String entryentity) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryentity);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        if (entryentity.equals("showentryentity")) {
            for (DynamicObject entry : entryEntity) {
                this.setStandardamt(entry.getInt("seq") - 1);
            }
        } else {
            for (DynamicObject entry : entryEntity) {
                String datatype = entry.getString("datatype");
                if (!"1".equals(datatype)) continue;
                this.setStandardamtReal(entry.getInt("seq") - 1);
            }
        }
    }

    private void setStandardamt(int rowIndex) {
        BigDecimal initqty = (BigDecimal)this.getModel().getValue("initqty");
        BigDecimal stdcost = (BigDecimal)this.getModel().getValue("showstdcost", rowIndex);
        this.getModel().setValue("showstdamt", (Object)stdcost.multiply(initqty), rowIndex);
    }

    private void setStandardamtReal(int rowIndex) {
        BigDecimal initqty = (BigDecimal)this.getModel().getValue("initqty");
        BigDecimal stdcostReal = (BigDecimal)this.getModel().getValue("stdcost", rowIndex);
        this.getModel().setValue("stdamt", (Object)stdcostReal.multiply(initqty), rowIndex);
    }

    private void initByListData() {
        IDataModel model = this.getModel();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        DynamicObject org = model.getDataEntity().getDynamicObject("org");
        String accountorgId = "";
        String costaccountId = "";
        if (org == null) {
            accountorgId = (String)fsp.getCustomParam("org");
            model.setValue("org", (Object)accountorgId);
        } else {
            accountorgId = String.valueOf(org.getLong("id"));
            costaccountId = (String)fsp.getCustomParam("costaccount");
        }
        if (!CadEmptyUtils.isEmpty((String)costaccountId)) {
            model.setValue("costaccount", (Object)costaccountId);
            Long costType = ScaInitHelper.getCostType(Long.parseLong(costaccountId));
            this.getModel().setValue("costtype", (Object)costType);
            return;
        }
        if (!CadEmptyUtils.isEmpty((String)accountorgId)) {
            this.setCostaccount(Long.parseLong(accountorgId));
        }
        this.getView().updateView("costaccount");
        this.getView().updateView("costtype");
    }

    private void setElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject subelement = row.getDynamicObject("showsubelement");
            if (subelement == null) {
                return;
            }
            QFilter subeleIdFilter = new QFilter("subelement", "=", (Object)subelement.getLong("id"));
            DynamicObject elementDetail = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id AS element", (QFilter[])new QFilter[]{subeleIdFilter});
            if (elementDetail != null) {
                int seq = row.getInt("seq");
                int rowIndex = seq - 1;
                this.getModel().setValue("showelement", (Object)elementDetail.getLong("element"), rowIndex);
            }
        }
    }

    private void setSubElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            QFilter subeleQF;
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject element = row.getDynamicObject("showelement");
            DynamicObject subelement = row.getDynamicObject("showsubelement");
            if (element == null || subelement == null) {
                return;
            }
            QFilter eleQF = new QFilter("element", "=", (Object)element.getLong("id"));
            boolean existRelation = QueryServiceHelper.exists((String)"cad_elementdetail", (QFilter[])new QFilter[]{eleQF, subeleQF = new QFilter("subelement", "=", (Object)subelement.getLong("id"))});
            if (existRelation) {
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("showentryentity");
            this.getModel().setValue("showsubelement", null, rowIndex);
        }
    }

    private void setCostaccount(long orgId) {
        DynamicObjectCollection costaccounts = this.getCostaccount(orgId);
        if (costaccounts == null || costaccounts.size() == 0 || costaccounts.size() > 1) {
            return;
        }
        DynamicObject costaccount = (DynamicObject)costaccounts.get(0);
        this.getModel().setValue("costaccount", (Object)costaccount.getLong("id"));
        Long costType = ScaInitHelper.getCostType(costaccount.getLong("id"));
        this.getModel().setValue("costtype", (Object)costType);
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }

    private DynamicObjectCollection getCostaccount(Long orgId) {
        QFilter accountorgQF = new QFilter("calorg", "=", (Object)orgId);
        QFilter enablestdtQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        String orderby = "enablestandardcost DESC, number ASC";
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, name", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF}, (String)orderby);
        return result;
    }

    private void initFilter() {
        BasedataEdit costcenterInput = (BasedataEdit)this.getControl("costcenter");
        costcenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            if (org == null) {
                qFilters.clear();
                return;
            }
            qFilters.add(new QFilter("orgduty.number", "=", (Object)baseproduction));
            qFilters.add(new QFilter("accountorg", "=", (Object)org.getLong("id")));
        });
        BasedataEdit costaccountInput = (BasedataEdit)this.getControl("costaccount");
        costaccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            if (org == null) {
                return;
            }
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getEnableQfilterByOrg((Long)org.getLong("id"), (Boolean)false, (String)AppIdHelper.getCurAppNum((IFormView)this.getView())));
        });
        BasedataEdit costObjectInput = (BasedataEdit)this.getControl("costobject");
        costObjectInput.addBeforeF7SelectListener(evt -> {
            DynamicObject costCenter = (DynamicObject)this.getModel().getValue("costcenter");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qf = filterParameter.getQFilters();
            qf.add(new QFilter("bizstatus", "=", (Object)"A"));
            qf.add(new QFilter("billstatus", "=", (Object)"C"));
            qf.add(this.getCostAccountQF());
            if (costCenter == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6210\u672c\u4e2d\u5fc3\u3002", (String)"WipCostInitEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            qf.add(new QFilter("costcenter", "=", (Object)costCenter.getLong("id")));
        });
        BasedataEdit subelementInput = (BasedataEdit)this.getControl("showsubelement");
        subelementInput.addBeforeF7SelectListener(evt -> {
            DynamicObject element;
            int rowIndex = this.getModel().getEntryCurrentRowIndex("showentryentity");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter duplicatedSubEleFilter = this.getDuplicatedSubEleFilter(rowIndex);
            if (duplicatedSubEleFilter != null) {
                filterParameter.getQFilters().add(duplicatedSubEleFilter);
            }
            if ((element = (DynamicObject)this.getModel().getValue("showelement", rowIndex)) == null) {
                return;
            }
            QFilter qf = new QFilter("type", "=", (Object)element.getString("type"));
            filterParameter.getQFilters().add(qf);
        });
    }

    private QFilter getDuplicatedSubEleFilter(int rowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("showentryentity");
        DynamicObject currentRow = (DynamicObject)entryEntity.get(rowIndex);
        HashSet<Long> alreadySelectedSubElementIds = new HashSet<Long>(16);
        for (DynamicObject row : entryEntity) {
            if (row == currentRow) continue;
            long subElementId = row.getLong("showsubelement.id");
            alreadySelectedSubElementIds.add(subElementId);
        }
        if (!CadEmptyUtils.isEmpty(alreadySelectedSubElementIds)) {
            return new QFilter("id", "not in", alreadySelectedSubElementIds);
        }
        return null;
    }

    private QFilter getCostAccountQF() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null) {
            QFilter costAccountQF = new QFilter("costaccount", "=", (Object)costAccount.getLong("id"));
            QFilter[] checkQf = new QFilter[]{costAccountQF};
            DynamicObjectCollection res = QueryServiceHelper.query((String)"sca_wipcostinit", (String)"costobject", (QFilter[])checkQf);
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)res)) {
                List costObjectList = DynamicObjectHelper.getIdList((DynamicObjectCollection)res, (String)"costobject");
                return new QFilter("id", "not in", (Object)costObjectList);
            }
        }
        return new QFilter("id", "!=", (Object)0L);
    }
}

