/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.restore;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class Coststructuresheet_FormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }

    public void initialize() {
        super.initialize();
        BasedataEdit subelementInput = (BasedataEdit)this.getControl("subelement");
        subelementInput.addBeforeF7SelectListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject element = (DynamicObject)this.getModel().getValue("element", rowIndex);
            if (element == null) {
                return;
            }
            List<QFilter> qFilters = this.getInputQFilters(evt);
            qFilters.add(new QFilter("type", "=", (Object)element.getString("type")));
        });
        BasedataEdit matVersion = (BasedataEdit)this.getControl("itemversion");
        matVersion.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject mat = (DynamicObject)this.getModel().getValue("product");
            if (mat != null) {
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = parameter.getListFilterParameter();
                List qList = filterParameter.getQFilters();
                qList.add(new QFilter("material", "=", mat.getPkValue()));
            }
        });
        BasedataEdit sonversion = (BasedataEdit)this.getControl("sonversion");
        sonversion.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject mat = (DynamicObject)this.getModel().getValue("hidemateriel", entryCurrentRowIndex);
            if (mat != null) {
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = parameter.getListFilterParameter();
                List qList = filterParameter.getQFilters();
                qList.add(new QFilter("material", "=", mat.getPkValue()));
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String key = e.getProperty().getName();
        if ("sunamt".equals(key)) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            BigDecimal sunamtSum = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : entryEntity) {
                sunamtSum = sunamtSum.add(dynamicObject.getBigDecimal("sunamt"));
            }
            model.setValue("amount", (Object)sunamtSum);
        } else if ("subjectormateriel".equals(key)) {
            model.setValue("materialname", null);
            model.setValue("model", null);
            model.setValue("sonauxprop", null);
            model.setValue("unit", null);
            model.setValue("hidemateriel", null);
        } else if ("material".equals(key)) {
            this.setMaterial(newValue, rowIndex);
        } else if ("element".equals(key)) {
            this.setSubElement(e);
        } else if ("subelement".equals(key)) {
            this.setElement(e);
            DynamicObject subelement = (DynamicObject)newValue;
            if (newValue != null) {
                String type = subelement.getString("type");
                if ("001".equals(type) || "002".equals(type)) {
                    this.getModel().setValue("subjectormateriel", (Object)"bd_material", rowIndex);
                } else {
                    this.getModel().setValue("subjectormateriel", (Object)"er_expenseitemedit", rowIndex);
                }
            }
        } else if ("costaccount".equals(key)) {
            DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject(key);
            if (costaccount == null) {
                this.getModel().setValue("currency", null);
            } else {
                this.setCurrencyAndPeriod(costaccount);
            }
        } else if ("product".equals(key)) {
            DynamicObject product = this.getModel().getDataEntity().getDynamicObject(key);
            this.getModel().setValue("itemversion", null);
            this.getModel().setValue("auxprop", null);
            if (product != null) {
                boolean isuseauxpty;
                DynamicObject fullPro = BusinessDataServiceHelper.loadSingle((Object)product.getPkValue(), (String)product.getDynamicObjectType().getName());
                boolean isenablematerialversion = fullPro.getBoolean("isenablematerialversion");
                if (isenablematerialversion) {
                    BasedataEdit itemversion = (BasedataEdit)this.getView().getControl("itemversion");
                    itemversion.setMustInput(true);
                }
                if (isuseauxpty = fullPro.getBoolean("isuseauxpty")) {
                    FlexEdit auxprop = (FlexEdit)this.getView().getControl("auxprop");
                    auxprop.setMustInput(true);
                }
            }
        } else if ("hidemateriel".equals(key)) {
            DynamicObject fullPro;
            boolean isuseauxpty;
            int selectIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("sonauxprop", null, selectIndex);
            DynamicObject product = (DynamicObject)this.getModel().getValue(key, selectIndex);
            if (product != null && (isuseauxpty = (fullPro = BusinessDataServiceHelper.loadSingle((Object)product.getPkValue(), (String)product.getDynamicObjectType().getName())).getBoolean("isuseauxpty"))) {
                FlexEdit auxprop = (FlexEdit)this.getView().getControl("sonauxprop");
                auxprop.setMustInput(true);
            }
        }
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period != null) {
            QFilter filter = new QFilter("entryentity.isenabled", "=", (Object)true);
            filter.and(new QFilter("entryentity.startperiod.id", "=", period.getPkValue()));
            DynamicObject[] result = BusinessDataServiceHelper.load((String)"sca_startstdcost", (String)"id", (QFilter[])new QFilter[]{filter});
            if (result == null || result.length == 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_audit"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_submit"});
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject costAccount;
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"Coststructuresheet_FormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (CadEmptyUtils.isEmpty((DynamicObject)(costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"Coststructuresheet_FormPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
        });
    }

    private void setMaterial(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        this.getModel().getValue("subjectormateriel");
        if (newValue == null) {
            model.setValue("materialname", null, rowIndex);
            model.setValue("model", null, rowIndex);
            model.setValue("sonauxprop", null, rowIndex);
            model.setValue("sonversion", null, rowIndex);
            model.setValue("unit", null, rowIndex);
        } else {
            DynamicObject obj = (DynamicObject)newValue;
            String name = obj.getDataEntityType().getName();
            if ("bd_material".equals(name)) {
                model.setValue("hidemateriel", (Object)obj, rowIndex);
                model.setValue("model", (Object)obj.getString("modelnum"), rowIndex);
                model.setValue("unit", obj.get("baseunit"), rowIndex);
                model.setValue("materialname", (Object)obj.getString("name"), rowIndex);
                model.setValue("sonauxprop", null, rowIndex);
                model.setValue("sonversion", null, rowIndex);
            } else if ("er_expenseitemedit".equals(name)) {
                model.setValue("materialname", (Object)obj.getString("fullname"), rowIndex);
                model.setValue("sonauxprop", null, rowIndex);
                model.setValue("model", null, rowIndex);
                model.setValue("hidemateriel", null, rowIndex);
                model.setValue("sonversion", null, rowIndex);
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent arg0) {
        this.getModel().getValue("material");
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String name = arg0.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        switch (name) {
            case "org": {
                List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "costaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"Coststructuresheet_FormPlugin_FormPlugin", (String)"macc-sca-form", (Object[])new Object[0]));
                    arg0.setCancel(true);
                    return;
                }
                QFilter costAccountFilter = StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)"sca");
                listShowParameter.getListFilterParameter().getQFilters().add(costAccountFilter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initQueryInfo();
    }

    private void initQueryInfo() {
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.setCostAccount(this.getModel().getDataEntity().getDynamicObject("org"));
            this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
            this.getView().updateView();
        }
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long mainBookId = OrgHelper.getCostAccountByAccoutOrg((Long)orgDO.getLong("id"));
        if (mainBookId != null && mainBookId != 0L) {
            boolean isnit = StartCostHelper.isInit((Long)mainBookId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (isnit) {
                this.getModel().setValue("costaccount", (Object)mainBookId);
            }
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.setPeriod();
    }

    private void setPeriod() {
        Long costaccountId;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long currperiod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)(costaccountId = Long.valueOf(costaccount.getLong("id"))));
        if (currperiod != null && currperiod != 0L) {
            this.getModel().setValue("period", (Object)currperiod);
        }
    }

    private void setElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject subelement = row.getDynamicObject("subelement");
            if (subelement == null) {
                return;
            }
            QFilter subeleIdFilter = new QFilter("subelement", "=", (Object)subelement.getLong("id"));
            DynamicObject elementDetail = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id", (QFilter[])new QFilter[]{subeleIdFilter});
            if (elementDetail != null) {
                int seq = row.getInt("seq");
                int rowIndex = seq - 1;
                this.getModel().setValue("element", (Object)elementDetail.getLong("element.id"), rowIndex);
            }
        }
    }

    private void setSubElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            QFilter subeleQF;
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject element = row.getDynamicObject("element");
            DynamicObject subelement = row.getDynamicObject("subelement");
            if (element == null || subelement == null) {
                return;
            }
            QFilter eleQF = new QFilter("element", "=", (Object)element.getLong("id"));
            boolean existRelation = QueryServiceHelper.exists((String)"cad_elementdetail", (QFilter[])new QFilter[]{eleQF, subeleQF = new QFilter("subelement", "=", (Object)subelement.getLong("id"))});
            if (existRelation) {
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("subelement", null, rowIndex);
        }
    }
}

