/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.restore;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class ForwardListPlugin
extends AbstractListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private static List<String> st = ForwardListPlugin.getBillTypeFilter();

    private static List<String> getBillTypeFilter() {
        QFilter billformidQF = new QFilter("billformid", "in", (Object)new String[]{"im_productinbill", "im_mdc_mftreturnbill", "im_mdc_mftmanuinbill", "im_mdc_omcmplinbill"});
        DynamicObjectCollection billtypes = QueryServiceHelper.query((String)"bos_billtype", (String)"number", (QFilter[])new QFilter[]{billformidQF});
        ArrayList<String> billTypeList = new ArrayList<String>(10);
        for (DynamicObject billtype : billtypes) {
            billTypeList.add(billtype.getString("number"));
        }
        return billTypeList;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("biztype", "=", (Object)"A"));
        qFilters.add(new QFilter("costaccount.enable", "=", (Object)"1"));
        qFilters.add(new QFilter("billtype.number", "in", st));
        qFilters.add(new QFilter("difftype", "!=", (Object)"B"));
        qFilters.add(new QFilter("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "Y", "Z"})));
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        String orgId = this.getDefOrg(acctOrgs);
        this.moveTop(acctOrgs, orgId);
        List costAccountItems = null;
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            costAccountItems = StartCostHelper.getCostAccountItems((Long)Long.valueOf(orgId), null, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "calorg.name": {
                    listcomitem.clear();
                    if (CadEmptyUtils.isEmpty((List)acctOrgs)) break;
                    commonFilterColumn.setComboItems(acctOrgs);
                    commonFilterColumn.setDefaultValue(orgId);
                    break;
                }
                case "costaccount.name": {
                    listcomitem.clear();
                    if (costAccountItems == null || costAccountItems.isEmpty()) break;
                    commonFilterColumn.setComboItems(costAccountItems);
                    commonFilterColumn.setDefaultValue(((ComboItem)costAccountItems.get(0)).getValue());
                    this.getPageCache().put("costaccountId", ((ComboItem)costAccountItems.get(0)).getValue());
                }
            }
        }
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString(new ArrayList()));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costcenter")) {
            String accountorgId = this.getPageCache().get("accountorgId");
            args.getQfilters().add(new QFilter("accountorg", "=", (Object)accountorgId).and(new QFilter("enable", "=", (Object)"1")));
        }
    }

    private void moveTop(List<ComboItem> acctOrgs, String orgId) {
        String currOrg;
        String string = currOrg = StringUtils.isEmpty((CharSequence)this.getPageCache().get("currOrg")) ? orgId : this.getPageCache().get("currOrg");
        if (CadEmptyUtils.isEmpty(acctOrgs) || CadEmptyUtils.isEmpty((String)currOrg)) {
            return;
        }
        for (int i = 0; i < acctOrgs.size(); ++i) {
            if (!currOrg.equals(acctOrgs.get(i).getValue())) continue;
            ComboItem temp = acctOrgs.get(0);
            acctOrgs.set(0, acctOrgs.get(i));
            acctOrgs.set(i, temp);
        }
        this.getPageCache().put("currOrg", currOrg);
    }

    private String getDefOrg(List<ComboItem> acctOrgs) {
        String orgId = this.getPageCache().get("accountorgId");
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            Long currAcctOrg = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
            orgId = isAccounting ? currAcctOrg.toString() : (CadEmptyUtils.isEmpty(acctOrgs) ? "0" : acctOrgs.get(0).getValue());
            this.getPageCache().put("accountorgId", orgId);
        }
        return orgId;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        String accountorgId = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            Map filter = (Map)customfilter.get(i);
            List listFieldName = (List)filter.get("FieldName");
            List listValue = (List)filter.get("Value");
            if (CadEmptyUtils.isEmpty((List)listValue)) continue;
            block9: for (int j = 0; j < listFieldName.size(); ++j) {
                String fieldName;
                switch (fieldName = (String)listFieldName.get(j)) {
                    case "calorg.id": {
                        accountorgId = (String)listValue.get(j);
                        this.getPageCache().put("accountorgId", accountorgId);
                        this.getPageCache().put("costaccountId", "");
                        this.getPageCache().put("costCenterId", "");
                        this.filterContainerInit(this.filterContainerInitArgs);
                        continue block9;
                    }
                    case "costaccount.id": {
                        String costaccountId = (String)listValue.get(j);
                        this.getPageCache().put("costaccountId", costaccountId);
                    }
                }
            }
        }
    }
}

