/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.restore;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportShowParameter;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import net.sf.json.JSONObject;

public class RestoreCalcEndEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(RestoreCalcEndEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"checkresult", "calcreport", "btncalcdetcomp", "btncalcdetcomprehensive", "btncalcdetcomprehensivelv"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData(this.getView());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "checkresult": {
                this.openReportResult("checkResultId");
                break;
            }
            case "calcreport": {
                this.openReportResult("calcReportId");
                break;
            }
            case "btncalcdetcomp": {
                this.openCalcRpt("sca_outlaycostsreport");
                break;
            }
            case "btncalcdetcomprehensive": {
                this.openCalcRpt("sca_diffresultcomprpt");
                break;
            }
            case "btncalcdetcomprehensivelv": {
                this.openCalcRpt("sca_diffresultcomplevrpt");
                break;
            }
        }
    }

    private void openCalcRpt(String rptName) {
        String custparam = (String)this.getView().getFormShowParameter().getCustomParam("custparam");
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId(rptName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (!CadEmptyUtils.isEmpty((String)custparam)) {
            CalcDataArgs calcDataArgs = (CalcDataArgs)SerializationUtils.fromJsonString((String)custparam, CalcDataArgs.class);
            JSONObject obj = new JSONObject();
            obj.put((Object)"orgIds", (Object)new Object[]{calcDataArgs.getOrgId()});
            obj.put((Object)"costaccountIds", (Object)new Object[]{calcDataArgs.getCostAccountId()});
            obj.put((Object)"currency", calcDataArgs.getCurrencyId());
            obj.put((Object)"startperiod", calcDataArgs.getPeriodId());
            obj.put((Object)"endperiod", calcDataArgs.getPeriodId());
            showParameter.setCustomParam("hpParam", (Object)obj.toString());
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void openReportResult(String key) {
        BillShowParameter lsp = new BillShowParameter();
        lsp.setFormId("sca_restore_calcreport");
        JSONObject custparamJs = new JSONObject();
        String resultType = this.getPageCache().get(key);
        if (CadEmptyUtils.isEmpty((String)resultType) || "null".equals(resultType)) {
            return;
        }
        long checkResultId = 0L;
        try {
            checkResultId = Long.parseLong(resultType);
        }
        catch (Exception ex) {
            logger.error("error:", (Throwable)ex);
            return;
        }
        custparamJs.accumulate("checkResultId", checkResultId);
        lsp.setPkId((Object)resultType);
        lsp.setCustomParam("custparam", (Object)custparamJs.toString());
        switch (key) {
            case "checkResultId": {
                lsp.setCaption(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"RestoreCalcEndEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
            case "calcReportId": {
                lsp.setCaption(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u62a5\u544a", (String)"RestoreCalcEndEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
            }
        }
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void initData(IFormView view) {
        String custparam = (String)view.getFormShowParameter().getCustomParam("custparam");
        if (CadEmptyUtils.isEmpty((String)custparam)) {
            return;
        }
        JSONObject calcParamJs = JSONObject.fromObject((Object)custparam);
        if (calcParamJs.size() < 2) {
            return;
        }
        Label labtime = (Label)this.getView().getControl("labtime");
        Label labTimeText = (Label)this.getView().getControl("labtimetext");
        Long time = calcParamJs.getLong("time");
        if (time < 60L) {
            labtime.setText(String.valueOf(time));
            labTimeText.setText(ResManager.loadKDString((String)"\u79d2", (String)"RestoreCalcEndEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
        } else if (time >= 60L) {
            labtime.setText(String.valueOf(time / 60L));
            labTimeText.setText(ResManager.loadKDString((String)"\u5206\u949f", (String)"RestoreCalcEndEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
        } else {
            labtime.setText(String.valueOf(time / 3600L));
            labTimeText.setText(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"RestoreCalcEndEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        Label labcheckfail = (Label)this.getView().getControl("labcheckfail");
        labcheckfail.setText(calcParamJs.getString("checkNoPassCount"));
        Label labcheckremaind = (Label)this.getView().getControl("labcheckremaind");
        labcheckremaind.setText(calcParamJs.getString("checkRemaindCount"));
        Label labsuccesscount = (Label)this.getView().getControl("labsuccesscount");
        labsuccesscount.setText(calcParamJs.getString("successCcCount"));
        Label labsuccesscocount = (Label)this.getView().getControl("labsuccesscocount");
        labsuccesscocount.setText(calcParamJs.getString("successCoCount"));
        this.getModel().setValue("org", (Object)calcParamJs.getLong("orgId"));
        this.getModel().setValue("period", (Object)calcParamJs.getLong("periodId"));
        this.getModel().setValue("costaccount", (Object)calcParamJs.getLong("costAccountId"));
        this.getPageCache().put("checkResultId", calcParamJs.getString("checkResultId"));
        this.getPageCache().put("calcReportId", calcParamJs.getString("calcReportId"));
        boolean isErrorShow = false;
        if (calcParamJs.containsKey((Object)"isSuccess") && !calcParamJs.getBoolean("isSuccess")) {
            isErrorShow = true;
        }
        this.getView().setVisible(Boolean.valueOf(isErrorShow), new String[]{"errorflex"});
        this.getView().setVisible(Boolean.valueOf(!isErrorShow), new String[]{"flexpanelap3"});
        this.getView().setVisible(Boolean.valueOf(!isErrorShow), new String[]{"flexpanelap1"});
    }
}

